/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApphubWorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * Part of 'parent'.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#application_id GoogleApphubWorkload#application_id}
    */
    readonly applicationId: string;
    /**
    * User-defined description of a Workload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#description GoogleApphubWorkload#description}
    */
    readonly description?: string;
    /**
    * Immutable. The resource name of the original discovered workload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#discovered_workload GoogleApphubWorkload#discovered_workload}
    */
    readonly discoveredWorkload: string;
    /**
    * User-defined name for the Workload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#display_name GoogleApphubWorkload#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#id GoogleApphubWorkload#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Part of 'parent'.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#location GoogleApphubWorkload#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#project GoogleApphubWorkload#project}
    */
    readonly project?: string;
    /**
    * The Workload identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#workload_id GoogleApphubWorkload#workload_id}
    */
    readonly workloadId: string;
    /**
    * attributes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#attributes GoogleApphubWorkload#attributes}
    */
    readonly attributes?: GoogleApphubWorkloadAttributes;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#timeouts GoogleApphubWorkload#timeouts}
    */
    readonly timeouts?: GoogleApphubWorkloadTimeouts;
}
export interface GoogleApphubWorkloadWorkloadProperties {
}
export declare function googleApphubWorkloadWorkloadPropertiesToTerraform(struct?: GoogleApphubWorkloadWorkloadProperties): any;
export declare function googleApphubWorkloadWorkloadPropertiesToHclTerraform(struct?: GoogleApphubWorkloadWorkloadProperties): any;
export declare class GoogleApphubWorkloadWorkloadPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubWorkloadWorkloadProperties | undefined;
    set internalValue(value: GoogleApphubWorkloadWorkloadProperties | undefined);
    get gcpProject(): string;
    get location(): string;
    get zone(): string;
}
export declare class GoogleApphubWorkloadWorkloadPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubWorkloadWorkloadPropertiesOutputReference;
}
export interface GoogleApphubWorkloadWorkloadReference {
}
export declare function googleApphubWorkloadWorkloadReferenceToTerraform(struct?: GoogleApphubWorkloadWorkloadReference): any;
export declare function googleApphubWorkloadWorkloadReferenceToHclTerraform(struct?: GoogleApphubWorkloadWorkloadReference): any;
export declare class GoogleApphubWorkloadWorkloadReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubWorkloadWorkloadReference | undefined;
    set internalValue(value: GoogleApphubWorkloadWorkloadReference | undefined);
    get uri(): string;
}
export declare class GoogleApphubWorkloadWorkloadReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubWorkloadWorkloadReferenceOutputReference;
}
export interface GoogleApphubWorkloadAttributesBusinessOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#display_name GoogleApphubWorkload#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#email GoogleApphubWorkload#email}
    */
    readonly email: string;
}
export declare function googleApphubWorkloadAttributesBusinessOwnersToTerraform(struct?: GoogleApphubWorkloadAttributesBusinessOwners | cdktf.IResolvable): any;
export declare function googleApphubWorkloadAttributesBusinessOwnersToHclTerraform(struct?: GoogleApphubWorkloadAttributesBusinessOwners | cdktf.IResolvable): any;
export declare class GoogleApphubWorkloadAttributesBusinessOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubWorkloadAttributesBusinessOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributesBusinessOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubWorkloadAttributesBusinessOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubWorkloadAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubWorkloadAttributesBusinessOwnersOutputReference;
}
export interface GoogleApphubWorkloadAttributesCriticality {
    /**
    * Criticality type. Possible values: ["MISSION_CRITICAL", "HIGH", "MEDIUM", "LOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#type GoogleApphubWorkload#type}
    */
    readonly type: string;
}
export declare function googleApphubWorkloadAttributesCriticalityToTerraform(struct?: GoogleApphubWorkloadAttributesCriticalityOutputReference | GoogleApphubWorkloadAttributesCriticality): any;
export declare function googleApphubWorkloadAttributesCriticalityToHclTerraform(struct?: GoogleApphubWorkloadAttributesCriticalityOutputReference | GoogleApphubWorkloadAttributesCriticality): any;
export declare class GoogleApphubWorkloadAttributesCriticalityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubWorkloadAttributesCriticality | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributesCriticality | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubWorkloadAttributesDeveloperOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#display_name GoogleApphubWorkload#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#email GoogleApphubWorkload#email}
    */
    readonly email: string;
}
export declare function googleApphubWorkloadAttributesDeveloperOwnersToTerraform(struct?: GoogleApphubWorkloadAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare function googleApphubWorkloadAttributesDeveloperOwnersToHclTerraform(struct?: GoogleApphubWorkloadAttributesDeveloperOwners | cdktf.IResolvable): any;
export declare class GoogleApphubWorkloadAttributesDeveloperOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubWorkloadAttributesDeveloperOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributesDeveloperOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubWorkloadAttributesDeveloperOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubWorkloadAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubWorkloadAttributesDeveloperOwnersOutputReference;
}
export interface GoogleApphubWorkloadAttributesEnvironment {
    /**
    * Environment type. Possible values: ["PRODUCTION", "STAGING", "TEST", "DEVELOPMENT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#type GoogleApphubWorkload#type}
    */
    readonly type: string;
}
export declare function googleApphubWorkloadAttributesEnvironmentToTerraform(struct?: GoogleApphubWorkloadAttributesEnvironmentOutputReference | GoogleApphubWorkloadAttributesEnvironment): any;
export declare function googleApphubWorkloadAttributesEnvironmentToHclTerraform(struct?: GoogleApphubWorkloadAttributesEnvironmentOutputReference | GoogleApphubWorkloadAttributesEnvironment): any;
export declare class GoogleApphubWorkloadAttributesEnvironmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubWorkloadAttributesEnvironment | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributesEnvironment | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleApphubWorkloadAttributesOperatorOwners {
    /**
    * Contact's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#display_name GoogleApphubWorkload#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address of the contacts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#email GoogleApphubWorkload#email}
    */
    readonly email: string;
}
export declare function googleApphubWorkloadAttributesOperatorOwnersToTerraform(struct?: GoogleApphubWorkloadAttributesOperatorOwners | cdktf.IResolvable): any;
export declare function googleApphubWorkloadAttributesOperatorOwnersToHclTerraform(struct?: GoogleApphubWorkloadAttributesOperatorOwners | cdktf.IResolvable): any;
export declare class GoogleApphubWorkloadAttributesOperatorOwnersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApphubWorkloadAttributesOperatorOwners | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributesOperatorOwners | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export declare class GoogleApphubWorkloadAttributesOperatorOwnersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApphubWorkloadAttributesOperatorOwners[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApphubWorkloadAttributesOperatorOwnersOutputReference;
}
export interface GoogleApphubWorkloadAttributes {
    /**
    * business_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#business_owners GoogleApphubWorkload#business_owners}
    */
    readonly businessOwners?: GoogleApphubWorkloadAttributesBusinessOwners[] | cdktf.IResolvable;
    /**
    * criticality block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#criticality GoogleApphubWorkload#criticality}
    */
    readonly criticality?: GoogleApphubWorkloadAttributesCriticality;
    /**
    * developer_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#developer_owners GoogleApphubWorkload#developer_owners}
    */
    readonly developerOwners?: GoogleApphubWorkloadAttributesDeveloperOwners[] | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#environment GoogleApphubWorkload#environment}
    */
    readonly environment?: GoogleApphubWorkloadAttributesEnvironment;
    /**
    * operator_owners block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#operator_owners GoogleApphubWorkload#operator_owners}
    */
    readonly operatorOwners?: GoogleApphubWorkloadAttributesOperatorOwners[] | cdktf.IResolvable;
}
export declare function googleApphubWorkloadAttributesToTerraform(struct?: GoogleApphubWorkloadAttributesOutputReference | GoogleApphubWorkloadAttributes): any;
export declare function googleApphubWorkloadAttributesToHclTerraform(struct?: GoogleApphubWorkloadAttributesOutputReference | GoogleApphubWorkloadAttributes): any;
export declare class GoogleApphubWorkloadAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubWorkloadAttributes | undefined;
    set internalValue(value: GoogleApphubWorkloadAttributes | undefined);
    private _businessOwners;
    get businessOwners(): GoogleApphubWorkloadAttributesBusinessOwnersList;
    putBusinessOwners(value: GoogleApphubWorkloadAttributesBusinessOwners[] | cdktf.IResolvable): void;
    resetBusinessOwners(): void;
    get businessOwnersInput(): cdktf.IResolvable | GoogleApphubWorkloadAttributesBusinessOwners[] | undefined;
    private _criticality;
    get criticality(): GoogleApphubWorkloadAttributesCriticalityOutputReference;
    putCriticality(value: GoogleApphubWorkloadAttributesCriticality): void;
    resetCriticality(): void;
    get criticalityInput(): GoogleApphubWorkloadAttributesCriticality | undefined;
    private _developerOwners;
    get developerOwners(): GoogleApphubWorkloadAttributesDeveloperOwnersList;
    putDeveloperOwners(value: GoogleApphubWorkloadAttributesDeveloperOwners[] | cdktf.IResolvable): void;
    resetDeveloperOwners(): void;
    get developerOwnersInput(): cdktf.IResolvable | GoogleApphubWorkloadAttributesDeveloperOwners[] | undefined;
    private _environment;
    get environment(): GoogleApphubWorkloadAttributesEnvironmentOutputReference;
    putEnvironment(value: GoogleApphubWorkloadAttributesEnvironment): void;
    resetEnvironment(): void;
    get environmentInput(): GoogleApphubWorkloadAttributesEnvironment | undefined;
    private _operatorOwners;
    get operatorOwners(): GoogleApphubWorkloadAttributesOperatorOwnersList;
    putOperatorOwners(value: GoogleApphubWorkloadAttributesOperatorOwners[] | cdktf.IResolvable): void;
    resetOperatorOwners(): void;
    get operatorOwnersInput(): cdktf.IResolvable | GoogleApphubWorkloadAttributesOperatorOwners[] | undefined;
}
export interface GoogleApphubWorkloadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#create GoogleApphubWorkload#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#delete GoogleApphubWorkload#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#update GoogleApphubWorkload#update}
    */
    readonly update?: string;
}
export declare function googleApphubWorkloadTimeoutsToTerraform(struct?: GoogleApphubWorkloadTimeouts | cdktf.IResolvable): any;
export declare function googleApphubWorkloadTimeoutsToHclTerraform(struct?: GoogleApphubWorkloadTimeouts | cdktf.IResolvable): any;
export declare class GoogleApphubWorkloadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApphubWorkloadTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApphubWorkloadTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload google_apphub_workload}
*/
export declare class GoogleApphubWorkload extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apphub_workload";
    /**
    * Generates CDKTF code for importing a GoogleApphubWorkload resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleApphubWorkload to import
    * @param importFromId The id of the existing GoogleApphubWorkload that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleApphubWorkload to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_apphub_workload google_apphub_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApphubWorkloadConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApphubWorkloadConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoveredWorkload?;
    get discoveredWorkload(): string;
    set discoveredWorkload(value: string);
    get discoveredWorkloadInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadId?;
    get workloadId(): string;
    set workloadId(value: string);
    get workloadIdInput(): string | undefined;
    private _workloadProperties;
    get workloadProperties(): GoogleApphubWorkloadWorkloadPropertiesList;
    private _workloadReference;
    get workloadReference(): GoogleApphubWorkloadWorkloadReferenceList;
    private _attributes;
    get attributes(): GoogleApphubWorkloadAttributesOutputReference;
    putAttributes(value: GoogleApphubWorkloadAttributes): void;
    resetAttributes(): void;
    get attributesInput(): GoogleApphubWorkloadAttributes | undefined;
    private _timeouts;
    get timeouts(): GoogleApphubWorkloadTimeoutsOutputReference;
    putTimeouts(value: GoogleApphubWorkloadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApphubWorkloadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
