/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAssuredWorkloadsWorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Input only. The billing account used for the resources which are direct children of workload. This billing account is initially associated with the resources created as part of Workload creation. After the initial creation of these resources, the customer can change the assigned billing account. The resource name has the form `billingAccounts/{billing_account_id}`. For example, `billingAccounts/012345-567890-ABCDEF`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#billing_account GoogleAssuredWorkloadsWorkload#billing_account}
    */
    readonly billingAccount?: string;
    /**
    * Required. Immutable. Compliance Regime associated with this workload. Possible values: COMPLIANCE_REGIME_UNSPECIFIED, IL4, CJIS, FEDRAMP_HIGH, FEDRAMP_MODERATE, US_REGIONAL_ACCESS, HIPAA, HITRUST, EU_REGIONS_AND_SUPPORT, CA_REGIONS_AND_SUPPORT, ITAR, AU_REGIONS_AND_US_SUPPORT, ASSURED_WORKLOADS_FOR_PARTNERS, ISR_REGIONS, ISR_REGIONS_AND_SUPPORT, CA_PROTECTED_B, IL5, IL2, JP_REGIONS_AND_SUPPORT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#compliance_regime GoogleAssuredWorkloadsWorkload#compliance_regime}
    */
    readonly complianceRegime: string;
    /**
    * Required. The user-assigned display name of the Workload. When present it must be between 4 to 30 characters. Allowed characters are: lowercase and uppercase letters, numbers, hyphen, and spaces. Example: My Workload
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#display_name GoogleAssuredWorkloadsWorkload#display_name}
    */
    readonly displayName: string;
    /**
    * Optional. Indicates the sovereignty status of the given workload. Currently meant to be used by Europe/Canada customers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#enable_sovereign_controls GoogleAssuredWorkloadsWorkload#enable_sovereign_controls}
    */
    readonly enableSovereignControls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#id GoogleAssuredWorkloadsWorkload#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. Labels applied to the workload.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field `effective_labels` for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#labels GoogleAssuredWorkloadsWorkload#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#location GoogleAssuredWorkloadsWorkload#location}
    */
    readonly location: string;
    /**
    * The organization for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#organization GoogleAssuredWorkloadsWorkload#organization}
    */
    readonly organization: string;
    /**
    * Optional. Partner regime associated with this workload. Possible values: PARTNER_UNSPECIFIED, LOCAL_CONTROLS_BY_S3NS, SOVEREIGN_CONTROLS_BY_T_SYSTEMS, SOVEREIGN_CONTROLS_BY_SIA_MINSAIT, SOVEREIGN_CONTROLS_BY_PSN
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#partner GoogleAssuredWorkloadsWorkload#partner}
    */
    readonly partner?: string;
    /**
    * Input only. The parent resource for the resources managed by this Assured Workload. May be either empty or a folder resource which is a child of the Workload parent. If not specified all resources are created under the parent organization. Format: folders/{folder_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#provisioned_resources_parent GoogleAssuredWorkloadsWorkload#provisioned_resources_parent}
    */
    readonly provisionedResourcesParent?: string;
    /**
    * Optional. Indicates whether the e-mail notification for a violation is enabled for a workload. This value will be by default True, and if not present will be considered as true. This should only be updated via updateWorkload call. Any Changes to this field during the createWorkload call will not be honored. This will always be true while creating the workload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#violation_notifications_enabled GoogleAssuredWorkloadsWorkload#violation_notifications_enabled}
    */
    readonly violationNotificationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * kms_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#kms_settings GoogleAssuredWorkloadsWorkload#kms_settings}
    */
    readonly kmsSettings?: GoogleAssuredWorkloadsWorkloadKmsSettings;
    /**
    * partner_permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#partner_permissions GoogleAssuredWorkloadsWorkload#partner_permissions}
    */
    readonly partnerPermissions?: GoogleAssuredWorkloadsWorkloadPartnerPermissions;
    /**
    * resource_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#resource_settings GoogleAssuredWorkloadsWorkload#resource_settings}
    */
    readonly resourceSettings?: GoogleAssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#timeouts GoogleAssuredWorkloadsWorkload#timeouts}
    */
    readonly timeouts?: GoogleAssuredWorkloadsWorkloadTimeouts;
}
export interface GoogleAssuredWorkloadsWorkloadComplianceStatus {
}
export declare function googleAssuredWorkloadsWorkloadComplianceStatusToTerraform(struct?: GoogleAssuredWorkloadsWorkloadComplianceStatus): any;
export declare function googleAssuredWorkloadsWorkloadComplianceStatusToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadComplianceStatus): any;
export declare class GoogleAssuredWorkloadsWorkloadComplianceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAssuredWorkloadsWorkloadComplianceStatus | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadComplianceStatus | undefined);
    get acknowledgedViolationCount(): number[];
    get activeViolationCount(): number[];
}
export declare class GoogleAssuredWorkloadsWorkloadComplianceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAssuredWorkloadsWorkloadComplianceStatusOutputReference;
}
export interface GoogleAssuredWorkloadsWorkloadEkmProvisioningResponse {
}
export declare function googleAssuredWorkloadsWorkloadEkmProvisioningResponseToTerraform(struct?: GoogleAssuredWorkloadsWorkloadEkmProvisioningResponse): any;
export declare function googleAssuredWorkloadsWorkloadEkmProvisioningResponseToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadEkmProvisioningResponse): any;
export declare class GoogleAssuredWorkloadsWorkloadEkmProvisioningResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAssuredWorkloadsWorkloadEkmProvisioningResponse | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadEkmProvisioningResponse | undefined);
    get ekmProvisioningErrorDomain(): string;
    get ekmProvisioningErrorMapping(): string;
    get ekmProvisioningState(): string;
}
export declare class GoogleAssuredWorkloadsWorkloadEkmProvisioningResponseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAssuredWorkloadsWorkloadEkmProvisioningResponseOutputReference;
}
export interface GoogleAssuredWorkloadsWorkloadResources {
}
export declare function googleAssuredWorkloadsWorkloadResourcesToTerraform(struct?: GoogleAssuredWorkloadsWorkloadResources): any;
export declare function googleAssuredWorkloadsWorkloadResourcesToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadResources): any;
export declare class GoogleAssuredWorkloadsWorkloadResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAssuredWorkloadsWorkloadResources | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadResources | undefined);
    get resourceId(): number;
    get resourceType(): string;
}
export declare class GoogleAssuredWorkloadsWorkloadResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAssuredWorkloadsWorkloadResourcesOutputReference;
}
export interface GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponse {
}
export declare function googleAssuredWorkloadsWorkloadSaaEnrollmentResponseToTerraform(struct?: GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponse): any;
export declare function googleAssuredWorkloadsWorkloadSaaEnrollmentResponseToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponse): any;
export declare class GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponse | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponse | undefined);
    get setupErrors(): string[];
    get setupStatus(): string;
}
export declare class GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponseOutputReference;
}
export interface GoogleAssuredWorkloadsWorkloadKmsSettings {
    /**
    * Required. Input only. Immutable. The time at which the Key Management Service will automatically create a new version of the crypto key and mark it as the primary.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#next_rotation_time GoogleAssuredWorkloadsWorkload#next_rotation_time}
    */
    readonly nextRotationTime: string;
    /**
    * Required. Input only. Immutable. will be advanced by this period when the Key Management Service automatically rotates a key. Must be at least 24 hours and at most 876,000 hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#rotation_period GoogleAssuredWorkloadsWorkload#rotation_period}
    */
    readonly rotationPeriod: string;
}
export declare function googleAssuredWorkloadsWorkloadKmsSettingsToTerraform(struct?: GoogleAssuredWorkloadsWorkloadKmsSettingsOutputReference | GoogleAssuredWorkloadsWorkloadKmsSettings): any;
export declare function googleAssuredWorkloadsWorkloadKmsSettingsToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadKmsSettingsOutputReference | GoogleAssuredWorkloadsWorkloadKmsSettings): any;
export declare class GoogleAssuredWorkloadsWorkloadKmsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAssuredWorkloadsWorkloadKmsSettings | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadKmsSettings | undefined);
    private _nextRotationTime?;
    get nextRotationTime(): string;
    set nextRotationTime(value: string);
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string;
    set rotationPeriod(value: string);
    get rotationPeriodInput(): string | undefined;
}
export interface GoogleAssuredWorkloadsWorkloadPartnerPermissions {
    /**
    * Optional. Allow partner to view violation alerts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#assured_workloads_monitoring GoogleAssuredWorkloadsWorkload#assured_workloads_monitoring}
    */
    readonly assuredWorkloadsMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Allow the partner to view inspectability logs and monitoring violations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#data_logs_viewer GoogleAssuredWorkloadsWorkload#data_logs_viewer}
    */
    readonly dataLogsViewer?: boolean | cdktf.IResolvable;
    /**
    * Optional. Allow partner to view access approval logs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#service_access_approver GoogleAssuredWorkloadsWorkload#service_access_approver}
    */
    readonly serviceAccessApprover?: boolean | cdktf.IResolvable;
}
export declare function googleAssuredWorkloadsWorkloadPartnerPermissionsToTerraform(struct?: GoogleAssuredWorkloadsWorkloadPartnerPermissionsOutputReference | GoogleAssuredWorkloadsWorkloadPartnerPermissions): any;
export declare function googleAssuredWorkloadsWorkloadPartnerPermissionsToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadPartnerPermissionsOutputReference | GoogleAssuredWorkloadsWorkloadPartnerPermissions): any;
export declare class GoogleAssuredWorkloadsWorkloadPartnerPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAssuredWorkloadsWorkloadPartnerPermissions | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadPartnerPermissions | undefined);
    private _assuredWorkloadsMonitoring?;
    get assuredWorkloadsMonitoring(): boolean | cdktf.IResolvable;
    set assuredWorkloadsMonitoring(value: boolean | cdktf.IResolvable);
    resetAssuredWorkloadsMonitoring(): void;
    get assuredWorkloadsMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _dataLogsViewer?;
    get dataLogsViewer(): boolean | cdktf.IResolvable;
    set dataLogsViewer(value: boolean | cdktf.IResolvable);
    resetDataLogsViewer(): void;
    get dataLogsViewerInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccessApprover?;
    get serviceAccessApprover(): boolean | cdktf.IResolvable;
    set serviceAccessApprover(value: boolean | cdktf.IResolvable);
    resetServiceAccessApprover(): void;
    get serviceAccessApproverInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleAssuredWorkloadsWorkloadResourceSettings {
    /**
    * User-assigned resource display name. If not empty it will be used to create a resource with the specified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#display_name GoogleAssuredWorkloadsWorkload#display_name}
    */
    readonly displayName?: string;
    /**
    * Resource identifier. For a project this represents projectId. If the project is already taken, the workload creation will fail. For KeyRing, this represents the keyring_id. For a folder, don't set this value as folder_id is assigned by Google.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#resource_id GoogleAssuredWorkloadsWorkload#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Indicates the type of resource. This field should be specified to correspond the id to the right project type (CONSUMER_PROJECT or ENCRYPTION_KEYS_PROJECT) Possible values: RESOURCE_TYPE_UNSPECIFIED, CONSUMER_PROJECT, ENCRYPTION_KEYS_PROJECT, KEYRING, CONSUMER_FOLDER
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#resource_type GoogleAssuredWorkloadsWorkload#resource_type}
    */
    readonly resourceType?: string;
}
export declare function googleAssuredWorkloadsWorkloadResourceSettingsToTerraform(struct?: GoogleAssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable): any;
export declare function googleAssuredWorkloadsWorkloadResourceSettingsToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable): any;
export declare class GoogleAssuredWorkloadsWorkloadResourceSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
}
export declare class GoogleAssuredWorkloadsWorkloadResourceSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAssuredWorkloadsWorkloadResourceSettingsOutputReference;
}
export interface GoogleAssuredWorkloadsWorkloadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#create GoogleAssuredWorkloadsWorkload#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#delete GoogleAssuredWorkloadsWorkload#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#update GoogleAssuredWorkloadsWorkload#update}
    */
    readonly update?: string;
}
export declare function googleAssuredWorkloadsWorkloadTimeoutsToTerraform(struct?: GoogleAssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable): any;
export declare function googleAssuredWorkloadsWorkloadTimeoutsToHclTerraform(struct?: GoogleAssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable): any;
export declare class GoogleAssuredWorkloadsWorkloadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload google_assured_workloads_workload}
*/
export declare class GoogleAssuredWorkloadsWorkload extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_assured_workloads_workload";
    /**
    * Generates CDKTF code for importing a GoogleAssuredWorkloadsWorkload resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleAssuredWorkloadsWorkload to import
    * @param importFromId The id of the existing GoogleAssuredWorkloadsWorkload that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleAssuredWorkloadsWorkload to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_assured_workloads_workload google_assured_workloads_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAssuredWorkloadsWorkloadConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAssuredWorkloadsWorkloadConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    resetBillingAccount(): void;
    get billingAccountInput(): string | undefined;
    private _complianceRegime?;
    get complianceRegime(): string;
    set complianceRegime(value: string);
    get complianceRegimeInput(): string | undefined;
    private _complianceStatus;
    get complianceStatus(): GoogleAssuredWorkloadsWorkloadComplianceStatusList;
    get compliantButDisallowedServices(): string[];
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _ekmProvisioningResponse;
    get ekmProvisioningResponse(): GoogleAssuredWorkloadsWorkloadEkmProvisioningResponseList;
    private _enableSovereignControls?;
    get enableSovereignControls(): boolean | cdktf.IResolvable;
    set enableSovereignControls(value: boolean | cdktf.IResolvable);
    resetEnableSovereignControls(): void;
    get enableSovereignControlsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kajEnrollmentState(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _partner?;
    get partner(): string;
    set partner(value: string);
    resetPartner(): void;
    get partnerInput(): string | undefined;
    private _provisionedResourcesParent?;
    get provisionedResourcesParent(): string;
    set provisionedResourcesParent(value: string);
    resetProvisionedResourcesParent(): void;
    get provisionedResourcesParentInput(): string | undefined;
    private _resources;
    get resources(): GoogleAssuredWorkloadsWorkloadResourcesList;
    private _saaEnrollmentResponse;
    get saaEnrollmentResponse(): GoogleAssuredWorkloadsWorkloadSaaEnrollmentResponseList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _violationNotificationsEnabled?;
    get violationNotificationsEnabled(): boolean | cdktf.IResolvable;
    set violationNotificationsEnabled(value: boolean | cdktf.IResolvable);
    resetViolationNotificationsEnabled(): void;
    get violationNotificationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kmsSettings;
    get kmsSettings(): GoogleAssuredWorkloadsWorkloadKmsSettingsOutputReference;
    putKmsSettings(value: GoogleAssuredWorkloadsWorkloadKmsSettings): void;
    resetKmsSettings(): void;
    get kmsSettingsInput(): GoogleAssuredWorkloadsWorkloadKmsSettings | undefined;
    private _partnerPermissions;
    get partnerPermissions(): GoogleAssuredWorkloadsWorkloadPartnerPermissionsOutputReference;
    putPartnerPermissions(value: GoogleAssuredWorkloadsWorkloadPartnerPermissions): void;
    resetPartnerPermissions(): void;
    get partnerPermissionsInput(): GoogleAssuredWorkloadsWorkloadPartnerPermissions | undefined;
    private _resourceSettings;
    get resourceSettings(): GoogleAssuredWorkloadsWorkloadResourceSettingsList;
    putResourceSettings(value: GoogleAssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable): void;
    resetResourceSettings(): void;
    get resourceSettingsInput(): cdktf.IResolvable | GoogleAssuredWorkloadsWorkloadResourceSettings[] | undefined;
    private _timeouts;
    get timeouts(): GoogleAssuredWorkloadsWorkloadTimeoutsOutputReference;
    putTimeouts(value: GoogleAssuredWorkloadsWorkloadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAssuredWorkloadsWorkloadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
