/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBackupDrManagementServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#id GoogleBackupDrManagementServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the management server (management console)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#location GoogleBackupDrManagementServer#location}
    */
    readonly location: string;
    /**
    * The name of management server (management console)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#name GoogleBackupDrManagementServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#project GoogleBackupDrManagementServer#project}
    */
    readonly project?: string;
    /**
    * The type of management server (management console). Default value: "BACKUP_RESTORE" Possible values: ["BACKUP_RESTORE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#type GoogleBackupDrManagementServer#type}
    */
    readonly type?: string;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#networks GoogleBackupDrManagementServer#networks}
    */
    readonly networks: GoogleBackupDrManagementServerNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#timeouts GoogleBackupDrManagementServer#timeouts}
    */
    readonly timeouts?: GoogleBackupDrManagementServerTimeouts;
}
export interface GoogleBackupDrManagementServerManagementUri {
}
export declare function googleBackupDrManagementServerManagementUriToTerraform(struct?: GoogleBackupDrManagementServerManagementUri): any;
export declare function googleBackupDrManagementServerManagementUriToHclTerraform(struct?: GoogleBackupDrManagementServerManagementUri): any;
export declare class GoogleBackupDrManagementServerManagementUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBackupDrManagementServerManagementUri | undefined;
    set internalValue(value: GoogleBackupDrManagementServerManagementUri | undefined);
    get api(): string;
    get webUi(): string;
}
export declare class GoogleBackupDrManagementServerManagementUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBackupDrManagementServerManagementUriOutputReference;
}
export interface GoogleBackupDrManagementServerNetworks {
    /**
    * Network with format 'projects/{{project_id}}/global/networks/{{network_id}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#network GoogleBackupDrManagementServer#network}
    */
    readonly network: string;
    /**
    * Type of Network peeringMode Default value: "PRIVATE_SERVICE_ACCESS" Possible values: ["PRIVATE_SERVICE_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#peering_mode GoogleBackupDrManagementServer#peering_mode}
    */
    readonly peeringMode?: string;
}
export declare function googleBackupDrManagementServerNetworksToTerraform(struct?: GoogleBackupDrManagementServerNetworks | cdktf.IResolvable): any;
export declare function googleBackupDrManagementServerNetworksToHclTerraform(struct?: GoogleBackupDrManagementServerNetworks | cdktf.IResolvable): any;
export declare class GoogleBackupDrManagementServerNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBackupDrManagementServerNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBackupDrManagementServerNetworks | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peeringMode?;
    get peeringMode(): string;
    set peeringMode(value: string);
    resetPeeringMode(): void;
    get peeringModeInput(): string | undefined;
}
export declare class GoogleBackupDrManagementServerNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBackupDrManagementServerNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBackupDrManagementServerNetworksOutputReference;
}
export interface GoogleBackupDrManagementServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#create GoogleBackupDrManagementServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#delete GoogleBackupDrManagementServer#delete}
    */
    readonly delete?: string;
}
export declare function googleBackupDrManagementServerTimeoutsToTerraform(struct?: GoogleBackupDrManagementServerTimeouts | cdktf.IResolvable): any;
export declare function googleBackupDrManagementServerTimeoutsToHclTerraform(struct?: GoogleBackupDrManagementServerTimeouts | cdktf.IResolvable): any;
export declare class GoogleBackupDrManagementServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBackupDrManagementServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBackupDrManagementServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server google_backup_dr_management_server}
*/
export declare class GoogleBackupDrManagementServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_backup_dr_management_server";
    /**
    * Generates CDKTF code for importing a GoogleBackupDrManagementServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBackupDrManagementServer to import
    * @param importFromId The id of the existing GoogleBackupDrManagementServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBackupDrManagementServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_backup_dr_management_server google_backup_dr_management_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBackupDrManagementServerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBackupDrManagementServerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managementUri;
    get managementUri(): GoogleBackupDrManagementServerManagementUriList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get oauth2ClientId(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _networks;
    get networks(): GoogleBackupDrManagementServerNetworksList;
    putNetworks(value: GoogleBackupDrManagementServerNetworks[] | cdktf.IResolvable): void;
    get networksInput(): cdktf.IResolvable | GoogleBackupDrManagementServerNetworks[] | undefined;
    private _timeouts;
    get timeouts(): GoogleBackupDrManagementServerTimeoutsOutputReference;
    putTimeouts(value: GoogleBackupDrManagementServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBackupDrManagementServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
