/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBeyondcorpAppConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of AppConnectors that are authorised to be associated with this AppConnection
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#connectors GoogleBeyondcorpAppConnection#connectors}
    */
    readonly connectors?: string[];
    /**
    * An arbitrary user-provided name for the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#display_name GoogleBeyondcorpAppConnection#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#id GoogleBeyondcorpAppConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#labels GoogleBeyondcorpAppConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * ID of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#name GoogleBeyondcorpAppConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#project GoogleBeyondcorpAppConnection#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#region GoogleBeyondcorpAppConnection#region}
    */
    readonly region?: string;
    /**
    * The type of network connectivity used by the AppConnection. Refer to
    * https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#type
    * for a list of possible values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#type GoogleBeyondcorpAppConnection#type}
    */
    readonly type?: string;
    /**
    * application_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#application_endpoint GoogleBeyondcorpAppConnection#application_endpoint}
    */
    readonly applicationEndpoint: GoogleBeyondcorpAppConnectionApplicationEndpoint;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#gateway GoogleBeyondcorpAppConnection#gateway}
    */
    readonly gateway?: GoogleBeyondcorpAppConnectionGateway;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#timeouts GoogleBeyondcorpAppConnection#timeouts}
    */
    readonly timeouts?: GoogleBeyondcorpAppConnectionTimeouts;
}
export interface GoogleBeyondcorpAppConnectionApplicationEndpoint {
    /**
    * Hostname or IP address of the remote application endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#host GoogleBeyondcorpAppConnection#host}
    */
    readonly host: string;
    /**
    * Port of the remote application endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#port GoogleBeyondcorpAppConnection#port}
    */
    readonly port: number;
}
export declare function googleBeyondcorpAppConnectionApplicationEndpointToTerraform(struct?: GoogleBeyondcorpAppConnectionApplicationEndpointOutputReference | GoogleBeyondcorpAppConnectionApplicationEndpoint): any;
export declare function googleBeyondcorpAppConnectionApplicationEndpointToHclTerraform(struct?: GoogleBeyondcorpAppConnectionApplicationEndpointOutputReference | GoogleBeyondcorpAppConnectionApplicationEndpoint): any;
export declare class GoogleBeyondcorpAppConnectionApplicationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectionApplicationEndpoint | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectionApplicationEndpoint | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export interface GoogleBeyondcorpAppConnectionGateway {
    /**
    * AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#app_gateway GoogleBeyondcorpAppConnection#app_gateway}
    */
    readonly appGateway: string;
    /**
    * The type of hosting used by the gateway. Refer to
    * https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
    * for a list of possible values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#type GoogleBeyondcorpAppConnection#type}
    */
    readonly type?: string;
}
export declare function googleBeyondcorpAppConnectionGatewayToTerraform(struct?: GoogleBeyondcorpAppConnectionGatewayOutputReference | GoogleBeyondcorpAppConnectionGateway): any;
export declare function googleBeyondcorpAppConnectionGatewayToHclTerraform(struct?: GoogleBeyondcorpAppConnectionGatewayOutputReference | GoogleBeyondcorpAppConnectionGateway): any;
export declare class GoogleBeyondcorpAppConnectionGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectionGateway | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectionGateway | undefined);
    private _appGateway?;
    get appGateway(): string;
    set appGateway(value: string);
    get appGatewayInput(): string | undefined;
    get ingressPort(): number;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uri(): string;
}
export interface GoogleBeyondcorpAppConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#create GoogleBeyondcorpAppConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#delete GoogleBeyondcorpAppConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#update GoogleBeyondcorpAppConnection#update}
    */
    readonly update?: string;
}
export declare function googleBeyondcorpAppConnectionTimeoutsToTerraform(struct?: GoogleBeyondcorpAppConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleBeyondcorpAppConnectionTimeoutsToHclTerraform(struct?: GoogleBeyondcorpAppConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleBeyondcorpAppConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection google_beyondcorp_app_connection}
*/
export declare class GoogleBeyondcorpAppConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_beyondcorp_app_connection";
    /**
    * Generates CDKTF code for importing a GoogleBeyondcorpAppConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBeyondcorpAppConnection to import
    * @param importFromId The id of the existing GoogleBeyondcorpAppConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBeyondcorpAppConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connection google_beyondcorp_app_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBeyondcorpAppConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBeyondcorpAppConnectionConfig);
    private _connectors?;
    get connectors(): string[];
    set connectors(value: string[]);
    resetConnectors(): void;
    get connectorsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _applicationEndpoint;
    get applicationEndpoint(): GoogleBeyondcorpAppConnectionApplicationEndpointOutputReference;
    putApplicationEndpoint(value: GoogleBeyondcorpAppConnectionApplicationEndpoint): void;
    get applicationEndpointInput(): GoogleBeyondcorpAppConnectionApplicationEndpoint | undefined;
    private _gateway;
    get gateway(): GoogleBeyondcorpAppConnectionGatewayOutputReference;
    putGateway(value: GoogleBeyondcorpAppConnectionGateway): void;
    resetGateway(): void;
    get gatewayInput(): GoogleBeyondcorpAppConnectionGateway | undefined;
    private _timeouts;
    get timeouts(): GoogleBeyondcorpAppConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleBeyondcorpAppConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBeyondcorpAppConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
