/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBeyondcorpAppConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * An arbitrary user-provided name for the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#display_name GoogleBeyondcorpAppConnector#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#id GoogleBeyondcorpAppConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#labels GoogleBeyondcorpAppConnector#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * ID of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#name GoogleBeyondcorpAppConnector#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#project GoogleBeyondcorpAppConnector#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#region GoogleBeyondcorpAppConnector#region}
    */
    readonly region?: string;
    /**
    * principal_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#principal_info GoogleBeyondcorpAppConnector#principal_info}
    */
    readonly principalInfo: GoogleBeyondcorpAppConnectorPrincipalInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#timeouts GoogleBeyondcorpAppConnector#timeouts}
    */
    readonly timeouts?: GoogleBeyondcorpAppConnectorTimeouts;
}
export interface GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount {
    /**
    * Email address of the service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#email GoogleBeyondcorpAppConnector#email}
    */
    readonly email: string;
}
export declare function googleBeyondcorpAppConnectorPrincipalInfoServiceAccountToTerraform(struct?: GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference | GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount): any;
export declare function googleBeyondcorpAppConnectorPrincipalInfoServiceAccountToHclTerraform(struct?: GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference | GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount): any;
export declare class GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export interface GoogleBeyondcorpAppConnectorPrincipalInfo {
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#service_account GoogleBeyondcorpAppConnector#service_account}
    */
    readonly serviceAccount: GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount;
}
export declare function googleBeyondcorpAppConnectorPrincipalInfoToTerraform(struct?: GoogleBeyondcorpAppConnectorPrincipalInfoOutputReference | GoogleBeyondcorpAppConnectorPrincipalInfo): any;
export declare function googleBeyondcorpAppConnectorPrincipalInfoToHclTerraform(struct?: GoogleBeyondcorpAppConnectorPrincipalInfoOutputReference | GoogleBeyondcorpAppConnectorPrincipalInfo): any;
export declare class GoogleBeyondcorpAppConnectorPrincipalInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectorPrincipalInfo | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectorPrincipalInfo | undefined);
    private _serviceAccount;
    get serviceAccount(): GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference;
    putServiceAccount(value: GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount): void;
    get serviceAccountInput(): GoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined;
}
export interface GoogleBeyondcorpAppConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#create GoogleBeyondcorpAppConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#delete GoogleBeyondcorpAppConnector#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#update GoogleBeyondcorpAppConnector#update}
    */
    readonly update?: string;
}
export declare function googleBeyondcorpAppConnectorTimeoutsToTerraform(struct?: GoogleBeyondcorpAppConnectorTimeouts | cdktf.IResolvable): any;
export declare function googleBeyondcorpAppConnectorTimeoutsToHclTerraform(struct?: GoogleBeyondcorpAppConnectorTimeouts | cdktf.IResolvable): any;
export declare class GoogleBeyondcorpAppConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppConnectorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBeyondcorpAppConnectorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector google_beyondcorp_app_connector}
*/
export declare class GoogleBeyondcorpAppConnector extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_beyondcorp_app_connector";
    /**
    * Generates CDKTF code for importing a GoogleBeyondcorpAppConnector resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBeyondcorpAppConnector to import
    * @param importFromId The id of the existing GoogleBeyondcorpAppConnector that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBeyondcorpAppConnector to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_beyondcorp_app_connector google_beyondcorp_app_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBeyondcorpAppConnectorConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBeyondcorpAppConnectorConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _principalInfo;
    get principalInfo(): GoogleBeyondcorpAppConnectorPrincipalInfoOutputReference;
    putPrincipalInfo(value: GoogleBeyondcorpAppConnectorPrincipalInfo): void;
    get principalInfoInput(): GoogleBeyondcorpAppConnectorPrincipalInfo | undefined;
    private _timeouts;
    get timeouts(): GoogleBeyondcorpAppConnectorTimeoutsOutputReference;
    putTimeouts(value: GoogleBeyondcorpAppConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBeyondcorpAppConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
