/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBiglakeCatalogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#id GoogleBiglakeCatalog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the Catalog should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#location GoogleBiglakeCatalog#location}
    */
    readonly location: string;
    /**
    * The name of the Catalog. Format:
    * projects/{project_id_or_number}/locations/{locationId}/catalogs/{catalogId}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#name GoogleBiglakeCatalog#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#project GoogleBiglakeCatalog#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#timeouts GoogleBiglakeCatalog#timeouts}
    */
    readonly timeouts?: GoogleBiglakeCatalogTimeouts;
}
export interface GoogleBiglakeCatalogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#create GoogleBiglakeCatalog#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#delete GoogleBiglakeCatalog#delete}
    */
    readonly delete?: string;
}
export declare function googleBiglakeCatalogTimeoutsToTerraform(struct?: GoogleBiglakeCatalogTimeouts | cdktf.IResolvable): any;
export declare function googleBiglakeCatalogTimeoutsToHclTerraform(struct?: GoogleBiglakeCatalogTimeouts | cdktf.IResolvable): any;
export declare class GoogleBiglakeCatalogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeCatalogTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBiglakeCatalogTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog google_biglake_catalog}
*/
export declare class GoogleBiglakeCatalog extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_biglake_catalog";
    /**
    * Generates CDKTF code for importing a GoogleBiglakeCatalog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBiglakeCatalog to import
    * @param importFromId The id of the existing GoogleBiglakeCatalog that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBiglakeCatalog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_catalog google_biglake_catalog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBiglakeCatalogConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBiglakeCatalogConfig);
    get createTime(): string;
    get deleteTime(): string;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleBiglakeCatalogTimeoutsOutputReference;
    putTimeouts(value: GoogleBiglakeCatalogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBiglakeCatalogTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
