/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBiglakeDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The parent catalog.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#catalog GoogleBiglakeDatabase#catalog}
    */
    readonly catalog: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#id GoogleBiglakeDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#name GoogleBiglakeDatabase#name}
    */
    readonly name: string;
    /**
    * The database type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#type GoogleBiglakeDatabase#type}
    */
    readonly type: string;
    /**
    * hive_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#hive_options GoogleBiglakeDatabase#hive_options}
    */
    readonly hiveOptions: GoogleBiglakeDatabaseHiveOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#timeouts GoogleBiglakeDatabase#timeouts}
    */
    readonly timeouts?: GoogleBiglakeDatabaseTimeouts;
}
export interface GoogleBiglakeDatabaseHiveOptions {
    /**
    * Cloud Storage folder URI where the database data is stored, starting with "gs://".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#location_uri GoogleBiglakeDatabase#location_uri}
    */
    readonly locationUri?: string;
    /**
    * Stores user supplied Hive database parameters. An object containing a
    * list of"key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#parameters GoogleBiglakeDatabase#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function googleBiglakeDatabaseHiveOptionsToTerraform(struct?: GoogleBiglakeDatabaseHiveOptionsOutputReference | GoogleBiglakeDatabaseHiveOptions): any;
export declare function googleBiglakeDatabaseHiveOptionsToHclTerraform(struct?: GoogleBiglakeDatabaseHiveOptionsOutputReference | GoogleBiglakeDatabaseHiveOptions): any;
export declare class GoogleBiglakeDatabaseHiveOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeDatabaseHiveOptions | undefined;
    set internalValue(value: GoogleBiglakeDatabaseHiveOptions | undefined);
    private _locationUri?;
    get locationUri(): string;
    set locationUri(value: string);
    resetLocationUri(): void;
    get locationUriInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleBiglakeDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#create GoogleBiglakeDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#delete GoogleBiglakeDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#update GoogleBiglakeDatabase#update}
    */
    readonly update?: string;
}
export declare function googleBiglakeDatabaseTimeoutsToTerraform(struct?: GoogleBiglakeDatabaseTimeouts | cdktf.IResolvable): any;
export declare function googleBiglakeDatabaseTimeoutsToHclTerraform(struct?: GoogleBiglakeDatabaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleBiglakeDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBiglakeDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database google_biglake_database}
*/
export declare class GoogleBiglakeDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_biglake_database";
    /**
    * Generates CDKTF code for importing a GoogleBiglakeDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBiglakeDatabase to import
    * @param importFromId The id of the existing GoogleBiglakeDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBiglakeDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_database google_biglake_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBiglakeDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBiglakeDatabaseConfig);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    get catalogInput(): string | undefined;
    get createTime(): string;
    get deleteTime(): string;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _hiveOptions;
    get hiveOptions(): GoogleBiglakeDatabaseHiveOptionsOutputReference;
    putHiveOptions(value: GoogleBiglakeDatabaseHiveOptions): void;
    get hiveOptionsInput(): GoogleBiglakeDatabaseHiveOptions | undefined;
    private _timeouts;
    get timeouts(): GoogleBiglakeDatabaseTimeoutsOutputReference;
    putTimeouts(value: GoogleBiglakeDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBiglakeDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
