/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBiglakeTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the parent database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#database GoogleBiglakeTable#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#id GoogleBiglakeTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Output only. The name of the Table. Format:
    * projects/{project_id_or_number}/locations/{locationId}/catalogs/{catalogId}/databases/{databaseId}/tables/{tableId}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#name GoogleBiglakeTable#name}
    */
    readonly name: string;
    /**
    * The database type. Possible values: ["HIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#type GoogleBiglakeTable#type}
    */
    readonly type?: string;
    /**
    * hive_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#hive_options GoogleBiglakeTable#hive_options}
    */
    readonly hiveOptions?: GoogleBiglakeTableHiveOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#timeouts GoogleBiglakeTable#timeouts}
    */
    readonly timeouts?: GoogleBiglakeTableTimeouts;
}
export interface GoogleBiglakeTableHiveOptionsStorageDescriptor {
    /**
    * The fully qualified Java class name of the input format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#input_format GoogleBiglakeTable#input_format}
    */
    readonly inputFormat?: string;
    /**
    * Cloud Storage folder URI where the table data is stored, starting with "gs://".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#location_uri GoogleBiglakeTable#location_uri}
    */
    readonly locationUri?: string;
    /**
    * The fully qualified Java class name of the output format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#output_format GoogleBiglakeTable#output_format}
    */
    readonly outputFormat?: string;
}
export declare function googleBiglakeTableHiveOptionsStorageDescriptorToTerraform(struct?: GoogleBiglakeTableHiveOptionsStorageDescriptorOutputReference | GoogleBiglakeTableHiveOptionsStorageDescriptor): any;
export declare function googleBiglakeTableHiveOptionsStorageDescriptorToHclTerraform(struct?: GoogleBiglakeTableHiveOptionsStorageDescriptorOutputReference | GoogleBiglakeTableHiveOptionsStorageDescriptor): any;
export declare class GoogleBiglakeTableHiveOptionsStorageDescriptorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeTableHiveOptionsStorageDescriptor | undefined;
    set internalValue(value: GoogleBiglakeTableHiveOptionsStorageDescriptor | undefined);
    private _inputFormat?;
    get inputFormat(): string;
    set inputFormat(value: string);
    resetInputFormat(): void;
    get inputFormatInput(): string | undefined;
    private _locationUri?;
    get locationUri(): string;
    set locationUri(value: string);
    resetLocationUri(): void;
    get locationUriInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
}
export interface GoogleBiglakeTableHiveOptions {
    /**
    * Stores user supplied Hive table parameters. An object containing a
    * list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#parameters GoogleBiglakeTable#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Hive table type. For example, MANAGED_TABLE, EXTERNAL_TABLE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#table_type GoogleBiglakeTable#table_type}
    */
    readonly tableType?: string;
    /**
    * storage_descriptor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#storage_descriptor GoogleBiglakeTable#storage_descriptor}
    */
    readonly storageDescriptor?: GoogleBiglakeTableHiveOptionsStorageDescriptor;
}
export declare function googleBiglakeTableHiveOptionsToTerraform(struct?: GoogleBiglakeTableHiveOptionsOutputReference | GoogleBiglakeTableHiveOptions): any;
export declare function googleBiglakeTableHiveOptionsToHclTerraform(struct?: GoogleBiglakeTableHiveOptionsOutputReference | GoogleBiglakeTableHiveOptions): any;
export declare class GoogleBiglakeTableHiveOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeTableHiveOptions | undefined;
    set internalValue(value: GoogleBiglakeTableHiveOptions | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tableType?;
    get tableType(): string;
    set tableType(value: string);
    resetTableType(): void;
    get tableTypeInput(): string | undefined;
    private _storageDescriptor;
    get storageDescriptor(): GoogleBiglakeTableHiveOptionsStorageDescriptorOutputReference;
    putStorageDescriptor(value: GoogleBiglakeTableHiveOptionsStorageDescriptor): void;
    resetStorageDescriptor(): void;
    get storageDescriptorInput(): GoogleBiglakeTableHiveOptionsStorageDescriptor | undefined;
}
export interface GoogleBiglakeTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#create GoogleBiglakeTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#delete GoogleBiglakeTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#update GoogleBiglakeTable#update}
    */
    readonly update?: string;
}
export declare function googleBiglakeTableTimeoutsToTerraform(struct?: GoogleBiglakeTableTimeouts | cdktf.IResolvable): any;
export declare function googleBiglakeTableTimeoutsToHclTerraform(struct?: GoogleBiglakeTableTimeouts | cdktf.IResolvable): any;
export declare class GoogleBiglakeTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBiglakeTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBiglakeTableTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table google_biglake_table}
*/
export declare class GoogleBiglakeTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_biglake_table";
    /**
    * Generates CDKTF code for importing a GoogleBiglakeTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBiglakeTable to import
    * @param importFromId The id of the existing GoogleBiglakeTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBiglakeTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_biglake_table google_biglake_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBiglakeTableConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBiglakeTableConfig);
    get createTime(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    get deleteTime(): string;
    get etag(): string;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _hiveOptions;
    get hiveOptions(): GoogleBiglakeTableHiveOptionsOutputReference;
    putHiveOptions(value: GoogleBiglakeTableHiveOptions): void;
    resetHiveOptions(): void;
    get hiveOptionsInput(): GoogleBiglakeTableHiveOptions | undefined;
    private _timeouts;
    get timeouts(): GoogleBiglakeTableTimeoutsOutputReference;
    putTimeouts(value: GoogleBiglakeTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBiglakeTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
