/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryAnalyticsHubListingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Categories of the listing. Up to two categories are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#categories GoogleBigqueryAnalyticsHubListing#categories}
    */
    readonly categories?: string[];
    /**
    * The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#data_exchange_id GoogleBigqueryAnalyticsHubListing#data_exchange_id}
    */
    readonly dataExchangeId: string;
    /**
    * Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#description GoogleBigqueryAnalyticsHubListing#description}
    */
    readonly description?: string;
    /**
    * Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#display_name GoogleBigqueryAnalyticsHubListing#display_name}
    */
    readonly displayName: string;
    /**
    * Documentation describing the listing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#documentation GoogleBigqueryAnalyticsHubListing#documentation}
    */
    readonly documentation?: string;
    /**
    * Base64 encoded image representing the listing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#icon GoogleBigqueryAnalyticsHubListing#icon}
    */
    readonly icon?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#id GoogleBigqueryAnalyticsHubListing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#listing_id GoogleBigqueryAnalyticsHubListing#listing_id}
    */
    readonly listingId: string;
    /**
    * The name of the location this data exchange listing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#location GoogleBigqueryAnalyticsHubListing#location}
    */
    readonly location: string;
    /**
    * Email or URL of the primary point of contact of the listing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#primary_contact GoogleBigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#project GoogleBigqueryAnalyticsHubListing#project}
    */
    readonly project?: string;
    /**
    * Email or URL of the request access of the listing. Subscribers can use this reference to request access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#request_access GoogleBigqueryAnalyticsHubListing#request_access}
    */
    readonly requestAccess?: string;
    /**
    * bigquery_dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#bigquery_dataset GoogleBigqueryAnalyticsHubListing#bigquery_dataset}
    */
    readonly bigqueryDataset: GoogleBigqueryAnalyticsHubListingBigqueryDataset;
    /**
    * data_provider block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#data_provider GoogleBigqueryAnalyticsHubListing#data_provider}
    */
    readonly dataProvider?: GoogleBigqueryAnalyticsHubListingDataProvider;
    /**
    * publisher block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#publisher GoogleBigqueryAnalyticsHubListing#publisher}
    */
    readonly publisher?: GoogleBigqueryAnalyticsHubListingPublisher;
    /**
    * restricted_export_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#restricted_export_config GoogleBigqueryAnalyticsHubListing#restricted_export_config}
    */
    readonly restrictedExportConfig?: GoogleBigqueryAnalyticsHubListingRestrictedExportConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#timeouts GoogleBigqueryAnalyticsHubListing#timeouts}
    */
    readonly timeouts?: GoogleBigqueryAnalyticsHubListingTimeouts;
}
export interface GoogleBigqueryAnalyticsHubListingBigqueryDataset {
    /**
    * Resource name of the dataset source for this listing. e.g. projects/myproject/datasets/123
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#dataset GoogleBigqueryAnalyticsHubListing#dataset}
    */
    readonly dataset: string;
}
export declare function googleBigqueryAnalyticsHubListingBigqueryDatasetToTerraform(struct?: GoogleBigqueryAnalyticsHubListingBigqueryDatasetOutputReference | GoogleBigqueryAnalyticsHubListingBigqueryDataset): any;
export declare function googleBigqueryAnalyticsHubListingBigqueryDatasetToHclTerraform(struct?: GoogleBigqueryAnalyticsHubListingBigqueryDatasetOutputReference | GoogleBigqueryAnalyticsHubListingBigqueryDataset): any;
export declare class GoogleBigqueryAnalyticsHubListingBigqueryDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryAnalyticsHubListingBigqueryDataset | undefined;
    set internalValue(value: GoogleBigqueryAnalyticsHubListingBigqueryDataset | undefined);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
}
export interface GoogleBigqueryAnalyticsHubListingDataProvider {
    /**
    * Name of the data provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#name GoogleBigqueryAnalyticsHubListing#name}
    */
    readonly name: string;
    /**
    * Email or URL of the data provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#primary_contact GoogleBigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
}
export declare function googleBigqueryAnalyticsHubListingDataProviderToTerraform(struct?: GoogleBigqueryAnalyticsHubListingDataProviderOutputReference | GoogleBigqueryAnalyticsHubListingDataProvider): any;
export declare function googleBigqueryAnalyticsHubListingDataProviderToHclTerraform(struct?: GoogleBigqueryAnalyticsHubListingDataProviderOutputReference | GoogleBigqueryAnalyticsHubListingDataProvider): any;
export declare class GoogleBigqueryAnalyticsHubListingDataProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryAnalyticsHubListingDataProvider | undefined;
    set internalValue(value: GoogleBigqueryAnalyticsHubListingDataProvider | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
}
export interface GoogleBigqueryAnalyticsHubListingPublisher {
    /**
    * Name of the listing publisher.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#name GoogleBigqueryAnalyticsHubListing#name}
    */
    readonly name: string;
    /**
    * Email or URL of the listing publisher.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#primary_contact GoogleBigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
}
export declare function googleBigqueryAnalyticsHubListingPublisherToTerraform(struct?: GoogleBigqueryAnalyticsHubListingPublisherOutputReference | GoogleBigqueryAnalyticsHubListingPublisher): any;
export declare function googleBigqueryAnalyticsHubListingPublisherToHclTerraform(struct?: GoogleBigqueryAnalyticsHubListingPublisherOutputReference | GoogleBigqueryAnalyticsHubListingPublisher): any;
export declare class GoogleBigqueryAnalyticsHubListingPublisherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryAnalyticsHubListingPublisher | undefined;
    set internalValue(value: GoogleBigqueryAnalyticsHubListingPublisher | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
}
export interface GoogleBigqueryAnalyticsHubListingRestrictedExportConfig {
    /**
    * If true, enable restricted export.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#enabled GoogleBigqueryAnalyticsHubListing#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * If true, restrict export of query result derived from restricted linked dataset table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#restrict_query_result GoogleBigqueryAnalyticsHubListing#restrict_query_result}
    */
    readonly restrictQueryResult?: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryAnalyticsHubListingRestrictedExportConfigToTerraform(struct?: GoogleBigqueryAnalyticsHubListingRestrictedExportConfigOutputReference | GoogleBigqueryAnalyticsHubListingRestrictedExportConfig): any;
export declare function googleBigqueryAnalyticsHubListingRestrictedExportConfigToHclTerraform(struct?: GoogleBigqueryAnalyticsHubListingRestrictedExportConfigOutputReference | GoogleBigqueryAnalyticsHubListingRestrictedExportConfig): any;
export declare class GoogleBigqueryAnalyticsHubListingRestrictedExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryAnalyticsHubListingRestrictedExportConfig | undefined;
    set internalValue(value: GoogleBigqueryAnalyticsHubListingRestrictedExportConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _restrictQueryResult?;
    get restrictQueryResult(): boolean | cdktf.IResolvable;
    set restrictQueryResult(value: boolean | cdktf.IResolvable);
    resetRestrictQueryResult(): void;
    get restrictQueryResultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleBigqueryAnalyticsHubListingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#create GoogleBigqueryAnalyticsHubListing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#delete GoogleBigqueryAnalyticsHubListing#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#update GoogleBigqueryAnalyticsHubListing#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryAnalyticsHubListingTimeoutsToTerraform(struct?: GoogleBigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable): any;
export declare function googleBigqueryAnalyticsHubListingTimeoutsToHclTerraform(struct?: GoogleBigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryAnalyticsHubListingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing google_bigquery_analytics_hub_listing}
*/
export declare class GoogleBigqueryAnalyticsHubListing extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_analytics_hub_listing";
    /**
    * Generates CDKTF code for importing a GoogleBigqueryAnalyticsHubListing resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigqueryAnalyticsHubListing to import
    * @param importFromId The id of the existing GoogleBigqueryAnalyticsHubListing that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigqueryAnalyticsHubListing to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_analytics_hub_listing google_bigquery_analytics_hub_listing} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryAnalyticsHubListingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryAnalyticsHubListingConfig);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _dataExchangeId?;
    get dataExchangeId(): string;
    set dataExchangeId(value: string);
    get dataExchangeIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _documentation?;
    get documentation(): string;
    set documentation(value: string);
    resetDocumentation(): void;
    get documentationInput(): string | undefined;
    private _icon?;
    get icon(): string;
    set icon(value: string);
    resetIcon(): void;
    get iconInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listingId?;
    get listingId(): string;
    set listingId(value: string);
    get listingIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requestAccess?;
    get requestAccess(): string;
    set requestAccess(value: string);
    resetRequestAccess(): void;
    get requestAccessInput(): string | undefined;
    private _bigqueryDataset;
    get bigqueryDataset(): GoogleBigqueryAnalyticsHubListingBigqueryDatasetOutputReference;
    putBigqueryDataset(value: GoogleBigqueryAnalyticsHubListingBigqueryDataset): void;
    get bigqueryDatasetInput(): GoogleBigqueryAnalyticsHubListingBigqueryDataset | undefined;
    private _dataProvider;
    get dataProvider(): GoogleBigqueryAnalyticsHubListingDataProviderOutputReference;
    putDataProvider(value: GoogleBigqueryAnalyticsHubListingDataProvider): void;
    resetDataProvider(): void;
    get dataProviderInput(): GoogleBigqueryAnalyticsHubListingDataProvider | undefined;
    private _publisher;
    get publisher(): GoogleBigqueryAnalyticsHubListingPublisherOutputReference;
    putPublisher(value: GoogleBigqueryAnalyticsHubListingPublisher): void;
    resetPublisher(): void;
    get publisherInput(): GoogleBigqueryAnalyticsHubListingPublisher | undefined;
    private _restrictedExportConfig;
    get restrictedExportConfig(): GoogleBigqueryAnalyticsHubListingRestrictedExportConfigOutputReference;
    putRestrictedExportConfig(value: GoogleBigqueryAnalyticsHubListingRestrictedExportConfig): void;
    resetRestrictedExportConfig(): void;
    get restrictedExportConfigInput(): GoogleBigqueryAnalyticsHubListingRestrictedExportConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryAnalyticsHubListingTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryAnalyticsHubListingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryAnalyticsHubListingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
