/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryBiReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#id GoogleBigqueryBiReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * LOCATION_DESCRIPTION
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#location GoogleBigqueryBiReservation#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#project GoogleBigqueryBiReservation#project}
    */
    readonly project?: string;
    /**
    * Size of a reservation, in bytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#size GoogleBigqueryBiReservation#size}
    */
    readonly size?: number;
    /**
    * preferred_tables block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#preferred_tables GoogleBigqueryBiReservation#preferred_tables}
    */
    readonly preferredTables?: GoogleBigqueryBiReservationPreferredTables[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#timeouts GoogleBigqueryBiReservation#timeouts}
    */
    readonly timeouts?: GoogleBigqueryBiReservationTimeouts;
}
export interface GoogleBigqueryBiReservationPreferredTables {
    /**
    * The ID of the dataset in the above project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#dataset_id GoogleBigqueryBiReservation#dataset_id}
    */
    readonly datasetId?: string;
    /**
    * The assigned project ID of the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#project_id GoogleBigqueryBiReservation#project_id}
    */
    readonly projectId?: string;
    /**
    * The ID of the table in the above dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#table_id GoogleBigqueryBiReservation#table_id}
    */
    readonly tableId?: string;
}
export declare function googleBigqueryBiReservationPreferredTablesToTerraform(struct?: GoogleBigqueryBiReservationPreferredTables | cdktf.IResolvable): any;
export declare function googleBigqueryBiReservationPreferredTablesToHclTerraform(struct?: GoogleBigqueryBiReservationPreferredTables | cdktf.IResolvable): any;
export declare class GoogleBigqueryBiReservationPreferredTablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigqueryBiReservationPreferredTables | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryBiReservationPreferredTables | cdktf.IResolvable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    resetDatasetId(): void;
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    resetTableId(): void;
    get tableIdInput(): string | undefined;
}
export declare class GoogleBigqueryBiReservationPreferredTablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigqueryBiReservationPreferredTables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigqueryBiReservationPreferredTablesOutputReference;
}
export interface GoogleBigqueryBiReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#create GoogleBigqueryBiReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#delete GoogleBigqueryBiReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#update GoogleBigqueryBiReservation#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryBiReservationTimeoutsToTerraform(struct?: GoogleBigqueryBiReservationTimeouts | cdktf.IResolvable): any;
export declare function googleBigqueryBiReservationTimeoutsToHclTerraform(struct?: GoogleBigqueryBiReservationTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryBiReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryBiReservationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryBiReservationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation google_bigquery_bi_reservation}
*/
export declare class GoogleBigqueryBiReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_bi_reservation";
    /**
    * Generates CDKTF code for importing a GoogleBigqueryBiReservation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigqueryBiReservation to import
    * @param importFromId The id of the existing GoogleBigqueryBiReservation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigqueryBiReservation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_bi_reservation google_bigquery_bi_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryBiReservationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryBiReservationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    get updateTime(): string;
    private _preferredTables;
    get preferredTables(): GoogleBigqueryBiReservationPreferredTablesList;
    putPreferredTables(value: GoogleBigqueryBiReservationPreferredTables[] | cdktf.IResolvable): void;
    resetPreferredTables(): void;
    get preferredTablesInput(): cdktf.IResolvable | GoogleBigqueryBiReservationPreferredTables[] | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryBiReservationTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryBiReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryBiReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
