/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional connection id that should be assigned to the created connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#connection_id GoogleBigqueryConnection#connection_id}
    */
    readonly connectionId?: string;
    /**
    * A descriptive description for the connection
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#description GoogleBigqueryConnection#description}
    */
    readonly description?: string;
    /**
    * A descriptive name for the connection
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#friendly_name GoogleBigqueryConnection#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#id GoogleBigqueryConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the connection should reside.
    * Cloud SQL instance must be in the same location as the connection
    * with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
    * Examples: US, EU, asia-northeast1, us-central1, europe-west1.
    * Spanner Connections same as spanner region
    * AWS allowed regions are aws-us-east-1
    * Azure allowed regions are azure-eastus2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#location GoogleBigqueryConnection#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#project GoogleBigqueryConnection#project}
    */
    readonly project?: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#aws GoogleBigqueryConnection#aws}
    */
    readonly aws?: GoogleBigqueryConnectionAws;
    /**
    * azure block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#azure GoogleBigqueryConnection#azure}
    */
    readonly azure?: GoogleBigqueryConnectionAzure;
    /**
    * cloud_resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#cloud_resource GoogleBigqueryConnection#cloud_resource}
    */
    readonly cloudResource?: GoogleBigqueryConnectionCloudResource;
    /**
    * cloud_spanner block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#cloud_spanner GoogleBigqueryConnection#cloud_spanner}
    */
    readonly cloudSpanner?: GoogleBigqueryConnectionCloudSpanner;
    /**
    * cloud_sql block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#cloud_sql GoogleBigqueryConnection#cloud_sql}
    */
    readonly cloudSql?: GoogleBigqueryConnectionCloudSql;
    /**
    * spark block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#spark GoogleBigqueryConnection#spark}
    */
    readonly spark?: GoogleBigqueryConnectionSpark;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#timeouts GoogleBigqueryConnection#timeouts}
    */
    readonly timeouts?: GoogleBigqueryConnectionTimeouts;
}
export interface GoogleBigqueryConnectionAwsAccessRole {
    /**
    * The user’s AWS IAM Role that trusts the Google-owned AWS IAM user Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#iam_role_id GoogleBigqueryConnection#iam_role_id}
    */
    readonly iamRoleId: string;
}
export declare function googleBigqueryConnectionAwsAccessRoleToTerraform(struct?: GoogleBigqueryConnectionAwsAccessRoleOutputReference | GoogleBigqueryConnectionAwsAccessRole): any;
export declare function googleBigqueryConnectionAwsAccessRoleToHclTerraform(struct?: GoogleBigqueryConnectionAwsAccessRoleOutputReference | GoogleBigqueryConnectionAwsAccessRole): any;
export declare class GoogleBigqueryConnectionAwsAccessRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionAwsAccessRole | undefined;
    set internalValue(value: GoogleBigqueryConnectionAwsAccessRole | undefined);
    private _iamRoleId?;
    get iamRoleId(): string;
    set iamRoleId(value: string);
    get iamRoleIdInput(): string | undefined;
    get identity(): string;
}
export interface GoogleBigqueryConnectionAws {
    /**
    * access_role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#access_role GoogleBigqueryConnection#access_role}
    */
    readonly accessRole: GoogleBigqueryConnectionAwsAccessRole;
}
export declare function googleBigqueryConnectionAwsToTerraform(struct?: GoogleBigqueryConnectionAwsOutputReference | GoogleBigqueryConnectionAws): any;
export declare function googleBigqueryConnectionAwsToHclTerraform(struct?: GoogleBigqueryConnectionAwsOutputReference | GoogleBigqueryConnectionAws): any;
export declare class GoogleBigqueryConnectionAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionAws | undefined;
    set internalValue(value: GoogleBigqueryConnectionAws | undefined);
    private _accessRole;
    get accessRole(): GoogleBigqueryConnectionAwsAccessRoleOutputReference;
    putAccessRole(value: GoogleBigqueryConnectionAwsAccessRole): void;
    get accessRoleInput(): GoogleBigqueryConnectionAwsAccessRole | undefined;
}
export interface GoogleBigqueryConnectionAzure {
    /**
    * The id of customer's directory that host the data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#customer_tenant_id GoogleBigqueryConnection#customer_tenant_id}
    */
    readonly customerTenantId: string;
    /**
    * The Azure Application (client) ID where the federated credentials will be hosted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#federated_application_client_id GoogleBigqueryConnection#federated_application_client_id}
    */
    readonly federatedApplicationClientId?: string;
}
export declare function googleBigqueryConnectionAzureToTerraform(struct?: GoogleBigqueryConnectionAzureOutputReference | GoogleBigqueryConnectionAzure): any;
export declare function googleBigqueryConnectionAzureToHclTerraform(struct?: GoogleBigqueryConnectionAzureOutputReference | GoogleBigqueryConnectionAzure): any;
export declare class GoogleBigqueryConnectionAzureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionAzure | undefined;
    set internalValue(value: GoogleBigqueryConnectionAzure | undefined);
    get application(): string;
    get clientId(): string;
    private _customerTenantId?;
    get customerTenantId(): string;
    set customerTenantId(value: string);
    get customerTenantIdInput(): string | undefined;
    private _federatedApplicationClientId?;
    get federatedApplicationClientId(): string;
    set federatedApplicationClientId(value: string);
    resetFederatedApplicationClientId(): void;
    get federatedApplicationClientIdInput(): string | undefined;
    get identity(): string;
    get objectId(): string;
    get redirectUri(): string;
}
export interface GoogleBigqueryConnectionCloudResource {
}
export declare function googleBigqueryConnectionCloudResourceToTerraform(struct?: GoogleBigqueryConnectionCloudResourceOutputReference | GoogleBigqueryConnectionCloudResource): any;
export declare function googleBigqueryConnectionCloudResourceToHclTerraform(struct?: GoogleBigqueryConnectionCloudResourceOutputReference | GoogleBigqueryConnectionCloudResource): any;
export declare class GoogleBigqueryConnectionCloudResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionCloudResource | undefined;
    set internalValue(value: GoogleBigqueryConnectionCloudResource | undefined);
    get serviceAccountId(): string;
}
export interface GoogleBigqueryConnectionCloudSpanner {
    /**
    * Cloud Spanner database in the form 'project/instance/database'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#database GoogleBigqueryConnection#database}
    */
    readonly database: string;
    /**
    * Cloud Spanner database role for fine-grained access control. The Cloud Spanner admin should have provisioned the database role with appropriate permissions, such as 'SELECT' and 'INSERT'. Other users should only use roles provided by their Cloud Spanner admins. The database role name must start with a letter, and can only contain letters, numbers, and underscores. For more details, see https://cloud.google.com/spanner/docs/fgac-about.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#database_role GoogleBigqueryConnection#database_role}
    */
    readonly databaseRole?: string;
    /**
    * Allows setting max parallelism per query when executing on Spanner independent compute resources. If unspecified, default values of parallelism are chosen that are dependent on the Cloud Spanner instance configuration. 'useParallelism' and 'useDataBoost' must be set when setting max parallelism.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#max_parallelism GoogleBigqueryConnection#max_parallelism}
    */
    readonly maxParallelism?: number;
    /**
    * If set, the request will be executed via Spanner independent compute resources. 'use_parallelism' must be set when using data boost.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#use_data_boost GoogleBigqueryConnection#use_data_boost}
    */
    readonly useDataBoost?: boolean | cdktf.IResolvable;
    /**
    * If parallelism should be used when reading from Cloud Spanner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#use_parallelism GoogleBigqueryConnection#use_parallelism}
    */
    readonly useParallelism?: boolean | cdktf.IResolvable;
    /**
    * If the serverless analytics service should be used to read data from Cloud Spanner. 'useParallelism' must be set when using serverless analytics.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#use_serverless_analytics GoogleBigqueryConnection#use_serverless_analytics}
    */
    readonly useServerlessAnalytics?: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryConnectionCloudSpannerToTerraform(struct?: GoogleBigqueryConnectionCloudSpannerOutputReference | GoogleBigqueryConnectionCloudSpanner): any;
export declare function googleBigqueryConnectionCloudSpannerToHclTerraform(struct?: GoogleBigqueryConnectionCloudSpannerOutputReference | GoogleBigqueryConnectionCloudSpanner): any;
export declare class GoogleBigqueryConnectionCloudSpannerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionCloudSpanner | undefined;
    set internalValue(value: GoogleBigqueryConnectionCloudSpanner | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _databaseRole?;
    get databaseRole(): string;
    set databaseRole(value: string);
    resetDatabaseRole(): void;
    get databaseRoleInput(): string | undefined;
    private _maxParallelism?;
    get maxParallelism(): number;
    set maxParallelism(value: number);
    resetMaxParallelism(): void;
    get maxParallelismInput(): number | undefined;
    private _useDataBoost?;
    get useDataBoost(): boolean | cdktf.IResolvable;
    set useDataBoost(value: boolean | cdktf.IResolvable);
    resetUseDataBoost(): void;
    get useDataBoostInput(): boolean | cdktf.IResolvable | undefined;
    private _useParallelism?;
    get useParallelism(): boolean | cdktf.IResolvable;
    set useParallelism(value: boolean | cdktf.IResolvable);
    resetUseParallelism(): void;
    get useParallelismInput(): boolean | cdktf.IResolvable | undefined;
    private _useServerlessAnalytics?;
    get useServerlessAnalytics(): boolean | cdktf.IResolvable;
    set useServerlessAnalytics(value: boolean | cdktf.IResolvable);
    resetUseServerlessAnalytics(): void;
    get useServerlessAnalyticsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleBigqueryConnectionCloudSqlCredential {
    /**
    * Password for database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#password GoogleBigqueryConnection#password}
    */
    readonly password: string;
    /**
    * Username for database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#username GoogleBigqueryConnection#username}
    */
    readonly username: string;
}
export declare function googleBigqueryConnectionCloudSqlCredentialToTerraform(struct?: GoogleBigqueryConnectionCloudSqlCredentialOutputReference | GoogleBigqueryConnectionCloudSqlCredential): any;
export declare function googleBigqueryConnectionCloudSqlCredentialToHclTerraform(struct?: GoogleBigqueryConnectionCloudSqlCredentialOutputReference | GoogleBigqueryConnectionCloudSqlCredential): any;
export declare class GoogleBigqueryConnectionCloudSqlCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionCloudSqlCredential | undefined;
    set internalValue(value: GoogleBigqueryConnectionCloudSqlCredential | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleBigqueryConnectionCloudSql {
    /**
    * Database name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#database GoogleBigqueryConnection#database}
    */
    readonly database: string;
    /**
    * Cloud SQL instance ID in the form project:location:instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#instance_id GoogleBigqueryConnection#instance_id}
    */
    readonly instanceId: string;
    /**
    * Type of the Cloud SQL database. Possible values: ["DATABASE_TYPE_UNSPECIFIED", "POSTGRES", "MYSQL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#type GoogleBigqueryConnection#type}
    */
    readonly type: string;
    /**
    * credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#credential GoogleBigqueryConnection#credential}
    */
    readonly credential: GoogleBigqueryConnectionCloudSqlCredential;
}
export declare function googleBigqueryConnectionCloudSqlToTerraform(struct?: GoogleBigqueryConnectionCloudSqlOutputReference | GoogleBigqueryConnectionCloudSql): any;
export declare function googleBigqueryConnectionCloudSqlToHclTerraform(struct?: GoogleBigqueryConnectionCloudSqlOutputReference | GoogleBigqueryConnectionCloudSql): any;
export declare class GoogleBigqueryConnectionCloudSqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionCloudSql | undefined;
    set internalValue(value: GoogleBigqueryConnectionCloudSql | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get serviceAccountId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _credential;
    get credential(): GoogleBigqueryConnectionCloudSqlCredentialOutputReference;
    putCredential(value: GoogleBigqueryConnectionCloudSqlCredential): void;
    get credentialInput(): GoogleBigqueryConnectionCloudSqlCredential | undefined;
}
export interface GoogleBigqueryConnectionSparkMetastoreServiceConfig {
    /**
    * Resource name of an existing Dataproc Metastore service in the form of projects/[projectId]/locations/[region]/services/[serviceId].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#metastore_service GoogleBigqueryConnection#metastore_service}
    */
    readonly metastoreService?: string;
}
export declare function googleBigqueryConnectionSparkMetastoreServiceConfigToTerraform(struct?: GoogleBigqueryConnectionSparkMetastoreServiceConfigOutputReference | GoogleBigqueryConnectionSparkMetastoreServiceConfig): any;
export declare function googleBigqueryConnectionSparkMetastoreServiceConfigToHclTerraform(struct?: GoogleBigqueryConnectionSparkMetastoreServiceConfigOutputReference | GoogleBigqueryConnectionSparkMetastoreServiceConfig): any;
export declare class GoogleBigqueryConnectionSparkMetastoreServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionSparkMetastoreServiceConfig | undefined;
    set internalValue(value: GoogleBigqueryConnectionSparkMetastoreServiceConfig | undefined);
    private _metastoreService?;
    get metastoreService(): string;
    set metastoreService(value: string);
    resetMetastoreService(): void;
    get metastoreServiceInput(): string | undefined;
}
export interface GoogleBigqueryConnectionSparkSparkHistoryServerConfig {
    /**
    * Resource name of an existing Dataproc Cluster to act as a Spark History Server for the connection if the form of projects/[projectId]/regions/[region]/clusters/[cluster_name].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#dataproc_cluster GoogleBigqueryConnection#dataproc_cluster}
    */
    readonly dataprocCluster?: string;
}
export declare function googleBigqueryConnectionSparkSparkHistoryServerConfigToTerraform(struct?: GoogleBigqueryConnectionSparkSparkHistoryServerConfigOutputReference | GoogleBigqueryConnectionSparkSparkHistoryServerConfig): any;
export declare function googleBigqueryConnectionSparkSparkHistoryServerConfigToHclTerraform(struct?: GoogleBigqueryConnectionSparkSparkHistoryServerConfigOutputReference | GoogleBigqueryConnectionSparkSparkHistoryServerConfig): any;
export declare class GoogleBigqueryConnectionSparkSparkHistoryServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionSparkSparkHistoryServerConfig | undefined;
    set internalValue(value: GoogleBigqueryConnectionSparkSparkHistoryServerConfig | undefined);
    private _dataprocCluster?;
    get dataprocCluster(): string;
    set dataprocCluster(value: string);
    resetDataprocCluster(): void;
    get dataprocClusterInput(): string | undefined;
}
export interface GoogleBigqueryConnectionSpark {
    /**
    * metastore_service_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#metastore_service_config GoogleBigqueryConnection#metastore_service_config}
    */
    readonly metastoreServiceConfig?: GoogleBigqueryConnectionSparkMetastoreServiceConfig;
    /**
    * spark_history_server_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#spark_history_server_config GoogleBigqueryConnection#spark_history_server_config}
    */
    readonly sparkHistoryServerConfig?: GoogleBigqueryConnectionSparkSparkHistoryServerConfig;
}
export declare function googleBigqueryConnectionSparkToTerraform(struct?: GoogleBigqueryConnectionSparkOutputReference | GoogleBigqueryConnectionSpark): any;
export declare function googleBigqueryConnectionSparkToHclTerraform(struct?: GoogleBigqueryConnectionSparkOutputReference | GoogleBigqueryConnectionSpark): any;
export declare class GoogleBigqueryConnectionSparkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionSpark | undefined;
    set internalValue(value: GoogleBigqueryConnectionSpark | undefined);
    get serviceAccountId(): string;
    private _metastoreServiceConfig;
    get metastoreServiceConfig(): GoogleBigqueryConnectionSparkMetastoreServiceConfigOutputReference;
    putMetastoreServiceConfig(value: GoogleBigqueryConnectionSparkMetastoreServiceConfig): void;
    resetMetastoreServiceConfig(): void;
    get metastoreServiceConfigInput(): GoogleBigqueryConnectionSparkMetastoreServiceConfig | undefined;
    private _sparkHistoryServerConfig;
    get sparkHistoryServerConfig(): GoogleBigqueryConnectionSparkSparkHistoryServerConfigOutputReference;
    putSparkHistoryServerConfig(value: GoogleBigqueryConnectionSparkSparkHistoryServerConfig): void;
    resetSparkHistoryServerConfig(): void;
    get sparkHistoryServerConfigInput(): GoogleBigqueryConnectionSparkSparkHistoryServerConfig | undefined;
}
export interface GoogleBigqueryConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#create GoogleBigqueryConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#delete GoogleBigqueryConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#update GoogleBigqueryConnection#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryConnectionTimeoutsToTerraform(struct?: GoogleBigqueryConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleBigqueryConnectionTimeoutsToHclTerraform(struct?: GoogleBigqueryConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection google_bigquery_connection}
*/
export declare class GoogleBigqueryConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_connection";
    /**
    * Generates CDKTF code for importing a GoogleBigqueryConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigqueryConnection to import
    * @param importFromId The id of the existing GoogleBigqueryConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigqueryConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_connection google_bigquery_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryConnectionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleBigqueryConnectionConfig);
    private _connectionId?;
    get connectionId(): string;
    set connectionId(value: string);
    resetConnectionId(): void;
    get connectionIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    get hasCredential(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _aws;
    get aws(): GoogleBigqueryConnectionAwsOutputReference;
    putAws(value: GoogleBigqueryConnectionAws): void;
    resetAws(): void;
    get awsInput(): GoogleBigqueryConnectionAws | undefined;
    private _azure;
    get azure(): GoogleBigqueryConnectionAzureOutputReference;
    putAzure(value: GoogleBigqueryConnectionAzure): void;
    resetAzure(): void;
    get azureInput(): GoogleBigqueryConnectionAzure | undefined;
    private _cloudResource;
    get cloudResource(): GoogleBigqueryConnectionCloudResourceOutputReference;
    putCloudResource(value: GoogleBigqueryConnectionCloudResource): void;
    resetCloudResource(): void;
    get cloudResourceInput(): GoogleBigqueryConnectionCloudResource | undefined;
    private _cloudSpanner;
    get cloudSpanner(): GoogleBigqueryConnectionCloudSpannerOutputReference;
    putCloudSpanner(value: GoogleBigqueryConnectionCloudSpanner): void;
    resetCloudSpanner(): void;
    get cloudSpannerInput(): GoogleBigqueryConnectionCloudSpanner | undefined;
    private _cloudSql;
    get cloudSql(): GoogleBigqueryConnectionCloudSqlOutputReference;
    putCloudSql(value: GoogleBigqueryConnectionCloudSql): void;
    resetCloudSql(): void;
    get cloudSqlInput(): GoogleBigqueryConnectionCloudSql | undefined;
    private _spark;
    get spark(): GoogleBigqueryConnectionSparkOutputReference;
    putSpark(value: GoogleBigqueryConnectionSpark): void;
    resetSpark(): void;
    get sparkInput(): GoogleBigqueryConnectionSpark | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
