/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryRoutineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the dataset containing this routine
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#dataset_id GoogleBigqueryRoutine#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The body of the routine. For functions, this is the expression in the AS clause.
    * If language=SQL, it is the substring inside (but excluding) the parentheses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#definition_body GoogleBigqueryRoutine#definition_body}
    */
    readonly definitionBody: string;
    /**
    * The description of the routine if defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#description GoogleBigqueryRoutine#description}
    */
    readonly description?: string;
    /**
    * The determinism level of the JavaScript UDF if defined. Possible values: ["DETERMINISM_LEVEL_UNSPECIFIED", "DETERMINISTIC", "NOT_DETERMINISTIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#determinism_level GoogleBigqueryRoutine#determinism_level}
    */
    readonly determinismLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#id GoogleBigqueryRoutine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. If language = "JAVASCRIPT", this field stores the path of the
    * imported JAVASCRIPT libraries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#imported_libraries GoogleBigqueryRoutine#imported_libraries}
    */
    readonly importedLibraries?: string[];
    /**
    * The language of the routine. Possible values: ["SQL", "JAVASCRIPT", "PYTHON", "JAVA", "SCALA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#language GoogleBigqueryRoutine#language}
    */
    readonly language?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#project GoogleBigqueryRoutine#project}
    */
    readonly project?: string;
    /**
    * Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
    *
    * If absent, the return table type is inferred from definitionBody at query time in each query
    * that references this routine. If present, then the columns in the evaluated table result will
    * be cast to match the column types specificed in return table type, at query time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#return_table_type GoogleBigqueryRoutine#return_table_type}
    */
    readonly returnTableType?: string;
    /**
    * A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
    * If absent, the return type is inferred from definitionBody at query time in each query
    * that references this routine. If present, then the evaluated result will be cast to
    * the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
    * string, any changes to the string will create a diff, even if the JSON itself hasn't
    * changed. If the API returns a different value for the same schema, e.g. it switche
    * d the order of values or replaced STRUCT field type with RECORD field type, we currently
    * cannot suppress the recurring diff this causes. As a workaround, we recommend using
    * the schema as returned by the API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#return_type GoogleBigqueryRoutine#return_type}
    */
    readonly returnType?: string;
    /**
    * The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#routine_id GoogleBigqueryRoutine#routine_id}
    */
    readonly routineId: string;
    /**
    * The type of routine. Possible values: ["SCALAR_FUNCTION", "PROCEDURE", "TABLE_VALUED_FUNCTION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#routine_type GoogleBigqueryRoutine#routine_type}
    */
    readonly routineType: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#arguments GoogleBigqueryRoutine#arguments}
    */
    readonly arguments?: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable;
    /**
    * remote_function_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#remote_function_options GoogleBigqueryRoutine#remote_function_options}
    */
    readonly remoteFunctionOptions?: GoogleBigqueryRoutineRemoteFunctionOptions;
    /**
    * spark_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#spark_options GoogleBigqueryRoutine#spark_options}
    */
    readonly sparkOptions?: GoogleBigqueryRoutineSparkOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#timeouts GoogleBigqueryRoutine#timeouts}
    */
    readonly timeouts?: GoogleBigqueryRoutineTimeouts;
}
export interface GoogleBigqueryRoutineArguments {
    /**
    * Defaults to FIXED_TYPE. Default value: "FIXED_TYPE" Possible values: ["FIXED_TYPE", "ANY_TYPE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#argument_kind GoogleBigqueryRoutine#argument_kind}
    */
    readonly argumentKind?: string;
    /**
    * A JSON schema for the data type. Required unless argumentKind = ANY_TYPE.
    * ~>**NOTE**: Because this field expects a JSON string, any changes to the string
    * will create a diff, even if the JSON itself hasn't changed. If the API returns
    * a different value for the same schema, e.g. it switched the order of values
    * or replaced STRUCT field type with RECORD field type, we currently cannot
    * suppress the recurring diff this causes. As a workaround, we recommend using
    * the schema as returned by the API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#data_type GoogleBigqueryRoutine#data_type}
    */
    readonly dataType?: string;
    /**
    * Specifies whether the argument is input or output. Can be set for procedures only. Possible values: ["IN", "OUT", "INOUT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#mode GoogleBigqueryRoutine#mode}
    */
    readonly mode?: string;
    /**
    * The name of this argument. Can be absent for function return argument.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#name GoogleBigqueryRoutine#name}
    */
    readonly name?: string;
}
export declare function googleBigqueryRoutineArgumentsToTerraform(struct?: GoogleBigqueryRoutineArguments | cdktf.IResolvable): any;
export declare function googleBigqueryRoutineArgumentsToHclTerraform(struct?: GoogleBigqueryRoutineArguments | cdktf.IResolvable): any;
export declare class GoogleBigqueryRoutineArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigqueryRoutineArguments | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryRoutineArguments | cdktf.IResolvable | undefined);
    private _argumentKind?;
    get argumentKind(): string;
    set argumentKind(value: string);
    resetArgumentKind(): void;
    get argumentKindInput(): string | undefined;
    private _dataType?;
    get dataType(): string;
    set dataType(value: string);
    resetDataType(): void;
    get dataTypeInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleBigqueryRoutineArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigqueryRoutineArgumentsOutputReference;
}
export interface GoogleBigqueryRoutineRemoteFunctionOptions {
    /**
    * Fully qualified name of the user-provided connection object which holds
    * the authentication information to send requests to the remote service.
    * Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#connection GoogleBigqueryRoutine#connection}
    */
    readonly connection?: string;
    /**
    * Endpoint of the user-provided remote service, e.g.
    * 'https://us-east1-my_gcf_project.cloudfunctions.net/remote_add'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#endpoint GoogleBigqueryRoutine#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Max number of rows in each batch sent to the remote service. If absent or if 0,
    * BigQuery dynamically decides the number of rows in a batch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#max_batching_rows GoogleBigqueryRoutine#max_batching_rows}
    */
    readonly maxBatchingRows?: string;
    /**
    * User-defined context as a set of key/value pairs, which will be sent as function
    * invocation context together with batched arguments in the requests to the remote
    * service. The total number of bytes of keys and values must be less than 8KB.
    *
    * An object containing a list of "key": value pairs. Example:
    * '{ "name": "wrench", "mass": "1.3kg", "count": "3" }'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#user_defined_context GoogleBigqueryRoutine#user_defined_context}
    */
    readonly userDefinedContext?: {
        [key: string]: string;
    };
}
export declare function googleBigqueryRoutineRemoteFunctionOptionsToTerraform(struct?: GoogleBigqueryRoutineRemoteFunctionOptionsOutputReference | GoogleBigqueryRoutineRemoteFunctionOptions): any;
export declare function googleBigqueryRoutineRemoteFunctionOptionsToHclTerraform(struct?: GoogleBigqueryRoutineRemoteFunctionOptionsOutputReference | GoogleBigqueryRoutineRemoteFunctionOptions): any;
export declare class GoogleBigqueryRoutineRemoteFunctionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryRoutineRemoteFunctionOptions | undefined;
    set internalValue(value: GoogleBigqueryRoutineRemoteFunctionOptions | undefined);
    private _connection?;
    get connection(): string;
    set connection(value: string);
    resetConnection(): void;
    get connectionInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _maxBatchingRows?;
    get maxBatchingRows(): string;
    set maxBatchingRows(value: string);
    resetMaxBatchingRows(): void;
    get maxBatchingRowsInput(): string | undefined;
    private _userDefinedContext?;
    get userDefinedContext(): {
        [key: string]: string;
    };
    set userDefinedContext(value: {
        [key: string]: string;
    });
    resetUserDefinedContext(): void;
    get userDefinedContextInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleBigqueryRoutineSparkOptions {
    /**
    * Archive files to be extracted into the working directory of each executor. For more information about Apache Spark, see Apache Spark.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#archive_uris GoogleBigqueryRoutine#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Fully qualified name of the user-provided Spark connection object.
    * Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#connection GoogleBigqueryRoutine#connection}
    */
    readonly connection?: string;
    /**
    * Custom container image for the runtime environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#container_image GoogleBigqueryRoutine#container_image}
    */
    readonly containerImage?: string;
    /**
    * Files to be placed in the working directory of each executor. For more information about Apache Spark, see Apache Spark.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#file_uris GoogleBigqueryRoutine#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark, see Apache Spark.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#jar_uris GoogleBigqueryRoutine#jar_uris}
    */
    readonly jarUris?: string[];
    /**
    * The fully qualified name of a class in jarUris, for example, com.example.wordcount.
    * Exactly one of mainClass and main_jar_uri field should be set for Java/Scala language type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#main_class GoogleBigqueryRoutine#main_class}
    */
    readonly mainClass?: string;
    /**
    * The main file/jar URI of the Spark application.
    * Exactly one of the definitionBody field and the mainFileUri field must be set for Python.
    * Exactly one of mainClass and mainFileUri field should be set for Java/Scala language type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#main_file_uri GoogleBigqueryRoutine#main_file_uri}
    */
    readonly mainFileUri?: string;
    /**
    * Configuration properties as a set of key/value pairs, which will be passed on to the Spark application.
    * For more information, see Apache Spark and the procedure option list.
    * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#properties GoogleBigqueryRoutine#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Python files to be placed on the PYTHONPATH for PySpark application. Supported file types: .py, .egg, and .zip. For more information about Apache Spark, see Apache Spark.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#py_file_uris GoogleBigqueryRoutine#py_file_uris}
    */
    readonly pyFileUris?: string[];
    /**
    * Runtime version. If not specified, the default runtime version is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#runtime_version GoogleBigqueryRoutine#runtime_version}
    */
    readonly runtimeVersion?: string;
}
export declare function googleBigqueryRoutineSparkOptionsToTerraform(struct?: GoogleBigqueryRoutineSparkOptionsOutputReference | GoogleBigqueryRoutineSparkOptions): any;
export declare function googleBigqueryRoutineSparkOptionsToHclTerraform(struct?: GoogleBigqueryRoutineSparkOptionsOutputReference | GoogleBigqueryRoutineSparkOptions): any;
export declare class GoogleBigqueryRoutineSparkOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryRoutineSparkOptions | undefined;
    set internalValue(value: GoogleBigqueryRoutineSparkOptions | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _connection?;
    get connection(): string;
    set connection(value: string);
    resetConnection(): void;
    get connectionInput(): string | undefined;
    private _containerImage?;
    get containerImage(): string;
    set containerImage(value: string);
    resetContainerImage(): void;
    get containerImageInput(): string | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarUris?;
    get jarUris(): string[];
    set jarUris(value: string[]);
    resetJarUris(): void;
    get jarUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainFileUri?;
    get mainFileUri(): string;
    set mainFileUri(value: string);
    resetMainFileUri(): void;
    get mainFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pyFileUris?;
    get pyFileUris(): string[];
    set pyFileUris(value: string[]);
    resetPyFileUris(): void;
    get pyFileUrisInput(): string[] | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
}
export interface GoogleBigqueryRoutineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#create GoogleBigqueryRoutine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#delete GoogleBigqueryRoutine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#update GoogleBigqueryRoutine#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryRoutineTimeoutsToTerraform(struct?: GoogleBigqueryRoutineTimeouts | cdktf.IResolvable): any;
export declare function googleBigqueryRoutineTimeoutsToHclTerraform(struct?: GoogleBigqueryRoutineTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryRoutineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryRoutineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryRoutineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine google_bigquery_routine}
*/
export declare class GoogleBigqueryRoutine extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_routine";
    /**
    * Generates CDKTF code for importing a GoogleBigqueryRoutine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigqueryRoutine to import
    * @param importFromId The id of the existing GoogleBigqueryRoutine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigqueryRoutine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_routine google_bigquery_routine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryRoutineConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryRoutineConfig);
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _definitionBody?;
    get definitionBody(): string;
    set definitionBody(value: string);
    get definitionBodyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _determinismLevel?;
    get determinismLevel(): string;
    set determinismLevel(value: string);
    resetDeterminismLevel(): void;
    get determinismLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importedLibraries?;
    get importedLibraries(): string[];
    set importedLibraries(value: string[]);
    resetImportedLibraries(): void;
    get importedLibrariesInput(): string[] | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    get lastModifiedTime(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _returnTableType?;
    get returnTableType(): string;
    set returnTableType(value: string);
    resetReturnTableType(): void;
    get returnTableTypeInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    resetReturnType(): void;
    get returnTypeInput(): string | undefined;
    private _routineId?;
    get routineId(): string;
    set routineId(value: string);
    get routineIdInput(): string | undefined;
    private _routineType?;
    get routineType(): string;
    set routineType(value: string);
    get routineTypeInput(): string | undefined;
    private _arguments;
    get arguments(): GoogleBigqueryRoutineArgumentsList;
    putArguments(value: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | GoogleBigqueryRoutineArguments[] | undefined;
    private _remoteFunctionOptions;
    get remoteFunctionOptions(): GoogleBigqueryRoutineRemoteFunctionOptionsOutputReference;
    putRemoteFunctionOptions(value: GoogleBigqueryRoutineRemoteFunctionOptions): void;
    resetRemoteFunctionOptions(): void;
    get remoteFunctionOptionsInput(): GoogleBigqueryRoutineRemoteFunctionOptions | undefined;
    private _sparkOptions;
    get sparkOptions(): GoogleBigqueryRoutineSparkOptionsOutputReference;
    putSparkOptions(value: GoogleBigqueryRoutineSparkOptions): void;
    resetSparkOptions(): void;
    get sparkOptionsInput(): GoogleBigqueryRoutineSparkOptions | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryRoutineTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryRoutineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryRoutineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
