/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies column names to use for data clustering. Up to four top-level columns are allowed, and should be specified in descending priority order.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#clustering GoogleBigqueryTable#clustering}
    */
    readonly clustering?: string[];
    /**
    * The dataset ID to create the table in. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#dataset_id GoogleBigqueryTable#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Whether or not to allow Terraform to destroy the instance. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#deletion_protection GoogleBigqueryTable#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * The field description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#description GoogleBigqueryTable#description}
    */
    readonly description?: string;
    /**
    * The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#expiration_time GoogleBigqueryTable#expiration_time}
    */
    readonly expirationTime?: number;
    /**
    * A descriptive name for the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#friendly_name GoogleBigqueryTable#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#id GoogleBigqueryTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A mapping of labels to assign to the resource.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#labels GoogleBigqueryTable#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The maximum staleness of data that could be returned when the table (or stale MV) is queried. Staleness encoded as a string encoding of [SQL IntervalValue type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#max_staleness GoogleBigqueryTable#max_staleness}
    */
    readonly maxStaleness?: string;
    /**
    * The ID of the project in which the resource belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#project GoogleBigqueryTable#project}
    */
    readonly project?: string;
    /**
    * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#require_partition_filter GoogleBigqueryTable#require_partition_filter}
    */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
    * A JSON schema for the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#schema GoogleBigqueryTable#schema}
    */
    readonly schema?: string;
    /**
    * A unique ID for the resource. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#table_id GoogleBigqueryTable#table_id}
    */
    readonly tableId: string;
    /**
    * encryption_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#encryption_configuration GoogleBigqueryTable#encryption_configuration}
    */
    readonly encryptionConfiguration?: GoogleBigqueryTableEncryptionConfiguration;
    /**
    * external_data_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#external_data_configuration GoogleBigqueryTable#external_data_configuration}
    */
    readonly externalDataConfiguration?: GoogleBigqueryTableExternalDataConfiguration;
    /**
    * materialized_view block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#materialized_view GoogleBigqueryTable#materialized_view}
    */
    readonly materializedView?: GoogleBigqueryTableMaterializedView;
    /**
    * range_partitioning block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#range_partitioning GoogleBigqueryTable#range_partitioning}
    */
    readonly rangePartitioning?: GoogleBigqueryTableRangePartitioning;
    /**
    * table_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#table_constraints GoogleBigqueryTable#table_constraints}
    */
    readonly tableConstraints?: GoogleBigqueryTableTableConstraints;
    /**
    * table_replication_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#table_replication_info GoogleBigqueryTable#table_replication_info}
    */
    readonly tableReplicationInfo?: GoogleBigqueryTableTableReplicationInfo;
    /**
    * time_partitioning block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#time_partitioning GoogleBigqueryTable#time_partitioning}
    */
    readonly timePartitioning?: GoogleBigqueryTableTimePartitioning;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#view GoogleBigqueryTable#view}
    */
    readonly view?: GoogleBigqueryTableView;
}
export interface GoogleBigqueryTableEncryptionConfiguration {
    /**
    * The self link or full name of a key which should be used to encrypt this table. Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#kms_key_name GoogleBigqueryTable#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleBigqueryTableEncryptionConfigurationToTerraform(struct?: GoogleBigqueryTableEncryptionConfigurationOutputReference | GoogleBigqueryTableEncryptionConfiguration): any;
export declare function googleBigqueryTableEncryptionConfigurationToHclTerraform(struct?: GoogleBigqueryTableEncryptionConfigurationOutputReference | GoogleBigqueryTableEncryptionConfiguration): any;
export declare class GoogleBigqueryTableEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableEncryptionConfiguration | undefined;
    set internalValue(value: GoogleBigqueryTableEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersion(): string;
}
export interface GoogleBigqueryTableExternalDataConfigurationAvroOptions {
    /**
    * If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#use_avro_logical_types GoogleBigqueryTable#use_avro_logical_types}
    */
    readonly useAvroLogicalTypes: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryTableExternalDataConfigurationAvroOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationAvroOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationAvroOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationAvroOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationAvroOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationAvroOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationAvroOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationAvroOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationAvroOptions | undefined);
    private _useAvroLogicalTypes?;
    get useAvroLogicalTypes(): boolean | cdktf.IResolvable;
    set useAvroLogicalTypes(value: boolean | cdktf.IResolvable);
    get useAvroLogicalTypesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleBigqueryTableExternalDataConfigurationCsvOptions {
    /**
    * Indicates if BigQuery should accept rows that are missing trailing optional columns.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#allow_jagged_rows GoogleBigqueryTable#allow_jagged_rows}
    */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
    * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#allow_quoted_newlines GoogleBigqueryTable#allow_quoted_newlines}
    */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
    * The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#encoding GoogleBigqueryTable#encoding}
    */
    readonly encoding?: string;
    /**
    * The separator for fields in a CSV file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#field_delimiter GoogleBigqueryTable#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * The value that is used to quote data sections in a CSV file. If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as \". Due to limitations with Terraform default values, this value is required to be explicitly set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#quote GoogleBigqueryTable#quote}
    */
    readonly quote: string;
    /**
    * The number of rows at the top of a CSV file that BigQuery will skip when reading the data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#skip_leading_rows GoogleBigqueryTable#skip_leading_rows}
    */
    readonly skipLeadingRows?: number;
}
export declare function googleBigqueryTableExternalDataConfigurationCsvOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationCsvOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationCsvOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationCsvOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationCsvOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationCsvOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationCsvOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationCsvOptions | undefined);
    private _allowJaggedRows?;
    get allowJaggedRows(): boolean | cdktf.IResolvable;
    set allowJaggedRows(value: boolean | cdktf.IResolvable);
    resetAllowJaggedRows(): void;
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    get allowQuotedNewlines(): boolean | cdktf.IResolvable;
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable);
    resetAllowQuotedNewlines(): void;
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _quote?;
    get quote(): string;
    set quote(value: string);
    get quoteInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number;
    set skipLeadingRows(value: number);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions {
    /**
    * Range of a sheet to query from. Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#range GoogleBigqueryTable#range}
    */
    readonly range?: string;
    /**
    * The number of rows at the top of the sheet that BigQuery will skip when reading the data. At least one of range or skip_leading_rows must be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#skip_leading_rows GoogleBigqueryTable#skip_leading_rows}
    */
    readonly skipLeadingRows?: number;
}
export declare function googleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined);
    private _range?;
    get range(): string;
    set range(value: string);
    resetRange(): void;
    get rangeInput(): string | undefined;
    private _skipLeadingRows?;
    get skipLeadingRows(): number;
    set skipLeadingRows(value: number);
    resetSkipLeadingRows(): void;
    get skipLeadingRowsInput(): number | undefined;
}
export interface GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions {
    /**
    * When set, what mode of hive partitioning to use when reading data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#mode GoogleBigqueryTable#mode}
    */
    readonly mode?: string;
    /**
    * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#require_partition_filter GoogleBigqueryTable#require_partition_filter}
    */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
    * When hive partition detection is requested, a common for all source uris must be required. The prefix must end immediately before the partition key encoding begins.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_uri_prefix GoogleBigqueryTable#source_uri_prefix}
    */
    readonly sourceUriPrefix?: string;
}
export declare function googleBigqueryTableExternalDataConfigurationHivePartitioningOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationHivePartitioningOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceUriPrefix?;
    get sourceUriPrefix(): string;
    set sourceUriPrefix(value: string);
    resetSourceUriPrefix(): void;
    get sourceUriPrefixInput(): string | undefined;
}
export interface GoogleBigqueryTableExternalDataConfigurationJsonOptions {
    /**
    * The character encoding of the data. The supported values are UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#encoding GoogleBigqueryTable#encoding}
    */
    readonly encoding?: string;
}
export declare function googleBigqueryTableExternalDataConfigurationJsonOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationJsonOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationJsonOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationJsonOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationJsonOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationJsonOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationJsonOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationJsonOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationJsonOptions | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
}
export interface GoogleBigqueryTableExternalDataConfigurationParquetOptions {
    /**
    * Indicates whether to use schema inference specifically for Parquet LIST logical type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#enable_list_inference GoogleBigqueryTable#enable_list_inference}
    */
    readonly enableListInference?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#enum_as_string GoogleBigqueryTable#enum_as_string}
    */
    readonly enumAsString?: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryTableExternalDataConfigurationParquetOptionsToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationParquetOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationParquetOptions): any;
export declare function googleBigqueryTableExternalDataConfigurationParquetOptionsToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationParquetOptionsOutputReference | GoogleBigqueryTableExternalDataConfigurationParquetOptions): any;
export declare class GoogleBigqueryTableExternalDataConfigurationParquetOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfigurationParquetOptions | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfigurationParquetOptions | undefined);
    private _enableListInference?;
    get enableListInference(): boolean | cdktf.IResolvable;
    set enableListInference(value: boolean | cdktf.IResolvable);
    resetEnableListInference(): void;
    get enableListInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _enumAsString?;
    get enumAsString(): boolean | cdktf.IResolvable;
    set enumAsString(value: boolean | cdktf.IResolvable);
    resetEnumAsString(): void;
    get enumAsStringInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleBigqueryTableExternalDataConfiguration {
    /**
    * Let BigQuery try to autodetect the schema and format of the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#autodetect GoogleBigqueryTable#autodetect}
    */
    readonly autodetect: boolean | cdktf.IResolvable;
    /**
    * The compression type of the data source. Valid values are "NONE" or "GZIP".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#compression GoogleBigqueryTable#compression}
    */
    readonly compression?: string;
    /**
    * The connection specifying the credentials to be used to read external storage, such as Azure Blob, Cloud Storage, or S3. The connectionId can have the form "{{project}}.{{location}}.{{connection_id}}" or "projects/{{project}}/locations/{{location}}/connections/{{connection_id}}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#connection_id GoogleBigqueryTable#connection_id}
    */
    readonly connectionId?: string;
    /**
    * Specifies how source URIs are interpreted for constructing the file set to load.  By default source URIs are expanded against the underlying storage.  Other options include specifying manifest files. Only applicable to object storage systems.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#file_set_spec_type GoogleBigqueryTable#file_set_spec_type}
    */
    readonly fileSetSpecType?: string;
    /**
    * Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#ignore_unknown_values GoogleBigqueryTable#ignore_unknown_values}
    */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of bad records that BigQuery can ignore when reading data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#max_bad_records GoogleBigqueryTable#max_bad_records}
    */
    readonly maxBadRecords?: number;
    /**
    * Metadata Cache Mode for the table. Set this to enable caching of metadata from external data source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#metadata_cache_mode GoogleBigqueryTable#metadata_cache_mode}
    */
    readonly metadataCacheMode?: string;
    /**
    * Object Metadata is used to create Object Tables. Object Tables contain a listing of objects (with their metadata) found at the sourceUris. If ObjectMetadata is set, sourceFormat should be omitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#object_metadata GoogleBigqueryTable#object_metadata}
    */
    readonly objectMetadata?: string;
    /**
    * When creating an external table, the user can provide a reference file with the table schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#reference_file_schema_uri GoogleBigqueryTable#reference_file_schema_uri}
    */
    readonly referenceFileSchemaUri?: string;
    /**
    * A JSON schema for the external table. Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#schema GoogleBigqueryTable#schema}
    */
    readonly schema?: string;
    /**
    *  Please see sourceFormat under ExternalDataConfiguration in Bigquery's public API documentation (https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#externaldataconfiguration) for supported formats. To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_format GoogleBigqueryTable#source_format}
    */
    readonly sourceFormat?: string;
    /**
    * A list of the fully-qualified URIs that point to your data in Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_uris GoogleBigqueryTable#source_uris}
    */
    readonly sourceUris: string[];
    /**
    * avro_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#avro_options GoogleBigqueryTable#avro_options}
    */
    readonly avroOptions?: GoogleBigqueryTableExternalDataConfigurationAvroOptions;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#csv_options GoogleBigqueryTable#csv_options}
    */
    readonly csvOptions?: GoogleBigqueryTableExternalDataConfigurationCsvOptions;
    /**
    * google_sheets_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#google_sheets_options GoogleBigqueryTable#google_sheets_options}
    */
    readonly googleSheetsOptions?: GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions;
    /**
    * hive_partitioning_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#hive_partitioning_options GoogleBigqueryTable#hive_partitioning_options}
    */
    readonly hivePartitioningOptions?: GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions;
    /**
    * json_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#json_options GoogleBigqueryTable#json_options}
    */
    readonly jsonOptions?: GoogleBigqueryTableExternalDataConfigurationJsonOptions;
    /**
    * parquet_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#parquet_options GoogleBigqueryTable#parquet_options}
    */
    readonly parquetOptions?: GoogleBigqueryTableExternalDataConfigurationParquetOptions;
}
export declare function googleBigqueryTableExternalDataConfigurationToTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationOutputReference | GoogleBigqueryTableExternalDataConfiguration): any;
export declare function googleBigqueryTableExternalDataConfigurationToHclTerraform(struct?: GoogleBigqueryTableExternalDataConfigurationOutputReference | GoogleBigqueryTableExternalDataConfiguration): any;
export declare class GoogleBigqueryTableExternalDataConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableExternalDataConfiguration | undefined;
    set internalValue(value: GoogleBigqueryTableExternalDataConfiguration | undefined);
    private _autodetect?;
    get autodetect(): boolean | cdktf.IResolvable;
    set autodetect(value: boolean | cdktf.IResolvable);
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _connectionId?;
    get connectionId(): string;
    set connectionId(value: string);
    resetConnectionId(): void;
    get connectionIdInput(): string | undefined;
    private _fileSetSpecType?;
    get fileSetSpecType(): string;
    set fileSetSpecType(value: string);
    resetFileSetSpecType(): void;
    get fileSetSpecTypeInput(): string | undefined;
    private _ignoreUnknownValues?;
    get ignoreUnknownValues(): boolean | cdktf.IResolvable;
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable);
    resetIgnoreUnknownValues(): void;
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    get maxBadRecords(): number;
    set maxBadRecords(value: number);
    resetMaxBadRecords(): void;
    get maxBadRecordsInput(): number | undefined;
    private _metadataCacheMode?;
    get metadataCacheMode(): string;
    set metadataCacheMode(value: string);
    resetMetadataCacheMode(): void;
    get metadataCacheModeInput(): string | undefined;
    private _objectMetadata?;
    get objectMetadata(): string;
    set objectMetadata(value: string);
    resetObjectMetadata(): void;
    get objectMetadataInput(): string | undefined;
    private _referenceFileSchemaUri?;
    get referenceFileSchemaUri(): string;
    set referenceFileSchemaUri(value: string);
    resetReferenceFileSchemaUri(): void;
    get referenceFileSchemaUriInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    resetSourceFormat(): void;
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    get sourceUris(): string[];
    set sourceUris(value: string[]);
    get sourceUrisInput(): string[] | undefined;
    private _avroOptions;
    get avroOptions(): GoogleBigqueryTableExternalDataConfigurationAvroOptionsOutputReference;
    putAvroOptions(value: GoogleBigqueryTableExternalDataConfigurationAvroOptions): void;
    resetAvroOptions(): void;
    get avroOptionsInput(): GoogleBigqueryTableExternalDataConfigurationAvroOptions | undefined;
    private _csvOptions;
    get csvOptions(): GoogleBigqueryTableExternalDataConfigurationCsvOptionsOutputReference;
    putCsvOptions(value: GoogleBigqueryTableExternalDataConfigurationCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): GoogleBigqueryTableExternalDataConfigurationCsvOptions | undefined;
    private _googleSheetsOptions;
    get googleSheetsOptions(): GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptionsOutputReference;
    putGoogleSheetsOptions(value: GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions): void;
    resetGoogleSheetsOptions(): void;
    get googleSheetsOptionsInput(): GoogleBigqueryTableExternalDataConfigurationGoogleSheetsOptions | undefined;
    private _hivePartitioningOptions;
    get hivePartitioningOptions(): GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptionsOutputReference;
    putHivePartitioningOptions(value: GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions): void;
    resetHivePartitioningOptions(): void;
    get hivePartitioningOptionsInput(): GoogleBigqueryTableExternalDataConfigurationHivePartitioningOptions | undefined;
    private _jsonOptions;
    get jsonOptions(): GoogleBigqueryTableExternalDataConfigurationJsonOptionsOutputReference;
    putJsonOptions(value: GoogleBigqueryTableExternalDataConfigurationJsonOptions): void;
    resetJsonOptions(): void;
    get jsonOptionsInput(): GoogleBigqueryTableExternalDataConfigurationJsonOptions | undefined;
    private _parquetOptions;
    get parquetOptions(): GoogleBigqueryTableExternalDataConfigurationParquetOptionsOutputReference;
    putParquetOptions(value: GoogleBigqueryTableExternalDataConfigurationParquetOptions): void;
    resetParquetOptions(): void;
    get parquetOptionsInput(): GoogleBigqueryTableExternalDataConfigurationParquetOptions | undefined;
}
export interface GoogleBigqueryTableMaterializedView {
    /**
    * Allow non incremental materialized view definition. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#allow_non_incremental_definition GoogleBigqueryTable#allow_non_incremental_definition}
    */
    readonly allowNonIncrementalDefinition?: boolean | cdktf.IResolvable;
    /**
    * Specifies if BigQuery should automatically refresh materialized view when the base table is updated. The default is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#enable_refresh GoogleBigqueryTable#enable_refresh}
    */
    readonly enableRefresh?: boolean | cdktf.IResolvable;
    /**
    * A query whose result is persisted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#query GoogleBigqueryTable#query}
    */
    readonly query: string;
    /**
    * Specifies maximum frequency at which this materialized view will be refreshed. The default is 1800000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#refresh_interval_ms GoogleBigqueryTable#refresh_interval_ms}
    */
    readonly refreshIntervalMs?: number;
}
export declare function googleBigqueryTableMaterializedViewToTerraform(struct?: GoogleBigqueryTableMaterializedViewOutputReference | GoogleBigqueryTableMaterializedView): any;
export declare function googleBigqueryTableMaterializedViewToHclTerraform(struct?: GoogleBigqueryTableMaterializedViewOutputReference | GoogleBigqueryTableMaterializedView): any;
export declare class GoogleBigqueryTableMaterializedViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableMaterializedView | undefined;
    set internalValue(value: GoogleBigqueryTableMaterializedView | undefined);
    private _allowNonIncrementalDefinition?;
    get allowNonIncrementalDefinition(): boolean | cdktf.IResolvable;
    set allowNonIncrementalDefinition(value: boolean | cdktf.IResolvable);
    resetAllowNonIncrementalDefinition(): void;
    get allowNonIncrementalDefinitionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableRefresh?;
    get enableRefresh(): boolean | cdktf.IResolvable;
    set enableRefresh(value: boolean | cdktf.IResolvable);
    resetEnableRefresh(): void;
    get enableRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _refreshIntervalMs?;
    get refreshIntervalMs(): number;
    set refreshIntervalMs(value: number);
    resetRefreshIntervalMs(): void;
    get refreshIntervalMsInput(): number | undefined;
}
export interface GoogleBigqueryTableRangePartitioningRange {
    /**
    * End of the range partitioning, exclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#end GoogleBigqueryTable#end}
    */
    readonly end: number;
    /**
    * The width of each range within the partition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#interval GoogleBigqueryTable#interval}
    */
    readonly interval: number;
    /**
    * Start of the range partitioning, inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#start GoogleBigqueryTable#start}
    */
    readonly start: number;
}
export declare function googleBigqueryTableRangePartitioningRangeToTerraform(struct?: GoogleBigqueryTableRangePartitioningRangeOutputReference | GoogleBigqueryTableRangePartitioningRange): any;
export declare function googleBigqueryTableRangePartitioningRangeToHclTerraform(struct?: GoogleBigqueryTableRangePartitioningRangeOutputReference | GoogleBigqueryTableRangePartitioningRange): any;
export declare class GoogleBigqueryTableRangePartitioningRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableRangePartitioningRange | undefined;
    set internalValue(value: GoogleBigqueryTableRangePartitioningRange | undefined);
    private _end?;
    get end(): number;
    set end(value: number);
    get endInput(): number | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    get startInput(): number | undefined;
}
export interface GoogleBigqueryTableRangePartitioning {
    /**
    * The field used to determine how to create a range-based partition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#field GoogleBigqueryTable#field}
    */
    readonly field: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#range GoogleBigqueryTable#range}
    */
    readonly range: GoogleBigqueryTableRangePartitioningRange;
}
export declare function googleBigqueryTableRangePartitioningToTerraform(struct?: GoogleBigqueryTableRangePartitioningOutputReference | GoogleBigqueryTableRangePartitioning): any;
export declare function googleBigqueryTableRangePartitioningToHclTerraform(struct?: GoogleBigqueryTableRangePartitioningOutputReference | GoogleBigqueryTableRangePartitioning): any;
export declare class GoogleBigqueryTableRangePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableRangePartitioning | undefined;
    set internalValue(value: GoogleBigqueryTableRangePartitioning | undefined);
    private _field?;
    get field(): string;
    set field(value: string);
    get fieldInput(): string | undefined;
    private _range;
    get range(): GoogleBigqueryTableRangePartitioningRangeOutputReference;
    putRange(value: GoogleBigqueryTableRangePartitioningRange): void;
    get rangeInput(): GoogleBigqueryTableRangePartitioningRange | undefined;
}
export interface GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences {
    /**
    * The column in the primary key that are referenced by the referencingColumn.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#referenced_column GoogleBigqueryTable#referenced_column}
    */
    readonly referencedColumn: string;
    /**
    * The column that composes the foreign key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#referencing_column GoogleBigqueryTable#referencing_column}
    */
    readonly referencingColumn: string;
}
export declare function googleBigqueryTableTableConstraintsForeignKeysColumnReferencesToTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeysColumnReferencesOutputReference | GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences): any;
export declare function googleBigqueryTableTableConstraintsForeignKeysColumnReferencesToHclTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeysColumnReferencesOutputReference | GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences): any;
export declare class GoogleBigqueryTableTableConstraintsForeignKeysColumnReferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences | undefined;
    set internalValue(value: GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences | undefined);
    private _referencedColumn?;
    get referencedColumn(): string;
    set referencedColumn(value: string);
    get referencedColumnInput(): string | undefined;
    private _referencingColumn?;
    get referencingColumn(): string;
    set referencingColumn(value: string);
    get referencingColumnInput(): string | undefined;
}
export interface GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#dataset_id GoogleBigqueryTable#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#project_id GoogleBigqueryTable#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters. Certain operations allow suffixing of the table ID with a partition decorator, such as sample_table$20190123.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#table_id GoogleBigqueryTable#table_id}
    */
    readonly tableId: string;
}
export declare function googleBigqueryTableTableConstraintsForeignKeysReferencedTableToTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeysReferencedTableOutputReference | GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable): any;
export declare function googleBigqueryTableTableConstraintsForeignKeysReferencedTableToHclTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeysReferencedTableOutputReference | GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable): any;
export declare class GoogleBigqueryTableTableConstraintsForeignKeysReferencedTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable | undefined;
    set internalValue(value: GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface GoogleBigqueryTableTableConstraintsForeignKeys {
    /**
    * Set only if the foreign key constraint is named.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#name GoogleBigqueryTable#name}
    */
    readonly name?: string;
    /**
    * column_references block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#column_references GoogleBigqueryTable#column_references}
    */
    readonly columnReferences: GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences;
    /**
    * referenced_table block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#referenced_table GoogleBigqueryTable#referenced_table}
    */
    readonly referencedTable: GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable;
}
export declare function googleBigqueryTableTableConstraintsForeignKeysToTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeys | cdktf.IResolvable): any;
export declare function googleBigqueryTableTableConstraintsForeignKeysToHclTerraform(struct?: GoogleBigqueryTableTableConstraintsForeignKeys | cdktf.IResolvable): any;
export declare class GoogleBigqueryTableTableConstraintsForeignKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigqueryTableTableConstraintsForeignKeys | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryTableTableConstraintsForeignKeys | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _columnReferences;
    get columnReferences(): GoogleBigqueryTableTableConstraintsForeignKeysColumnReferencesOutputReference;
    putColumnReferences(value: GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences): void;
    get columnReferencesInput(): GoogleBigqueryTableTableConstraintsForeignKeysColumnReferences | undefined;
    private _referencedTable;
    get referencedTable(): GoogleBigqueryTableTableConstraintsForeignKeysReferencedTableOutputReference;
    putReferencedTable(value: GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable): void;
    get referencedTableInput(): GoogleBigqueryTableTableConstraintsForeignKeysReferencedTable | undefined;
}
export declare class GoogleBigqueryTableTableConstraintsForeignKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigqueryTableTableConstraintsForeignKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigqueryTableTableConstraintsForeignKeysOutputReference;
}
export interface GoogleBigqueryTableTableConstraintsPrimaryKey {
    /**
    * The columns that are composed of the primary key constraint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#columns GoogleBigqueryTable#columns}
    */
    readonly columns: string[];
}
export declare function googleBigqueryTableTableConstraintsPrimaryKeyToTerraform(struct?: GoogleBigqueryTableTableConstraintsPrimaryKeyOutputReference | GoogleBigqueryTableTableConstraintsPrimaryKey): any;
export declare function googleBigqueryTableTableConstraintsPrimaryKeyToHclTerraform(struct?: GoogleBigqueryTableTableConstraintsPrimaryKeyOutputReference | GoogleBigqueryTableTableConstraintsPrimaryKey): any;
export declare class GoogleBigqueryTableTableConstraintsPrimaryKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTableConstraintsPrimaryKey | undefined;
    set internalValue(value: GoogleBigqueryTableTableConstraintsPrimaryKey | undefined);
    private _columns?;
    get columns(): string[];
    set columns(value: string[]);
    get columnsInput(): string[] | undefined;
}
export interface GoogleBigqueryTableTableConstraints {
    /**
    * foreign_keys block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#foreign_keys GoogleBigqueryTable#foreign_keys}
    */
    readonly foreignKeys?: GoogleBigqueryTableTableConstraintsForeignKeys[] | cdktf.IResolvable;
    /**
    * primary_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#primary_key GoogleBigqueryTable#primary_key}
    */
    readonly primaryKey?: GoogleBigqueryTableTableConstraintsPrimaryKey;
}
export declare function googleBigqueryTableTableConstraintsToTerraform(struct?: GoogleBigqueryTableTableConstraintsOutputReference | GoogleBigqueryTableTableConstraints): any;
export declare function googleBigqueryTableTableConstraintsToHclTerraform(struct?: GoogleBigqueryTableTableConstraintsOutputReference | GoogleBigqueryTableTableConstraints): any;
export declare class GoogleBigqueryTableTableConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTableConstraints | undefined;
    set internalValue(value: GoogleBigqueryTableTableConstraints | undefined);
    private _foreignKeys;
    get foreignKeys(): GoogleBigqueryTableTableConstraintsForeignKeysList;
    putForeignKeys(value: GoogleBigqueryTableTableConstraintsForeignKeys[] | cdktf.IResolvable): void;
    resetForeignKeys(): void;
    get foreignKeysInput(): cdktf.IResolvable | GoogleBigqueryTableTableConstraintsForeignKeys[] | undefined;
    private _primaryKey;
    get primaryKey(): GoogleBigqueryTableTableConstraintsPrimaryKeyOutputReference;
    putPrimaryKey(value: GoogleBigqueryTableTableConstraintsPrimaryKey): void;
    resetPrimaryKey(): void;
    get primaryKeyInput(): GoogleBigqueryTableTableConstraintsPrimaryKey | undefined;
}
export interface GoogleBigqueryTableTableReplicationInfo {
    /**
    * The interval at which the source materialized view is polled for updates. The default is 300000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#replication_interval_ms GoogleBigqueryTable#replication_interval_ms}
    */
    readonly replicationIntervalMs?: number;
    /**
    * The ID of the source dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_dataset_id GoogleBigqueryTable#source_dataset_id}
    */
    readonly sourceDatasetId: string;
    /**
    * The ID of the source project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_project_id GoogleBigqueryTable#source_project_id}
    */
    readonly sourceProjectId: string;
    /**
    * The ID of the source materialized view.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#source_table_id GoogleBigqueryTable#source_table_id}
    */
    readonly sourceTableId: string;
}
export declare function googleBigqueryTableTableReplicationInfoToTerraform(struct?: GoogleBigqueryTableTableReplicationInfoOutputReference | GoogleBigqueryTableTableReplicationInfo): any;
export declare function googleBigqueryTableTableReplicationInfoToHclTerraform(struct?: GoogleBigqueryTableTableReplicationInfoOutputReference | GoogleBigqueryTableTableReplicationInfo): any;
export declare class GoogleBigqueryTableTableReplicationInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTableReplicationInfo | undefined;
    set internalValue(value: GoogleBigqueryTableTableReplicationInfo | undefined);
    private _replicationIntervalMs?;
    get replicationIntervalMs(): number;
    set replicationIntervalMs(value: number);
    resetReplicationIntervalMs(): void;
    get replicationIntervalMsInput(): number | undefined;
    private _sourceDatasetId?;
    get sourceDatasetId(): string;
    set sourceDatasetId(value: string);
    get sourceDatasetIdInput(): string | undefined;
    private _sourceProjectId?;
    get sourceProjectId(): string;
    set sourceProjectId(value: string);
    get sourceProjectIdInput(): string | undefined;
    private _sourceTableId?;
    get sourceTableId(): string;
    set sourceTableId(value: string);
    get sourceTableIdInput(): string | undefined;
}
export interface GoogleBigqueryTableTimePartitioning {
    /**
    * Number of milliseconds for which to keep the storage for a partition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#expiration_ms GoogleBigqueryTable#expiration_ms}
    */
    readonly expirationMs?: number;
    /**
    * The field used to determine how to create a time-based partition. If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#field GoogleBigqueryTable#field}
    */
    readonly field?: string;
    /**
    * If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#require_partition_filter GoogleBigqueryTable#require_partition_filter}
    */
    readonly requirePartitionFilter?: boolean | cdktf.IResolvable;
    /**
    * The supported types are DAY, HOUR, MONTH, and YEAR, which will generate one partition per day, hour, month, and year, respectively.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#type GoogleBigqueryTable#type}
    */
    readonly type: string;
}
export declare function googleBigqueryTableTimePartitioningToTerraform(struct?: GoogleBigqueryTableTimePartitioningOutputReference | GoogleBigqueryTableTimePartitioning): any;
export declare function googleBigqueryTableTimePartitioningToHclTerraform(struct?: GoogleBigqueryTableTimePartitioningOutputReference | GoogleBigqueryTableTimePartitioning): any;
export declare class GoogleBigqueryTableTimePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableTimePartitioning | undefined;
    set internalValue(value: GoogleBigqueryTableTimePartitioning | undefined);
    private _expirationMs?;
    get expirationMs(): number;
    set expirationMs(value: number);
    resetExpirationMs(): void;
    get expirationMsInput(): number | undefined;
    private _field?;
    get field(): string;
    set field(value: string);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleBigqueryTableView {
    /**
    * A query that BigQuery executes when the view is referenced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#query GoogleBigqueryTable#query}
    */
    readonly query: string;
    /**
    * Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#use_legacy_sql GoogleBigqueryTable#use_legacy_sql}
    */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryTableViewToTerraform(struct?: GoogleBigqueryTableViewOutputReference | GoogleBigqueryTableView): any;
export declare function googleBigqueryTableViewToHclTerraform(struct?: GoogleBigqueryTableViewOutputReference | GoogleBigqueryTableView): any;
export declare class GoogleBigqueryTableViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryTableView | undefined;
    set internalValue(value: GoogleBigqueryTableView | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _useLegacySql?;
    get useLegacySql(): boolean | cdktf.IResolvable;
    set useLegacySql(value: boolean | cdktf.IResolvable);
    resetUseLegacySql(): void;
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table google_bigquery_table}
*/
export declare class GoogleBigqueryTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_table";
    /**
    * Generates CDKTF code for importing a GoogleBigqueryTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigqueryTable to import
    * @param importFromId The id of the existing GoogleBigqueryTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigqueryTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigquery_table google_bigquery_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryTableConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryTableConfig);
    private _clustering?;
    get clustering(): string[];
    set clustering(value: string[]);
    resetClustering(): void;
    get clusteringInput(): string[] | undefined;
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _expirationTime?;
    get expirationTime(): number;
    set expirationTime(value: number);
    resetExpirationTime(): void;
    get expirationTimeInput(): number | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastModifiedTime(): number;
    get location(): string;
    private _maxStaleness?;
    get maxStaleness(): string;
    set maxStaleness(value: string);
    resetMaxStaleness(): void;
    get maxStalenessInput(): string | undefined;
    get numBytes(): number;
    get numLongTermBytes(): number;
    get numRows(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requirePartitionFilter?;
    get requirePartitionFilter(): boolean | cdktf.IResolvable;
    set requirePartitionFilter(value: boolean | cdktf.IResolvable);
    resetRequirePartitionFilter(): void;
    get requirePartitionFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    get selfLink(): string;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get type(): string;
    private _encryptionConfiguration;
    get encryptionConfiguration(): GoogleBigqueryTableEncryptionConfigurationOutputReference;
    putEncryptionConfiguration(value: GoogleBigqueryTableEncryptionConfiguration): void;
    resetEncryptionConfiguration(): void;
    get encryptionConfigurationInput(): GoogleBigqueryTableEncryptionConfiguration | undefined;
    private _externalDataConfiguration;
    get externalDataConfiguration(): GoogleBigqueryTableExternalDataConfigurationOutputReference;
    putExternalDataConfiguration(value: GoogleBigqueryTableExternalDataConfiguration): void;
    resetExternalDataConfiguration(): void;
    get externalDataConfigurationInput(): GoogleBigqueryTableExternalDataConfiguration | undefined;
    private _materializedView;
    get materializedView(): GoogleBigqueryTableMaterializedViewOutputReference;
    putMaterializedView(value: GoogleBigqueryTableMaterializedView): void;
    resetMaterializedView(): void;
    get materializedViewInput(): GoogleBigqueryTableMaterializedView | undefined;
    private _rangePartitioning;
    get rangePartitioning(): GoogleBigqueryTableRangePartitioningOutputReference;
    putRangePartitioning(value: GoogleBigqueryTableRangePartitioning): void;
    resetRangePartitioning(): void;
    get rangePartitioningInput(): GoogleBigqueryTableRangePartitioning | undefined;
    private _tableConstraints;
    get tableConstraints(): GoogleBigqueryTableTableConstraintsOutputReference;
    putTableConstraints(value: GoogleBigqueryTableTableConstraints): void;
    resetTableConstraints(): void;
    get tableConstraintsInput(): GoogleBigqueryTableTableConstraints | undefined;
    private _tableReplicationInfo;
    get tableReplicationInfo(): GoogleBigqueryTableTableReplicationInfoOutputReference;
    putTableReplicationInfo(value: GoogleBigqueryTableTableReplicationInfo): void;
    resetTableReplicationInfo(): void;
    get tableReplicationInfoInput(): GoogleBigqueryTableTableReplicationInfo | undefined;
    private _timePartitioning;
    get timePartitioning(): GoogleBigqueryTableTimePartitioningOutputReference;
    putTimePartitioning(value: GoogleBigqueryTableTimePartitioning): void;
    resetTimePartitioning(): void;
    get timePartitioningInput(): GoogleBigqueryTableTimePartitioning | undefined;
    private _view;
    get view(): GoogleBigqueryTableViewOutputReference;
    putView(value: GoogleBigqueryTableView): void;
    resetView(): void;
    get viewInput(): GoogleBigqueryTableView | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
