/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigtableAppProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique name of the app profile in the form '[_a-zA-Z0-9][-_.a-zA-Z0-9]*'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#app_profile_id GoogleBigtableAppProfile#app_profile_id}
    */
    readonly appProfileId: string;
    /**
    * Long form description of the use case for this app profile.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#description GoogleBigtableAppProfile#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#id GoogleBigtableAppProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If true, ignore safety checks when deleting/updating the app profile.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#ignore_warnings GoogleBigtableAppProfile#ignore_warnings}
    */
    readonly ignoreWarnings?: boolean | cdktf.IResolvable;
    /**
    * The name of the instance to create the app profile within.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#instance GoogleBigtableAppProfile#instance}
    */
    readonly instance?: string;
    /**
    * The set of clusters to route to. The order is ignored; clusters will be tried in order of distance. If left empty, all clusters are eligible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#multi_cluster_routing_cluster_ids GoogleBigtableAppProfile#multi_cluster_routing_cluster_ids}
    */
    readonly multiClusterRoutingClusterIds?: string[];
    /**
    * If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available
    * in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
    * consistency to improve availability.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#multi_cluster_routing_use_any GoogleBigtableAppProfile#multi_cluster_routing_use_any}
    */
    readonly multiClusterRoutingUseAny?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#project GoogleBigtableAppProfile#project}
    */
    readonly project?: string;
    /**
    * single_cluster_routing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#single_cluster_routing GoogleBigtableAppProfile#single_cluster_routing}
    */
    readonly singleClusterRouting?: GoogleBigtableAppProfileSingleClusterRouting;
    /**
    * standard_isolation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#standard_isolation GoogleBigtableAppProfile#standard_isolation}
    */
    readonly standardIsolation?: GoogleBigtableAppProfileStandardIsolation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#timeouts GoogleBigtableAppProfile#timeouts}
    */
    readonly timeouts?: GoogleBigtableAppProfileTimeouts;
}
export interface GoogleBigtableAppProfileSingleClusterRouting {
    /**
    * If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
    * It is unsafe to send these requests to the same table/row/column in multiple clusters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#allow_transactional_writes GoogleBigtableAppProfile#allow_transactional_writes}
    */
    readonly allowTransactionalWrites?: boolean | cdktf.IResolvable;
    /**
    * The cluster to which read/write requests should be routed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#cluster_id GoogleBigtableAppProfile#cluster_id}
    */
    readonly clusterId: string;
}
export declare function googleBigtableAppProfileSingleClusterRoutingToTerraform(struct?: GoogleBigtableAppProfileSingleClusterRoutingOutputReference | GoogleBigtableAppProfileSingleClusterRouting): any;
export declare function googleBigtableAppProfileSingleClusterRoutingToHclTerraform(struct?: GoogleBigtableAppProfileSingleClusterRoutingOutputReference | GoogleBigtableAppProfileSingleClusterRouting): any;
export declare class GoogleBigtableAppProfileSingleClusterRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableAppProfileSingleClusterRouting | undefined;
    set internalValue(value: GoogleBigtableAppProfileSingleClusterRouting | undefined);
    private _allowTransactionalWrites?;
    get allowTransactionalWrites(): boolean | cdktf.IResolvable;
    set allowTransactionalWrites(value: boolean | cdktf.IResolvable);
    resetAllowTransactionalWrites(): void;
    get allowTransactionalWritesInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
}
export interface GoogleBigtableAppProfileStandardIsolation {
    /**
    * The priority of requests sent using this app profile. Possible values: ["PRIORITY_LOW", "PRIORITY_MEDIUM", "PRIORITY_HIGH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#priority GoogleBigtableAppProfile#priority}
    */
    readonly priority: string;
}
export declare function googleBigtableAppProfileStandardIsolationToTerraform(struct?: GoogleBigtableAppProfileStandardIsolationOutputReference | GoogleBigtableAppProfileStandardIsolation): any;
export declare function googleBigtableAppProfileStandardIsolationToHclTerraform(struct?: GoogleBigtableAppProfileStandardIsolationOutputReference | GoogleBigtableAppProfileStandardIsolation): any;
export declare class GoogleBigtableAppProfileStandardIsolationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableAppProfileStandardIsolation | undefined;
    set internalValue(value: GoogleBigtableAppProfileStandardIsolation | undefined);
    private _priority?;
    get priority(): string;
    set priority(value: string);
    get priorityInput(): string | undefined;
}
export interface GoogleBigtableAppProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#create GoogleBigtableAppProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#delete GoogleBigtableAppProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#update GoogleBigtableAppProfile#update}
    */
    readonly update?: string;
}
export declare function googleBigtableAppProfileTimeoutsToTerraform(struct?: GoogleBigtableAppProfileTimeouts | cdktf.IResolvable): any;
export declare function googleBigtableAppProfileTimeoutsToHclTerraform(struct?: GoogleBigtableAppProfileTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigtableAppProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableAppProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableAppProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile google_bigtable_app_profile}
*/
export declare class GoogleBigtableAppProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_app_profile";
    /**
    * Generates CDKTF code for importing a GoogleBigtableAppProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigtableAppProfile to import
    * @param importFromId The id of the existing GoogleBigtableAppProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigtableAppProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_app_profile google_bigtable_app_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigtableAppProfileConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigtableAppProfileConfig);
    private _appProfileId?;
    get appProfileId(): string;
    set appProfileId(value: string);
    get appProfileIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreWarnings?;
    get ignoreWarnings(): boolean | cdktf.IResolvable;
    set ignoreWarnings(value: boolean | cdktf.IResolvable);
    resetIgnoreWarnings(): void;
    get ignoreWarningsInput(): boolean | cdktf.IResolvable | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _multiClusterRoutingClusterIds?;
    get multiClusterRoutingClusterIds(): string[];
    set multiClusterRoutingClusterIds(value: string[]);
    resetMultiClusterRoutingClusterIds(): void;
    get multiClusterRoutingClusterIdsInput(): string[] | undefined;
    private _multiClusterRoutingUseAny?;
    get multiClusterRoutingUseAny(): boolean | cdktf.IResolvable;
    set multiClusterRoutingUseAny(value: boolean | cdktf.IResolvable);
    resetMultiClusterRoutingUseAny(): void;
    get multiClusterRoutingUseAnyInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _singleClusterRouting;
    get singleClusterRouting(): GoogleBigtableAppProfileSingleClusterRoutingOutputReference;
    putSingleClusterRouting(value: GoogleBigtableAppProfileSingleClusterRouting): void;
    resetSingleClusterRouting(): void;
    get singleClusterRoutingInput(): GoogleBigtableAppProfileSingleClusterRouting | undefined;
    private _standardIsolation;
    get standardIsolation(): GoogleBigtableAppProfileStandardIsolationOutputReference;
    putStandardIsolation(value: GoogleBigtableAppProfileStandardIsolation): void;
    resetStandardIsolation(): void;
    get standardIsolationInput(): GoogleBigtableAppProfileStandardIsolation | undefined;
    private _timeouts;
    get timeouts(): GoogleBigtableAppProfileTimeoutsOutputReference;
    putTimeouts(value: GoogleBigtableAppProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigtableAppProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
