/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigtableGcPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the column family.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#column_family GoogleBigtableGcPolicy#column_family}
    */
    readonly columnFamily: string;
    /**
    * The deletion policy for the GC policy. Setting ABANDON allows the resource
    * 				to be abandoned rather than deleted. This is useful for GC policy as it cannot be deleted
    * 				in a replicated instance. Possible values are: "ABANDON".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#deletion_policy GoogleBigtableGcPolicy#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * Serialized JSON string for garbage collection policy. Conflicts with "mode", "max_age" and "max_version".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#gc_rules GoogleBigtableGcPolicy#gc_rules}
    */
    readonly gcRules?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#id GoogleBigtableGcPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Bigtable instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#instance_name GoogleBigtableGcPolicy#instance_name}
    */
    readonly instanceName: string;
    /**
    * NOTE: 'gc_rules' is more flexible, and should be preferred over this field for new resources. This field may be deprecated in the future. If multiple policies are set, you should choose between UNION OR INTERSECTION.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#mode GoogleBigtableGcPolicy#mode}
    */
    readonly mode?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#project GoogleBigtableGcPolicy#project}
    */
    readonly project?: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#table GoogleBigtableGcPolicy#table}
    */
    readonly table: string;
    /**
    * max_age block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#max_age GoogleBigtableGcPolicy#max_age}
    */
    readonly maxAge?: GoogleBigtableGcPolicyMaxAge;
    /**
    * max_version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#max_version GoogleBigtableGcPolicy#max_version}
    */
    readonly maxVersion?: GoogleBigtableGcPolicyMaxVersion[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#timeouts GoogleBigtableGcPolicy#timeouts}
    */
    readonly timeouts?: GoogleBigtableGcPolicyTimeouts;
}
export interface GoogleBigtableGcPolicyMaxAge {
    /**
    * Number of days before applying GC policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#days GoogleBigtableGcPolicy#days}
    */
    readonly days?: number;
    /**
    * Duration before applying GC policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#duration GoogleBigtableGcPolicy#duration}
    */
    readonly duration?: string;
}
export declare function googleBigtableGcPolicyMaxAgeToTerraform(struct?: GoogleBigtableGcPolicyMaxAgeOutputReference | GoogleBigtableGcPolicyMaxAge): any;
export declare function googleBigtableGcPolicyMaxAgeToHclTerraform(struct?: GoogleBigtableGcPolicyMaxAgeOutputReference | GoogleBigtableGcPolicyMaxAge): any;
export declare class GoogleBigtableGcPolicyMaxAgeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableGcPolicyMaxAge | undefined;
    set internalValue(value: GoogleBigtableGcPolicyMaxAge | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
}
export interface GoogleBigtableGcPolicyMaxVersion {
    /**
    * Number of version before applying the GC policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#number GoogleBigtableGcPolicy#number}
    */
    readonly number: number;
}
export declare function googleBigtableGcPolicyMaxVersionToTerraform(struct?: GoogleBigtableGcPolicyMaxVersion | cdktf.IResolvable): any;
export declare function googleBigtableGcPolicyMaxVersionToHclTerraform(struct?: GoogleBigtableGcPolicyMaxVersion | cdktf.IResolvable): any;
export declare class GoogleBigtableGcPolicyMaxVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigtableGcPolicyMaxVersion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableGcPolicyMaxVersion | cdktf.IResolvable | undefined);
    private _number?;
    get number(): number;
    set number(value: number);
    get numberInput(): number | undefined;
}
export declare class GoogleBigtableGcPolicyMaxVersionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigtableGcPolicyMaxVersion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigtableGcPolicyMaxVersionOutputReference;
}
export interface GoogleBigtableGcPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#create GoogleBigtableGcPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#delete GoogleBigtableGcPolicy#delete}
    */
    readonly delete?: string;
}
export declare function googleBigtableGcPolicyTimeoutsToTerraform(struct?: GoogleBigtableGcPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleBigtableGcPolicyTimeoutsToHclTerraform(struct?: GoogleBigtableGcPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigtableGcPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableGcPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableGcPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy google_bigtable_gc_policy}
*/
export declare class GoogleBigtableGcPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_gc_policy";
    /**
    * Generates CDKTF code for importing a GoogleBigtableGcPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBigtableGcPolicy to import
    * @param importFromId The id of the existing GoogleBigtableGcPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBigtableGcPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_bigtable_gc_policy google_bigtable_gc_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigtableGcPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigtableGcPolicyConfig);
    private _columnFamily?;
    get columnFamily(): string;
    set columnFamily(value: string);
    get columnFamilyInput(): string | undefined;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _gcRules?;
    get gcRules(): string;
    set gcRules(value: string);
    resetGcRules(): void;
    get gcRulesInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _maxAge;
    get maxAge(): GoogleBigtableGcPolicyMaxAgeOutputReference;
    putMaxAge(value: GoogleBigtableGcPolicyMaxAge): void;
    resetMaxAge(): void;
    get maxAgeInput(): GoogleBigtableGcPolicyMaxAge | undefined;
    private _maxVersion;
    get maxVersion(): GoogleBigtableGcPolicyMaxVersionList;
    putMaxVersion(value: GoogleBigtableGcPolicyMaxVersion[] | cdktf.IResolvable): void;
    resetMaxVersion(): void;
    get maxVersionInput(): cdktf.IResolvable | GoogleBigtableGcPolicyMaxVersion[] | undefined;
    private _timeouts;
    get timeouts(): GoogleBigtableGcPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleBigtableGcPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigtableGcPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
