/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBillingProjectInfoConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the billing account associated with the project, if
    * any. Set to empty string to disable billing for the project.
    * For example, '"012345-567890-ABCDEF"' or '""'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#billing_account GoogleBillingProjectInfo#billing_account}
    */
    readonly billingAccount: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#id GoogleBillingProjectInfo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#project GoogleBillingProjectInfo#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#timeouts GoogleBillingProjectInfo#timeouts}
    */
    readonly timeouts?: GoogleBillingProjectInfoTimeouts;
}
export interface GoogleBillingProjectInfoTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#create GoogleBillingProjectInfo#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#delete GoogleBillingProjectInfo#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#update GoogleBillingProjectInfo#update}
    */
    readonly update?: string;
}
export declare function googleBillingProjectInfoTimeoutsToTerraform(struct?: GoogleBillingProjectInfoTimeouts | cdktf.IResolvable): any;
export declare function googleBillingProjectInfoTimeoutsToHclTerraform(struct?: GoogleBillingProjectInfoTimeouts | cdktf.IResolvable): any;
export declare class GoogleBillingProjectInfoTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBillingProjectInfoTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBillingProjectInfoTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info google_billing_project_info}
*/
export declare class GoogleBillingProjectInfo extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_billing_project_info";
    /**
    * Generates CDKTF code for importing a GoogleBillingProjectInfo resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBillingProjectInfo to import
    * @param importFromId The id of the existing GoogleBillingProjectInfo that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBillingProjectInfo to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_project_info google_billing_project_info} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBillingProjectInfoConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBillingProjectInfoConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleBillingProjectInfoTimeoutsOutputReference;
    putTimeouts(value: GoogleBillingProjectInfoTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBillingProjectInfoTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
