/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBillingSubaccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount#deletion_policy GoogleBillingSubaccount#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount#display_name GoogleBillingSubaccount#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount#id GoogleBillingSubaccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount#master_billing_account GoogleBillingSubaccount#master_billing_account}
    */
    readonly masterBillingAccount: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount google_billing_subaccount}
*/
export declare class GoogleBillingSubaccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_billing_subaccount";
    /**
    * Generates CDKTF code for importing a GoogleBillingSubaccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBillingSubaccount to import
    * @param importFromId The id of the existing GoogleBillingSubaccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBillingSubaccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_billing_subaccount google_billing_subaccount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBillingSubaccountConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBillingSubaccountConfig);
    get billingAccountId(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _masterBillingAccount?;
    get masterBillingAccount(): string;
    set masterBillingAccount(value: string);
    get masterBillingAccountInput(): string | undefined;
    get name(): string;
    get open(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
