/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBlockchainNodeEngineBlockchainNodesConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the requesting object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#blockchain_node_id GoogleBlockchainNodeEngineBlockchainNodes#blockchain_node_id}
    */
    readonly blockchainNodeId: string;
    /**
    * User-provided key-value pairs Possible values: ["ETHEREUM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#blockchain_type GoogleBlockchainNodeEngineBlockchainNodes#blockchain_type}
    */
    readonly blockchainType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#id GoogleBlockchainNodeEngineBlockchainNodes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-provided key-value pairs
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#labels GoogleBlockchainNodeEngineBlockchainNodes#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of Blockchain Node being created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#location GoogleBlockchainNodeEngineBlockchainNodes#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#project GoogleBlockchainNodeEngineBlockchainNodes#project}
    */
    readonly project?: string;
    /**
    * ethereum_details block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#ethereum_details GoogleBlockchainNodeEngineBlockchainNodes#ethereum_details}
    */
    readonly ethereumDetails?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#timeouts GoogleBlockchainNodeEngineBlockchainNodes#timeouts}
    */
    readonly timeouts?: GoogleBlockchainNodeEngineBlockchainNodesTimeouts;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfo {
}
export declare function googleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfo): any;
export declare function googleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfo): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfo | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfo | undefined);
    get jsonRpcApiEndpoint(): string;
    get websocketsApiEndpoint(): string;
}
export declare class GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoOutputReference;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesConnectionInfo {
}
export declare function googleBlockchainNodeEngineBlockchainNodesConnectionInfoToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfo): any;
export declare function googleBlockchainNodeEngineBlockchainNodesConnectionInfoToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfo): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfo | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesConnectionInfo | undefined);
    private _endpointInfo;
    get endpointInfo(): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoEndpointInfoList;
    get serviceAttachment(): string;
}
export declare class GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoOutputReference;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpoints {
}
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpoints): any;
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpoints): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpoints | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpoints | undefined);
    get beaconApiEndpoint(): string;
    get beaconPrometheusMetricsApiEndpoint(): string;
    get executionClientPrometheusMetricsApiEndpoint(): string;
}
export declare class GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsOutputReference;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails {
    /**
    * Blockchain garbage collection modes. Only applicable when NodeType is FULL or ARCHIVE. Possible values: ["FULL", "ARCHIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#garbage_collection_mode GoogleBlockchainNodeEngineBlockchainNodes#garbage_collection_mode}
    */
    readonly garbageCollectionMode?: string;
}
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails): any;
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails | undefined);
    private _garbageCollectionMode?;
    get garbageCollectionMode(): string;
    set garbageCollectionMode(value: string);
    resetGarbageCollectionMode(): void;
    get garbageCollectionModeInput(): string | undefined;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig {
    /**
    * URLs for MEV-relay services to use for block building. When set, a managed MEV-boost service is configured on the beacon client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#mev_relay_urls GoogleBlockchainNodeEngineBlockchainNodes#mev_relay_urls}
    */
    readonly mevRelayUrls?: string[];
}
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig): any;
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig | undefined);
    private _mevRelayUrls?;
    get mevRelayUrls(): string[];
    set mevRelayUrls(value: string[]);
    resetMevRelayUrls(): void;
    get mevRelayUrlsInput(): string[] | undefined;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails {
    /**
    * Enables JSON-RPC access to functions in the admin namespace. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#api_enable_admin GoogleBlockchainNodeEngineBlockchainNodes#api_enable_admin}
    */
    readonly apiEnableAdmin?: boolean | cdktf.IResolvable;
    /**
    * Enables JSON-RPC access to functions in the debug namespace. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#api_enable_debug GoogleBlockchainNodeEngineBlockchainNodes#api_enable_debug}
    */
    readonly apiEnableDebug?: boolean | cdktf.IResolvable;
    /**
    * The consensus client Possible values: ["CONSENSUS_CLIENT_UNSPECIFIED", "LIGHTHOUSE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#consensus_client GoogleBlockchainNodeEngineBlockchainNodes#consensus_client}
    */
    readonly consensusClient?: string;
    /**
    * The execution client Possible values: ["EXECUTION_CLIENT_UNSPECIFIED", "GETH", "ERIGON"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#execution_client GoogleBlockchainNodeEngineBlockchainNodes#execution_client}
    */
    readonly executionClient?: string;
    /**
    * The Ethereum environment being accessed. Possible values: ["MAINNET", "TESTNET_GOERLI_PRATER", "TESTNET_SEPOLIA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#network GoogleBlockchainNodeEngineBlockchainNodes#network}
    */
    readonly network?: string;
    /**
    * The type of Ethereum node. Possible values: ["LIGHT", "FULL", "ARCHIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#node_type GoogleBlockchainNodeEngineBlockchainNodes#node_type}
    */
    readonly nodeType?: string;
    /**
    * geth_details block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#geth_details GoogleBlockchainNodeEngineBlockchainNodes#geth_details}
    */
    readonly fetchhDetails?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails;
    /**
    * validator_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#validator_config GoogleBlockchainNodeEngineBlockchainNodes#validator_config}
    */
    readonly validatorConfig?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig;
}
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails): any;
export declare function googleBlockchainNodeEngineBlockchainNodesEthereumDetailsToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsOutputReference | GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails | undefined);
    private _additionalEndpoints;
    get additionalEndpoints(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsAdditionalEndpointsList;
    private _apiEnableAdmin?;
    get apiEnableAdmin(): boolean | cdktf.IResolvable;
    set apiEnableAdmin(value: boolean | cdktf.IResolvable);
    resetApiEnableAdmin(): void;
    get apiEnableAdminInput(): boolean | cdktf.IResolvable | undefined;
    private _apiEnableDebug?;
    get apiEnableDebug(): boolean | cdktf.IResolvable;
    set apiEnableDebug(value: boolean | cdktf.IResolvable);
    resetApiEnableDebug(): void;
    get apiEnableDebugInput(): boolean | cdktf.IResolvable | undefined;
    private _consensusClient?;
    get consensusClient(): string;
    set consensusClient(value: string);
    resetConsensusClient(): void;
    get consensusClientInput(): string | undefined;
    private _executionClient?;
    get executionClient(): string;
    set executionClient(value: string);
    resetExecutionClient(): void;
    get executionClientInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nodeType?;
    get nodeType(): string;
    set nodeType(value: string);
    resetNodeType(): void;
    get nodeTypeInput(): string | undefined;
    private _gethDetails;
    get fetchhDetails(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetailsOutputReference;
    putFetchhDetails(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails): void;
    resetFetchhDetails(): void;
    get fetchhDetailsInput(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsGethDetails | undefined;
    private _validatorConfig;
    get validatorConfig(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfigOutputReference;
    putValidatorConfig(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig): void;
    resetValidatorConfig(): void;
    get validatorConfigInput(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsValidatorConfig | undefined;
}
export interface GoogleBlockchainNodeEngineBlockchainNodesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#create GoogleBlockchainNodeEngineBlockchainNodes#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#delete GoogleBlockchainNodeEngineBlockchainNodes#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#update GoogleBlockchainNodeEngineBlockchainNodes#update}
    */
    readonly update?: string;
}
export declare function googleBlockchainNodeEngineBlockchainNodesTimeoutsToTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesTimeouts | cdktf.IResolvable): any;
export declare function googleBlockchainNodeEngineBlockchainNodesTimeoutsToHclTerraform(struct?: GoogleBlockchainNodeEngineBlockchainNodesTimeouts | cdktf.IResolvable): any;
export declare class GoogleBlockchainNodeEngineBlockchainNodesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBlockchainNodeEngineBlockchainNodesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBlockchainNodeEngineBlockchainNodesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes google_blockchain_node_engine_blockchain_nodes}
*/
export declare class GoogleBlockchainNodeEngineBlockchainNodes extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_blockchain_node_engine_blockchain_nodes";
    /**
    * Generates CDKTF code for importing a GoogleBlockchainNodeEngineBlockchainNodes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleBlockchainNodeEngineBlockchainNodes to import
    * @param importFromId The id of the existing GoogleBlockchainNodeEngineBlockchainNodes that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleBlockchainNodeEngineBlockchainNodes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_blockchain_node_engine_blockchain_nodes google_blockchain_node_engine_blockchain_nodes} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBlockchainNodeEngineBlockchainNodesConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBlockchainNodeEngineBlockchainNodesConfig);
    private _blockchainNodeId?;
    get blockchainNodeId(): string;
    set blockchainNodeId(value: string);
    get blockchainNodeIdInput(): string | undefined;
    private _blockchainType?;
    get blockchainType(): string;
    set blockchainType(value: string);
    resetBlockchainType(): void;
    get blockchainTypeInput(): string | undefined;
    private _connectionInfo;
    get connectionInfo(): GoogleBlockchainNodeEngineBlockchainNodesConnectionInfoList;
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _ethereumDetails;
    get ethereumDetails(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetailsOutputReference;
    putEthereumDetails(value: GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails): void;
    resetEthereumDetails(): void;
    get ethereumDetailsInput(): GoogleBlockchainNodeEngineBlockchainNodesEthereumDetails | undefined;
    private _timeouts;
    get timeouts(): GoogleBlockchainNodeEngineBlockchainNodesTimeoutsOutputReference;
    putTimeouts(value: GoogleBlockchainNodeEngineBlockchainNodesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBlockchainNodeEngineBlockchainNodesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
