/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCertificateManagerCertificateIssuanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * One or more paragraphs of text description of a CertificateIssuanceConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#description GoogleCertificateManagerCertificateIssuanceConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#id GoogleCertificateManagerCertificateIssuanceConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key algorithm to use when generating the private key. Possible values: ["RSA_2048", "ECDSA_P256"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#key_algorithm GoogleCertificateManagerCertificateIssuanceConfig#key_algorithm}
    */
    readonly keyAlgorithm: string;
    /**
    * 'Set of label tags associated with the CertificateIssuanceConfig resource.
    *  An object containing a list of "key": value pairs. Example: { "name": "wrench", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#labels GoogleCertificateManagerCertificateIssuanceConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Lifetime of issued certificates. A duration in seconds with up to nine fractional digits, ending with 's'.
    * Example: "1814400s". Valid values are from 21 days (1814400s) to 30 days (2592000s)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#lifetime GoogleCertificateManagerCertificateIssuanceConfig#lifetime}
    */
    readonly lifetime: string;
    /**
    * The Certificate Manager location. If not specified, "global" is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#location GoogleCertificateManagerCertificateIssuanceConfig#location}
    */
    readonly location?: string;
    /**
    * A user-defined name of the certificate issuance config.
    * CertificateIssuanceConfig names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#name GoogleCertificateManagerCertificateIssuanceConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#project GoogleCertificateManagerCertificateIssuanceConfig#project}
    */
    readonly project?: string;
    /**
    * It specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate.
    * Must be a number between 1-99, inclusive.
    * You must set the rotation window percentage in relation to the certificate lifetime so that certificate renewal occurs at least 7 days after
    * the certificate has been issued and at least 7 days before it expires.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#rotation_window_percentage GoogleCertificateManagerCertificateIssuanceConfig#rotation_window_percentage}
    */
    readonly rotationWindowPercentage: number;
    /**
    * certificate_authority_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#certificate_authority_config GoogleCertificateManagerCertificateIssuanceConfig#certificate_authority_config}
    */
    readonly certificateAuthorityConfig: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#timeouts GoogleCertificateManagerCertificateIssuanceConfig#timeouts}
    */
    readonly timeouts?: GoogleCertificateManagerCertificateIssuanceConfigTimeouts;
}
export interface GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig {
    /**
    * A CA pool resource used to issue a certificate.
    * The CA pool string has a relative resource path following the form
    * "projects/{project}/locations/{location}/caPools/{caPool}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#ca_pool GoogleCertificateManagerCertificateIssuanceConfig#ca_pool}
    */
    readonly caPool: string;
}
export declare function googleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigToTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigOutputReference | GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig): any;
export declare function googleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigToHclTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigOutputReference | GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig): any;
export declare class GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig | undefined);
    private _caPool?;
    get caPool(): string;
    set caPool(value: string);
    get caPoolInput(): string | undefined;
}
export interface GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig {
    /**
    * certificate_authority_service_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#certificate_authority_service_config GoogleCertificateManagerCertificateIssuanceConfig#certificate_authority_service_config}
    */
    readonly certificateAuthorityServiceConfig?: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig;
}
export declare function googleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigToTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigOutputReference | GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig): any;
export declare function googleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigToHclTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigOutputReference | GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig): any;
export declare class GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig | undefined);
    private _certificateAuthorityServiceConfig;
    get certificateAuthorityServiceConfig(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfigOutputReference;
    putCertificateAuthorityServiceConfig(value: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig): void;
    resetCertificateAuthorityServiceConfig(): void;
    get certificateAuthorityServiceConfigInput(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigCertificateAuthorityServiceConfig | undefined;
}
export interface GoogleCertificateManagerCertificateIssuanceConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#create GoogleCertificateManagerCertificateIssuanceConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#delete GoogleCertificateManagerCertificateIssuanceConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#update GoogleCertificateManagerCertificateIssuanceConfig#update}
    */
    readonly update?: string;
}
export declare function googleCertificateManagerCertificateIssuanceConfigTimeoutsToTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigTimeouts | cdktf.IResolvable): any;
export declare function googleCertificateManagerCertificateIssuanceConfigTimeoutsToHclTerraform(struct?: GoogleCertificateManagerCertificateIssuanceConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerCertificateIssuanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateIssuanceConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateIssuanceConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config google_certificate_manager_certificate_issuance_config}
*/
export declare class GoogleCertificateManagerCertificateIssuanceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate_issuance_config";
    /**
    * Generates CDKTF code for importing a GoogleCertificateManagerCertificateIssuanceConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCertificateManagerCertificateIssuanceConfig to import
    * @param importFromId The id of the existing GoogleCertificateManagerCertificateIssuanceConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCertificateManagerCertificateIssuanceConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_certificate_issuance_config google_certificate_manager_certificate_issuance_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCertificateManagerCertificateIssuanceConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCertificateManagerCertificateIssuanceConfigConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyAlgorithm?;
    get keyAlgorithm(): string;
    set keyAlgorithm(value: string);
    get keyAlgorithmInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string;
    set lifetime(value: string);
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rotationWindowPercentage?;
    get rotationWindowPercentage(): number;
    set rotationWindowPercentage(value: number);
    get rotationWindowPercentageInput(): number | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _certificateAuthorityConfig;
    get certificateAuthorityConfig(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfigOutputReference;
    putCertificateAuthorityConfig(value: GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig): void;
    get certificateAuthorityConfigInput(): GoogleCertificateManagerCertificateIssuanceConfigCertificateAuthorityConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCertificateManagerCertificateIssuanceConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleCertificateManagerCertificateIssuanceConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCertificateManagerCertificateIssuanceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
