/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCertificateManagerDnsAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#description GoogleCertificateManagerDnsAuthorization#description}
    */
    readonly description?: string;
    /**
    * A domain which is being authorized. A DnsAuthorization resource covers a
    * single domain and its wildcard, e.g. authorization for "example.com" can
    * be used to issue certificates for "example.com" and "*.example.com".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#domain GoogleCertificateManagerDnsAuthorization#domain}
    */
    readonly domain: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#id GoogleCertificateManagerDnsAuthorization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the DNS Authorization resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#labels GoogleCertificateManagerDnsAuthorization#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Certificate Manager location. If not specified, "global" is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#location GoogleCertificateManagerDnsAuthorization#location}
    */
    readonly location?: string;
    /**
    * Name of the resource; provided by the client when the resource is created.
    * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
    * and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#name GoogleCertificateManagerDnsAuthorization#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#project GoogleCertificateManagerDnsAuthorization#project}
    */
    readonly project?: string;
    /**
    * type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
    * be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
    *
    * FIXED_RECORD DNS authorization uses DNS-01 validation method
    *
    * PER_PROJECT_RECORD DNS authorization allows for independent management
    * of Google-managed certificates with DNS authorization across multiple
    * projects. Possible values: ["FIXED_RECORD", "PER_PROJECT_RECORD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#type GoogleCertificateManagerDnsAuthorization#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#timeouts GoogleCertificateManagerDnsAuthorization#timeouts}
    */
    readonly timeouts?: GoogleCertificateManagerDnsAuthorizationTimeouts;
}
export interface GoogleCertificateManagerDnsAuthorizationDnsResourceRecord {
}
export declare function googleCertificateManagerDnsAuthorizationDnsResourceRecordToTerraform(struct?: GoogleCertificateManagerDnsAuthorizationDnsResourceRecord): any;
export declare function googleCertificateManagerDnsAuthorizationDnsResourceRecordToHclTerraform(struct?: GoogleCertificateManagerDnsAuthorizationDnsResourceRecord): any;
export declare class GoogleCertificateManagerDnsAuthorizationDnsResourceRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerDnsAuthorizationDnsResourceRecord | undefined;
    set internalValue(value: GoogleCertificateManagerDnsAuthorizationDnsResourceRecord | undefined);
    get data(): string;
    get name(): string;
    get type(): string;
}
export declare class GoogleCertificateManagerDnsAuthorizationDnsResourceRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerDnsAuthorizationDnsResourceRecordOutputReference;
}
export interface GoogleCertificateManagerDnsAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#create GoogleCertificateManagerDnsAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#delete GoogleCertificateManagerDnsAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#update GoogleCertificateManagerDnsAuthorization#update}
    */
    readonly update?: string;
}
export declare function googleCertificateManagerDnsAuthorizationTimeoutsToTerraform(struct?: GoogleCertificateManagerDnsAuthorizationTimeouts | cdktf.IResolvable): any;
export declare function googleCertificateManagerDnsAuthorizationTimeoutsToHclTerraform(struct?: GoogleCertificateManagerDnsAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerDnsAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerDnsAuthorizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerDnsAuthorizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization google_certificate_manager_dns_authorization}
*/
export declare class GoogleCertificateManagerDnsAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_dns_authorization";
    /**
    * Generates CDKTF code for importing a GoogleCertificateManagerDnsAuthorization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCertificateManagerDnsAuthorization to import
    * @param importFromId The id of the existing GoogleCertificateManagerDnsAuthorization that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCertificateManagerDnsAuthorization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_dns_authorization google_certificate_manager_dns_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCertificateManagerDnsAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCertificateManagerDnsAuthorizationConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dnsResourceRecord;
    get dnsResourceRecord(): GoogleCertificateManagerDnsAuthorizationDnsResourceRecordList;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleCertificateManagerDnsAuthorizationTimeoutsOutputReference;
    putTimeouts(value: GoogleCertificateManagerDnsAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCertificateManagerDnsAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
