/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCertificateManagerTrustConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * One or more paragraphs of text description of a trust config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#description GoogleCertificateManagerTrustConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#id GoogleCertificateManagerTrustConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the trust config.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#labels GoogleCertificateManagerTrustConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The trust config location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#location GoogleCertificateManagerTrustConfig#location}
    */
    readonly location: string;
    /**
    * A user-defined name of the trust config. Trust config names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#name GoogleCertificateManagerTrustConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#project GoogleCertificateManagerTrustConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#timeouts GoogleCertificateManagerTrustConfig#timeouts}
    */
    readonly timeouts?: GoogleCertificateManagerTrustConfigTimeouts;
    /**
    * trust_stores block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#trust_stores GoogleCertificateManagerTrustConfig#trust_stores}
    */
    readonly trustStores?: GoogleCertificateManagerTrustConfigTrustStores[] | cdktf.IResolvable;
}
export interface GoogleCertificateManagerTrustConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#create GoogleCertificateManagerTrustConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#delete GoogleCertificateManagerTrustConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#update GoogleCertificateManagerTrustConfig#update}
    */
    readonly update?: string;
}
export declare function googleCertificateManagerTrustConfigTimeoutsToTerraform(struct?: GoogleCertificateManagerTrustConfigTimeouts | cdktf.IResolvable): any;
export declare function googleCertificateManagerTrustConfigTimeoutsToHclTerraform(struct?: GoogleCertificateManagerTrustConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerTrustConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerTrustConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerTrustConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas {
    /**
    * PEM intermediate certificate used for building up paths for validation.
    * Each certificate provided in PEM format may occupy up to 5kB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#pem_certificate GoogleCertificateManagerTrustConfig#pem_certificate}
    */
    readonly pemCertificate?: string;
}
export declare function googleCertificateManagerTrustConfigTrustStoresIntermediateCasToTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas | cdktf.IResolvable): any;
export declare function googleCertificateManagerTrustConfigTrustStoresIntermediateCasToHclTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerTrustConfigTrustStoresIntermediateCasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas | cdktf.IResolvable | undefined);
    private _pemCertificate?;
    get pemCertificate(): string;
    set pemCertificate(value: string);
    resetPemCertificate(): void;
    get pemCertificateInput(): string | undefined;
}
export declare class GoogleCertificateManagerTrustConfigTrustStoresIntermediateCasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerTrustConfigTrustStoresIntermediateCasOutputReference;
}
export interface GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors {
    /**
    * PEM root certificate of the PKI used for validation.
    * Each certificate provided in PEM format may occupy up to 5kB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#pem_certificate GoogleCertificateManagerTrustConfig#pem_certificate}
    */
    readonly pemCertificate?: string;
}
export declare function googleCertificateManagerTrustConfigTrustStoresTrustAnchorsToTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors | cdktf.IResolvable): any;
export declare function googleCertificateManagerTrustConfigTrustStoresTrustAnchorsToHclTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerTrustConfigTrustStoresTrustAnchorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors | cdktf.IResolvable | undefined);
    private _pemCertificate?;
    get pemCertificate(): string;
    set pemCertificate(value: string);
    resetPemCertificate(): void;
    get pemCertificateInput(): string | undefined;
}
export declare class GoogleCertificateManagerTrustConfigTrustStoresTrustAnchorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerTrustConfigTrustStoresTrustAnchorsOutputReference;
}
export interface GoogleCertificateManagerTrustConfigTrustStores {
    /**
    * intermediate_cas block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#intermediate_cas GoogleCertificateManagerTrustConfig#intermediate_cas}
    */
    readonly intermediateCas?: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas[] | cdktf.IResolvable;
    /**
    * trust_anchors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#trust_anchors GoogleCertificateManagerTrustConfig#trust_anchors}
    */
    readonly trustAnchors?: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors[] | cdktf.IResolvable;
}
export declare function googleCertificateManagerTrustConfigTrustStoresToTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStores | cdktf.IResolvable): any;
export declare function googleCertificateManagerTrustConfigTrustStoresToHclTerraform(struct?: GoogleCertificateManagerTrustConfigTrustStores | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerTrustConfigTrustStoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerTrustConfigTrustStores | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerTrustConfigTrustStores | cdktf.IResolvable | undefined);
    private _intermediateCas;
    get intermediateCas(): GoogleCertificateManagerTrustConfigTrustStoresIntermediateCasList;
    putIntermediateCas(value: GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas[] | cdktf.IResolvable): void;
    resetIntermediateCas(): void;
    get intermediateCasInput(): cdktf.IResolvable | GoogleCertificateManagerTrustConfigTrustStoresIntermediateCas[] | undefined;
    private _trustAnchors;
    get trustAnchors(): GoogleCertificateManagerTrustConfigTrustStoresTrustAnchorsList;
    putTrustAnchors(value: GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors[] | cdktf.IResolvable): void;
    resetTrustAnchors(): void;
    get trustAnchorsInput(): cdktf.IResolvable | GoogleCertificateManagerTrustConfigTrustStoresTrustAnchors[] | undefined;
}
export declare class GoogleCertificateManagerTrustConfigTrustStoresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCertificateManagerTrustConfigTrustStores[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerTrustConfigTrustStoresOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config google_certificate_manager_trust_config}
*/
export declare class GoogleCertificateManagerTrustConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_trust_config";
    /**
    * Generates CDKTF code for importing a GoogleCertificateManagerTrustConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCertificateManagerTrustConfig to import
    * @param importFromId The id of the existing GoogleCertificateManagerTrustConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCertificateManagerTrustConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_certificate_manager_trust_config google_certificate_manager_trust_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCertificateManagerTrustConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCertificateManagerTrustConfigConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleCertificateManagerTrustConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleCertificateManagerTrustConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCertificateManagerTrustConfigTimeouts | undefined;
    private _trustStores;
    get trustStores(): GoogleCertificateManagerTrustConfigTrustStoresList;
    putTrustStores(value: GoogleCertificateManagerTrustConfigTrustStores[] | cdktf.IResolvable): void;
    resetTrustStores(): void;
    get trustStoresInput(): cdktf.IResolvable | GoogleCertificateManagerTrustConfigTrustStores[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
