/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudIdentityGroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Group to create this membership in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#group GoogleCloudIdentityGroupMembership#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#id GoogleCloudIdentityGroupMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * member_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#member_key GoogleCloudIdentityGroupMembership#member_key}
    */
    readonly memberKey?: GoogleCloudIdentityGroupMembershipMemberKey;
    /**
    * preferred_member_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#preferred_member_key GoogleCloudIdentityGroupMembership#preferred_member_key}
    */
    readonly preferredMemberKey?: GoogleCloudIdentityGroupMembershipPreferredMemberKey;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#roles GoogleCloudIdentityGroupMembership#roles}
    */
    readonly roles: GoogleCloudIdentityGroupMembershipRoles[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#timeouts GoogleCloudIdentityGroupMembership#timeouts}
    */
    readonly timeouts?: GoogleCloudIdentityGroupMembershipTimeouts;
}
export interface GoogleCloudIdentityGroupMembershipMemberKey {
    /**
    * The ID of the entity.
    *
    * For Google-managed entities, the id must be the email address of an existing
    * group or user.
    *
    * For external-identity-mapped entities, the id must be a string conforming
    * to the Identity Source's requirements.
    *
    * Must be unique within a namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#id GoogleCloudIdentityGroupMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The namespace in which the entity exists.
    *
    * If not specified, the EntityKey represents a Google-managed entity
    * such as a Google user or a Google Group.
    *
    * If specified, the EntityKey represents an external-identity-mapped group.
    * The namespace must correspond to an identity source created in Admin Console
    * and must be in the form of 'identitysources/{identity_source_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#namespace GoogleCloudIdentityGroupMembership#namespace}
    */
    readonly namespace?: string;
}
export declare function googleCloudIdentityGroupMembershipMemberKeyToTerraform(struct?: GoogleCloudIdentityGroupMembershipMemberKeyOutputReference | GoogleCloudIdentityGroupMembershipMemberKey): any;
export declare function googleCloudIdentityGroupMembershipMemberKeyToHclTerraform(struct?: GoogleCloudIdentityGroupMembershipMemberKeyOutputReference | GoogleCloudIdentityGroupMembershipMemberKey): any;
export declare class GoogleCloudIdentityGroupMembershipMemberKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupMembershipMemberKey | undefined;
    set internalValue(value: GoogleCloudIdentityGroupMembershipMemberKey | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface GoogleCloudIdentityGroupMembershipPreferredMemberKey {
    /**
    * The ID of the entity.
    *
    * For Google-managed entities, the id must be the email address of an existing
    * group or user.
    *
    * For external-identity-mapped entities, the id must be a string conforming
    * to the Identity Source's requirements.
    *
    * Must be unique within a namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#id GoogleCloudIdentityGroupMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The namespace in which the entity exists.
    *
    * If not specified, the EntityKey represents a Google-managed entity
    * such as a Google user or a Google Group.
    *
    * If specified, the EntityKey represents an external-identity-mapped group.
    * The namespace must correspond to an identity source created in Admin Console
    * and must be in the form of 'identitysources/{identity_source_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#namespace GoogleCloudIdentityGroupMembership#namespace}
    */
    readonly namespace?: string;
}
export declare function googleCloudIdentityGroupMembershipPreferredMemberKeyToTerraform(struct?: GoogleCloudIdentityGroupMembershipPreferredMemberKeyOutputReference | GoogleCloudIdentityGroupMembershipPreferredMemberKey): any;
export declare function googleCloudIdentityGroupMembershipPreferredMemberKeyToHclTerraform(struct?: GoogleCloudIdentityGroupMembershipPreferredMemberKeyOutputReference | GoogleCloudIdentityGroupMembershipPreferredMemberKey): any;
export declare class GoogleCloudIdentityGroupMembershipPreferredMemberKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupMembershipPreferredMemberKey | undefined;
    set internalValue(value: GoogleCloudIdentityGroupMembershipPreferredMemberKey | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface GoogleCloudIdentityGroupMembershipRolesExpiryDetail {
    /**
    * The time at which the MembershipRole will expire.
    *
    * A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
    * resolution and up to nine fractional digits.
    *
    * Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#expire_time GoogleCloudIdentityGroupMembership#expire_time}
    */
    readonly expireTime: string;
}
export declare function googleCloudIdentityGroupMembershipRolesExpiryDetailToTerraform(struct?: GoogleCloudIdentityGroupMembershipRolesExpiryDetailOutputReference | GoogleCloudIdentityGroupMembershipRolesExpiryDetail): any;
export declare function googleCloudIdentityGroupMembershipRolesExpiryDetailToHclTerraform(struct?: GoogleCloudIdentityGroupMembershipRolesExpiryDetailOutputReference | GoogleCloudIdentityGroupMembershipRolesExpiryDetail): any;
export declare class GoogleCloudIdentityGroupMembershipRolesExpiryDetailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupMembershipRolesExpiryDetail | undefined;
    set internalValue(value: GoogleCloudIdentityGroupMembershipRolesExpiryDetail | undefined);
    private _expireTime?;
    get expireTime(): string;
    set expireTime(value: string);
    get expireTimeInput(): string | undefined;
}
export interface GoogleCloudIdentityGroupMembershipRoles {
    /**
    * The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER. Possible values: ["OWNER", "MANAGER", "MEMBER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#name GoogleCloudIdentityGroupMembership#name}
    */
    readonly name: string;
    /**
    * expiry_detail block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#expiry_detail GoogleCloudIdentityGroupMembership#expiry_detail}
    */
    readonly expiryDetail?: GoogleCloudIdentityGroupMembershipRolesExpiryDetail;
}
export declare function googleCloudIdentityGroupMembershipRolesToTerraform(struct?: GoogleCloudIdentityGroupMembershipRoles | cdktf.IResolvable): any;
export declare function googleCloudIdentityGroupMembershipRolesToHclTerraform(struct?: GoogleCloudIdentityGroupMembershipRoles | cdktf.IResolvable): any;
export declare class GoogleCloudIdentityGroupMembershipRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudIdentityGroupMembershipRoles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudIdentityGroupMembershipRoles | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _expiryDetail;
    get expiryDetail(): GoogleCloudIdentityGroupMembershipRolesExpiryDetailOutputReference;
    putExpiryDetail(value: GoogleCloudIdentityGroupMembershipRolesExpiryDetail): void;
    resetExpiryDetail(): void;
    get expiryDetailInput(): GoogleCloudIdentityGroupMembershipRolesExpiryDetail | undefined;
}
export declare class GoogleCloudIdentityGroupMembershipRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudIdentityGroupMembershipRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudIdentityGroupMembershipRolesOutputReference;
}
export interface GoogleCloudIdentityGroupMembershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#create GoogleCloudIdentityGroupMembership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#delete GoogleCloudIdentityGroupMembership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#update GoogleCloudIdentityGroupMembership#update}
    */
    readonly update?: string;
}
export declare function googleCloudIdentityGroupMembershipTimeoutsToTerraform(struct?: GoogleCloudIdentityGroupMembershipTimeouts | cdktf.IResolvable): any;
export declare function googleCloudIdentityGroupMembershipTimeoutsToHclTerraform(struct?: GoogleCloudIdentityGroupMembershipTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudIdentityGroupMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupMembershipTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudIdentityGroupMembershipTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership google_cloud_identity_group_membership}
*/
export declare class GoogleCloudIdentityGroupMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_identity_group_membership";
    /**
    * Generates CDKTF code for importing a GoogleCloudIdentityGroupMembership resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudIdentityGroupMembership to import
    * @param importFromId The id of the existing GoogleCloudIdentityGroupMembership that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudIdentityGroupMembership to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group_membership google_cloud_identity_group_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudIdentityGroupMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudIdentityGroupMembershipConfig);
    get createTime(): string;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get type(): string;
    get updateTime(): string;
    private _memberKey;
    get memberKey(): GoogleCloudIdentityGroupMembershipMemberKeyOutputReference;
    putMemberKey(value: GoogleCloudIdentityGroupMembershipMemberKey): void;
    resetMemberKey(): void;
    get memberKeyInput(): GoogleCloudIdentityGroupMembershipMemberKey | undefined;
    private _preferredMemberKey;
    get preferredMemberKey(): GoogleCloudIdentityGroupMembershipPreferredMemberKeyOutputReference;
    putPreferredMemberKey(value: GoogleCloudIdentityGroupMembershipPreferredMemberKey): void;
    resetPreferredMemberKey(): void;
    get preferredMemberKeyInput(): GoogleCloudIdentityGroupMembershipPreferredMemberKey | undefined;
    private _roles;
    get roles(): GoogleCloudIdentityGroupMembershipRolesList;
    putRoles(value: GoogleCloudIdentityGroupMembershipRoles[] | cdktf.IResolvable): void;
    get rolesInput(): cdktf.IResolvable | GoogleCloudIdentityGroupMembershipRoles[] | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudIdentityGroupMembershipTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudIdentityGroupMembershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudIdentityGroupMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
