/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudIdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * An extended description to help users determine the purpose of a Group.
    * Must not be longer than 4,096 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#description GoogleCloudIdentityGroup#description}
    */
    readonly description?: string;
    /**
    * The display name of the Group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#display_name GoogleCloudIdentityGroup#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#id GoogleCloudIdentityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The initial configuration options for creating a Group.
    *
    * See the
    * [API reference](https://cloud.google.com/identity/docs/reference/rest/v1beta1/groups/create#initialgroupconfig)
    * for possible values. Default value: "EMPTY" Possible values: ["INITIAL_GROUP_CONFIG_UNSPECIFIED", "WITH_INITIAL_OWNER", "EMPTY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#initial_group_config GoogleCloudIdentityGroup#initial_group_config}
    */
    readonly initialGroupConfig?: string;
    /**
    * One or more label entries that apply to the Group. Currently supported labels contain a key with an empty value.
    *
    * Google Groups are the default type of group and have a label with a key of cloudidentity.googleapis.com/groups.discussion_forum and an empty value.
    *
    * Existing Google Groups can have an additional label with a key of cloudidentity.googleapis.com/groups.security and an empty value added to them. This is an immutable change and the security label cannot be removed once added.
    *
    * Dynamic groups have a label with a key of cloudidentity.googleapis.com/groups.dynamic.
    *
    * Identity-mapped groups for Cloud Search have a label with a key of system/groups/external and an empty value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#labels GoogleCloudIdentityGroup#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
    /**
    * The resource name of the entity under which this Group resides in the
    * Cloud Identity resource hierarchy.
    *
    * Must be of the form identitysources/{identity_source_id} for external-identity-mapped
    * groups or customers/{customer_id} for Google Groups.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#parent GoogleCloudIdentityGroup#parent}
    */
    readonly parent: string;
    /**
    * group_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#group_key GoogleCloudIdentityGroup#group_key}
    */
    readonly groupKey: GoogleCloudIdentityGroupGroupKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#timeouts GoogleCloudIdentityGroup#timeouts}
    */
    readonly timeouts?: GoogleCloudIdentityGroupTimeouts;
}
export interface GoogleCloudIdentityGroupAdditionalGroupKeys {
}
export declare function googleCloudIdentityGroupAdditionalGroupKeysToTerraform(struct?: GoogleCloudIdentityGroupAdditionalGroupKeys): any;
export declare function googleCloudIdentityGroupAdditionalGroupKeysToHclTerraform(struct?: GoogleCloudIdentityGroupAdditionalGroupKeys): any;
export declare class GoogleCloudIdentityGroupAdditionalGroupKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudIdentityGroupAdditionalGroupKeys | undefined;
    set internalValue(value: GoogleCloudIdentityGroupAdditionalGroupKeys | undefined);
    get id(): string;
    get namespace(): string;
}
export declare class GoogleCloudIdentityGroupAdditionalGroupKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudIdentityGroupAdditionalGroupKeysOutputReference;
}
export interface GoogleCloudIdentityGroupGroupKey {
    /**
    * The ID of the entity.
    *
    * For Google-managed entities, the id must be the email address of an existing
    * group or user.
    *
    * For external-identity-mapped entities, the id must be a string conforming
    * to the Identity Source's requirements.
    *
    * Must be unique within a namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#id GoogleCloudIdentityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The namespace in which the entity exists.
    *
    * If not specified, the EntityKey represents a Google-managed entity
    * such as a Google user or a Google Group.
    *
    * If specified, the EntityKey represents an external-identity-mapped group.
    * The namespace must correspond to an identity source created in Admin Console
    * and must be in the form of 'identitysources/{identity_source_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#namespace GoogleCloudIdentityGroup#namespace}
    */
    readonly namespace?: string;
}
export declare function googleCloudIdentityGroupGroupKeyToTerraform(struct?: GoogleCloudIdentityGroupGroupKeyOutputReference | GoogleCloudIdentityGroupGroupKey): any;
export declare function googleCloudIdentityGroupGroupKeyToHclTerraform(struct?: GoogleCloudIdentityGroupGroupKeyOutputReference | GoogleCloudIdentityGroupGroupKey): any;
export declare class GoogleCloudIdentityGroupGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupGroupKey | undefined;
    set internalValue(value: GoogleCloudIdentityGroupGroupKey | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface GoogleCloudIdentityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#create GoogleCloudIdentityGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#delete GoogleCloudIdentityGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#update GoogleCloudIdentityGroup#update}
    */
    readonly update?: string;
}
export declare function googleCloudIdentityGroupTimeoutsToTerraform(struct?: GoogleCloudIdentityGroupTimeouts | cdktf.IResolvable): any;
export declare function googleCloudIdentityGroupTimeoutsToHclTerraform(struct?: GoogleCloudIdentityGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudIdentityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdentityGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudIdentityGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group google_cloud_identity_group}
*/
export declare class GoogleCloudIdentityGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_identity_group";
    /**
    * Generates CDKTF code for importing a GoogleCloudIdentityGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudIdentityGroup to import
    * @param importFromId The id of the existing GoogleCloudIdentityGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudIdentityGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_identity_group google_cloud_identity_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudIdentityGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudIdentityGroupConfig);
    private _additionalGroupKeys;
    get additionalGroupKeys(): GoogleCloudIdentityGroupAdditionalGroupKeysList;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialGroupConfig?;
    get initialGroupConfig(): string;
    set initialGroupConfig(value: string);
    resetInitialGroupConfig(): void;
    get initialGroupConfigInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _groupKey;
    get groupKey(): GoogleCloudIdentityGroupGroupKeyOutputReference;
    putGroupKey(value: GoogleCloudIdentityGroupGroupKey): void;
    get groupKeyInput(): GoogleCloudIdentityGroupGroupKey | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudIdentityGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudIdentityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudIdentityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
