/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudIdsEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#description GoogleCloudIdsEndpoint#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#id GoogleCloudIdsEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#location GoogleCloudIdsEndpoint#location}
    */
    readonly location: string;
    /**
    * Name of the endpoint in the format projects/{project_id}/locations/{locationId}/endpoints/{endpointId}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#name GoogleCloudIdsEndpoint#name}
    */
    readonly name: string;
    /**
    * Name of the VPC network that is connected to the IDS endpoint. This can either contain the VPC network name itself (like "src-net") or the full URL to the network (like "projects/{project_id}/global/networks/src-net").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#network GoogleCloudIdsEndpoint#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#project GoogleCloudIdsEndpoint#project}
    */
    readonly project?: string;
    /**
    * The minimum alert severity level that is reported by the endpoint. Possible values: ["INFORMATIONAL", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#severity GoogleCloudIdsEndpoint#severity}
    */
    readonly severity: string;
    /**
    * Configuration for threat IDs excluded from generating alerts. Limit: 99 IDs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#threat_exceptions GoogleCloudIdsEndpoint#threat_exceptions}
    */
    readonly threatExceptions?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#timeouts GoogleCloudIdsEndpoint#timeouts}
    */
    readonly timeouts?: GoogleCloudIdsEndpointTimeouts;
}
export interface GoogleCloudIdsEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#create GoogleCloudIdsEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#delete GoogleCloudIdsEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#update GoogleCloudIdsEndpoint#update}
    */
    readonly update?: string;
}
export declare function googleCloudIdsEndpointTimeoutsToTerraform(struct?: GoogleCloudIdsEndpointTimeouts | cdktf.IResolvable): any;
export declare function googleCloudIdsEndpointTimeoutsToHclTerraform(struct?: GoogleCloudIdsEndpointTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudIdsEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudIdsEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudIdsEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint google_cloud_ids_endpoint}
*/
export declare class GoogleCloudIdsEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_ids_endpoint";
    /**
    * Generates CDKTF code for importing a GoogleCloudIdsEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudIdsEndpoint to import
    * @param importFromId The id of the existing GoogleCloudIdsEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudIdsEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_ids_endpoint google_cloud_ids_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudIdsEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudIdsEndpointConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endpointForwardingRule(): string;
    get endpointIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _threatExceptions?;
    get threatExceptions(): string[];
    set threatExceptions(value: string[]);
    resetThreatExceptions(): void;
    get threatExceptionsInput(): string[] | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleCloudIdsEndpointTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudIdsEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudIdsEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
