/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to 'true', the revision name (template.metadata.name) will be omitted and
    * autogenerated by Cloud Run. This cannot be set to 'true' while 'template.metadata.name'
    * is also set.
    * (For legacy support, if 'template.metadata.name' is unset in state while
    * this field is set to false, the revision name will still autogenerate.)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#autogenerate_revision_name GoogleCloudRunService#autogenerate_revision_name}
    */
    readonly autogenerateRevisionName?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#id GoogleCloudRunService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#location GoogleCloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a Google Cloud project and region.
    * Is required when creating resources. Name is primarily intended
    * for creation idempotence and configuration definition. Cannot be updated.
    * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#project GoogleCloudRunService#project}
    */
    readonly project?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#metadata GoogleCloudRunService#metadata}
    */
    readonly metadata?: GoogleCloudRunServiceMetadata;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#template GoogleCloudRunService#template}
    */
    readonly template?: GoogleCloudRunServiceTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#timeouts GoogleCloudRunService#timeouts}
    */
    readonly timeouts?: GoogleCloudRunServiceTimeouts;
    /**
    * traffic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#traffic GoogleCloudRunService#traffic}
    */
    readonly traffic?: GoogleCloudRunServiceTraffic[] | cdktf.IResolvable;
}
export interface GoogleCloudRunServiceStatusConditions {
}
export declare function googleCloudRunServiceStatusConditionsToTerraform(struct?: GoogleCloudRunServiceStatusConditions): any;
export declare function googleCloudRunServiceStatusConditionsToHclTerraform(struct?: GoogleCloudRunServiceStatusConditions): any;
export declare class GoogleCloudRunServiceStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceStatusConditions | undefined;
    set internalValue(value: GoogleCloudRunServiceStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class GoogleCloudRunServiceStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceStatusConditionsOutputReference;
}
export interface GoogleCloudRunServiceStatusTraffic {
}
export declare function googleCloudRunServiceStatusTrafficToTerraform(struct?: GoogleCloudRunServiceStatusTraffic): any;
export declare function googleCloudRunServiceStatusTrafficToHclTerraform(struct?: GoogleCloudRunServiceStatusTraffic): any;
export declare class GoogleCloudRunServiceStatusTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceStatusTraffic | undefined;
    set internalValue(value: GoogleCloudRunServiceStatusTraffic | undefined);
    get latestRevision(): cdktf.IResolvable;
    get percent(): number;
    get revisionName(): string;
    get tag(): string;
    get url(): string;
}
export declare class GoogleCloudRunServiceStatusTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceStatusTrafficOutputReference;
}
export interface GoogleCloudRunServiceStatus {
}
export declare function googleCloudRunServiceStatusToTerraform(struct?: GoogleCloudRunServiceStatus): any;
export declare function googleCloudRunServiceStatusToHclTerraform(struct?: GoogleCloudRunServiceStatus): any;
export declare class GoogleCloudRunServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceStatus | undefined;
    set internalValue(value: GoogleCloudRunServiceStatus | undefined);
    private _conditions;
    get conditions(): GoogleCloudRunServiceStatusConditionsList;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    private _traffic;
    get traffic(): GoogleCloudRunServiceStatusTrafficList;
    get url(): string;
}
export declare class GoogleCloudRunServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceStatusOutputReference;
}
export interface GoogleCloudRunServiceMetadata {
    /**
    * Annotations is a key value map stored with a resource that
    * may be set by external tools to store and retrieve arbitrary metadata. More
    * info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
    *
    * **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
    * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
    * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Annotations with 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted. Use the following annotation
    * keys to configure features on a Service:
    *
    * - 'run.googleapis.com/binary-authorization-breakglass' sets the [Binary Authorization breakglass](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--breakglass).
    * - 'run.googleapis.com/binary-authorization' sets the [Binary Authorization](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--binary-authorization).
    * - 'run.googleapis.com/client-name' sets the client name calling the Cloud Run API.
    * - 'run.googleapis.com/custom-audiences' sets the [custom audiences](https://cloud.google.com/sdk/gcloud/reference/alpha/run/deploy#--add-custom-audiences)
    *   that can be used in the audience field of ID token for authenticated requests.
    * - 'run.googleapis.com/description' sets a user defined description for the Service.
    * - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
    *   for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
    * - 'run.googleapis.com/launch-stage' sets the [launch stage](https://cloud.google.com/run/docs/troubleshooting#launch-stage-validation)
    *   when a preview feature is used. For example, '"run.googleapis.com/launch-stage": "BETA"'
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#annotations GoogleCloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
    * (scope and select) objects. May match selectors of replication controllers
    * and routes.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#labels GoogleCloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * In Cloud Run the namespace must be equal to either the
    * project ID or project number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#namespace GoogleCloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function googleCloudRunServiceMetadataToTerraform(struct?: GoogleCloudRunServiceMetadataOutputReference | GoogleCloudRunServiceMetadata): any;
export declare function googleCloudRunServiceMetadataToHclTerraform(struct?: GoogleCloudRunServiceMetadataOutputReference | GoogleCloudRunServiceMetadata): any;
export declare class GoogleCloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceMetadata | undefined;
    set internalValue(value: GoogleCloudRunServiceMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
}
export interface GoogleCloudRunServiceTemplateMetadata {
    /**
    * Annotations is a key value map stored with a resource that
    * may be set by external tools to store and retrieve arbitrary metadata. More
    * info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
    *
    * **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
    * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
    * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Annotations with 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted. Use the following annotation
    * keys to configure features on a Revision template:
    *
    * - 'autoscaling.knative.dev/maxScale' sets the [maximum number of container
    *   instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--max-instances) of the Revision to run.
    * - 'autoscaling.knative.dev/minScale' sets the [minimum number of container
    *   instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--min-instances) of the Revision to run.
    * - 'run.googleapis.com/client-name' sets the client name calling the Cloud Run API.
    * - 'run.googleapis.com/cloudsql-instances' sets the [Cloud SQL
    *   instances](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--add-cloudsql-instances) the Revision connects to.
    * - 'run.googleapis.com/cpu-throttling' sets whether to throttle the CPU when the container is not actively serving
    *   requests. See https://cloud.google.com/sdk/gcloud/reference/run/deploy#--[no-]cpu-throttling.
    * - 'run.googleapis.com/encryption-key-shutdown-hours' sets the number of hours to wait before an automatic shutdown
    *   server after CMEK key revocation is detected.
    * - 'run.googleapis.com/encryption-key' sets the [CMEK key](https://cloud.google.com/run/docs/securing/using-cmek)
    *   reference to encrypt the container with.
    * - 'run.googleapis.com/execution-environment' sets the [execution
    *   environment](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--execution-environment)
    *   where the application will run.
    * - 'run.googleapis.com/post-key-revocation-action-type' sets the
    *   [action type](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--post-key-revocation-action-type)
    *   after CMEK key revocation.
    * - 'run.googleapis.com/secrets' sets a list of key-value pairs to set as
    *   [secrets](https://cloud.google.com/run/docs/configuring/secrets#yaml).
    * - 'run.googleapis.com/sessionAffinity' sets whether to enable
    *   [session affinity](https://cloud.google.com/sdk/gcloud/reference/beta/run/deploy#--[no-]session-affinity)
    *   for connections to the Revision.
    * - 'run.googleapis.com/startup-cpu-boost' sets whether to allocate extra CPU to containers on startup.
    *   See https://cloud.google.com/sdk/gcloud/reference/run/deploy#--[no-]cpu-boost.
    * - 'run.googleapis.com/vpc-access-connector' sets a [VPC connector](https://cloud.google.com/run/docs/configuring/connecting-vpc#terraform_1)
    *   for the Revision.
    * - 'run.googleapis.com/vpc-access-egress' sets the outbound traffic to send through the VPC connector for this resource.
    *   See https://cloud.google.com/sdk/gcloud/reference/run/deploy#--vpc-egress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#annotations GoogleCloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
    * (scope and select) objects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#labels GoogleCloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name must be unique within a Google Cloud project and region.
    * Is required when creating resources. Name is primarily intended
    * for creation idempotence and configuration definition. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name?: string;
    /**
    * In Cloud Run the namespace must be equal to either the
    * project ID or project number. It will default to the resource's project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#namespace GoogleCloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function googleCloudRunServiceTemplateMetadataToTerraform(struct?: GoogleCloudRunServiceTemplateMetadataOutputReference | GoogleCloudRunServiceTemplateMetadata): any;
export declare function googleCloudRunServiceTemplateMetadataToHclTerraform(struct?: GoogleCloudRunServiceTemplateMetadataOutputReference | GoogleCloudRunServiceTemplateMetadata): any;
export declare class GoogleCloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateMetadata | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef {
    /**
    * A Cloud Secret Manager secret version. Must be 'latest' for the latest
    * version or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#key GoogleCloudRunService#key}
    */
    readonly key: string;
    /**
    * The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project.
    * If the secret is in another project, you must define an alias.
    * An alias definition has the form: :projects/{project-id|project-number}/secrets/.
    * If multiple alias definitions are needed, they must be separated by commas.
    * The alias definitions must be set on the run.googleapis.com/secrets annotation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#secret_key_ref GoogleCloudRunService#secret_key_ref}
    */
    readonly secretKeyRef: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvValueFromToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvValueFromToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined);
    private _secretKeyRef;
    get secretKeyRef(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): void;
    get secretKeyRefInput(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnv {
    /**
    * Name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name?: string;
    /**
    * Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#value GoogleCloudRunService#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#value_from GoogleCloudRunService#value_from}
    */
    readonly valueFrom?: GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference;
    putValueFrom(value: GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): GoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersEnvOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
    * Name of the referent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#optional GoogleCloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#local_object_reference GoogleCloudRunService#local_object_reference}
    */
    readonly localObjectReference?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
    * Name of the referent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#optional GoogleCloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#local_object_reference GoogleCloudRunService#local_object_reference}
    */
    readonly localObjectReference?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromSecretRefToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromSecretRefToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference | GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersEnvFrom {
    /**
    * An optional identifier to prepend to each key in the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#prefix GoogleCloudRunService#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#config_map_ref GoogleCloudRunService#config_map_ref}
    */
    readonly configMapRef?: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#secret_ref GoogleCloudRunService#secret_ref}
    */
    readonly secretRef?: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef;
}
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersEnvFromToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): GoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference;
    putSecretRef(value: GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): GoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#port GoogleCloudRunService#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
    * (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
    * If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#service GoogleCloudRunService#service}
    */
    readonly service?: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc): any;
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders {
    /**
    * The header field name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * The header field value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#value GoogleCloudRunService#value}
    */
    readonly value?: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet {
    /**
    * Path to access on the HTTP server. If set, it should not be empty string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#path GoogleCloudRunService#path}
    */
    readonly path?: string;
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#port GoogleCloudRunService#port}
    */
    readonly port?: number;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#http_headers GoogleCloudRunService#http_headers}
    */
    readonly httpHeaders?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet): any;
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _httpHeaders;
    get httpHeaders(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders[] | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after
    * having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#failure_threshold GoogleCloudRunService#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is
    * initiated.
    * Defaults to 0 seconds. Minimum value is 0. Maximum value is 3600.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#initial_delay_seconds GoogleCloudRunService#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe.
    * Default to 10 seconds. Minimum value is 1. Maximum value is 3600.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#period_seconds GoogleCloudRunService#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out.
    * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
    * Must be smaller than period_seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#timeout_seconds GoogleCloudRunService#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#grpc GoogleCloudRunService#grpc}
    */
    readonly grpc?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#http_get GoogleCloudRunService#http_get}
    */
    readonly httpGet?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet;
}
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbe): any;
export declare function googleCloudRunServiceTemplateSpecContainersLivenessProbeToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference | GoogleCloudRunServiceTemplateSpecContainersLivenessProbe): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbe | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference;
    putGrpc(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference;
    putHttpGet(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersPorts {
    /**
    * Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#container_port GoogleCloudRunService#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" (HTTP/1) and "h2c" (HTTP/2 end-to-end). Defaults to "http1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be "TCP". Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#protocol GoogleCloudRunService#protocol}
    */
    readonly protocol?: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersPortsToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersPortsToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersPortsOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainersResources {
    /**
    * Limits describes the maximum amount of compute resources allowed.
    * The values of the map is string form of the 'quantity' k8s type:
    * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#limits GoogleCloudRunService#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required.
    * If Requests is omitted for a container, it defaults to Limits if that is
    * explicitly specified, otherwise to an implementation-defined value.
    * The values of the map is string form of the 'quantity' k8s type:
    * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#requests GoogleCloudRunService#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function googleCloudRunServiceTemplateSpecContainersResourcesToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference | GoogleCloudRunServiceTemplateSpecContainersResources): any;
export declare function googleCloudRunServiceTemplateSpecContainersResourcesToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference | GoogleCloudRunServiceTemplateSpecContainersResources): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersResources | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#port GoogleCloudRunService#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
    * (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
    * If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#service GoogleCloudRunService#service}
    */
    readonly service?: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeGrpcToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc): any;
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeGrpcToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders {
    /**
    * The header field name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * The header field value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#value GoogleCloudRunService#value}
    */
    readonly value?: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet {
    /**
    * Path to access on the HTTP server. If set, it should not be empty string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#path GoogleCloudRunService#path}
    */
    readonly path?: string;
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#port GoogleCloudRunService#port}
    */
    readonly port?: number;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#http_headers GoogleCloudRunService#http_headers}
    */
    readonly httpHeaders?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet): any;
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _httpHeaders;
    get httpHeaders(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders[] | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#port GoogleCloudRunService#port}
    */
    readonly port?: number;
}
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket): any;
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after
    * having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#failure_threshold GoogleCloudRunService#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is
    * initiated.
    * Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#initial_delay_seconds GoogleCloudRunService#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe.
    * Default to 10 seconds. Minimum value is 1. Maximum value is 240.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#period_seconds GoogleCloudRunService#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out.
    * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
    * Must be smaller than periodSeconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#timeout_seconds GoogleCloudRunService#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#grpc GoogleCloudRunService#grpc}
    */
    readonly grpc?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#http_get GoogleCloudRunService#http_get}
    */
    readonly httpGet?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#tcp_socket GoogleCloudRunService#tcp_socket}
    */
    readonly tcpSocket?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket;
}
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbe): any;
export declare function googleCloudRunServiceTemplateSpecContainersStartupProbeToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference | GoogleCloudRunServiceTemplateSpecContainersStartupProbe): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersStartupProbe | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference;
    putGrpc(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference;
    putHttpGet(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference;
    putTcpSocket(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted.  Must
    * not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#mount_path GoogleCloudRunService#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
}
export declare function googleCloudRunServiceTemplateSpecContainersVolumeMountsToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersVolumeMountsToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecContainers {
    /**
    * Arguments to the entrypoint.
    * The docker image's CMD is used if this is not provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#args GoogleCloudRunService#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell.
    * The docker image's ENTRYPOINT is used if this is not provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#command GoogleCloudRunService#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. This is most often a reference to a container located
    * in the container registry, such as gcr.io/cloudrun/hello
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#image GoogleCloudRunService#image}
    */
    readonly image: string;
    /**
    * Name of the container
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name?: string;
    /**
    * Container's working directory.
    * If not specified, the container runtime's default will be used, which
    * might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#working_dir GoogleCloudRunService#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#env GoogleCloudRunService#env}
    */
    readonly env?: GoogleCloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#env_from GoogleCloudRunService#env_from}
    */
    readonly envFrom?: GoogleCloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#liveness_probe GoogleCloudRunService#liveness_probe}
    */
    readonly livenessProbe?: GoogleCloudRunServiceTemplateSpecContainersLivenessProbe;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#ports GoogleCloudRunService#ports}
    */
    readonly ports?: GoogleCloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#resources GoogleCloudRunService#resources}
    */
    readonly resources?: GoogleCloudRunServiceTemplateSpecContainersResources;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#startup_probe GoogleCloudRunService#startup_probe}
    */
    readonly startupProbe?: GoogleCloudRunServiceTemplateSpecContainersStartupProbe;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#volume_mounts GoogleCloudRunService#volume_mounts}
    */
    readonly volumeMounts?: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function googleCloudRunServiceTemplateSpecContainersToTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainers | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecContainersToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecContainers | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecContainers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): GoogleCloudRunServiceTemplateSpecContainersEnvList;
    putEnv(value: GoogleCloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersEnv[] | undefined;
    private _envFrom;
    get envFrom(): GoogleCloudRunServiceTemplateSpecContainersEnvFromList;
    putEnvFrom(value: GoogleCloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersEnvFrom[] | undefined;
    private _livenessProbe;
    get livenessProbe(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference;
    putLivenessProbe(value: GoogleCloudRunServiceTemplateSpecContainersLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): GoogleCloudRunServiceTemplateSpecContainersLivenessProbe | undefined;
    private _ports;
    get ports(): GoogleCloudRunServiceTemplateSpecContainersPortsList;
    putPorts(value: GoogleCloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersPorts[] | undefined;
    private _resources;
    get resources(): GoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference;
    putResources(value: GoogleCloudRunServiceTemplateSpecContainersResources): void;
    resetResources(): void;
    get resourcesInput(): GoogleCloudRunServiceTemplateSpecContainersResources | undefined;
    private _startupProbe;
    get startupProbe(): GoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference;
    putStartupProbe(value: GoogleCloudRunServiceTemplateSpecContainersStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): GoogleCloudRunServiceTemplateSpecContainersStartupProbe | undefined;
    private _volumeMounts;
    get volumeMounts(): GoogleCloudRunServiceTemplateSpecContainersVolumeMountsList;
    putVolumeMounts(value: GoogleCloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainersVolumeMounts[] | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecContainersOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecVolumesCsi {
    /**
    * Unique name representing the type of file system to be created. Cloud Run supports the following values:
    *   * gcsfuse.run.googleapis.com: Mount a Google Cloud Storage bucket using GCSFuse. This driver requires the
    *     run.googleapis.com/execution-environment annotation to be set to "gen2" and
    *     run.googleapis.com/launch-stage set to "BETA" or "ALPHA".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#driver GoogleCloudRunService#driver}
    */
    readonly driver: string;
    /**
    * If true, all mounts created from this volume will be read-only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#read_only GoogleCloudRunService#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Driver-specific attributes. The following options are supported for available drivers:
    *   * gcsfuse.run.googleapis.com
    *     * bucketName: The name of the Cloud Storage Bucket that backs this volume. The Cloud Run Service identity must have access to this bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#volume_attributes GoogleCloudRunService#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
}
export declare function googleCloudRunServiceTemplateSpecVolumesCsiToTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference | GoogleCloudRunServiceTemplateSpecVolumesCsi): any;
export declare function googleCloudRunServiceTemplateSpecVolumesCsiToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference | GoogleCloudRunServiceTemplateSpecVolumesCsi): any;
export declare class GoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecVolumesCsi | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecVolumesCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecVolumesEmptyDir {
    /**
    * The medium on which the data is stored. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#medium GoogleCloudRunService#medium}
    */
    readonly medium?: string;
    /**
    * Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#size_limit GoogleCloudRunService#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function googleCloudRunServiceTemplateSpecVolumesEmptyDirToTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference | GoogleCloudRunServiceTemplateSpecVolumesEmptyDir): any;
export declare function googleCloudRunServiceTemplateSpecVolumesEmptyDirToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference | GoogleCloudRunServiceTemplateSpecVolumesEmptyDir): any;
export declare class GoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecVolumesEmptyDir | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecVolumesEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecVolumesSecretItems {
    /**
    * The Cloud Secret Manager secret version.
    * Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#key GoogleCloudRunService#key}
    */
    readonly key: string;
    /**
    * Mode bits to use on this file, must be a value between 0000 and 0777. If
    * not specified, the volume defaultMode will be used. This might be in
    * conflict with other options that affect the file mode, like fsGroup, and
    * the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#mode GoogleCloudRunService#mode}
    */
    readonly mode?: number;
    /**
    * The relative path of the file to map the key to.
    * May not be an absolute path.
    * May not contain the path element '..'.
    * May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#path GoogleCloudRunService#path}
    */
    readonly path: string;
}
export declare function googleCloudRunServiceTemplateSpecVolumesSecretItemsToTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecVolumesSecretItemsToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): number;
    set mode(value: number);
    resetMode(): void;
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpecVolumesSecret {
    /**
    * Mode bits to use on created files by default. Must be a value between 0000
    * and 0777. Defaults to 0644. Directories within the path are not affected by
    * this setting. This might be in conflict with other options that affect the
    * file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#default_mode GoogleCloudRunService#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. By default, the secret
    * is assumed to be in the same project.
    * If the secret is in another project, you must define an alias.
    * An alias definition has the form:
    * {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
    * If multiple alias definitions are needed, they must be separated by
    * commas.
    * The alias definitions must be set on the run.googleapis.com/secrets
    * annotation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#secret_name GoogleCloudRunService#secret_name}
    */
    readonly secretName: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#items GoogleCloudRunService#items}
    */
    readonly items?: GoogleCloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function googleCloudRunServiceTemplateSpecVolumesSecretToTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference | GoogleCloudRunServiceTemplateSpecVolumesSecret): any;
export declare function googleCloudRunServiceTemplateSpecVolumesSecretToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference | GoogleCloudRunServiceTemplateSpecVolumesSecret): any;
export declare class GoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpecVolumesSecret | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _items;
    get items(): GoogleCloudRunServiceTemplateSpecVolumesSecretItemsList;
    putItems(value: GoogleCloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecVolumesSecretItems[] | undefined;
}
export interface GoogleCloudRunServiceTemplateSpecVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#name GoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#csi GoogleCloudRunService#csi}
    */
    readonly csi?: GoogleCloudRunServiceTemplateSpecVolumesCsi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#empty_dir GoogleCloudRunService#empty_dir}
    */
    readonly emptyDir?: GoogleCloudRunServiceTemplateSpecVolumesEmptyDir;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#secret GoogleCloudRunService#secret}
    */
    readonly secret?: GoogleCloudRunServiceTemplateSpecVolumesSecret;
}
export declare function googleCloudRunServiceTemplateSpecVolumesToTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumes | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTemplateSpecVolumesToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTemplateSpecVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTemplateSpecVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpecVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _csi;
    get csi(): GoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference;
    putCsi(value: GoogleCloudRunServiceTemplateSpecVolumesCsi): void;
    resetCsi(): void;
    get csiInput(): GoogleCloudRunServiceTemplateSpecVolumesCsi | undefined;
    private _emptyDir;
    get emptyDir(): GoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference;
    putEmptyDir(value: GoogleCloudRunServiceTemplateSpecVolumesEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): GoogleCloudRunServiceTemplateSpecVolumesEmptyDir | undefined;
    private _secret;
    get secret(): GoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference;
    putSecret(value: GoogleCloudRunServiceTemplateSpecVolumesSecret): void;
    resetSecret(): void;
    get secretInput(): GoogleCloudRunServiceTemplateSpecVolumesSecret | undefined;
}
export declare class GoogleCloudRunServiceTemplateSpecVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTemplateSpecVolumesOutputReference;
}
export interface GoogleCloudRunServiceTemplateSpec {
    /**
    * ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
    * requests per container of the Revision. Values are:
    * - '0' thread-safe, the system should manage the max concurrency. This is
    *     the default value.
    * - '1' not-thread-safe. Single concurrency
    * - '2-N' thread-safe, max concurrency of N
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#container_concurrency GoogleCloudRunService#container_concurrency}
    */
    readonly containerConcurrency?: number;
    /**
    * Email address of the IAM service account associated with the revision of the
    * service. The service account represents the identity of the running revision,
    * and determines what permissions the revision has. If not provided, the revision
    * will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#service_account_name GoogleCloudRunService#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#timeout_seconds GoogleCloudRunService#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#containers GoogleCloudRunService#containers}
    */
    readonly containers?: GoogleCloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#volumes GoogleCloudRunService#volumes}
    */
    readonly volumes?: GoogleCloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable;
}
export declare function googleCloudRunServiceTemplateSpecToTerraform(struct?: GoogleCloudRunServiceTemplateSpecOutputReference | GoogleCloudRunServiceTemplateSpec): any;
export declare function googleCloudRunServiceTemplateSpecToHclTerraform(struct?: GoogleCloudRunServiceTemplateSpecOutputReference | GoogleCloudRunServiceTemplateSpec): any;
export declare class GoogleCloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplateSpec | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplateSpec | undefined);
    private _containerConcurrency?;
    get containerConcurrency(): number;
    set containerConcurrency(value: number);
    resetContainerConcurrency(): void;
    get containerConcurrencyInput(): number | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    get servingState(): string;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _containers;
    get containers(): GoogleCloudRunServiceTemplateSpecContainersList;
    putContainers(value: GoogleCloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecContainers[] | undefined;
    private _volumes;
    get volumes(): GoogleCloudRunServiceTemplateSpecVolumesList;
    putVolumes(value: GoogleCloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleCloudRunServiceTemplateSpecVolumes[] | undefined;
}
export interface GoogleCloudRunServiceTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#metadata GoogleCloudRunService#metadata}
    */
    readonly metadata?: GoogleCloudRunServiceTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#spec GoogleCloudRunService#spec}
    */
    readonly spec?: GoogleCloudRunServiceTemplateSpec;
}
export declare function googleCloudRunServiceTemplateToTerraform(struct?: GoogleCloudRunServiceTemplateOutputReference | GoogleCloudRunServiceTemplate): any;
export declare function googleCloudRunServiceTemplateToHclTerraform(struct?: GoogleCloudRunServiceTemplateOutputReference | GoogleCloudRunServiceTemplate): any;
export declare class GoogleCloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTemplate | undefined;
    set internalValue(value: GoogleCloudRunServiceTemplate | undefined);
    private _metadata;
    get metadata(): GoogleCloudRunServiceTemplateMetadataOutputReference;
    putMetadata(value: GoogleCloudRunServiceTemplateMetadata): void;
    resetMetadata(): void;
    get metadataInput(): GoogleCloudRunServiceTemplateMetadata | undefined;
    private _spec;
    get spec(): GoogleCloudRunServiceTemplateSpecOutputReference;
    putSpec(value: GoogleCloudRunServiceTemplateSpec): void;
    resetSpec(): void;
    get specInput(): GoogleCloudRunServiceTemplateSpec | undefined;
}
export interface GoogleCloudRunServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#create GoogleCloudRunService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#delete GoogleCloudRunService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#update GoogleCloudRunService#update}
    */
    readonly update?: string;
}
export declare function googleCloudRunServiceTimeoutsToTerraform(struct?: GoogleCloudRunServiceTimeouts | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTimeoutsToHclTerraform(struct?: GoogleCloudRunServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleCloudRunServiceTraffic {
    /**
    * LatestRevision may be optionally provided to indicate that the latest ready
    * Revision of the Configuration should be used for this traffic target. When
    * provided LatestRevision must be true if RevisionName is empty; it must be
    * false when RevisionName is non-empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#latest_revision GoogleCloudRunService#latest_revision}
    */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
    * Percent specifies percent of the traffic to this Revision or Configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#percent GoogleCloudRunService#percent}
    */
    readonly percent: number;
    /**
    * RevisionName of a specific revision to which to send this portion of traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#revision_name GoogleCloudRunService#revision_name}
    */
    readonly revisionName?: string;
    /**
    * Tag is optionally used to expose a dedicated url for referencing this target exclusively.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#tag GoogleCloudRunService#tag}
    */
    readonly tag?: string;
}
export declare function googleCloudRunServiceTrafficToTerraform(struct?: GoogleCloudRunServiceTraffic | cdktf.IResolvable): any;
export declare function googleCloudRunServiceTrafficToHclTerraform(struct?: GoogleCloudRunServiceTraffic | cdktf.IResolvable): any;
export declare class GoogleCloudRunServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunServiceTraffic | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunServiceTraffic | cdktf.IResolvable | undefined);
    private _latestRevision?;
    get latestRevision(): boolean | cdktf.IResolvable;
    set latestRevision(value: boolean | cdktf.IResolvable);
    resetLatestRevision(): void;
    get latestRevisionInput(): boolean | cdktf.IResolvable | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    get percentInput(): number | undefined;
    private _revisionName?;
    get revisionName(): string;
    set revisionName(value: string);
    resetRevisionName(): void;
    get revisionNameInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    get url(): string;
}
export declare class GoogleCloudRunServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunServiceTraffic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunServiceTrafficOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service google_cloud_run_service}
*/
export declare class GoogleCloudRunService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_service";
    /**
    * Generates CDKTF code for importing a GoogleCloudRunService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudRunService to import
    * @param importFromId The id of the existing GoogleCloudRunService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudRunService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_service google_cloud_run_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudRunServiceConfig);
    private _autogenerateRevisionName?;
    get autogenerateRevisionName(): boolean | cdktf.IResolvable;
    set autogenerateRevisionName(value: boolean | cdktf.IResolvable);
    resetAutogenerateRevisionName(): void;
    get autogenerateRevisionNameInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): GoogleCloudRunServiceStatusList;
    private _metadata;
    get metadata(): GoogleCloudRunServiceMetadataOutputReference;
    putMetadata(value: GoogleCloudRunServiceMetadata): void;
    resetMetadata(): void;
    get metadataInput(): GoogleCloudRunServiceMetadata | undefined;
    private _template;
    get template(): GoogleCloudRunServiceTemplateOutputReference;
    putTemplate(value: GoogleCloudRunServiceTemplate): void;
    resetTemplate(): void;
    get templateInput(): GoogleCloudRunServiceTemplate | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudRunServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudRunServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudRunServiceTimeouts | undefined;
    private _traffic;
    get traffic(): GoogleCloudRunServiceTrafficList;
    putTraffic(value: GoogleCloudRunServiceTraffic[] | cdktf.IResolvable): void;
    resetTraffic(): void;
    get trafficInput(): cdktf.IResolvable | GoogleCloudRunServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
