/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudRunV2JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
    *
    * Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected on new resources.
    * All system annotations in v1 now have a corresponding field in v2 Job.
    *
    * This field follows Kubernetes annotations' namespacing, limits, and rules.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#annotations GoogleCloudRunV2Job#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Arbitrary identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#client GoogleCloudRunV2Job#client}
    */
    readonly client?: string;
    /**
    * Arbitrary version identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#client_version GoogleCloudRunV2Job#client_version}
    */
    readonly clientVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#id GoogleCloudRunV2Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
    * environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
    *
    * Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system labels in v1 now have a corresponding field in v2 Job.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#labels GoogleCloudRunV2Job#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
    * If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
    *
    * For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values: ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#launch_stage GoogleCloudRunV2Job#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * The location of the cloud run job
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#location GoogleCloudRunV2Job#location}
    */
    readonly location: string;
    /**
    * Name of the Job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#project GoogleCloudRunV2Job#project}
    */
    readonly project?: string;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#binary_authorization GoogleCloudRunV2Job#binary_authorization}
    */
    readonly binaryAuthorization?: GoogleCloudRunV2JobBinaryAuthorization;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#template GoogleCloudRunV2Job#template}
    */
    readonly template: GoogleCloudRunV2JobTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#timeouts GoogleCloudRunV2Job#timeouts}
    */
    readonly timeouts?: GoogleCloudRunV2JobTimeouts;
}
export interface GoogleCloudRunV2JobConditions {
}
export declare function googleCloudRunV2JobConditionsToTerraform(struct?: GoogleCloudRunV2JobConditions): any;
export declare function googleCloudRunV2JobConditionsToHclTerraform(struct?: GoogleCloudRunV2JobConditions): any;
export declare class GoogleCloudRunV2JobConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobConditions | undefined;
    set internalValue(value: GoogleCloudRunV2JobConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleCloudRunV2JobConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobConditionsOutputReference;
}
export interface GoogleCloudRunV2JobLatestCreatedExecution {
}
export declare function googleCloudRunV2JobLatestCreatedExecutionToTerraform(struct?: GoogleCloudRunV2JobLatestCreatedExecution): any;
export declare function googleCloudRunV2JobLatestCreatedExecutionToHclTerraform(struct?: GoogleCloudRunV2JobLatestCreatedExecution): any;
export declare class GoogleCloudRunV2JobLatestCreatedExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobLatestCreatedExecution | undefined;
    set internalValue(value: GoogleCloudRunV2JobLatestCreatedExecution | undefined);
    get completionTime(): string;
    get createTime(): string;
    get name(): string;
}
export declare class GoogleCloudRunV2JobLatestCreatedExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobLatestCreatedExecutionOutputReference;
}
export interface GoogleCloudRunV2JobTerminalCondition {
}
export declare function googleCloudRunV2JobTerminalConditionToTerraform(struct?: GoogleCloudRunV2JobTerminalCondition): any;
export declare function googleCloudRunV2JobTerminalConditionToHclTerraform(struct?: GoogleCloudRunV2JobTerminalCondition): any;
export declare class GoogleCloudRunV2JobTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTerminalCondition | undefined;
    set internalValue(value: GoogleCloudRunV2JobTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleCloudRunV2JobTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTerminalConditionOutputReference;
}
export interface GoogleCloudRunV2JobBinaryAuthorization {
    /**
    * If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#breakglass_justification GoogleCloudRunV2Job#breakglass_justification}
    */
    readonly breakglassJustification?: string;
    /**
    * If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#use_default GoogleCloudRunV2Job#use_default}
    */
    readonly useDefault?: boolean | cdktf.IResolvable;
}
export declare function googleCloudRunV2JobBinaryAuthorizationToTerraform(struct?: GoogleCloudRunV2JobBinaryAuthorizationOutputReference | GoogleCloudRunV2JobBinaryAuthorization): any;
export declare function googleCloudRunV2JobBinaryAuthorizationToHclTerraform(struct?: GoogleCloudRunV2JobBinaryAuthorizationOutputReference | GoogleCloudRunV2JobBinaryAuthorization): any;
export declare class GoogleCloudRunV2JobBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobBinaryAuthorization | undefined;
    set internalValue(value: GoogleCloudRunV2JobBinaryAuthorization | undefined);
    private _breakglassJustification?;
    get breakglassJustification(): string;
    set breakglassJustification(value: string);
    resetBreakglassJustification(): void;
    get breakglassJustificationInput(): string | undefined;
    private _useDefault?;
    get useDefault(): boolean | cdktf.IResolvable;
    set useDefault(value: boolean | cdktf.IResolvable);
    resetUseDefault(): void;
    get useDefaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef {
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#secret GoogleCloudRunV2Job#secret}
    */
    readonly secret: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#version GoogleCloudRunV2Job#version}
    */
    readonly version: string;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#secret_key_ref GoogleCloudRunV2Job#secret_key_ref}
    */
    readonly secretKeyRef?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvValueSourceToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvValueSourceToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
    putSecretKeyRef(value: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#value GoogleCloudRunV2Job#value}
    */
    readonly value?: string;
    /**
    * value_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#value_source GoogleCloudRunV2Job#value_source}
    */
    readonly valueSource?: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersEnvToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueSource;
    get valueSource(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference;
    putValueSource(value: GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource): void;
    resetValueSource(): void;
    get valueSourceInput(): GoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateContainersEnvOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersPorts {
    /**
    * Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#container_port GoogleCloudRunV2Job#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name?: string;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersPortsToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersPortsToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateContainersPortsOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersResources {
    /**
    * Only memory and CPU are supported. Use key 'cpu' for CPU limit and 'memory' for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#limits GoogleCloudRunV2Job#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
}
export declare function googleCloudRunV2JobTemplateTemplateContainersResourcesToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersResources): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersResourcesToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference | GoogleCloudRunV2JobTemplateTemplateContainersResources): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersResources | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#mount_path GoogleCloudRunV2Job#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name: string;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersVolumeMountsToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersVolumeMountsToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateContainers {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#args GoogleCloudRunV2Job#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#command GoogleCloudRunV2Job#command}
    */
    readonly command?: string[];
    /**
    * URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#image GoogleCloudRunV2Job#image}
    */
    readonly image: string;
    /**
    * Name of the container specified as a DNS_LABEL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name?: string;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#working_dir GoogleCloudRunV2Job#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#env GoogleCloudRunV2Job#env}
    */
    readonly env?: GoogleCloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#ports GoogleCloudRunV2Job#ports}
    */
    readonly ports?: GoogleCloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#resources GoogleCloudRunV2Job#resources}
    */
    readonly resources?: GoogleCloudRunV2JobTemplateTemplateContainersResources;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#volume_mounts GoogleCloudRunV2Job#volume_mounts}
    */
    readonly volumeMounts?: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2JobTemplateTemplateContainersToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateContainersToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): GoogleCloudRunV2JobTemplateTemplateContainersEnvList;
    putEnv(value: GoogleCloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateContainersEnv[] | undefined;
    private _ports;
    get ports(): GoogleCloudRunV2JobTemplateTemplateContainersPortsList;
    putPorts(value: GoogleCloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateContainersPorts[] | undefined;
    private _resources;
    get resources(): GoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference;
    putResources(value: GoogleCloudRunV2JobTemplateTemplateContainersResources): void;
    resetResources(): void;
    get resourcesInput(): GoogleCloudRunV2JobTemplateTemplateContainersResources | undefined;
    private _volumeMounts;
    get volumeMounts(): GoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsList;
    putVolumeMounts(value: GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts[] | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateContainersOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance {
    /**
    * The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#instances GoogleCloudRunV2Job#instances}
    */
    readonly instances?: string[];
}
export declare function googleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): any;
export declare function googleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined);
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir {
    /**
    * The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#medium GoogleCloudRunV2Job#medium}
    */
    readonly medium?: string;
    /**
    * Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#size_limit GoogleCloudRunV2Job#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function googleCloudRunV2JobTemplateTemplateVolumesEmptyDirToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir): any;
export declare function googleCloudRunV2JobTemplateTemplateVolumesEmptyDirToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems {
    /**
    * Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#mode GoogleCloudRunV2Job#mode}
    */
    readonly mode?: number;
    /**
    * The relative path of the secret in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#path GoogleCloudRunV2Job#path}
    */
    readonly path: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#version GoogleCloudRunV2Job#version}
    */
    readonly version: string;
}
export declare function googleCloudRunV2JobTemplateTemplateVolumesSecretItemsToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateVolumesSecretItemsToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): number;
    set mode(value: number);
    resetMode(): void;
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateVolumesSecret {
    /**
    * Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#default_mode GoogleCloudRunV2Job#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#secret GoogleCloudRunV2Job#secret}
    */
    readonly secret: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#items GoogleCloudRunV2Job#items}
    */
    readonly items?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2JobTemplateTemplateVolumesSecretToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesSecret): any;
export declare function googleCloudRunV2JobTemplateTemplateVolumesSecretToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference | GoogleCloudRunV2JobTemplateTemplateVolumesSecret): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVolumesSecret | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _items;
    get items(): GoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsList;
    putItems(value: GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateVolumesSecretItems[] | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplateVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#name GoogleCloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * cloud_sql_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#cloud_sql_instance GoogleCloudRunV2Job#cloud_sql_instance}
    */
    readonly cloudSqlInstance?: GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#empty_dir GoogleCloudRunV2Job#empty_dir}
    */
    readonly emptyDir?: GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#secret GoogleCloudRunV2Job#secret}
    */
    readonly secret?: GoogleCloudRunV2JobTemplateTemplateVolumesSecret;
}
export declare function googleCloudRunV2JobTemplateTemplateVolumesToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateVolumesToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _cloudSqlInstance;
    get cloudSqlInstance(): GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference;
    putCloudSqlInstance(value: GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): void;
    resetCloudSqlInstance(): void;
    get cloudSqlInstanceInput(): GoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined;
    private _emptyDir;
    get emptyDir(): GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference;
    putEmptyDir(value: GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): GoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir | undefined;
    private _secret;
    get secret(): GoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference;
    putSecret(value: GoogleCloudRunV2JobTemplateTemplateVolumesSecret): void;
    resetSecret(): void;
    get secretInput(): GoogleCloudRunV2JobTemplateTemplateVolumesSecret | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateVolumesOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces {
    /**
    * The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
    * network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
    * looked up from the subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#network GoogleCloudRunV2Job#network}
    */
    readonly network?: string;
    /**
    * The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
    * network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
    * subnetwork with the same name with the network will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#subnetwork GoogleCloudRunV2Job#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * Network tags applied to this Cloud Run job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#tags GoogleCloudRunV2Job#tags}
    */
    readonly tags?: string[];
}
export declare function googleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
}
export declare class GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesOutputReference;
}
export interface GoogleCloudRunV2JobTemplateTemplateVpcAccess {
    /**
    * VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#connector GoogleCloudRunV2Job#connector}
    */
    readonly connector?: string;
    /**
    * Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#egress GoogleCloudRunV2Job#egress}
    */
    readonly egress?: string;
    /**
    * network_interfaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#network_interfaces GoogleCloudRunV2Job#network_interfaces}
    */
    readonly networkInterfaces?: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2JobTemplateTemplateVpcAccessToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference | GoogleCloudRunV2JobTemplateTemplateVpcAccess): any;
export declare function googleCloudRunV2JobTemplateTemplateVpcAccessToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference | GoogleCloudRunV2JobTemplateTemplateVpcAccess): any;
export declare class GoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplateVpcAccess | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplateVpcAccess | undefined);
    private _connector?;
    get connector(): string;
    set connector(value: string);
    resetConnector(): void;
    get connectorInput(): string | undefined;
    private _egress?;
    get egress(): string;
    set egress(value: string);
    resetEgress(): void;
    get egressInput(): string | undefined;
    private _networkInterfaces;
    get networkInterfaces(): GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesList;
    putNetworkInterfaces(value: GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable): void;
    resetNetworkInterfaces(): void;
    get networkInterfacesInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces[] | undefined;
}
export interface GoogleCloudRunV2JobTemplateTemplate {
    /**
    * A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#encryption_key GoogleCloudRunV2Job#encryption_key}
    */
    readonly encryptionKey?: string;
    /**
    * The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#execution_environment GoogleCloudRunV2Job#execution_environment}
    */
    readonly executionEnvironment?: string;
    /**
    * Number of retries allowed per Task, before marking this Task failed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#max_retries GoogleCloudRunV2Job#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#service_account GoogleCloudRunV2Job#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
    *
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#timeout GoogleCloudRunV2Job#timeout}
    */
    readonly timeout?: string;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#containers GoogleCloudRunV2Job#containers}
    */
    readonly containers?: GoogleCloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#volumes GoogleCloudRunV2Job#volumes}
    */
    readonly volumes?: GoogleCloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable;
    /**
    * vpc_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#vpc_access GoogleCloudRunV2Job#vpc_access}
    */
    readonly vpcAccess?: GoogleCloudRunV2JobTemplateTemplateVpcAccess;
}
export declare function googleCloudRunV2JobTemplateTemplateToTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateOutputReference | GoogleCloudRunV2JobTemplateTemplate): any;
export declare function googleCloudRunV2JobTemplateTemplateToHclTerraform(struct?: GoogleCloudRunV2JobTemplateTemplateOutputReference | GoogleCloudRunV2JobTemplateTemplate): any;
export declare class GoogleCloudRunV2JobTemplateTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplateTemplate | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplateTemplate | undefined);
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    resetEncryptionKey(): void;
    get encryptionKeyInput(): string | undefined;
    private _executionEnvironment?;
    get executionEnvironment(): string;
    set executionEnvironment(value: string);
    resetExecutionEnvironment(): void;
    get executionEnvironmentInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _containers;
    get containers(): GoogleCloudRunV2JobTemplateTemplateContainersList;
    putContainers(value: GoogleCloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateContainers[] | undefined;
    private _volumes;
    get volumes(): GoogleCloudRunV2JobTemplateTemplateVolumesList;
    putVolumes(value: GoogleCloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleCloudRunV2JobTemplateTemplateVolumes[] | undefined;
    private _vpcAccess;
    get vpcAccess(): GoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference;
    putVpcAccess(value: GoogleCloudRunV2JobTemplateTemplateVpcAccess): void;
    resetVpcAccess(): void;
    get vpcAccessInput(): GoogleCloudRunV2JobTemplateTemplateVpcAccess | undefined;
}
export interface GoogleCloudRunV2JobTemplate {
    /**
    * Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
    *
    * Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
    *
    * This field follows Kubernetes annotations' namespacing, limits, and rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#annotations GoogleCloudRunV2Job#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
    * or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
    * https://cloud.google.com/run/docs/configuring/labels.
    *
    * Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#labels GoogleCloudRunV2Job#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#parallelism GoogleCloudRunV2Job#parallelism}
    */
    readonly parallelism?: number;
    /**
    * Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#task_count GoogleCloudRunV2Job#task_count}
    */
    readonly taskCount?: number;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#template GoogleCloudRunV2Job#template}
    */
    readonly template: GoogleCloudRunV2JobTemplateTemplate;
}
export declare function googleCloudRunV2JobTemplateToTerraform(struct?: GoogleCloudRunV2JobTemplateOutputReference | GoogleCloudRunV2JobTemplate): any;
export declare function googleCloudRunV2JobTemplateToHclTerraform(struct?: GoogleCloudRunV2JobTemplateOutputReference | GoogleCloudRunV2JobTemplate): any;
export declare class GoogleCloudRunV2JobTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTemplate | undefined;
    set internalValue(value: GoogleCloudRunV2JobTemplate | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _taskCount?;
    get taskCount(): number;
    set taskCount(value: number);
    resetTaskCount(): void;
    get taskCountInput(): number | undefined;
    private _template;
    get template(): GoogleCloudRunV2JobTemplateTemplateOutputReference;
    putTemplate(value: GoogleCloudRunV2JobTemplateTemplate): void;
    get templateInput(): GoogleCloudRunV2JobTemplateTemplate | undefined;
}
export interface GoogleCloudRunV2JobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#create GoogleCloudRunV2Job#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#delete GoogleCloudRunV2Job#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#update GoogleCloudRunV2Job#update}
    */
    readonly update?: string;
}
export declare function googleCloudRunV2JobTimeoutsToTerraform(struct?: GoogleCloudRunV2JobTimeouts | cdktf.IResolvable): any;
export declare function googleCloudRunV2JobTimeoutsToHclTerraform(struct?: GoogleCloudRunV2JobTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2JobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2JobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2JobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job google_cloud_run_v2_job}
*/
export declare class GoogleCloudRunV2Job extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_job";
    /**
    * Generates CDKTF code for importing a GoogleCloudRunV2Job resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudRunV2Job to import
    * @param importFromId The id of the existing GoogleCloudRunV2Job that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudRunV2Job to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_job google_cloud_run_v2_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudRunV2JobConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudRunV2JobConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    private _clientVersion?;
    get clientVersion(): string;
    set clientVersion(value: string);
    resetClientVersion(): void;
    get clientVersionInput(): string | undefined;
    private _conditions;
    get conditions(): GoogleCloudRunV2JobConditionsList;
    get createTime(): string;
    get creator(): string;
    get deleteTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    get executionCount(): number;
    get expireTime(): string;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastModifier(): string;
    private _latestCreatedExecution;
    get latestCreatedExecution(): GoogleCloudRunV2JobLatestCreatedExecutionList;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _terminalCondition;
    get terminalCondition(): GoogleCloudRunV2JobTerminalConditionList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _binaryAuthorization;
    get binaryAuthorization(): GoogleCloudRunV2JobBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: GoogleCloudRunV2JobBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): GoogleCloudRunV2JobBinaryAuthorization | undefined;
    private _template;
    get template(): GoogleCloudRunV2JobTemplateOutputReference;
    putTemplate(value: GoogleCloudRunV2JobTemplate): void;
    get templateInput(): GoogleCloudRunV2JobTemplate | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudRunV2JobTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudRunV2JobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudRunV2JobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
