/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudRunV2ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
    *
    * Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected in new resources.
    * All system annotations in v1 now have a corresponding field in v2 Service.
    *
    * This field follows Kubernetes annotations' namespacing, limits, and rules.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#annotations GoogleCloudRunV2Service#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Arbitrary identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#client GoogleCloudRunV2Service#client}
    */
    readonly client?: string;
    /**
    * Arbitrary version identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#client_version GoogleCloudRunV2Service#client_version}
    */
    readonly clientVersion?: string;
    /**
    * One or more custom audiences that you want this service to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
    * For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#custom_audiences GoogleCloudRunV2Service#custom_audiences}
    */
    readonly customAudiences?: string[];
    /**
    * User-provided description of the Service. This field currently has a 512-character limit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#description GoogleCloudRunV2Service#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#id GoogleCloudRunV2Service#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL", "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#ingress GoogleCloudRunV2Service#ingress}
    */
    readonly ingress?: string;
    /**
    * Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
    * environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
    *
    * Cloud Run API v2 does not support labels with  'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system labels in v1 now have a corresponding field in v2 Service.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#labels GoogleCloudRunV2Service#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
    * If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
    *
    * For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output. Possible values: ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#launch_stage GoogleCloudRunV2Service#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * The location of the cloud run service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#location GoogleCloudRunV2Service#location}
    */
    readonly location: string;
    /**
    * Name of the Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#project GoogleCloudRunV2Service#project}
    */
    readonly project?: string;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#binary_authorization GoogleCloudRunV2Service#binary_authorization}
    */
    readonly binaryAuthorization?: GoogleCloudRunV2ServiceBinaryAuthorization;
    /**
    * scaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#scaling GoogleCloudRunV2Service#scaling}
    */
    readonly scaling?: GoogleCloudRunV2ServiceScaling;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#template GoogleCloudRunV2Service#template}
    */
    readonly template: GoogleCloudRunV2ServiceTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#timeouts GoogleCloudRunV2Service#timeouts}
    */
    readonly timeouts?: GoogleCloudRunV2ServiceTimeouts;
    /**
    * traffic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#traffic GoogleCloudRunV2Service#traffic}
    */
    readonly traffic?: GoogleCloudRunV2ServiceTraffic[] | cdktf.IResolvable;
}
export interface GoogleCloudRunV2ServiceConditions {
}
export declare function googleCloudRunV2ServiceConditionsToTerraform(struct?: GoogleCloudRunV2ServiceConditions): any;
export declare function googleCloudRunV2ServiceConditionsToHclTerraform(struct?: GoogleCloudRunV2ServiceConditions): any;
export declare class GoogleCloudRunV2ServiceConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceConditions | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleCloudRunV2ServiceConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceConditionsOutputReference;
}
export interface GoogleCloudRunV2ServiceTerminalCondition {
}
export declare function googleCloudRunV2ServiceTerminalConditionToTerraform(struct?: GoogleCloudRunV2ServiceTerminalCondition): any;
export declare function googleCloudRunV2ServiceTerminalConditionToHclTerraform(struct?: GoogleCloudRunV2ServiceTerminalCondition): any;
export declare class GoogleCloudRunV2ServiceTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTerminalCondition | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleCloudRunV2ServiceTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTerminalConditionOutputReference;
}
export interface GoogleCloudRunV2ServiceTrafficStatuses {
}
export declare function googleCloudRunV2ServiceTrafficStatusesToTerraform(struct?: GoogleCloudRunV2ServiceTrafficStatuses): any;
export declare function googleCloudRunV2ServiceTrafficStatusesToHclTerraform(struct?: GoogleCloudRunV2ServiceTrafficStatuses): any;
export declare class GoogleCloudRunV2ServiceTrafficStatusesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTrafficStatuses | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTrafficStatuses | undefined);
    get percent(): number;
    get revision(): string;
    get tag(): string;
    get type(): string;
    get uri(): string;
}
export declare class GoogleCloudRunV2ServiceTrafficStatusesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTrafficStatusesOutputReference;
}
export interface GoogleCloudRunV2ServiceBinaryAuthorization {
    /**
    * If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#breakglass_justification GoogleCloudRunV2Service#breakglass_justification}
    */
    readonly breakglassJustification?: string;
    /**
    * If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#use_default GoogleCloudRunV2Service#use_default}
    */
    readonly useDefault?: boolean | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceBinaryAuthorizationToTerraform(struct?: GoogleCloudRunV2ServiceBinaryAuthorizationOutputReference | GoogleCloudRunV2ServiceBinaryAuthorization): any;
export declare function googleCloudRunV2ServiceBinaryAuthorizationToHclTerraform(struct?: GoogleCloudRunV2ServiceBinaryAuthorizationOutputReference | GoogleCloudRunV2ServiceBinaryAuthorization): any;
export declare class GoogleCloudRunV2ServiceBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceBinaryAuthorization | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceBinaryAuthorization | undefined);
    private _breakglassJustification?;
    get breakglassJustification(): string;
    set breakglassJustification(value: string);
    resetBreakglassJustification(): void;
    get breakglassJustificationInput(): string | undefined;
    private _useDefault?;
    get useDefault(): boolean | cdktf.IResolvable;
    set useDefault(value: boolean | cdktf.IResolvable);
    resetUseDefault(): void;
    get useDefaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudRunV2ServiceScaling {
    /**
    * Minimum number of instances for the service, to be divided among all revisions receiving traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#min_instance_count GoogleCloudRunV2Service#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function googleCloudRunV2ServiceScalingToTerraform(struct?: GoogleCloudRunV2ServiceScalingOutputReference | GoogleCloudRunV2ServiceScaling): any;
export declare function googleCloudRunV2ServiceScalingToHclTerraform(struct?: GoogleCloudRunV2ServiceScalingOutputReference | GoogleCloudRunV2ServiceScaling): any;
export declare class GoogleCloudRunV2ServiceScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceScaling | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceScaling | undefined);
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef {
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#secret GoogleCloudRunV2Service#secret}
    */
    readonly secret: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#version GoogleCloudRunV2Service#version}
    */
    readonly version?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference | GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare function googleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference | GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersEnvValueSource {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#secret_key_ref GoogleCloudRunV2Service#secret_key_ref}
    */
    readonly secretKeyRef?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef;
}
export declare function googleCloudRunV2ServiceTemplateContainersEnvValueSourceToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference | GoogleCloudRunV2ServiceTemplateContainersEnvValueSource): any;
export declare function googleCloudRunV2ServiceTemplateContainersEnvValueSourceToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference | GoogleCloudRunV2ServiceTemplateContainersEnvValueSource): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSource | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
    putSecretKeyRef(value: GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#value GoogleCloudRunV2Service#value}
    */
    readonly value?: string;
    /**
    * value_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#value_source GoogleCloudRunV2Service#value_source}
    */
    readonly valueSource?: GoogleCloudRunV2ServiceTemplateContainersEnvValueSource;
}
export declare function googleCloudRunV2ServiceTemplateContainersEnvToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersEnvToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueSource;
    get valueSource(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference;
    putValueSource(value: GoogleCloudRunV2ServiceTemplateContainersEnvValueSource): void;
    resetValueSource(): void;
    get valueSourceInput(): GoogleCloudRunV2ServiceTemplateContainersEnvValueSource | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersEnvOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
    * (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
    * If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#service GoogleCloudRunV2Service#service}
    */
    readonly service?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc): any;
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#value GoogleCloudRunV2Service#value}
    */
    readonly value?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#path GoogleCloudRunV2Service#path}
    */
    readonly path?: string;
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#http_headers GoogleCloudRunV2Service#http_headers}
    */
    readonly httpHeaders?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): any;
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _httpHeaders;
    get httpHeaders(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535.
    * If not specified, defaults to the exposed port of the container, which
    * is the value of container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port: number;
}
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): any;
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#failure_threshold GoogleCloudRunV2Service#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#initial_delay_seconds GoogleCloudRunV2Service#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#period_seconds GoogleCloudRunV2Service#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#timeout_seconds GoogleCloudRunV2Service#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#grpc GoogleCloudRunV2Service#grpc}
    */
    readonly grpc?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#http_get GoogleCloudRunV2Service#http_get}
    */
    readonly httpGet?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#tcp_socket GoogleCloudRunV2Service#tcp_socket}
    */
    readonly tcpSocket?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket;
}
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbe): any;
export declare function googleCloudRunV2ServiceTemplateContainersLivenessProbeToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference | GoogleCloudRunV2ServiceTemplateContainersLivenessProbe): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbe | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference;
    putGrpc(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference;
    putHttpGet(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference;
    putTcpSocket(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersPorts {
    /**
    * Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#container_port GoogleCloudRunV2Service#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersPortsToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersPortsToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersPortsOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateContainersResources {
    /**
    * Determines whether CPU is only allocated during requests. True by default if the parent 'resources' field is not set. However, if
    * 'resources' is set, this field must be explicitly set to true to preserve the default behavior.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#cpu_idle GoogleCloudRunV2Service#cpu_idle}
    */
    readonly cpuIdle?: boolean | cdktf.IResolvable;
    /**
    * Only memory and CPU are supported. Use key 'cpu' for CPU limit and 'memory' for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#limits GoogleCloudRunV2Service#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#startup_cpu_boost GoogleCloudRunV2Service#startup_cpu_boost}
    */
    readonly startupCpuBoost?: boolean | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateContainersResourcesToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference | GoogleCloudRunV2ServiceTemplateContainersResources): any;
export declare function googleCloudRunV2ServiceTemplateContainersResourcesToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference | GoogleCloudRunV2ServiceTemplateContainersResources): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersResources | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersResources | undefined);
    private _cpuIdle?;
    get cpuIdle(): boolean | cdktf.IResolvable;
    set cpuIdle(value: boolean | cdktf.IResolvable);
    resetCpuIdle(): void;
    get cpuIdleInput(): boolean | cdktf.IResolvable | undefined;
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _startupCpuBoost?;
    get startupCpuBoost(): boolean | cdktf.IResolvable;
    set startupCpuBoost(value: boolean | cdktf.IResolvable);
    resetStartupCpuBoost(): void;
    get startupCpuBoostInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
    * (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
    * If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#service GoogleCloudRunV2Service#service}
    */
    readonly service?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeGrpcToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc): any;
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeGrpcToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#value GoogleCloudRunV2Service#value}
    */
    readonly value?: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#path GoogleCloudRunV2Service#path}
    */
    readonly path?: string;
    /**
    * Port number to access on the container. Must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#http_headers GoogleCloudRunV2Service#http_headers}
    */
    readonly httpHeaders?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet): any;
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _httpHeaders;
    get httpHeaders(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535.
    * If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#port GoogleCloudRunV2Service#port}
    */
    readonly port?: number;
}
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): any;
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#failure_threshold GoogleCloudRunV2Service#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#initial_delay_seconds GoogleCloudRunV2Service#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#period_seconds GoogleCloudRunV2Service#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#timeout_seconds GoogleCloudRunV2Service#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#grpc GoogleCloudRunV2Service#grpc}
    */
    readonly grpc?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#http_get GoogleCloudRunV2Service#http_get}
    */
    readonly httpGet?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#tcp_socket GoogleCloudRunV2Service#tcp_socket}
    */
    readonly tcpSocket?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket;
}
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbe): any;
export declare function googleCloudRunV2ServiceTemplateContainersStartupProbeToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference | GoogleCloudRunV2ServiceTemplateContainersStartupProbe): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersStartupProbe | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference;
    putGrpc(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference;
    putHttpGet(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference;
    putTcpSocket(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#mount_path GoogleCloudRunV2Service#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
}
export declare function googleCloudRunV2ServiceTemplateContainersVolumeMountsToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersVolumeMountsToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersVolumeMountsOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateContainers {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#args GoogleCloudRunV2Service#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#command GoogleCloudRunV2Service#command}
    */
    readonly command?: string[];
    /**
    * Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#depends_on GoogleCloudRunV2Service#depends_on}
    */
    readonly dependsOn?: string[];
    /**
    * URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#image GoogleCloudRunV2Service#image}
    */
    readonly image: string;
    /**
    * Name of the container specified as a DNS_LABEL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name?: string;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#working_dir GoogleCloudRunV2Service#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#env GoogleCloudRunV2Service#env}
    */
    readonly env?: GoogleCloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#liveness_probe GoogleCloudRunV2Service#liveness_probe}
    */
    readonly livenessProbe?: GoogleCloudRunV2ServiceTemplateContainersLivenessProbe;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#ports GoogleCloudRunV2Service#ports}
    */
    readonly ports?: GoogleCloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#resources GoogleCloudRunV2Service#resources}
    */
    readonly resources?: GoogleCloudRunV2ServiceTemplateContainersResources;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#startup_probe GoogleCloudRunV2Service#startup_probe}
    */
    readonly startupProbe?: GoogleCloudRunV2ServiceTemplateContainersStartupProbe;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#volume_mounts GoogleCloudRunV2Service#volume_mounts}
    */
    readonly volumeMounts?: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateContainersToTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainers | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateContainersToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateContainers | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateContainers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _dependsOn?;
    get dependsOn(): string[];
    set dependsOn(value: string[]);
    resetDependsOn(): void;
    get dependsOnInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): GoogleCloudRunV2ServiceTemplateContainersEnvList;
    putEnv(value: GoogleCloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainersEnv[] | undefined;
    private _livenessProbe;
    get livenessProbe(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference;
    putLivenessProbe(value: GoogleCloudRunV2ServiceTemplateContainersLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): GoogleCloudRunV2ServiceTemplateContainersLivenessProbe | undefined;
    private _ports;
    get ports(): GoogleCloudRunV2ServiceTemplateContainersPortsList;
    putPorts(value: GoogleCloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainersPorts[] | undefined;
    private _resources;
    get resources(): GoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference;
    putResources(value: GoogleCloudRunV2ServiceTemplateContainersResources): void;
    resetResources(): void;
    get resourcesInput(): GoogleCloudRunV2ServiceTemplateContainersResources | undefined;
    private _startupProbe;
    get startupProbe(): GoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference;
    putStartupProbe(value: GoogleCloudRunV2ServiceTemplateContainersStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): GoogleCloudRunV2ServiceTemplateContainersStartupProbe | undefined;
    private _volumeMounts;
    get volumeMounts(): GoogleCloudRunV2ServiceTemplateContainersVolumeMountsList;
    putVolumeMounts(value: GoogleCloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainersVolumeMounts[] | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateContainersOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateScaling {
    /**
    * Maximum number of serving instances that this resource should have.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#max_instance_count GoogleCloudRunV2Service#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * Minimum number of serving instances that this resource should have.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#min_instance_count GoogleCloudRunV2Service#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function googleCloudRunV2ServiceTemplateScalingToTerraform(struct?: GoogleCloudRunV2ServiceTemplateScalingOutputReference | GoogleCloudRunV2ServiceTemplateScaling): any;
export declare function googleCloudRunV2ServiceTemplateScalingToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateScalingOutputReference | GoogleCloudRunV2ServiceTemplateScaling): any;
export declare class GoogleCloudRunV2ServiceTemplateScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateScaling | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateScaling | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance {
    /**
    * The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#instances GoogleCloudRunV2Service#instances}
    */
    readonly instances?: string[];
}
export declare function googleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference | GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance): any;
export declare function googleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference | GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined);
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesEmptyDir {
    /**
    * The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#medium GoogleCloudRunV2Service#medium}
    */
    readonly medium?: string;
    /**
    * Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#size_limit GoogleCloudRunV2Service#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function googleCloudRunV2ServiceTemplateVolumesEmptyDirToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference | GoogleCloudRunV2ServiceTemplateVolumesEmptyDir): any;
export declare function googleCloudRunV2ServiceTemplateVolumesEmptyDirToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference | GoogleCloudRunV2ServiceTemplateVolumesEmptyDir): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesEmptyDir | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesGcs {
    /**
    * GCS Bucket name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#bucket GoogleCloudRunV2Service#bucket}
    */
    readonly bucket: string;
    /**
    * If true, mount the GCS bucket as read-only
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#read_only GoogleCloudRunV2Service#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateVolumesGcsToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference | GoogleCloudRunV2ServiceTemplateVolumesGcs): any;
export declare function googleCloudRunV2ServiceTemplateVolumesGcsToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference | GoogleCloudRunV2ServiceTemplateVolumesGcs): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesGcs | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesNfs {
    /**
    * Path that is exported by the NFS server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#path GoogleCloudRunV2Service#path}
    */
    readonly path: string;
    /**
    * If true, mount the NFS volume as read only
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#read_only GoogleCloudRunV2Service#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Hostname or IP address of the NFS server
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#server GoogleCloudRunV2Service#server}
    */
    readonly server: string;
}
export declare function googleCloudRunV2ServiceTemplateVolumesNfsToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference | GoogleCloudRunV2ServiceTemplateVolumesNfs): any;
export declare function googleCloudRunV2ServiceTemplateVolumesNfsToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference | GoogleCloudRunV2ServiceTemplateVolumesNfs): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesNfs | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesSecretItems {
    /**
    * Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#mode GoogleCloudRunV2Service#mode}
    */
    readonly mode?: number;
    /**
    * The relative path of the secret in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#path GoogleCloudRunV2Service#path}
    */
    readonly path: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#version GoogleCloudRunV2Service#version}
    */
    readonly version?: string;
}
export declare function googleCloudRunV2ServiceTemplateVolumesSecretItemsToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateVolumesSecretItemsToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): number;
    set mode(value: number);
    resetMode(): void;
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateVolumesSecretItemsOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateVolumesSecret {
    /**
    * Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#default_mode GoogleCloudRunV2Service#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#secret GoogleCloudRunV2Service#secret}
    */
    readonly secret: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#items GoogleCloudRunV2Service#items}
    */
    readonly items?: GoogleCloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateVolumesSecretToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference | GoogleCloudRunV2ServiceTemplateVolumesSecret): any;
export declare function googleCloudRunV2ServiceTemplateVolumesSecretToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference | GoogleCloudRunV2ServiceTemplateVolumesSecret): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumesSecret | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _items;
    get items(): GoogleCloudRunV2ServiceTemplateVolumesSecretItemsList;
    putItems(value: GoogleCloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateVolumesSecretItems[] | undefined;
}
export interface GoogleCloudRunV2ServiceTemplateVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#name GoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * cloud_sql_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#cloud_sql_instance GoogleCloudRunV2Service#cloud_sql_instance}
    */
    readonly cloudSqlInstance?: GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#empty_dir GoogleCloudRunV2Service#empty_dir}
    */
    readonly emptyDir?: GoogleCloudRunV2ServiceTemplateVolumesEmptyDir;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#gcs GoogleCloudRunV2Service#gcs}
    */
    readonly gcs?: GoogleCloudRunV2ServiceTemplateVolumesGcs;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#nfs GoogleCloudRunV2Service#nfs}
    */
    readonly nfs?: GoogleCloudRunV2ServiceTemplateVolumesNfs;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#secret GoogleCloudRunV2Service#secret}
    */
    readonly secret?: GoogleCloudRunV2ServiceTemplateVolumesSecret;
}
export declare function googleCloudRunV2ServiceTemplateVolumesToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumes | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateVolumesToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _cloudSqlInstance;
    get cloudSqlInstance(): GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference;
    putCloudSqlInstance(value: GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance): void;
    resetCloudSqlInstance(): void;
    get cloudSqlInstanceInput(): GoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined;
    private _emptyDir;
    get emptyDir(): GoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference;
    putEmptyDir(value: GoogleCloudRunV2ServiceTemplateVolumesEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): GoogleCloudRunV2ServiceTemplateVolumesEmptyDir | undefined;
    private _gcs;
    get gcs(): GoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference;
    putGcs(value: GoogleCloudRunV2ServiceTemplateVolumesGcs): void;
    resetGcs(): void;
    get gcsInput(): GoogleCloudRunV2ServiceTemplateVolumesGcs | undefined;
    private _nfs;
    get nfs(): GoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference;
    putNfs(value: GoogleCloudRunV2ServiceTemplateVolumesNfs): void;
    resetNfs(): void;
    get nfsInput(): GoogleCloudRunV2ServiceTemplateVolumesNfs | undefined;
    private _secret;
    get secret(): GoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference;
    putSecret(value: GoogleCloudRunV2ServiceTemplateVolumesSecret): void;
    resetSecret(): void;
    get secretInput(): GoogleCloudRunV2ServiceTemplateVolumesSecret | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateVolumesOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces {
    /**
    * The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
    * network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
    * looked up from the subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#network GoogleCloudRunV2Service#network}
    */
    readonly network?: string;
    /**
    * The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
    * network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
    * subnetwork with the same name with the network will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#subnetwork GoogleCloudRunV2Service#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * Network tags applied to this Cloud Run service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#tags GoogleCloudRunV2Service#tags}
    */
    readonly tags?: string[];
}
export declare function googleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
}
export declare class GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesOutputReference;
}
export interface GoogleCloudRunV2ServiceTemplateVpcAccess {
    /**
    * VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#connector GoogleCloudRunV2Service#connector}
    */
    readonly connector?: string;
    /**
    * Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#egress GoogleCloudRunV2Service#egress}
    */
    readonly egress?: string;
    /**
    * network_interfaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#network_interfaces GoogleCloudRunV2Service#network_interfaces}
    */
    readonly networkInterfaces?: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable;
}
export declare function googleCloudRunV2ServiceTemplateVpcAccessToTerraform(struct?: GoogleCloudRunV2ServiceTemplateVpcAccessOutputReference | GoogleCloudRunV2ServiceTemplateVpcAccess): any;
export declare function googleCloudRunV2ServiceTemplateVpcAccessToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateVpcAccessOutputReference | GoogleCloudRunV2ServiceTemplateVpcAccess): any;
export declare class GoogleCloudRunV2ServiceTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplateVpcAccess | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplateVpcAccess | undefined);
    private _connector?;
    get connector(): string;
    set connector(value: string);
    resetConnector(): void;
    get connectorInput(): string | undefined;
    private _egress?;
    get egress(): string;
    set egress(value: string);
    resetEgress(): void;
    get egressInput(): string | undefined;
    private _networkInterfaces;
    get networkInterfaces(): GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesList;
    putNetworkInterfaces(value: GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces[] | cdktf.IResolvable): void;
    resetNetworkInterfaces(): void;
    get networkInterfacesInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces[] | undefined;
}
export interface GoogleCloudRunV2ServiceTemplate {
    /**
    * Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
    *
    * Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
    *
    * This field follows Kubernetes annotations' namespacing, limits, and rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#annotations GoogleCloudRunV2Service#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#encryption_key GoogleCloudRunV2Service#encryption_key}
    */
    readonly encryptionKey?: string;
    /**
    * The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#execution_environment GoogleCloudRunV2Service#execution_environment}
    */
    readonly executionEnvironment?: string;
    /**
    * Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
    * For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
    *
    * Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
    * All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#labels GoogleCloudRunV2Service#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Sets the maximum number of requests that each serving instance can receive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#max_instance_request_concurrency GoogleCloudRunV2Service#max_instance_request_concurrency}
    */
    readonly maxInstanceRequestConcurrency?: number;
    /**
    * The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#revision GoogleCloudRunV2Service#revision}
    */
    readonly revision?: string;
    /**
    * Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#service_account GoogleCloudRunV2Service#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#session_affinity GoogleCloudRunV2Service#session_affinity}
    */
    readonly sessionAffinity?: boolean | cdktf.IResolvable;
    /**
    * Max allowed time for an instance to respond to a request.
    *
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#timeout GoogleCloudRunV2Service#timeout}
    */
    readonly timeout?: string;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#containers GoogleCloudRunV2Service#containers}
    */
    readonly containers?: GoogleCloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable;
    /**
    * scaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#scaling GoogleCloudRunV2Service#scaling}
    */
    readonly scaling?: GoogleCloudRunV2ServiceTemplateScaling;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#volumes GoogleCloudRunV2Service#volumes}
    */
    readonly volumes?: GoogleCloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable;
    /**
    * vpc_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#vpc_access GoogleCloudRunV2Service#vpc_access}
    */
    readonly vpcAccess?: GoogleCloudRunV2ServiceTemplateVpcAccess;
}
export declare function googleCloudRunV2ServiceTemplateToTerraform(struct?: GoogleCloudRunV2ServiceTemplateOutputReference | GoogleCloudRunV2ServiceTemplate): any;
export declare function googleCloudRunV2ServiceTemplateToHclTerraform(struct?: GoogleCloudRunV2ServiceTemplateOutputReference | GoogleCloudRunV2ServiceTemplate): any;
export declare class GoogleCloudRunV2ServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTemplate | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTemplate | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    resetEncryptionKey(): void;
    get encryptionKeyInput(): string | undefined;
    private _executionEnvironment?;
    get executionEnvironment(): string;
    set executionEnvironment(value: string);
    resetExecutionEnvironment(): void;
    get executionEnvironmentInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxInstanceRequestConcurrency?;
    get maxInstanceRequestConcurrency(): number;
    set maxInstanceRequestConcurrency(value: number);
    resetMaxInstanceRequestConcurrency(): void;
    get maxInstanceRequestConcurrencyInput(): number | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sessionAffinity?;
    get sessionAffinity(): boolean | cdktf.IResolvable;
    set sessionAffinity(value: boolean | cdktf.IResolvable);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _containers;
    get containers(): GoogleCloudRunV2ServiceTemplateContainersList;
    putContainers(value: GoogleCloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateContainers[] | undefined;
    private _scaling;
    get scaling(): GoogleCloudRunV2ServiceTemplateScalingOutputReference;
    putScaling(value: GoogleCloudRunV2ServiceTemplateScaling): void;
    resetScaling(): void;
    get scalingInput(): GoogleCloudRunV2ServiceTemplateScaling | undefined;
    private _volumes;
    get volumes(): GoogleCloudRunV2ServiceTemplateVolumesList;
    putVolumes(value: GoogleCloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTemplateVolumes[] | undefined;
    private _vpcAccess;
    get vpcAccess(): GoogleCloudRunV2ServiceTemplateVpcAccessOutputReference;
    putVpcAccess(value: GoogleCloudRunV2ServiceTemplateVpcAccess): void;
    resetVpcAccess(): void;
    get vpcAccessInput(): GoogleCloudRunV2ServiceTemplateVpcAccess | undefined;
}
export interface GoogleCloudRunV2ServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#create GoogleCloudRunV2Service#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#delete GoogleCloudRunV2Service#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#update GoogleCloudRunV2Service#update}
    */
    readonly update?: string;
}
export declare function googleCloudRunV2ServiceTimeoutsToTerraform(struct?: GoogleCloudRunV2ServiceTimeouts | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTimeoutsToHclTerraform(struct?: GoogleCloudRunV2ServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunV2ServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleCloudRunV2ServiceTraffic {
    /**
    * Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#percent GoogleCloudRunV2Service#percent}
    */
    readonly percent?: number;
    /**
    * Revision to which to send this portion of traffic, if traffic allocation is by revision.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#revision GoogleCloudRunV2Service#revision}
    */
    readonly revision?: string;
    /**
    * Indicates a string to be part of the URI to exclusively reference this target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#tag GoogleCloudRunV2Service#tag}
    */
    readonly tag?: string;
    /**
    * The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#type GoogleCloudRunV2Service#type}
    */
    readonly type?: string;
}
export declare function googleCloudRunV2ServiceTrafficToTerraform(struct?: GoogleCloudRunV2ServiceTraffic | cdktf.IResolvable): any;
export declare function googleCloudRunV2ServiceTrafficToHclTerraform(struct?: GoogleCloudRunV2ServiceTraffic | cdktf.IResolvable): any;
export declare class GoogleCloudRunV2ServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunV2ServiceTraffic | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunV2ServiceTraffic | cdktf.IResolvable | undefined);
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleCloudRunV2ServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudRunV2ServiceTraffic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunV2ServiceTrafficOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service google_cloud_run_v2_service}
*/
export declare class GoogleCloudRunV2Service extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_service";
    /**
    * Generates CDKTF code for importing a GoogleCloudRunV2Service resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudRunV2Service to import
    * @param importFromId The id of the existing GoogleCloudRunV2Service that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudRunV2Service to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloud_run_v2_service google_cloud_run_v2_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudRunV2ServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudRunV2ServiceConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    private _clientVersion?;
    get clientVersion(): string;
    set clientVersion(value: string);
    resetClientVersion(): void;
    get clientVersionInput(): string | undefined;
    private _conditions;
    get conditions(): GoogleCloudRunV2ServiceConditionsList;
    get createTime(): string;
    get creator(): string;
    private _customAudiences?;
    get customAudiences(): string[];
    set customAudiences(value: string[]);
    resetCustomAudiences(): void;
    get customAudiencesInput(): string[] | undefined;
    get deleteTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    get expireTime(): string;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingress?;
    get ingress(): string;
    set ingress(value: string);
    resetIngress(): void;
    get ingressInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastModifier(): string;
    get latestCreatedRevision(): string;
    get latestReadyRevision(): string;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _terminalCondition;
    get terminalCondition(): GoogleCloudRunV2ServiceTerminalConditionList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _trafficStatuses;
    get trafficStatuses(): GoogleCloudRunV2ServiceTrafficStatusesList;
    get uid(): string;
    get updateTime(): string;
    get uri(): string;
    private _binaryAuthorization;
    get binaryAuthorization(): GoogleCloudRunV2ServiceBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: GoogleCloudRunV2ServiceBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): GoogleCloudRunV2ServiceBinaryAuthorization | undefined;
    private _scaling;
    get scaling(): GoogleCloudRunV2ServiceScalingOutputReference;
    putScaling(value: GoogleCloudRunV2ServiceScaling): void;
    resetScaling(): void;
    get scalingInput(): GoogleCloudRunV2ServiceScaling | undefined;
    private _template;
    get template(): GoogleCloudRunV2ServiceTemplateOutputReference;
    putTemplate(value: GoogleCloudRunV2ServiceTemplate): void;
    get templateInput(): GoogleCloudRunV2ServiceTemplate | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudRunV2ServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudRunV2ServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTimeouts | undefined;
    private _traffic;
    get traffic(): GoogleCloudRunV2ServiceTrafficList;
    putTraffic(value: GoogleCloudRunV2ServiceTraffic[] | cdktf.IResolvable): void;
    resetTraffic(): void;
    get trafficInput(): cdktf.IResolvable | GoogleCloudRunV2ServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
