/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudbuildv2RepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allows clients to store small amounts of arbitrary data.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#annotations GoogleCloudbuildv2Repository#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#id GoogleCloudbuildv2Repository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#location GoogleCloudbuildv2Repository#location}
    */
    readonly location?: string;
    /**
    * Name of the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#name GoogleCloudbuildv2Repository#name}
    */
    readonly name: string;
    /**
    * The connection for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#parent_connection GoogleCloudbuildv2Repository#parent_connection}
    */
    readonly parentConnection: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#project GoogleCloudbuildv2Repository#project}
    */
    readonly project?: string;
    /**
    * Required. Git Clone HTTPS URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#remote_uri GoogleCloudbuildv2Repository#remote_uri}
    */
    readonly remoteUri: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#timeouts GoogleCloudbuildv2Repository#timeouts}
    */
    readonly timeouts?: GoogleCloudbuildv2RepositoryTimeouts;
}
export interface GoogleCloudbuildv2RepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#create GoogleCloudbuildv2Repository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#delete GoogleCloudbuildv2Repository#delete}
    */
    readonly delete?: string;
}
export declare function googleCloudbuildv2RepositoryTimeoutsToTerraform(struct?: GoogleCloudbuildv2RepositoryTimeouts | cdktf.IResolvable): any;
export declare function googleCloudbuildv2RepositoryTimeoutsToHclTerraform(struct?: GoogleCloudbuildv2RepositoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudbuildv2RepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2RepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildv2RepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository google_cloudbuildv2_repository}
*/
export declare class GoogleCloudbuildv2Repository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuildv2_repository";
    /**
    * Generates CDKTF code for importing a GoogleCloudbuildv2Repository resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudbuildv2Repository to import
    * @param importFromId The id of the existing GoogleCloudbuildv2Repository that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudbuildv2Repository to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudbuildv2_repository google_cloudbuildv2_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudbuildv2RepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudbuildv2RepositoryConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentConnection?;
    get parentConnection(): string;
    set parentConnection(value: string);
    get parentConnectionInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _remoteUri?;
    get remoteUri(): string;
    set remoteUri(value: string);
    get remoteUriInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleCloudbuildv2RepositoryTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudbuildv2RepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudbuildv2RepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
