/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleClouddeployAutomationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash ('/'). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character ('[a-z0-9A-Z]') with dashes ('-'), underscores ('_'), dots ('.'), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots('.'), not longer than 253 characters in total, followed by a slash ('/'). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#annotations GoogleClouddeployAutomation#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The delivery_pipeline for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#delivery_pipeline GoogleClouddeployAutomation#delivery_pipeline}
    */
    readonly deliveryPipeline: string;
    /**
    * Optional. Description of the 'Automation'. Max length is 255 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#description GoogleClouddeployAutomation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#id GoogleClouddeployAutomation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#labels GoogleClouddeployAutomation#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#location GoogleClouddeployAutomation#location}
    */
    readonly location: string;
    /**
    * Name of the 'Automation'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#name GoogleClouddeployAutomation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#project GoogleClouddeployAutomation#project}
    */
    readonly project?: string;
    /**
    * Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#service_account GoogleClouddeployAutomation#service_account}
    */
    readonly serviceAccount: string;
    /**
    * Optional. When Suspended, automation is deactivated from execution.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#suspended GoogleClouddeployAutomation#suspended}
    */
    readonly suspended?: boolean | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#rules GoogleClouddeployAutomation#rules}
    */
    readonly rules: GoogleClouddeployAutomationRules[] | cdktf.IResolvable;
    /**
    * selector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#selector GoogleClouddeployAutomation#selector}
    */
    readonly selector: GoogleClouddeployAutomationSelector;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#timeouts GoogleClouddeployAutomation#timeouts}
    */
    readonly timeouts?: GoogleClouddeployAutomationTimeouts;
}
export interface GoogleClouddeployAutomationRulesAdvanceRolloutRule {
    /**
    * Required. ID of the rule. This id must be unique in the 'Automation' resource to which this rule belongs. The format is 'a-z{0,62}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#id GoogleClouddeployAutomation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Optional. Proceeds only after phase name matched any one in the list. This value must consist of lower-case letters, numbers, and hyphens, start with a letter and end with a letter or a number, and have a max length of 63 characters. In other words, it must match the following regex: '^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#source_phases GoogleClouddeployAutomation#source_phases}
    */
    readonly sourcePhases?: string[];
    /**
    * Optional. How long to wait after a rollout is finished.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#wait GoogleClouddeployAutomation#wait}
    */
    readonly wait?: string;
}
export declare function googleClouddeployAutomationRulesAdvanceRolloutRuleToTerraform(struct?: GoogleClouddeployAutomationRulesAdvanceRolloutRuleOutputReference | GoogleClouddeployAutomationRulesAdvanceRolloutRule): any;
export declare function googleClouddeployAutomationRulesAdvanceRolloutRuleToHclTerraform(struct?: GoogleClouddeployAutomationRulesAdvanceRolloutRuleOutputReference | GoogleClouddeployAutomationRulesAdvanceRolloutRule): any;
export declare class GoogleClouddeployAutomationRulesAdvanceRolloutRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployAutomationRulesAdvanceRolloutRule | undefined;
    set internalValue(value: GoogleClouddeployAutomationRulesAdvanceRolloutRule | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _sourcePhases?;
    get sourcePhases(): string[];
    set sourcePhases(value: string[]);
    resetSourcePhases(): void;
    get sourcePhasesInput(): string[] | undefined;
    private _wait?;
    get wait(): string;
    set wait(value: string);
    resetWait(): void;
    get waitInput(): string | undefined;
}
export interface GoogleClouddeployAutomationRulesPromoteReleaseRule {
    /**
    * Optional. The starting phase of the rollout created by this operation. Default to the first phase.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#destination_phase GoogleClouddeployAutomation#destination_phase}
    */
    readonly destinationPhase?: string;
    /**
    * Optional. The ID of the stage in the pipeline to which this 'Release' is deploying. If unspecified, default it to the next stage in the promotion flow. The value of this field could be one of the following: * The last segment of a target name. It only needs the ID to determine if the target is one of the stages in the promotion sequence defined in the pipeline. * "@next", the next target in the promotion sequence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#destination_target_id GoogleClouddeployAutomation#destination_target_id}
    */
    readonly destinationTargetId?: string;
    /**
    * Required. ID of the rule. This id must be unique in the 'Automation' resource to which this rule belongs. The format is 'a-z{0,62}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#id GoogleClouddeployAutomation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Optional. How long the release need to be paused until being promoted to the next target.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#wait GoogleClouddeployAutomation#wait}
    */
    readonly wait?: string;
}
export declare function googleClouddeployAutomationRulesPromoteReleaseRuleToTerraform(struct?: GoogleClouddeployAutomationRulesPromoteReleaseRuleOutputReference | GoogleClouddeployAutomationRulesPromoteReleaseRule): any;
export declare function googleClouddeployAutomationRulesPromoteReleaseRuleToHclTerraform(struct?: GoogleClouddeployAutomationRulesPromoteReleaseRuleOutputReference | GoogleClouddeployAutomationRulesPromoteReleaseRule): any;
export declare class GoogleClouddeployAutomationRulesPromoteReleaseRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployAutomationRulesPromoteReleaseRule | undefined;
    set internalValue(value: GoogleClouddeployAutomationRulesPromoteReleaseRule | undefined);
    private _destinationPhase?;
    get destinationPhase(): string;
    set destinationPhase(value: string);
    resetDestinationPhase(): void;
    get destinationPhaseInput(): string | undefined;
    private _destinationTargetId?;
    get destinationTargetId(): string;
    set destinationTargetId(value: string);
    resetDestinationTargetId(): void;
    get destinationTargetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _wait?;
    get wait(): string;
    set wait(value: string);
    resetWait(): void;
    get waitInput(): string | undefined;
}
export interface GoogleClouddeployAutomationRules {
    /**
    * advance_rollout_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#advance_rollout_rule GoogleClouddeployAutomation#advance_rollout_rule}
    */
    readonly advanceRolloutRule?: GoogleClouddeployAutomationRulesAdvanceRolloutRule;
    /**
    * promote_release_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#promote_release_rule GoogleClouddeployAutomation#promote_release_rule}
    */
    readonly promoteReleaseRule?: GoogleClouddeployAutomationRulesPromoteReleaseRule;
}
export declare function googleClouddeployAutomationRulesToTerraform(struct?: GoogleClouddeployAutomationRules | cdktf.IResolvable): any;
export declare function googleClouddeployAutomationRulesToHclTerraform(struct?: GoogleClouddeployAutomationRules | cdktf.IResolvable): any;
export declare class GoogleClouddeployAutomationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleClouddeployAutomationRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddeployAutomationRules | cdktf.IResolvable | undefined);
    private _advanceRolloutRule;
    get advanceRolloutRule(): GoogleClouddeployAutomationRulesAdvanceRolloutRuleOutputReference;
    putAdvanceRolloutRule(value: GoogleClouddeployAutomationRulesAdvanceRolloutRule): void;
    resetAdvanceRolloutRule(): void;
    get advanceRolloutRuleInput(): GoogleClouddeployAutomationRulesAdvanceRolloutRule | undefined;
    private _promoteReleaseRule;
    get promoteReleaseRule(): GoogleClouddeployAutomationRulesPromoteReleaseRuleOutputReference;
    putPromoteReleaseRule(value: GoogleClouddeployAutomationRulesPromoteReleaseRule): void;
    resetPromoteReleaseRule(): void;
    get promoteReleaseRuleInput(): GoogleClouddeployAutomationRulesPromoteReleaseRule | undefined;
}
export declare class GoogleClouddeployAutomationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleClouddeployAutomationRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleClouddeployAutomationRulesOutputReference;
}
export interface GoogleClouddeployAutomationSelectorTargets {
    /**
    * ID of the 'Target'. The value of this field could be one of the following: * The last segment of a target name. It only needs the ID to determine which target is being referred to * "*", all targets in a location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#id GoogleClouddeployAutomation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#labels GoogleClouddeployAutomation#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function googleClouddeployAutomationSelectorTargetsToTerraform(struct?: GoogleClouddeployAutomationSelectorTargets | cdktf.IResolvable): any;
export declare function googleClouddeployAutomationSelectorTargetsToHclTerraform(struct?: GoogleClouddeployAutomationSelectorTargets | cdktf.IResolvable): any;
export declare class GoogleClouddeployAutomationSelectorTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleClouddeployAutomationSelectorTargets | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddeployAutomationSelectorTargets | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleClouddeployAutomationSelectorTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleClouddeployAutomationSelectorTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleClouddeployAutomationSelectorTargetsOutputReference;
}
export interface GoogleClouddeployAutomationSelector {
    /**
    * targets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#targets GoogleClouddeployAutomation#targets}
    */
    readonly targets: GoogleClouddeployAutomationSelectorTargets[] | cdktf.IResolvable;
}
export declare function googleClouddeployAutomationSelectorToTerraform(struct?: GoogleClouddeployAutomationSelectorOutputReference | GoogleClouddeployAutomationSelector): any;
export declare function googleClouddeployAutomationSelectorToHclTerraform(struct?: GoogleClouddeployAutomationSelectorOutputReference | GoogleClouddeployAutomationSelector): any;
export declare class GoogleClouddeployAutomationSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployAutomationSelector | undefined;
    set internalValue(value: GoogleClouddeployAutomationSelector | undefined);
    private _targets;
    get targets(): GoogleClouddeployAutomationSelectorTargetsList;
    putTargets(value: GoogleClouddeployAutomationSelectorTargets[] | cdktf.IResolvable): void;
    get targetsInput(): cdktf.IResolvable | GoogleClouddeployAutomationSelectorTargets[] | undefined;
}
export interface GoogleClouddeployAutomationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#create GoogleClouddeployAutomation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#delete GoogleClouddeployAutomation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#update GoogleClouddeployAutomation#update}
    */
    readonly update?: string;
}
export declare function googleClouddeployAutomationTimeoutsToTerraform(struct?: GoogleClouddeployAutomationTimeouts | cdktf.IResolvable): any;
export declare function googleClouddeployAutomationTimeoutsToHclTerraform(struct?: GoogleClouddeployAutomationTimeouts | cdktf.IResolvable): any;
export declare class GoogleClouddeployAutomationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployAutomationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddeployAutomationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation google_clouddeploy_automation}
*/
export declare class GoogleClouddeployAutomation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_clouddeploy_automation";
    /**
    * Generates CDKTF code for importing a GoogleClouddeployAutomation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleClouddeployAutomation to import
    * @param importFromId The id of the existing GoogleClouddeployAutomation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleClouddeployAutomation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_automation google_clouddeploy_automation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleClouddeployAutomationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleClouddeployAutomationConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _deliveryPipeline?;
    get deliveryPipeline(): string;
    set deliveryPipeline(value: string);
    get deliveryPipelineInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    get serviceAccountInput(): string | undefined;
    private _suspended?;
    get suspended(): boolean | cdktf.IResolvable;
    set suspended(value: boolean | cdktf.IResolvable);
    resetSuspended(): void;
    get suspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _rules;
    get rules(): GoogleClouddeployAutomationRulesList;
    putRules(value: GoogleClouddeployAutomationRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleClouddeployAutomationRules[] | undefined;
    private _selector;
    get selector(): GoogleClouddeployAutomationSelectorOutputReference;
    putSelector(value: GoogleClouddeployAutomationSelector): void;
    get selectorInput(): GoogleClouddeployAutomationSelector | undefined;
    private _timeouts;
    get timeouts(): GoogleClouddeployAutomationTimeoutsOutputReference;
    putTimeouts(value: GoogleClouddeployAutomationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleClouddeployAutomationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
