/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleClouddeployCustomTargetTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#annotations GoogleClouddeployCustomTargetType#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Description of the 'CustomTargetType'. Max length is 255 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#description GoogleClouddeployCustomTargetType#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#id GoogleClouddeployCustomTargetType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#labels GoogleClouddeployCustomTargetType#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#location GoogleClouddeployCustomTargetType#location}
    */
    readonly location: string;
    /**
    * Name of the 'CustomTargetType'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#name GoogleClouddeployCustomTargetType#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#project GoogleClouddeployCustomTargetType#project}
    */
    readonly project?: string;
    /**
    * custom_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#custom_actions GoogleClouddeployCustomTargetType#custom_actions}
    */
    readonly customActions?: GoogleClouddeployCustomTargetTypeCustomActions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#timeouts GoogleClouddeployCustomTargetType#timeouts}
    */
    readonly timeouts?: GoogleClouddeployCustomTargetTypeTimeouts;
}
export interface GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit {
    /**
    * Relative path from the repository root to the Skaffold file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#path GoogleClouddeployCustomTargetType#path}
    */
    readonly path?: string;
    /**
    * Git ref the package should be cloned from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#ref GoogleClouddeployCustomTargetType#ref}
    */
    readonly ref?: string;
    /**
    * Git repository the package should be cloned from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#repo GoogleClouddeployCustomTargetType#repo}
    */
    readonly repo: string;
}
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitToTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitOutputReference | GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit): any;
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitToHclTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitOutputReference | GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit): any;
export declare class GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit | undefined;
    set internalValue(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _ref?;
    get ref(): string;
    set ref(value: string);
    resetRef(): void;
    get refInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    get repoInput(): string | undefined;
}
export interface GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage {
    /**
    * Relative path from the source to the Skaffold file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#path GoogleClouddeployCustomTargetType#path}
    */
    readonly path?: string;
    /**
    * Cloud Storage source paths to copy recursively. For example, providing 'gs://my-bucket/dir/configs/*' will result in Skaffold copying all files within the 'dir/configs' directory in the bucket 'my-bucket'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#source GoogleClouddeployCustomTargetType#source}
    */
    readonly source: string;
}
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageToTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageOutputReference | GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage): any;
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageToHclTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageOutputReference | GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage): any;
export declare class GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage | undefined;
    set internalValue(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export interface GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules {
    /**
    * The Skaffold Config modules to use from the specified source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#configs GoogleClouddeployCustomTargetType#configs}
    */
    readonly configs?: string[];
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#git GoogleClouddeployCustomTargetType#git}
    */
    readonly git?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit;
    /**
    * google_cloud_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#google_cloud_storage GoogleClouddeployCustomTargetType#google_cloud_storage}
    */
    readonly googleCloudStorage?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage;
}
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesToTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules | cdktf.IResolvable): any;
export declare function googleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesToHclTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules | cdktf.IResolvable): any;
export declare class GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules | cdktf.IResolvable | undefined);
    private _configs?;
    get configs(): string[];
    set configs(value: string[]);
    resetConfigs(): void;
    get configsInput(): string[] | undefined;
    private _git;
    get git(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGitOutputReference;
    putGit(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit): void;
    resetGit(): void;
    get gitInput(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGit | undefined;
    private _googleCloudStorage;
    get googleCloudStorage(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorageOutputReference;
    putGoogleCloudStorage(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage): void;
    resetGoogleCloudStorage(): void;
    get googleCloudStorageInput(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesGoogleCloudStorage | undefined;
}
export declare class GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesOutputReference;
}
export interface GoogleClouddeployCustomTargetTypeCustomActions {
    /**
    * The Skaffold custom action responsible for deploy operations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#deploy_action GoogleClouddeployCustomTargetType#deploy_action}
    */
    readonly deployAction: string;
    /**
    * The Skaffold custom action responsible for render operations. If not provided then Cloud Deploy will perform the render operations via 'skaffold render'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#render_action GoogleClouddeployCustomTargetType#render_action}
    */
    readonly renderAction?: string;
    /**
    * include_skaffold_modules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#include_skaffold_modules GoogleClouddeployCustomTargetType#include_skaffold_modules}
    */
    readonly includeSkaffoldModules?: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules[] | cdktf.IResolvable;
}
export declare function googleClouddeployCustomTargetTypeCustomActionsToTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsOutputReference | GoogleClouddeployCustomTargetTypeCustomActions): any;
export declare function googleClouddeployCustomTargetTypeCustomActionsToHclTerraform(struct?: GoogleClouddeployCustomTargetTypeCustomActionsOutputReference | GoogleClouddeployCustomTargetTypeCustomActions): any;
export declare class GoogleClouddeployCustomTargetTypeCustomActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployCustomTargetTypeCustomActions | undefined;
    set internalValue(value: GoogleClouddeployCustomTargetTypeCustomActions | undefined);
    private _deployAction?;
    get deployAction(): string;
    set deployAction(value: string);
    get deployActionInput(): string | undefined;
    private _renderAction?;
    get renderAction(): string;
    set renderAction(value: string);
    resetRenderAction(): void;
    get renderActionInput(): string | undefined;
    private _includeSkaffoldModules;
    get includeSkaffoldModules(): GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModulesList;
    putIncludeSkaffoldModules(value: GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules[] | cdktf.IResolvable): void;
    resetIncludeSkaffoldModules(): void;
    get includeSkaffoldModulesInput(): cdktf.IResolvable | GoogleClouddeployCustomTargetTypeCustomActionsIncludeSkaffoldModules[] | undefined;
}
export interface GoogleClouddeployCustomTargetTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#create GoogleClouddeployCustomTargetType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#delete GoogleClouddeployCustomTargetType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#update GoogleClouddeployCustomTargetType#update}
    */
    readonly update?: string;
}
export declare function googleClouddeployCustomTargetTypeTimeoutsToTerraform(struct?: GoogleClouddeployCustomTargetTypeTimeouts | cdktf.IResolvable): any;
export declare function googleClouddeployCustomTargetTypeTimeoutsToHclTerraform(struct?: GoogleClouddeployCustomTargetTypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleClouddeployCustomTargetTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddeployCustomTargetTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddeployCustomTargetTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type google_clouddeploy_custom_target_type}
*/
export declare class GoogleClouddeployCustomTargetType extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_clouddeploy_custom_target_type";
    /**
    * Generates CDKTF code for importing a GoogleClouddeployCustomTargetType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleClouddeployCustomTargetType to import
    * @param importFromId The id of the existing GoogleClouddeployCustomTargetType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleClouddeployCustomTargetType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddeploy_custom_target_type google_clouddeploy_custom_target_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleClouddeployCustomTargetTypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleClouddeployCustomTargetTypeConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    get customTargetTypeId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _customActions;
    get customActions(): GoogleClouddeployCustomTargetTypeCustomActionsOutputReference;
    putCustomActions(value: GoogleClouddeployCustomTargetTypeCustomActions): void;
    resetCustomActions(): void;
    get customActionsInput(): GoogleClouddeployCustomTargetTypeCustomActions | undefined;
    private _timeouts;
    get timeouts(): GoogleClouddeployCustomTargetTypeTimeoutsOutputReference;
    putTimeouts(value: GoogleClouddeployCustomTargetTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleClouddeployCustomTargetTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
