/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleClouddomainsRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#contact_notices GoogleClouddomainsRegistration#contact_notices}
    */
    readonly contactNotices?: string[];
    /**
    * Required. The domain name. Unicode domain names must be expressed in Punycode format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#domain_name GoogleClouddomainsRegistration#domain_name}
    */
    readonly domainName: string;
    /**
    * The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#domain_notices GoogleClouddomainsRegistration#domain_notices}
    */
    readonly domainNotices?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#id GoogleClouddomainsRegistration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of labels associated with the Registration.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#labels GoogleClouddomainsRegistration#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#location GoogleClouddomainsRegistration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#project GoogleClouddomainsRegistration#project}
    */
    readonly project?: string;
    /**
    * contact_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#contact_settings GoogleClouddomainsRegistration#contact_settings}
    */
    readonly contactSettings: GoogleClouddomainsRegistrationContactSettings;
    /**
    * dns_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#dns_settings GoogleClouddomainsRegistration#dns_settings}
    */
    readonly dnsSettings?: GoogleClouddomainsRegistrationDnsSettings;
    /**
    * management_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#management_settings GoogleClouddomainsRegistration#management_settings}
    */
    readonly managementSettings?: GoogleClouddomainsRegistrationManagementSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#timeouts GoogleClouddomainsRegistration#timeouts}
    */
    readonly timeouts?: GoogleClouddomainsRegistrationTimeouts;
    /**
    * yearly_price block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#yearly_price GoogleClouddomainsRegistration#yearly_price}
    */
    readonly yearlyPrice: GoogleClouddomainsRegistrationYearlyPrice;
}
export interface GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress {
    /**
    * Unstructured address lines describing the lower levels of an address.
    * Because values in addressLines do not have type information and may sometimes contain multiple values in a single
    * field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
    * "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
    * is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
    * the most specific line of an address can be selected based on the language.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#address_lines GoogleClouddomainsRegistration#address_lines}
    */
    readonly addressLines?: string[];
    /**
    * Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
    * a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
    * (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
    * this should be left unpopulated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#administrative_area GoogleClouddomainsRegistration#administrative_area}
    */
    readonly administrativeArea?: string;
    /**
    * Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
    * where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#locality GoogleClouddomainsRegistration#locality}
    */
    readonly locality?: string;
    /**
    * The name of the organization at the address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#organization GoogleClouddomainsRegistration#organization}
    */
    readonly organization?: string;
    /**
    * Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
    * they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_code GoogleClouddomainsRegistration#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
    * it might contain "care of" information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#recipients GoogleClouddomainsRegistration#recipients}
    */
    readonly recipients?: string[];
    /**
    * Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
    * ensure the value is correct. See https://cldr.unicode.org/ and
    * https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#region_code GoogleClouddomainsRegistration#region_code}
    */
    readonly regionCode: string;
}
export declare function googleClouddomainsRegistrationContactSettingsAdminContactPostalAddressToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress): any;
export declare function googleClouddomainsRegistrationContactSettingsAdminContactPostalAddressToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress): any;
export declare class GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress | undefined);
    private _addressLines?;
    get addressLines(): string[];
    set addressLines(value: string[]);
    resetAddressLines(): void;
    get addressLinesInput(): string[] | undefined;
    private _administrativeArea?;
    get administrativeArea(): string;
    set administrativeArea(value: string);
    resetAdministrativeArea(): void;
    get administrativeAreaInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _recipients?;
    get recipients(): string[];
    set recipients(value: string[]);
    resetRecipients(): void;
    get recipientsInput(): string[] | undefined;
    private _regionCode?;
    get regionCode(): string;
    set regionCode(value: string);
    get regionCodeInput(): string | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettingsAdminContact {
    /**
    * Required. Email address of the contact.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#email GoogleClouddomainsRegistration#email}
    */
    readonly email: string;
    /**
    * Fax number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#fax_number GoogleClouddomainsRegistration#fax_number}
    */
    readonly faxNumber?: string;
    /**
    * Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#phone_number GoogleClouddomainsRegistration#phone_number}
    */
    readonly phoneNumber: string;
    /**
    * postal_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_address GoogleClouddomainsRegistration#postal_address}
    */
    readonly postalAddress: GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress;
}
export declare function googleClouddomainsRegistrationContactSettingsAdminContactToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsAdminContactOutputReference | GoogleClouddomainsRegistrationContactSettingsAdminContact): any;
export declare function googleClouddomainsRegistrationContactSettingsAdminContactToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsAdminContactOutputReference | GoogleClouddomainsRegistrationContactSettingsAdminContact): any;
export declare class GoogleClouddomainsRegistrationContactSettingsAdminContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsAdminContact | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsAdminContact | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _faxNumber?;
    get faxNumber(): string;
    set faxNumber(value: string);
    resetFaxNumber(): void;
    get faxNumberInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
    private _postalAddress;
    get postalAddress(): GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddressOutputReference;
    putPostalAddress(value: GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress): void;
    get postalAddressInput(): GoogleClouddomainsRegistrationContactSettingsAdminContactPostalAddress | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress {
    /**
    * Unstructured address lines describing the lower levels of an address.
    * Because values in addressLines do not have type information and may sometimes contain multiple values in a single
    * field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
    * "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
    * is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
    * the most specific line of an address can be selected based on the language.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#address_lines GoogleClouddomainsRegistration#address_lines}
    */
    readonly addressLines?: string[];
    /**
    * Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
    * a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
    * (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
    * this should be left unpopulated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#administrative_area GoogleClouddomainsRegistration#administrative_area}
    */
    readonly administrativeArea?: string;
    /**
    * Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
    * where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#locality GoogleClouddomainsRegistration#locality}
    */
    readonly locality?: string;
    /**
    * The name of the organization at the address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#organization GoogleClouddomainsRegistration#organization}
    */
    readonly organization?: string;
    /**
    * Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
    * they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_code GoogleClouddomainsRegistration#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
    * it might contain "care of" information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#recipients GoogleClouddomainsRegistration#recipients}
    */
    readonly recipients?: string[];
    /**
    * Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
    * ensure the value is correct. See https://cldr.unicode.org/ and
    * https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#region_code GoogleClouddomainsRegistration#region_code}
    */
    readonly regionCode: string;
}
export declare function googleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress): any;
export declare function googleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress): any;
export declare class GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress | undefined);
    private _addressLines?;
    get addressLines(): string[];
    set addressLines(value: string[]);
    resetAddressLines(): void;
    get addressLinesInput(): string[] | undefined;
    private _administrativeArea?;
    get administrativeArea(): string;
    set administrativeArea(value: string);
    resetAdministrativeArea(): void;
    get administrativeAreaInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _recipients?;
    get recipients(): string[];
    set recipients(value: string[]);
    resetRecipients(): void;
    get recipientsInput(): string[] | undefined;
    private _regionCode?;
    get regionCode(): string;
    set regionCode(value: string);
    get regionCodeInput(): string | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettingsRegistrantContact {
    /**
    * Required. Email address of the contact.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#email GoogleClouddomainsRegistration#email}
    */
    readonly email: string;
    /**
    * Fax number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#fax_number GoogleClouddomainsRegistration#fax_number}
    */
    readonly faxNumber?: string;
    /**
    * Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#phone_number GoogleClouddomainsRegistration#phone_number}
    */
    readonly phoneNumber: string;
    /**
    * postal_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_address GoogleClouddomainsRegistration#postal_address}
    */
    readonly postalAddress: GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress;
}
export declare function googleClouddomainsRegistrationContactSettingsRegistrantContactToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsRegistrantContactOutputReference | GoogleClouddomainsRegistrationContactSettingsRegistrantContact): any;
export declare function googleClouddomainsRegistrationContactSettingsRegistrantContactToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsRegistrantContactOutputReference | GoogleClouddomainsRegistrationContactSettingsRegistrantContact): any;
export declare class GoogleClouddomainsRegistrationContactSettingsRegistrantContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsRegistrantContact | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsRegistrantContact | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _faxNumber?;
    get faxNumber(): string;
    set faxNumber(value: string);
    resetFaxNumber(): void;
    get faxNumberInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
    private _postalAddress;
    get postalAddress(): GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddressOutputReference;
    putPostalAddress(value: GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress): void;
    get postalAddressInput(): GoogleClouddomainsRegistrationContactSettingsRegistrantContactPostalAddress | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress {
    /**
    * Unstructured address lines describing the lower levels of an address.
    * Because values in addressLines do not have type information and may sometimes contain multiple values in a single
    * field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
    * "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
    * is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
    * the most specific line of an address can be selected based on the language.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#address_lines GoogleClouddomainsRegistration#address_lines}
    */
    readonly addressLines?: string[];
    /**
    * Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
    * a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
    * (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
    * this should be left unpopulated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#administrative_area GoogleClouddomainsRegistration#administrative_area}
    */
    readonly administrativeArea?: string;
    /**
    * Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
    * where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#locality GoogleClouddomainsRegistration#locality}
    */
    readonly locality?: string;
    /**
    * The name of the organization at the address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#organization GoogleClouddomainsRegistration#organization}
    */
    readonly organization?: string;
    /**
    * Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
    * they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_code GoogleClouddomainsRegistration#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
    * it might contain "care of" information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#recipients GoogleClouddomainsRegistration#recipients}
    */
    readonly recipients?: string[];
    /**
    * Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
    * ensure the value is correct. See https://cldr.unicode.org/ and
    * https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#region_code GoogleClouddomainsRegistration#region_code}
    */
    readonly regionCode: string;
}
export declare function googleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress): any;
export declare function googleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressOutputReference | GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress): any;
export declare class GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress | undefined);
    private _addressLines?;
    get addressLines(): string[];
    set addressLines(value: string[]);
    resetAddressLines(): void;
    get addressLinesInput(): string[] | undefined;
    private _administrativeArea?;
    get administrativeArea(): string;
    set administrativeArea(value: string);
    resetAdministrativeArea(): void;
    get administrativeAreaInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _recipients?;
    get recipients(): string[];
    set recipients(value: string[]);
    resetRecipients(): void;
    get recipientsInput(): string[] | undefined;
    private _regionCode?;
    get regionCode(): string;
    set regionCode(value: string);
    get regionCodeInput(): string | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettingsTechnicalContact {
    /**
    * Required. Email address of the contact.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#email GoogleClouddomainsRegistration#email}
    */
    readonly email: string;
    /**
    * Fax number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#fax_number GoogleClouddomainsRegistration#fax_number}
    */
    readonly faxNumber?: string;
    /**
    * Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#phone_number GoogleClouddomainsRegistration#phone_number}
    */
    readonly phoneNumber: string;
    /**
    * postal_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#postal_address GoogleClouddomainsRegistration#postal_address}
    */
    readonly postalAddress: GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress;
}
export declare function googleClouddomainsRegistrationContactSettingsTechnicalContactToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsTechnicalContactOutputReference | GoogleClouddomainsRegistrationContactSettingsTechnicalContact): any;
export declare function googleClouddomainsRegistrationContactSettingsTechnicalContactToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsTechnicalContactOutputReference | GoogleClouddomainsRegistrationContactSettingsTechnicalContact): any;
export declare class GoogleClouddomainsRegistrationContactSettingsTechnicalContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettingsTechnicalContact | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettingsTechnicalContact | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _faxNumber?;
    get faxNumber(): string;
    set faxNumber(value: string);
    resetFaxNumber(): void;
    get faxNumberInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
    private _postalAddress;
    get postalAddress(): GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddressOutputReference;
    putPostalAddress(value: GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress): void;
    get postalAddressInput(): GoogleClouddomainsRegistrationContactSettingsTechnicalContactPostalAddress | undefined;
}
export interface GoogleClouddomainsRegistrationContactSettings {
    /**
    * Required. Privacy setting for the contacts associated with the Registration.
    * Values are PUBLIC_CONTACT_DATA, PRIVATE_CONTACT_DATA, and REDACTED_CONTACT_DATA
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#privacy GoogleClouddomainsRegistration#privacy}
    */
    readonly privacy: string;
    /**
    * admin_contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#admin_contact GoogleClouddomainsRegistration#admin_contact}
    */
    readonly adminContact: GoogleClouddomainsRegistrationContactSettingsAdminContact;
    /**
    * registrant_contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#registrant_contact GoogleClouddomainsRegistration#registrant_contact}
    */
    readonly registrantContact: GoogleClouddomainsRegistrationContactSettingsRegistrantContact;
    /**
    * technical_contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#technical_contact GoogleClouddomainsRegistration#technical_contact}
    */
    readonly technicalContact: GoogleClouddomainsRegistrationContactSettingsTechnicalContact;
}
export declare function googleClouddomainsRegistrationContactSettingsToTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsOutputReference | GoogleClouddomainsRegistrationContactSettings): any;
export declare function googleClouddomainsRegistrationContactSettingsToHclTerraform(struct?: GoogleClouddomainsRegistrationContactSettingsOutputReference | GoogleClouddomainsRegistrationContactSettings): any;
export declare class GoogleClouddomainsRegistrationContactSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationContactSettings | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationContactSettings | undefined);
    private _privacy?;
    get privacy(): string;
    set privacy(value: string);
    get privacyInput(): string | undefined;
    private _adminContact;
    get adminContact(): GoogleClouddomainsRegistrationContactSettingsAdminContactOutputReference;
    putAdminContact(value: GoogleClouddomainsRegistrationContactSettingsAdminContact): void;
    get adminContactInput(): GoogleClouddomainsRegistrationContactSettingsAdminContact | undefined;
    private _registrantContact;
    get registrantContact(): GoogleClouddomainsRegistrationContactSettingsRegistrantContactOutputReference;
    putRegistrantContact(value: GoogleClouddomainsRegistrationContactSettingsRegistrantContact): void;
    get registrantContactInput(): GoogleClouddomainsRegistrationContactSettingsRegistrantContact | undefined;
    private _technicalContact;
    get technicalContact(): GoogleClouddomainsRegistrationContactSettingsTechnicalContactOutputReference;
    putTechnicalContact(value: GoogleClouddomainsRegistrationContactSettingsTechnicalContact): void;
    get technicalContactInput(): GoogleClouddomainsRegistrationContactSettingsTechnicalContact | undefined;
}
export interface GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords {
    /**
    * The algorithm used to generate the referenced DNSKEY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#algorithm GoogleClouddomainsRegistration#algorithm}
    */
    readonly algorithm?: string;
    /**
    * The digest generated from the referenced DNSKEY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#digest GoogleClouddomainsRegistration#digest}
    */
    readonly digest?: string;
    /**
    * The hash function used to generate the digest of the referenced DNSKEY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#digest_type GoogleClouddomainsRegistration#digest_type}
    */
    readonly digestType?: string;
    /**
    * The key tag of the record. Must be set in range 0 -- 65535.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#key_tag GoogleClouddomainsRegistration#key_tag}
    */
    readonly keyTag?: number;
}
export declare function googleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsToTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords | cdktf.IResolvable): any;
export declare function googleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsToHclTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords | cdktf.IResolvable): any;
export declare class GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords | cdktf.IResolvable | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _digest?;
    get digest(): string;
    set digest(value: string);
    resetDigest(): void;
    get digestInput(): string | undefined;
    private _digestType?;
    get digestType(): string;
    set digestType(value: string);
    resetDigestType(): void;
    get digestTypeInput(): string | undefined;
    private _keyTag?;
    get keyTag(): number;
    set keyTag(value: number);
    resetKeyTag(): void;
    get keyTagInput(): number | undefined;
}
export declare class GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsOutputReference;
}
export interface GoogleClouddomainsRegistrationDnsSettingsCustomDns {
    /**
    * Required. A list of name servers that store the DNS zone for this domain. Each name server is a domain
    * name, with Unicode domain names expressed in Punycode format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#name_servers GoogleClouddomainsRegistration#name_servers}
    */
    readonly nameServers: string[];
    /**
    * ds_records block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#ds_records GoogleClouddomainsRegistration#ds_records}
    */
    readonly dsRecords?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords[] | cdktf.IResolvable;
}
export declare function googleClouddomainsRegistrationDnsSettingsCustomDnsToTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsOutputReference | GoogleClouddomainsRegistrationDnsSettingsCustomDns): any;
export declare function googleClouddomainsRegistrationDnsSettingsCustomDnsToHclTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsCustomDnsOutputReference | GoogleClouddomainsRegistrationDnsSettingsCustomDns): any;
export declare class GoogleClouddomainsRegistrationDnsSettingsCustomDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationDnsSettingsCustomDns | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationDnsSettingsCustomDns | undefined);
    private _nameServers?;
    get nameServers(): string[];
    set nameServers(value: string[]);
    get nameServersInput(): string[] | undefined;
    private _dsRecords;
    get dsRecords(): GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecordsList;
    putDsRecords(value: GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords[] | cdktf.IResolvable): void;
    resetDsRecords(): void;
    get dsRecordsInput(): cdktf.IResolvable | GoogleClouddomainsRegistrationDnsSettingsCustomDnsDsRecords[] | undefined;
}
export interface GoogleClouddomainsRegistrationDnsSettingsGlueRecords {
    /**
    * Required. Domain name of the host in Punycode format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#host_name GoogleClouddomainsRegistration#host_name}
    */
    readonly hostName: string;
    /**
    * List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
    * At least one of ipv4_address and ipv6_address must be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#ipv4_addresses GoogleClouddomainsRegistration#ipv4_addresses}
    */
    readonly ipv4Addresses?: string[];
    /**
    * List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
    * At least one of ipv4_address and ipv6_address must be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#ipv6_addresses GoogleClouddomainsRegistration#ipv6_addresses}
    */
    readonly ipv6Addresses?: string[];
}
export declare function googleClouddomainsRegistrationDnsSettingsGlueRecordsToTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsGlueRecords | cdktf.IResolvable): any;
export declare function googleClouddomainsRegistrationDnsSettingsGlueRecordsToHclTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsGlueRecords | cdktf.IResolvable): any;
export declare class GoogleClouddomainsRegistrationDnsSettingsGlueRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleClouddomainsRegistrationDnsSettingsGlueRecords | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationDnsSettingsGlueRecords | cdktf.IResolvable | undefined);
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _ipv4Addresses?;
    get ipv4Addresses(): string[];
    set ipv4Addresses(value: string[]);
    resetIpv4Addresses(): void;
    get ipv4AddressesInput(): string[] | undefined;
    private _ipv6Addresses?;
    get ipv6Addresses(): string[];
    set ipv6Addresses(value: string[]);
    resetIpv6Addresses(): void;
    get ipv6AddressesInput(): string[] | undefined;
}
export declare class GoogleClouddomainsRegistrationDnsSettingsGlueRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleClouddomainsRegistrationDnsSettingsGlueRecords[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleClouddomainsRegistrationDnsSettingsGlueRecordsOutputReference;
}
export interface GoogleClouddomainsRegistrationDnsSettings {
    /**
    * custom_dns block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#custom_dns GoogleClouddomainsRegistration#custom_dns}
    */
    readonly customDns?: GoogleClouddomainsRegistrationDnsSettingsCustomDns;
    /**
    * glue_records block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#glue_records GoogleClouddomainsRegistration#glue_records}
    */
    readonly glueRecords?: GoogleClouddomainsRegistrationDnsSettingsGlueRecords[] | cdktf.IResolvable;
}
export declare function googleClouddomainsRegistrationDnsSettingsToTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsOutputReference | GoogleClouddomainsRegistrationDnsSettings): any;
export declare function googleClouddomainsRegistrationDnsSettingsToHclTerraform(struct?: GoogleClouddomainsRegistrationDnsSettingsOutputReference | GoogleClouddomainsRegistrationDnsSettings): any;
export declare class GoogleClouddomainsRegistrationDnsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationDnsSettings | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationDnsSettings | undefined);
    private _customDns;
    get customDns(): GoogleClouddomainsRegistrationDnsSettingsCustomDnsOutputReference;
    putCustomDns(value: GoogleClouddomainsRegistrationDnsSettingsCustomDns): void;
    resetCustomDns(): void;
    get customDnsInput(): GoogleClouddomainsRegistrationDnsSettingsCustomDns | undefined;
    private _glueRecords;
    get glueRecords(): GoogleClouddomainsRegistrationDnsSettingsGlueRecordsList;
    putGlueRecords(value: GoogleClouddomainsRegistrationDnsSettingsGlueRecords[] | cdktf.IResolvable): void;
    resetGlueRecords(): void;
    get glueRecordsInput(): cdktf.IResolvable | GoogleClouddomainsRegistrationDnsSettingsGlueRecords[] | undefined;
}
export interface GoogleClouddomainsRegistrationManagementSettings {
    /**
    * The desired renewal method for this Registration. The actual renewalMethod is automatically updated to reflect this choice.
    * If unset or equal to RENEWAL_METHOD_UNSPECIFIED, the actual renewalMethod is treated as if it were set to AUTOMATIC_RENEWAL.
    * You cannot use RENEWAL_DISABLED during resource creation, and you can update the renewal status only when the Registration
    * resource has state ACTIVE or SUSPENDED.
    *
    * When preferredRenewalMethod is set to AUTOMATIC_RENEWAL, the actual renewalMethod can be set to RENEWAL_DISABLED in case of
    * problems with the billing account or reported domain abuse. In such cases, check the issues field on the Registration. After
    * the problem is resolved, the renewalMethod is automatically updated to preferredRenewalMethod in a few hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#preferred_renewal_method GoogleClouddomainsRegistration#preferred_renewal_method}
    */
    readonly preferredRenewalMethod?: string;
    /**
    * Controls whether the domain can be transferred to another registrar. Values are UNLOCKED or LOCKED.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#transfer_lock_state GoogleClouddomainsRegistration#transfer_lock_state}
    */
    readonly transferLockState?: string;
}
export declare function googleClouddomainsRegistrationManagementSettingsToTerraform(struct?: GoogleClouddomainsRegistrationManagementSettingsOutputReference | GoogleClouddomainsRegistrationManagementSettings): any;
export declare function googleClouddomainsRegistrationManagementSettingsToHclTerraform(struct?: GoogleClouddomainsRegistrationManagementSettingsOutputReference | GoogleClouddomainsRegistrationManagementSettings): any;
export declare class GoogleClouddomainsRegistrationManagementSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationManagementSettings | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationManagementSettings | undefined);
    private _preferredRenewalMethod?;
    get preferredRenewalMethod(): string;
    set preferredRenewalMethod(value: string);
    resetPreferredRenewalMethod(): void;
    get preferredRenewalMethodInput(): string | undefined;
    get renewalMethod(): string;
    private _transferLockState?;
    get transferLockState(): string;
    set transferLockState(value: string);
    resetTransferLockState(): void;
    get transferLockStateInput(): string | undefined;
}
export interface GoogleClouddomainsRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#create GoogleClouddomainsRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#delete GoogleClouddomainsRegistration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#update GoogleClouddomainsRegistration#update}
    */
    readonly update?: string;
}
export declare function googleClouddomainsRegistrationTimeoutsToTerraform(struct?: GoogleClouddomainsRegistrationTimeouts | cdktf.IResolvable): any;
export declare function googleClouddomainsRegistrationTimeoutsToHclTerraform(struct?: GoogleClouddomainsRegistrationTimeouts | cdktf.IResolvable): any;
export declare class GoogleClouddomainsRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleClouddomainsRegistrationYearlyPrice {
    /**
    * The three-letter currency code defined in ISO 4217.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#currency_code GoogleClouddomainsRegistration#currency_code}
    */
    readonly currencyCode?: string;
    /**
    * The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#units GoogleClouddomainsRegistration#units}
    */
    readonly units?: string;
}
export declare function googleClouddomainsRegistrationYearlyPriceToTerraform(struct?: GoogleClouddomainsRegistrationYearlyPriceOutputReference | GoogleClouddomainsRegistrationYearlyPrice): any;
export declare function googleClouddomainsRegistrationYearlyPriceToHclTerraform(struct?: GoogleClouddomainsRegistrationYearlyPriceOutputReference | GoogleClouddomainsRegistrationYearlyPrice): any;
export declare class GoogleClouddomainsRegistrationYearlyPriceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleClouddomainsRegistrationYearlyPrice | undefined;
    set internalValue(value: GoogleClouddomainsRegistrationYearlyPrice | undefined);
    private _currencyCode?;
    get currencyCode(): string;
    set currencyCode(value: string);
    resetCurrencyCode(): void;
    get currencyCodeInput(): string | undefined;
    private _units?;
    get units(): string;
    set units(value: string);
    resetUnits(): void;
    get unitsInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration google_clouddomains_registration}
*/
export declare class GoogleClouddomainsRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_clouddomains_registration";
    /**
    * Generates CDKTF code for importing a GoogleClouddomainsRegistration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleClouddomainsRegistration to import
    * @param importFromId The id of the existing GoogleClouddomainsRegistration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleClouddomainsRegistration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_clouddomains_registration google_clouddomains_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleClouddomainsRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleClouddomainsRegistrationConfig);
    private _contactNotices?;
    get contactNotices(): string[];
    set contactNotices(value: string[]);
    resetContactNotices(): void;
    get contactNoticesInput(): string[] | undefined;
    get createTime(): string;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainNotices?;
    get domainNotices(): string[];
    set domainNotices(value: string[]);
    resetDomainNotices(): void;
    get domainNoticesInput(): string[] | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issues(): string[];
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get registerFailureReason(): string;
    get state(): string;
    get supportedPrivacy(): string[];
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _contactSettings;
    get contactSettings(): GoogleClouddomainsRegistrationContactSettingsOutputReference;
    putContactSettings(value: GoogleClouddomainsRegistrationContactSettings): void;
    get contactSettingsInput(): GoogleClouddomainsRegistrationContactSettings | undefined;
    private _dnsSettings;
    get dnsSettings(): GoogleClouddomainsRegistrationDnsSettingsOutputReference;
    putDnsSettings(value: GoogleClouddomainsRegistrationDnsSettings): void;
    resetDnsSettings(): void;
    get dnsSettingsInput(): GoogleClouddomainsRegistrationDnsSettings | undefined;
    private _managementSettings;
    get managementSettings(): GoogleClouddomainsRegistrationManagementSettingsOutputReference;
    putManagementSettings(value: GoogleClouddomainsRegistrationManagementSettings): void;
    resetManagementSettings(): void;
    get managementSettingsInput(): GoogleClouddomainsRegistrationManagementSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleClouddomainsRegistrationTimeoutsOutputReference;
    putTimeouts(value: GoogleClouddomainsRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleClouddomainsRegistrationTimeouts | undefined;
    private _yearlyPrice;
    get yearlyPrice(): GoogleClouddomainsRegistrationYearlyPriceOutputReference;
    putYearlyPrice(value: GoogleClouddomainsRegistrationYearlyPrice): void;
    get yearlyPriceInput(): GoogleClouddomainsRegistrationYearlyPrice | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
