/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Memory (in MB), available to the function. Default value is 256. Possible values include 128, 256, 512, 1024, etc.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#available_memory_mb GoogleCloudfunctionsFunction#available_memory_mb}
    */
    readonly availableMemoryMb?: number;
    /**
    *  A set of key/value environment variable pairs available during build time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#build_environment_variables GoogleCloudfunctionsFunction#build_environment_variables}
    */
    readonly buildEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
    * Name of the Cloud Build Custom Worker Pool that should be used to build the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#build_worker_pool GoogleCloudfunctionsFunction#build_worker_pool}
    */
    readonly buildWorkerPool?: string;
    /**
    * Description of the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#description GoogleCloudfunctionsFunction#description}
    */
    readonly description?: string;
    /**
    * Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#docker_registry GoogleCloudfunctionsFunction#docker_registry}
    */
    readonly dockerRegistry?: string;
    /**
    * User managed repository created in Artifact Registry optionally with a customer managed encryption key. If specified, deployments will use Artifact Registry for storing images built with Cloud Build.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#docker_repository GoogleCloudfunctionsFunction#docker_repository}
    */
    readonly dockerRepository?: string;
    /**
    * Name of the function that will be executed when the Google Cloud Function is triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#entry_point GoogleCloudfunctionsFunction#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * A set of key/value environment variable pairs to assign to the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#environment_variables GoogleCloudfunctionsFunction#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * The security level for the function. Defaults to SECURE_OPTIONAL. Valid only if trigger_http is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#https_trigger_security_level GoogleCloudfunctionsFunction#https_trigger_security_level}
    */
    readonly httpsTriggerSecurityLevel?: string;
    /**
    * URL which triggers function execution. Returned only if trigger_http is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#https_trigger_url GoogleCloudfunctionsFunction#https_trigger_url}
    */
    readonly httpsTriggerUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#id GoogleCloudfunctionsFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String value that controls what traffic can reach the function. Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#ingress_settings GoogleCloudfunctionsFunction#ingress_settings}
    */
    readonly ingressSettings?: string;
    /**
    * Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#kms_key_name GoogleCloudfunctionsFunction#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#labels GoogleCloudfunctionsFunction#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The limit on the maximum number of function instances that may coexist at a given time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#max_instances GoogleCloudfunctionsFunction#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * The limit on the minimum number of function instances that may coexist at a given time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#min_instances GoogleCloudfunctionsFunction#min_instances}
    */
    readonly minInstances?: number;
    /**
    * A user-defined name of the function. Function names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#name GoogleCloudfunctionsFunction#name}
    */
    readonly name: string;
    /**
    * Project of the function. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#project GoogleCloudfunctionsFunction#project}
    */
    readonly project?: string;
    /**
    * Region of function. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#region GoogleCloudfunctionsFunction#region}
    */
    readonly region?: string;
    /**
    * The runtime in which the function is going to run. Eg. "nodejs12", "nodejs14", "python37", "go111".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#runtime GoogleCloudfunctionsFunction#runtime}
    */
    readonly runtime: string;
    /**
    *  If provided, the self-provided service account to run the function with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#service_account_email GoogleCloudfunctionsFunction#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * The GCS bucket containing the zip archive which contains the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#source_archive_bucket GoogleCloudfunctionsFunction#source_archive_bucket}
    */
    readonly sourceArchiveBucket?: string;
    /**
    * The source archive object (file) in archive bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#source_archive_object GoogleCloudfunctionsFunction#source_archive_object}
    */
    readonly sourceArchiveObject?: string;
    /**
    * Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#timeout GoogleCloudfunctionsFunction#timeout}
    */
    readonly timeout?: number;
    /**
    * Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#trigger_http GoogleCloudfunctionsFunction#trigger_http}
    */
    readonly triggerHttp?: boolean | cdktf.IResolvable;
    /**
    * The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/* /locations/* /connectors/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#vpc_connector GoogleCloudfunctionsFunction#vpc_connector}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly vpcConnector?: string;
    /**
    * The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#vpc_connector_egress_settings GoogleCloudfunctionsFunction#vpc_connector_egress_settings}
    */
    readonly vpcConnectorEgressSettings?: string;
    /**
    * event_trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#event_trigger GoogleCloudfunctionsFunction#event_trigger}
    */
    readonly eventTrigger?: GoogleCloudfunctionsFunctionEventTrigger;
    /**
    * secret_environment_variables block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#secret_environment_variables GoogleCloudfunctionsFunction#secret_environment_variables}
    */
    readonly secretEnvironmentVariables?: GoogleCloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable;
    /**
    * secret_volumes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#secret_volumes GoogleCloudfunctionsFunction#secret_volumes}
    */
    readonly secretVolumes?: GoogleCloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable;
    /**
    * source_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#source_repository GoogleCloudfunctionsFunction#source_repository}
    */
    readonly sourceRepository?: GoogleCloudfunctionsFunctionSourceRepository;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#timeouts GoogleCloudfunctionsFunction#timeouts}
    */
    readonly timeouts?: GoogleCloudfunctionsFunctionTimeouts;
}
export interface GoogleCloudfunctionsFunctionEventTriggerFailurePolicy {
    /**
    * Whether the function should be retried on failure. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#retry GoogleCloudfunctionsFunction#retry}
    */
    readonly retry: boolean | cdktf.IResolvable;
}
export declare function googleCloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct?: GoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference | GoogleCloudfunctionsFunctionEventTriggerFailurePolicy): any;
export declare function googleCloudfunctionsFunctionEventTriggerFailurePolicyToHclTerraform(struct?: GoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference | GoogleCloudfunctionsFunctionEventTriggerFailurePolicy): any;
export declare class GoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined);
    private _retry?;
    get retry(): boolean | cdktf.IResolvable;
    set retry(value: boolean | cdktf.IResolvable);
    get retryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudfunctionsFunctionEventTrigger {
    /**
    * The type of event to observe. For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#event_type GoogleCloudfunctionsFunction#event_type}
    */
    readonly eventType: string;
    /**
    * The name or partial URI of the resource from which to observe events. For example, "myBucket" or "projects/my-project/topics/my-topic"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#resource GoogleCloudfunctionsFunction#resource}
    */
    readonly resource: string;
    /**
    * failure_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#failure_policy GoogleCloudfunctionsFunction#failure_policy}
    */
    readonly failurePolicy?: GoogleCloudfunctionsFunctionEventTriggerFailurePolicy;
}
export declare function googleCloudfunctionsFunctionEventTriggerToTerraform(struct?: GoogleCloudfunctionsFunctionEventTriggerOutputReference | GoogleCloudfunctionsFunctionEventTrigger): any;
export declare function googleCloudfunctionsFunctionEventTriggerToHclTerraform(struct?: GoogleCloudfunctionsFunctionEventTriggerOutputReference | GoogleCloudfunctionsFunctionEventTrigger): any;
export declare class GoogleCloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudfunctionsFunctionEventTrigger | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionEventTrigger | undefined);
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    get eventTypeInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _failurePolicy;
    get failurePolicy(): GoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
    putFailurePolicy(value: GoogleCloudfunctionsFunctionEventTriggerFailurePolicy): void;
    resetFailurePolicy(): void;
    get failurePolicyInput(): GoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
}
export interface GoogleCloudfunctionsFunctionSecretEnvironmentVariables {
    /**
    * Name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#key GoogleCloudfunctionsFunction#key}
    */
    readonly key: string;
    /**
    * Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#project_id GoogleCloudfunctionsFunction#project_id}
    */
    readonly projectId?: string;
    /**
    * ID of the secret in secret manager (not the full resource name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#secret GoogleCloudfunctionsFunction#secret}
    */
    readonly secret: string;
    /**
    * Version of the secret (version number or the string "latest"). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new clones start.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#version GoogleCloudfunctionsFunction#version}
    */
    readonly version: string;
}
export declare function googleCloudfunctionsFunctionSecretEnvironmentVariablesToTerraform(struct?: GoogleCloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable): any;
export declare function googleCloudfunctionsFunctionSecretEnvironmentVariablesToHclTerraform(struct?: GoogleCloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable): any;
export declare class GoogleCloudfunctionsFunctionSecretEnvironmentVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class GoogleCloudfunctionsFunctionSecretEnvironmentVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudfunctionsFunctionSecretEnvironmentVariablesOutputReference;
}
export interface GoogleCloudfunctionsFunctionSecretVolumesVersions {
    /**
    * Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mount_path as "/etc/secrets" and path as "/secret_foo" would mount the secret value file at "/etc/secrets/secret_foo".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#path GoogleCloudfunctionsFunction#path}
    */
    readonly path: string;
    /**
    * Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#version GoogleCloudfunctionsFunction#version}
    */
    readonly version: string;
}
export declare function googleCloudfunctionsFunctionSecretVolumesVersionsToTerraform(struct?: GoogleCloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable): any;
export declare function googleCloudfunctionsFunctionSecretVolumesVersionsToHclTerraform(struct?: GoogleCloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable): any;
export declare class GoogleCloudfunctionsFunctionSecretVolumesVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class GoogleCloudfunctionsFunctionSecretVolumesVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudfunctionsFunctionSecretVolumesVersionsOutputReference;
}
export interface GoogleCloudfunctionsFunctionSecretVolumes {
    /**
    * The path within the container to mount the secret volume. For example, setting the mount_path as "/etc/secrets" would mount the secret value files under the "/etc/secrets" directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount paths: "/etc/secrets" Restricted mount paths: "/cloudsql", "/dev/log", "/pod", "/proc", "/var/log".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#mount_path GoogleCloudfunctionsFunction#mount_path}
    */
    readonly mountPath: string;
    /**
    * Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#project_id GoogleCloudfunctionsFunction#project_id}
    */
    readonly projectId?: string;
    /**
    * ID of the secret in secret manager (not the full resource name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#secret GoogleCloudfunctionsFunction#secret}
    */
    readonly secret: string;
    /**
    * versions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#versions GoogleCloudfunctionsFunction#versions}
    */
    readonly versions?: GoogleCloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable;
}
export declare function googleCloudfunctionsFunctionSecretVolumesToTerraform(struct?: GoogleCloudfunctionsFunctionSecretVolumes | cdktf.IResolvable): any;
export declare function googleCloudfunctionsFunctionSecretVolumesToHclTerraform(struct?: GoogleCloudfunctionsFunctionSecretVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudfunctionsFunctionSecretVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudfunctionsFunctionSecretVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionSecretVolumes | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _versions;
    get versions(): GoogleCloudfunctionsFunctionSecretVolumesVersionsList;
    putVersions(value: GoogleCloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable): void;
    resetVersions(): void;
    get versionsInput(): cdktf.IResolvable | GoogleCloudfunctionsFunctionSecretVolumesVersions[] | undefined;
}
export declare class GoogleCloudfunctionsFunctionSecretVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudfunctionsFunctionSecretVolumesOutputReference;
}
export interface GoogleCloudfunctionsFunctionSourceRepository {
    /**
    * The URL pointing to the hosted repository where the function is defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#url GoogleCloudfunctionsFunction#url}
    */
    readonly url: string;
}
export declare function googleCloudfunctionsFunctionSourceRepositoryToTerraform(struct?: GoogleCloudfunctionsFunctionSourceRepositoryOutputReference | GoogleCloudfunctionsFunctionSourceRepository): any;
export declare function googleCloudfunctionsFunctionSourceRepositoryToHclTerraform(struct?: GoogleCloudfunctionsFunctionSourceRepositoryOutputReference | GoogleCloudfunctionsFunctionSourceRepository): any;
export declare class GoogleCloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudfunctionsFunctionSourceRepository | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionSourceRepository | undefined);
    get deployedUrl(): string;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface GoogleCloudfunctionsFunctionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#create GoogleCloudfunctionsFunction#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#delete GoogleCloudfunctionsFunction#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#read GoogleCloudfunctionsFunction#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#update GoogleCloudfunctionsFunction#update}
    */
    readonly update?: string;
}
export declare function googleCloudfunctionsFunctionTimeoutsToTerraform(struct?: GoogleCloudfunctionsFunctionTimeouts | cdktf.IResolvable): any;
export declare function googleCloudfunctionsFunctionTimeoutsToHclTerraform(struct?: GoogleCloudfunctionsFunctionTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudfunctionsFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudfunctionsFunctionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudfunctionsFunctionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function google_cloudfunctions_function}
*/
export declare class GoogleCloudfunctionsFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions_function";
    /**
    * Generates CDKTF code for importing a GoogleCloudfunctionsFunction resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleCloudfunctionsFunction to import
    * @param importFromId The id of the existing GoogleCloudfunctionsFunction that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleCloudfunctionsFunction to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_cloudfunctions_function google_cloudfunctions_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudfunctionsFunctionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudfunctionsFunctionConfig);
    private _availableMemoryMb?;
    get availableMemoryMb(): number;
    set availableMemoryMb(value: number);
    resetAvailableMemoryMb(): void;
    get availableMemoryMbInput(): number | undefined;
    private _buildEnvironmentVariables?;
    get buildEnvironmentVariables(): {
        [key: string]: string;
    };
    set buildEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetBuildEnvironmentVariables(): void;
    get buildEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _buildWorkerPool?;
    get buildWorkerPool(): string;
    set buildWorkerPool(value: string);
    resetBuildWorkerPool(): void;
    get buildWorkerPoolInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dockerRegistry?;
    get dockerRegistry(): string;
    set dockerRegistry(value: string);
    resetDockerRegistry(): void;
    get dockerRegistryInput(): string | undefined;
    private _dockerRepository?;
    get dockerRepository(): string;
    set dockerRepository(value: string);
    resetDockerRepository(): void;
    get dockerRepositoryInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _httpsTriggerSecurityLevel?;
    get httpsTriggerSecurityLevel(): string;
    set httpsTriggerSecurityLevel(value: string);
    resetHttpsTriggerSecurityLevel(): void;
    get httpsTriggerSecurityLevelInput(): string | undefined;
    private _httpsTriggerUrl?;
    get httpsTriggerUrl(): string;
    set httpsTriggerUrl(value: string);
    resetHttpsTriggerUrl(): void;
    get httpsTriggerUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingressSettings?;
    get ingressSettings(): string;
    set ingressSettings(value: string);
    resetIngressSettings(): void;
    get ingressSettingsInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _sourceArchiveBucket?;
    get sourceArchiveBucket(): string;
    set sourceArchiveBucket(value: string);
    resetSourceArchiveBucket(): void;
    get sourceArchiveBucketInput(): string | undefined;
    private _sourceArchiveObject?;
    get sourceArchiveObject(): string;
    set sourceArchiveObject(value: string);
    resetSourceArchiveObject(): void;
    get sourceArchiveObjectInput(): string | undefined;
    get status(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _triggerHttp?;
    get triggerHttp(): boolean | cdktf.IResolvable;
    set triggerHttp(value: boolean | cdktf.IResolvable);
    resetTriggerHttp(): void;
    get triggerHttpInput(): boolean | cdktf.IResolvable | undefined;
    get versionId(): string;
    private _vpcConnector?;
    get vpcConnector(): string;
    set vpcConnector(value: string);
    resetVpcConnector(): void;
    get vpcConnectorInput(): string | undefined;
    private _vpcConnectorEgressSettings?;
    get vpcConnectorEgressSettings(): string;
    set vpcConnectorEgressSettings(value: string);
    resetVpcConnectorEgressSettings(): void;
    get vpcConnectorEgressSettingsInput(): string | undefined;
    private _eventTrigger;
    get eventTrigger(): GoogleCloudfunctionsFunctionEventTriggerOutputReference;
    putEventTrigger(value: GoogleCloudfunctionsFunctionEventTrigger): void;
    resetEventTrigger(): void;
    get eventTriggerInput(): GoogleCloudfunctionsFunctionEventTrigger | undefined;
    private _secretEnvironmentVariables;
    get secretEnvironmentVariables(): GoogleCloudfunctionsFunctionSecretEnvironmentVariablesList;
    putSecretEnvironmentVariables(value: GoogleCloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable): void;
    resetSecretEnvironmentVariables(): void;
    get secretEnvironmentVariablesInput(): cdktf.IResolvable | GoogleCloudfunctionsFunctionSecretEnvironmentVariables[] | undefined;
    private _secretVolumes;
    get secretVolumes(): GoogleCloudfunctionsFunctionSecretVolumesList;
    putSecretVolumes(value: GoogleCloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable): void;
    resetSecretVolumes(): void;
    get secretVolumesInput(): cdktf.IResolvable | GoogleCloudfunctionsFunctionSecretVolumes[] | undefined;
    private _sourceRepository;
    get sourceRepository(): GoogleCloudfunctionsFunctionSourceRepositoryOutputReference;
    putSourceRepository(value: GoogleCloudfunctionsFunctionSourceRepository): void;
    resetSourceRepository(): void;
    get sourceRepositoryInput(): GoogleCloudfunctionsFunctionSourceRepository | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudfunctionsFunctionTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudfunctionsFunctionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudfunctionsFunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
