/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeDiskAsyncReplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#id GoogleComputeDiskAsyncReplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Primary disk for asynchronous replication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#primary_disk GoogleComputeDiskAsyncReplication#primary_disk}
    */
    readonly primaryDisk: string;
    /**
    * secondary_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#secondary_disk GoogleComputeDiskAsyncReplication#secondary_disk}
    */
    readonly secondaryDisk: GoogleComputeDiskAsyncReplicationSecondaryDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#timeouts GoogleComputeDiskAsyncReplication#timeouts}
    */
    readonly timeouts?: GoogleComputeDiskAsyncReplicationTimeouts;
}
export interface GoogleComputeDiskAsyncReplicationSecondaryDisk {
    /**
    * Secondary disk for asynchronous replication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#disk GoogleComputeDiskAsyncReplication#disk}
    */
    readonly disk: string;
}
export declare function googleComputeDiskAsyncReplicationSecondaryDiskToTerraform(struct?: GoogleComputeDiskAsyncReplicationSecondaryDiskOutputReference | GoogleComputeDiskAsyncReplicationSecondaryDisk): any;
export declare function googleComputeDiskAsyncReplicationSecondaryDiskToHclTerraform(struct?: GoogleComputeDiskAsyncReplicationSecondaryDiskOutputReference | GoogleComputeDiskAsyncReplicationSecondaryDisk): any;
export declare class GoogleComputeDiskAsyncReplicationSecondaryDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskAsyncReplicationSecondaryDisk | undefined;
    set internalValue(value: GoogleComputeDiskAsyncReplicationSecondaryDisk | undefined);
    private _disk?;
    get disk(): string;
    set disk(value: string);
    get diskInput(): string | undefined;
    get state(): string;
}
export interface GoogleComputeDiskAsyncReplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#create GoogleComputeDiskAsyncReplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#delete GoogleComputeDiskAsyncReplication#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeDiskAsyncReplicationTimeoutsToTerraform(struct?: GoogleComputeDiskAsyncReplicationTimeouts | cdktf.IResolvable): any;
export declare function googleComputeDiskAsyncReplicationTimeoutsToHclTerraform(struct?: GoogleComputeDiskAsyncReplicationTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeDiskAsyncReplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskAsyncReplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeDiskAsyncReplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication google_compute_disk_async_replication}
*/
export declare class GoogleComputeDiskAsyncReplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_disk_async_replication";
    /**
    * Generates CDKTF code for importing a GoogleComputeDiskAsyncReplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeDiskAsyncReplication to import
    * @param importFromId The id of the existing GoogleComputeDiskAsyncReplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeDiskAsyncReplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk_async_replication google_compute_disk_async_replication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeDiskAsyncReplicationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeDiskAsyncReplicationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _primaryDisk?;
    get primaryDisk(): string;
    set primaryDisk(value: string);
    get primaryDiskInput(): string | undefined;
    private _secondaryDisk;
    get secondaryDisk(): GoogleComputeDiskAsyncReplicationSecondaryDiskOutputReference;
    putSecondaryDisk(value: GoogleComputeDiskAsyncReplicationSecondaryDisk): void;
    get secondaryDiskInput(): GoogleComputeDiskAsyncReplicationSecondaryDisk | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeDiskAsyncReplicationTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeDiskAsyncReplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeDiskAsyncReplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
