/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#description GoogleComputeDisk#description}
    */
    readonly description?: string;
    /**
    * Whether this disk is using confidential compute mode.
    * Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#enable_confidential_compute GoogleComputeDisk#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#id GoogleComputeDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The image from which to initialize this disk. This can be
    * one of: the image's 'self_link', 'projects/{project}/global/images/{image}',
    * 'projects/{project}/global/images/family/{family}', 'global/images/{image}',
    * 'global/images/family/{family}', 'family/{family}', '{project}/{family}',
    * '{project}/{image}', '{family}', or '{image}'. If referred by family, the
    * images names must include the family name. If they don't, use the
    * [google_compute_image data source](/docs/providers/google/d/compute_image.html).
    * For instance, the image 'centos-6-v20180104' includes its family name 'centos-6'.
    * These images can be referred by family name here.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#image GoogleComputeDisk#image}
    */
    readonly image?: string;
    /**
    * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#interface GoogleComputeDisk#interface}
    */
    readonly interface?: string;
    /**
    * Labels to apply to this disk.  A list of key->value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#labels GoogleComputeDisk#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Any applicable license URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#licenses GoogleComputeDisk#licenses}
    */
    readonly licenses?: string[];
    /**
    * Indicates whether or not the disk can be read/write attached to more than one instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#multi_writer GoogleComputeDisk#multi_writer}
    */
    readonly multiWriter?: boolean | cdktf.IResolvable;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#name GoogleComputeDisk#name}
    */
    readonly name: string;
    /**
    * Physical block size of the persistent disk, in bytes. If not present
    * in a request, a default value is used. Currently supported sizes
    * are 4096 and 16384, other sizes may be added in the future.
    * If an unsupported value is requested, the error message will list
    * the supported values for the caller's project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#physical_block_size_bytes GoogleComputeDisk#physical_block_size_bytes}
    */
    readonly physicalBlockSizeBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#project GoogleComputeDisk#project}
    */
    readonly project?: string;
    /**
    * Indicates how many IOPS must be provisioned for the disk.
    * Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
    * allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#provisioned_iops GoogleComputeDisk#provisioned_iops}
    */
    readonly provisionedIops?: number;
    /**
    * Indicates how much Throughput must be provisioned for the disk.
    * Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
    * allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#provisioned_throughput GoogleComputeDisk#provisioned_throughput}
    */
    readonly provisionedThroughput?: number;
    /**
    * Resource policies applied to this disk for automatic snapshot creations.
    *
    * ~>**NOTE** This value does not support updating the
    * resource policy, as resource policies can not be updated more than
    * one at a time. Use
    * ['google_compute_disk_resource_policy_attachment'](https://registry.terraform.io/providers/hashicorp/google/latest/docs/resources/compute_disk_resource_policy_attachment)
    * to allow for updating the resource policy attached to the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#resource_policies GoogleComputeDisk#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * Size of the persistent disk, specified in GB. You can specify this
    * field when creating a persistent disk using the 'image' or
    * 'snapshot' parameter, or specify it alone to create an empty
    * persistent disk.
    *
    * If you specify this field along with 'image' or 'snapshot',
    * the value must not be less than the size of the image
    * or the size of the snapshot.
    *
    * ~>**NOTE** If you change the size, Terraform updates the disk size
    * if upsizing is detected but recreates the disk if downsizing is requested.
    * You can add 'lifecycle.prevent_destroy' in the config to prevent destroying
    * and recreating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#size GoogleComputeDisk#size}
    */
    readonly size?: number;
    /**
    * The source snapshot used to create this disk. You can provide this as
    * a partial or full URL to the resource. If the snapshot is in another
    * project than this disk, you must supply a full URL. For example, the
    * following are valid values:
    *
    * * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
    * * 'projects/project/global/snapshots/snapshot'
    * * 'global/snapshots/snapshot'
    * * 'snapshot'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#snapshot GoogleComputeDisk#snapshot}
    */
    readonly snapshot?: string;
    /**
    * The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
    * For example, the following are valid values:
    *
    * * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
    * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
    * * projects/{project}/zones/{zone}/disks/{disk}
    * * projects/{project}/regions/{region}/disks/{disk}
    * * zones/{zone}/disks/{disk}
    * * regions/{region}/disks/{disk}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#source_disk GoogleComputeDisk#source_disk}
    */
    readonly sourceDisk?: string;
    /**
    * URL of the disk type resource describing which disk type to use to
    * create the disk. Provide this when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#type GoogleComputeDisk#type}
    */
    readonly type?: string;
    /**
    * A reference to the zone where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#zone GoogleComputeDisk#zone}
    */
    readonly zone?: string;
    /**
    * async_primary_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#async_primary_disk GoogleComputeDisk#async_primary_disk}
    */
    readonly asyncPrimaryDisk?: GoogleComputeDiskAsyncPrimaryDisk;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#disk_encryption_key GoogleComputeDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: GoogleComputeDiskDiskEncryptionKey;
    /**
    * guest_os_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#guest_os_features GoogleComputeDisk#guest_os_features}
    */
    readonly guestOsFeatures?: GoogleComputeDiskGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * source_image_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#source_image_encryption_key GoogleComputeDisk#source_image_encryption_key}
    */
    readonly sourceImageEncryptionKey?: GoogleComputeDiskSourceImageEncryptionKey;
    /**
    * source_snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#source_snapshot_encryption_key GoogleComputeDisk#source_snapshot_encryption_key}
    */
    readonly sourceSnapshotEncryptionKey?: GoogleComputeDiskSourceSnapshotEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#timeouts GoogleComputeDisk#timeouts}
    */
    readonly timeouts?: GoogleComputeDiskTimeouts;
}
export interface GoogleComputeDiskAsyncPrimaryDisk {
    /**
    * Primary disk for asynchronous disk replication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#disk GoogleComputeDisk#disk}
    */
    readonly disk: string;
}
export declare function googleComputeDiskAsyncPrimaryDiskToTerraform(struct?: GoogleComputeDiskAsyncPrimaryDiskOutputReference | GoogleComputeDiskAsyncPrimaryDisk): any;
export declare function googleComputeDiskAsyncPrimaryDiskToHclTerraform(struct?: GoogleComputeDiskAsyncPrimaryDiskOutputReference | GoogleComputeDiskAsyncPrimaryDisk): any;
export declare class GoogleComputeDiskAsyncPrimaryDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskAsyncPrimaryDisk | undefined;
    set internalValue(value: GoogleComputeDiskAsyncPrimaryDisk | undefined);
    private _disk?;
    get disk(): string;
    set disk(value: string);
    get diskInput(): string | undefined;
}
export interface GoogleComputeDiskDiskEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
    * in the cloud console. Your project's Compute Engine System service account
    * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
    * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
    * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_self_link GoogleComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
    * If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_service_account GoogleComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#raw_key GoogleComputeDisk#raw_key}
    */
    readonly rawKey?: string;
    /**
    * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit
    * customer-supplied encryption key to either encrypt or decrypt
    * this resource. You can provide either the rawKey or the rsaEncryptedKey.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#rsa_encrypted_key GoogleComputeDisk#rsa_encrypted_key}
    */
    readonly rsaEncryptedKey?: string;
}
export declare function googleComputeDiskDiskEncryptionKeyToTerraform(struct?: GoogleComputeDiskDiskEncryptionKeyOutputReference | GoogleComputeDiskDiskEncryptionKey): any;
export declare function googleComputeDiskDiskEncryptionKeyToHclTerraform(struct?: GoogleComputeDiskDiskEncryptionKeyOutputReference | GoogleComputeDiskDiskEncryptionKey): any;
export declare class GoogleComputeDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskDiskEncryptionKey | undefined;
    set internalValue(value: GoogleComputeDiskDiskEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    private _rsaEncryptedKey?;
    get rsaEncryptedKey(): string;
    set rsaEncryptedKey(value: string);
    resetRsaEncryptedKey(): void;
    get rsaEncryptedKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeDiskGuestOsFeatures {
    /**
    * The type of supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Possible values: ["MULTI_IP_SUBNET", "SECURE_BOOT", "SEV_CAPABLE", "UEFI_COMPATIBLE", "VIRTIO_SCSI_MULTIQUEUE", "WINDOWS", "GVNIC", "SEV_LIVE_MIGRATABLE", "SEV_SNP_CAPABLE", "SUSPEND_RESUME_COMPATIBLE", "TDX_CAPABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#type GoogleComputeDisk#type}
    */
    readonly type: string;
}
export declare function googleComputeDiskGuestOsFeaturesToTerraform(struct?: GoogleComputeDiskGuestOsFeatures | cdktf.IResolvable): any;
export declare function googleComputeDiskGuestOsFeaturesToHclTerraform(struct?: GoogleComputeDiskGuestOsFeatures | cdktf.IResolvable): any;
export declare class GoogleComputeDiskGuestOsFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeDiskGuestOsFeatures | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeDiskGuestOsFeatures | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleComputeDiskGuestOsFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeDiskGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeDiskGuestOsFeaturesOutputReference;
}
export interface GoogleComputeDiskSourceImageEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
    * in the cloud console. Your project's Compute Engine System service account
    * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
    * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
    * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_self_link GoogleComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
    * If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_service_account GoogleComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#raw_key GoogleComputeDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function googleComputeDiskSourceImageEncryptionKeyToTerraform(struct?: GoogleComputeDiskSourceImageEncryptionKeyOutputReference | GoogleComputeDiskSourceImageEncryptionKey): any;
export declare function googleComputeDiskSourceImageEncryptionKeyToHclTerraform(struct?: GoogleComputeDiskSourceImageEncryptionKeyOutputReference | GoogleComputeDiskSourceImageEncryptionKey): any;
export declare class GoogleComputeDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: GoogleComputeDiskSourceImageEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeDiskSourceSnapshotEncryptionKey {
    /**
    * The self link of the encryption key used to encrypt the disk. Also called KmsKeyName
    * in the cloud console. Your project's Compute Engine System service account
    * ('service-{{PROJECT_NUMBER}}@compute-system.iam.gserviceaccount.com') must have
    * 'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
    * See https://cloud.google.com/compute/docs/disks/customer-managed-encryption#encrypt_a_new_persistent_disk_with_your_own_keys
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_self_link GoogleComputeDisk#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
    * If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#kms_key_service_account GoogleComputeDisk#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#raw_key GoogleComputeDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function googleComputeDiskSourceSnapshotEncryptionKeyToTerraform(struct?: GoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeDiskSourceSnapshotEncryptionKey): any;
export declare function googleComputeDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: GoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeDiskSourceSnapshotEncryptionKey): any;
export declare class GoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: GoogleComputeDiskSourceSnapshotEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#create GoogleComputeDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#delete GoogleComputeDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#update GoogleComputeDisk#update}
    */
    readonly update?: string;
}
export declare function googleComputeDiskTimeoutsToTerraform(struct?: GoogleComputeDiskTimeouts | cdktf.IResolvable): any;
export declare function googleComputeDiskTimeoutsToHclTerraform(struct?: GoogleComputeDiskTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk google_compute_disk}
*/
export declare class GoogleComputeDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_disk";
    /**
    * Generates CDKTF code for importing a GoogleComputeDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeDisk to import
    * @param importFromId The id of the existing GoogleComputeDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_disk google_compute_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeDiskConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeDiskConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get diskId(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _licenses?;
    get licenses(): string[];
    set licenses(value: string[]);
    resetLicenses(): void;
    get licensesInput(): string[] | undefined;
    private _multiWriter?;
    get multiWriter(): boolean | cdktf.IResolvable;
    set multiWriter(value: boolean | cdktf.IResolvable);
    resetMultiWriter(): void;
    get multiWriterInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    get physicalBlockSizeBytes(): number;
    set physicalBlockSizeBytes(value: number);
    resetPhysicalBlockSizeBytes(): void;
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _provisionedIops?;
    get provisionedIops(): number;
    set provisionedIops(value: number);
    resetProvisionedIops(): void;
    get provisionedIopsInput(): number | undefined;
    private _provisionedThroughput?;
    get provisionedThroughput(): number;
    set provisionedThroughput(value: number);
    resetProvisionedThroughput(): void;
    get provisionedThroughputInput(): number | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshot?;
    get snapshot(): string;
    set snapshot(value: string);
    resetSnapshot(): void;
    get snapshotInput(): string | undefined;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    resetSourceDisk(): void;
    get sourceDiskInput(): string | undefined;
    get sourceDiskId(): string;
    get sourceImageId(): string;
    get sourceSnapshotId(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _asyncPrimaryDisk;
    get asyncPrimaryDisk(): GoogleComputeDiskAsyncPrimaryDiskOutputReference;
    putAsyncPrimaryDisk(value: GoogleComputeDiskAsyncPrimaryDisk): void;
    resetAsyncPrimaryDisk(): void;
    get asyncPrimaryDiskInput(): GoogleComputeDiskAsyncPrimaryDisk | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): GoogleComputeDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: GoogleComputeDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): GoogleComputeDiskDiskEncryptionKey | undefined;
    private _guestOsFeatures;
    get guestOsFeatures(): GoogleComputeDiskGuestOsFeaturesList;
    putGuestOsFeatures(value: GoogleComputeDiskGuestOsFeatures[] | cdktf.IResolvable): void;
    resetGuestOsFeatures(): void;
    get guestOsFeaturesInput(): cdktf.IResolvable | GoogleComputeDiskGuestOsFeatures[] | undefined;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): GoogleComputeDiskSourceImageEncryptionKeyOutputReference;
    putSourceImageEncryptionKey(value: GoogleComputeDiskSourceImageEncryptionKey): void;
    resetSourceImageEncryptionKey(): void;
    get sourceImageEncryptionKeyInput(): GoogleComputeDiskSourceImageEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): GoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: GoogleComputeDiskSourceSnapshotEncryptionKey): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): GoogleComputeDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeDiskTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
