/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The 'ports', 'portRange', and 'allPorts' fields are mutually exclusive.
    * Only packets addressed to ports in the specified range will be forwarded
    * to the backends configured with this forwarding rule.
    *
    * The 'allPorts' field has the following limitations:
    * * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, SCTP, or
    * L3_DEFAULT.
    * * It's applicable only to the following products: internal passthrough
    * Network Load Balancers, backend service-based external passthrough Network
    * Load Balancers, and internal and external protocol forwarding.
    * * Set this field to true to allow packets addressed to any port or packets
    * lacking destination port information (for example, UDP fragments after the
    * first fragment) to be forwarded to the backends configured with this
    * forwarding rule. The L3_DEFAULT protocol requires 'allPorts' be set to
    * true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#all_ports GoogleComputeForwardingRule#all_ports}
    */
    readonly allPorts?: boolean | cdktf.IResolvable;
    /**
    * This field is used along with the 'backend_service' field for
    * internal load balancing or with the 'target' field for internal
    * TargetInstance.
    *
    * If the field is set to 'TRUE', clients can access ILB from all
    * regions.
    *
    * Otherwise only allows access from clients in the same region as the
    * internal load balancer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#allow_global_access GoogleComputeForwardingRule#allow_global_access}
    */
    readonly allowGlobalAccess?: boolean | cdktf.IResolvable;
    /**
    * This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#allow_psc_global_access GoogleComputeForwardingRule#allow_psc_global_access}
    */
    readonly allowPscGlobalAccess?: boolean | cdktf.IResolvable;
    /**
    * Identifies the backend service to which the forwarding rule sends traffic.
    *
    * Required for Internal TCP/UDP Load Balancing and Network Load Balancing;
    * must be omitted for all other load balancer types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#backend_service GoogleComputeForwardingRule#backend_service}
    */
    readonly backendService?: string;
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#description GoogleComputeForwardingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#id GoogleComputeForwardingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IP address for which this forwarding rule accepts traffic. When a client
    * sends traffic to this IP address, the forwarding rule directs the traffic
    * to the referenced 'target' or 'backendService'.
    *
    * While creating a forwarding rule, specifying an 'IPAddress' is
    * required under the following circumstances:
    *
    * * When the 'target' is set to 'targetGrpcProxy' and
    * 'validateForProxyless' is set to 'true', the
    * 'IPAddress' should be set to '0.0.0.0'.
    * * When the 'target' is a Private Service Connect Google APIs
    * bundle, you must specify an 'IPAddress'.
    *
    *
    * Otherwise, you can optionally specify an IP address that references an
    * existing static (reserved) IP address resource. When omitted, Google Cloud
    * assigns an ephemeral IP address.
    *
    * Use one of the following formats to specify an IP address while creating a
    * forwarding rule:
    *
    * * IP address number, as in '100.1.2.3'
    * * IPv6 address range, as in '2600:1234::/96'
    * * Full resource URL, as in
    * 'https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name'
    * * Partial URL or by name, as in:
    *   * 'projects/project_id/regions/region/addresses/address-name'
    *   * 'regions/region/addresses/address-name'
    *   * 'global/addresses/address-name'
    *   * 'address-name'
    *
    *
    * The forwarding rule's 'target' or 'backendService',
    * and in most cases, also the 'loadBalancingScheme', determine the
    * type of IP address that you can use. For detailed information, see
    * [IP address
    * specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    *
    * When reading an 'IPAddress', the API always returns the IP
    * address number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#ip_address GoogleComputeForwardingRule#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The IP protocol to which this rule applies.
    *
    * For protocol forwarding, valid
    * options are 'TCP', 'UDP', 'ESP',
    * 'AH', 'SCTP', 'ICMP' and
    * 'L3_DEFAULT'.
    *
    * The valid IP protocols are different for different load balancing products
    * as described in [Load balancing
    * features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
    *
    * A Forwarding Rule with protocol L3_DEFAULT can attach with target instance or
    * backend service with UNSPECIFIED protocol.
    * A forwarding rule with "L3_DEFAULT" IPProtocal cannot be attached to a backend service with TCP or UDP. Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP", "L3_DEFAULT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#ip_protocol GoogleComputeForwardingRule#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * The IP address version that will be used by this forwarding rule.
    * Valid options are IPV4 and IPV6.
    *
    * If not set, the IPv4 address will be used by default. Possible values: ["IPV4", "IPV6"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#ip_version GoogleComputeForwardingRule#ip_version}
    */
    readonly ipVersion?: string;
    /**
    * Indicates whether or not this load balancer can be used as a collector for
    * packet mirroring. To prevent mirroring loops, instances behind this
    * load balancer will not have their traffic mirrored even if a
    * 'PacketMirroring' rule applies to them.
    *
    * This can only be set to true for load balancers that have their
    * 'loadBalancingScheme' set to 'INTERNAL'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#is_mirroring_collector GoogleComputeForwardingRule#is_mirroring_collector}
    */
    readonly isMirroringCollector?: boolean | cdktf.IResolvable;
    /**
    * Labels to apply to this forwarding rule.  A list of key->value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#labels GoogleComputeForwardingRule#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the forwarding rule type.
    *
    * For more information about forwarding rules, refer to
    * [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts). Default value: "EXTERNAL" Possible values: ["EXTERNAL", "EXTERNAL_MANAGED", "INTERNAL", "INTERNAL_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#load_balancing_scheme GoogleComputeForwardingRule#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * Name of the resource; provided by the client when the resource is created.
    * The name must be 1-63 characters long, and comply with
    * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
    *
    * Specifically, the name must be 1-63 characters long and match the regular
    * expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first
    * character must be a lowercase letter, and all following characters must
    * be a dash, lowercase letter, or digit, except the last character, which
    * cannot be a dash.
    *
    * For Private Service Connect forwarding rules that forward traffic to Google
    * APIs, the forwarding rule name must be a 1-20 characters string with
    * lowercase letters and numbers and must start with a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#name GoogleComputeForwardingRule#name}
    */
    readonly name: string;
    /**
    * This field is not used for external load balancing.
    *
    * For Internal TCP/UDP Load Balancing, this field identifies the network that
    * the load balanced IP should belong to for this Forwarding Rule.
    * If the subnetwork is specified, the network of the subnetwork will be used.
    * If neither subnetwork nor this field is specified, the default network will
    * be used.
    *
    * For Private Service Connect forwarding rules that forward traffic to Google
    * APIs, a network must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#network GoogleComputeForwardingRule#network}
    */
    readonly network?: string;
    /**
    * This signifies the networking tier used for configuring
    * this load balancer and can only take the following values:
    * 'PREMIUM', 'STANDARD'.
    *
    * For regional ForwardingRule, the valid values are 'PREMIUM' and
    * 'STANDARD'. For GlobalForwardingRule, the valid value is
    * 'PREMIUM'.
    *
    * If this field is not specified, it is assumed to be 'PREMIUM'.
    * If 'IPAddress' is specified, this value must be equal to the
    * networkTier of the Address. Possible values: ["PREMIUM", "STANDARD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#network_tier GoogleComputeForwardingRule#network_tier}
    */
    readonly networkTier?: string;
    /**
    * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#no_automate_dns_zone GoogleComputeForwardingRule#no_automate_dns_zone}
    */
    readonly noAutomateDnsZone?: boolean | cdktf.IResolvable;
    /**
    * The 'ports', 'portRange', and 'allPorts' fields are mutually exclusive.
    * Only packets addressed to ports in the specified range will be forwarded
    * to the backends configured with this forwarding rule.
    *
    * The 'portRange' field has the following limitations:
    * * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, or SCTP,
    * and
    * * It's applicable only to the following products: external passthrough
    * Network Load Balancers, internal and external proxy Network Load
    * Balancers, internal and external Application Load Balancers, external
    * protocol forwarding, and Classic VPN.
    * * Some products have restrictions on what ports can be used. See
    * [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
    * for details.
    *
    * For external forwarding rules, two or more forwarding rules cannot use the
    * same '[IPAddress, IPProtocol]' pair, and cannot have overlapping
    * 'portRange's.
    *
    * For internal forwarding rules within the same VPC network, two or more
    * forwarding rules cannot use the same '[IPAddress, IPProtocol]' pair, and
    * cannot have overlapping 'portRange's.
    *
    * @pattern: \d+(?:-\d+)?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#port_range GoogleComputeForwardingRule#port_range}
    */
    readonly portRange?: string;
    /**
    * The 'ports', 'portRange', and 'allPorts' fields are mutually exclusive.
    * Only packets addressed to ports in the specified range will be forwarded
    * to the backends configured with this forwarding rule.
    *
    * The 'ports' field has the following limitations:
    * * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, or SCTP,
    * and
    * * It's applicable only to the following products: internal passthrough
    * Network Load Balancers, backend service-based external passthrough Network
    * Load Balancers, and internal protocol forwarding.
    * * You can specify a list of up to five ports by number, separated by
    * commas. The ports can be contiguous or discontiguous.
    *
    * For external forwarding rules, two or more forwarding rules cannot use the
    * same '[IPAddress, IPProtocol]' pair if they share at least one port
    * number.
    *
    * For internal forwarding rules within the same VPC network, two or more
    * forwarding rules cannot use the same '[IPAddress, IPProtocol]' pair if
    * they share at least one port number.
    *
    * @pattern: \d+(?:-\d+)?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#ports GoogleComputeForwardingRule#ports}
    */
    readonly ports?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#project GoogleComputeForwardingRule#project}
    */
    readonly project?: string;
    /**
    * This is used in PSC consumer ForwardingRule to make terraform recreate the ForwardingRule when the status is closed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#recreate_closed_psc GoogleComputeForwardingRule#recreate_closed_psc}
    */
    readonly recreateClosedPsc?: boolean | cdktf.IResolvable;
    /**
    * A reference to the region where the regional forwarding rule resides.
    *
    * This field is not applicable to global forwarding rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#region GoogleComputeForwardingRule#region}
    */
    readonly region?: string;
    /**
    * An optional prefix to the service name for this Forwarding Rule.
    * If specified, will be the first label of the fully qualified service
    * name.
    *
    * The label must be 1-63 characters long, and comply with RFC1035.
    * Specifically, the label must be 1-63 characters long and match the
    * regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first
    * character must be a lowercase letter, and all following characters
    * must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * This field is only used for INTERNAL load balancing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#service_label GoogleComputeForwardingRule#service_label}
    */
    readonly serviceLabel?: string;
    /**
    * If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#source_ip_ranges GoogleComputeForwardingRule#source_ip_ranges}
    */
    readonly sourceIpRanges?: string[];
    /**
    * This field identifies the subnetwork that the load balanced IP should
    * belong to for this Forwarding Rule, used in internal load balancing and
    * network load balancing with IPv6.
    *
    * If the network specified is in auto subnet mode, this field is optional.
    * However, a subnetwork must be specified if the network is in custom subnet
    * mode or when creating external forwarding rule with IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#subnetwork GoogleComputeForwardingRule#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The URL of the target resource to receive the matched traffic.  For
    * regional forwarding rules, this target must be in the same region as the
    * forwarding rule. For global forwarding rules, this target must be a global
    * load balancing resource.
    *
    * The forwarded traffic must be of a type appropriate to the target object.
    * *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    * *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
    *   *  'vpc-sc' - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
    *   *  'all-apis' - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
    *
    *
    * For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#target GoogleComputeForwardingRule#target}
    */
    readonly target?: string;
    /**
    * service_directory_registrations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#service_directory_registrations GoogleComputeForwardingRule#service_directory_registrations}
    */
    readonly serviceDirectoryRegistrations?: GoogleComputeForwardingRuleServiceDirectoryRegistrations;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#timeouts GoogleComputeForwardingRule#timeouts}
    */
    readonly timeouts?: GoogleComputeForwardingRuleTimeouts;
}
export interface GoogleComputeForwardingRuleServiceDirectoryRegistrations {
    /**
    * Service Directory namespace to register the forwarding rule under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#namespace GoogleComputeForwardingRule#namespace}
    */
    readonly namespace?: string;
    /**
    * Service Directory service to register the forwarding rule under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#service GoogleComputeForwardingRule#service}
    */
    readonly service?: string;
}
export declare function googleComputeForwardingRuleServiceDirectoryRegistrationsToTerraform(struct?: GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference | GoogleComputeForwardingRuleServiceDirectoryRegistrations): any;
export declare function googleComputeForwardingRuleServiceDirectoryRegistrationsToHclTerraform(struct?: GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference | GoogleComputeForwardingRuleServiceDirectoryRegistrations): any;
export declare class GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeForwardingRuleServiceDirectoryRegistrations | undefined;
    set internalValue(value: GoogleComputeForwardingRuleServiceDirectoryRegistrations | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface GoogleComputeForwardingRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#create GoogleComputeForwardingRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#delete GoogleComputeForwardingRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#update GoogleComputeForwardingRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeForwardingRuleTimeoutsToTerraform(struct?: GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare function googleComputeForwardingRuleTimeoutsToHclTerraform(struct?: GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule google_compute_forwarding_rule}
*/
export declare class GoogleComputeForwardingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_forwarding_rule";
    /**
    * Generates CDKTF code for importing a GoogleComputeForwardingRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeForwardingRule to import
    * @param importFromId The id of the existing GoogleComputeForwardingRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeForwardingRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_forwarding_rule google_compute_forwarding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeForwardingRuleConfig);
    private _allPorts?;
    get allPorts(): boolean | cdktf.IResolvable;
    set allPorts(value: boolean | cdktf.IResolvable);
    resetAllPorts(): void;
    get allPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGlobalAccess?;
    get allowGlobalAccess(): boolean | cdktf.IResolvable;
    set allowGlobalAccess(value: boolean | cdktf.IResolvable);
    resetAllowGlobalAccess(): void;
    get allowGlobalAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _allowPscGlobalAccess?;
    get allowPscGlobalAccess(): boolean | cdktf.IResolvable;
    set allowPscGlobalAccess(value: boolean | cdktf.IResolvable);
    resetAllowPscGlobalAccess(): void;
    get allowPscGlobalAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    get baseForwardingRule(): string;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _ipVersion?;
    get ipVersion(): string;
    set ipVersion(value: string);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    private _isMirroringCollector?;
    get isMirroringCollector(): boolean | cdktf.IResolvable;
    set isMirroringCollector(value: boolean | cdktf.IResolvable);
    resetIsMirroringCollector(): void;
    get isMirroringCollectorInput(): boolean | cdktf.IResolvable | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _noAutomateDnsZone?;
    get noAutomateDnsZone(): boolean | cdktf.IResolvable;
    set noAutomateDnsZone(value: boolean | cdktf.IResolvable);
    resetNoAutomateDnsZone(): void;
    get noAutomateDnsZoneInput(): boolean | cdktf.IResolvable | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscConnectionId(): string;
    get pscConnectionStatus(): string;
    private _recreateClosedPsc?;
    get recreateClosedPsc(): boolean | cdktf.IResolvable;
    set recreateClosedPsc(value: boolean | cdktf.IResolvable);
    resetRecreateClosedPsc(): void;
    get recreateClosedPscInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _serviceLabel?;
    get serviceLabel(): string;
    set serviceLabel(value: string);
    resetServiceLabel(): void;
    get serviceLabelInput(): string | undefined;
    get serviceName(): string;
    private _sourceIpRanges?;
    get sourceIpRanges(): string[];
    set sourceIpRanges(value: string[]);
    resetSourceIpRanges(): void;
    get sourceIpRangesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _serviceDirectoryRegistrations;
    get serviceDirectoryRegistrations(): GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference;
    putServiceDirectoryRegistrations(value: GoogleComputeForwardingRuleServiceDirectoryRegistrations): void;
    resetServiceDirectoryRegistrations(): void;
    get serviceDirectoryRegistrationsInput(): GoogleComputeForwardingRuleServiceDirectoryRegistrations | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeForwardingRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeForwardingRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeForwardingRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
