/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * This is used in PSC consumer ForwardingRule to control whether the PSC endpoint can be accessed from another region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#allow_psc_global_access GoogleComputeGlobalForwardingRule#allow_psc_global_access}
    */
    readonly allowPscGlobalAccess?: boolean | cdktf.IResolvable;
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#description GoogleComputeGlobalForwardingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#id GoogleComputeGlobalForwardingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IP address for which this forwarding rule accepts traffic. When a client
    * sends traffic to this IP address, the forwarding rule directs the traffic
    * to the referenced 'target'.
    *
    * While creating a forwarding rule, specifying an 'IPAddress' is
    * required under the following circumstances:
    *
    * * When the 'target' is set to 'targetGrpcProxy' and
    * 'validateForProxyless' is set to 'true', the
    * 'IPAddress' should be set to '0.0.0.0'.
    * * When the 'target' is a Private Service Connect Google APIs
    * bundle, you must specify an 'IPAddress'.
    *
    *
    * Otherwise, you can optionally specify an IP address that references an
    * existing static (reserved) IP address resource. When omitted, Google Cloud
    * assigns an ephemeral IP address.
    *
    * Use one of the following formats to specify an IP address while creating a
    * forwarding rule:
    *
    * * IP address number, as in '100.1.2.3'
    * * IPv6 address range, as in '2600:1234::/96'
    * * Full resource URL, as in
    * 'https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name'
    * * Partial URL or by name, as in:
    *   * 'projects/project_id/regions/region/addresses/address-name'
    *   * 'regions/region/addresses/address-name'
    *   * 'global/addresses/address-name'
    *   * 'address-name'
    *
    *
    * The forwarding rule's 'target',
    * and in most cases, also the 'loadBalancingScheme', determine the
    * type of IP address that you can use. For detailed information, see
    * [IP address
    * specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    *
    * When reading an 'IPAddress', the API always returns the IP
    * address number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#ip_address GoogleComputeGlobalForwardingRule#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The IP protocol to which this rule applies.
    *
    * For protocol forwarding, valid
    * options are 'TCP', 'UDP', 'ESP',
    * 'AH', 'SCTP', 'ICMP' and
    * 'L3_DEFAULT'.
    *
    * The valid IP protocols are different for different load balancing products
    * as described in [Load balancing
    * features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends). Possible values: ["TCP", "UDP", "ESP", "AH", "SCTP", "ICMP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#ip_protocol GoogleComputeGlobalForwardingRule#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * The IP Version that will be used by this global forwarding rule. Possible values: ["IPV4", "IPV6"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#ip_version GoogleComputeGlobalForwardingRule#ip_version}
    */
    readonly ipVersion?: string;
    /**
    * Labels to apply to this forwarding rule.  A list of key->value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#labels GoogleComputeGlobalForwardingRule#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the forwarding rule type.
    *
    * For more information about forwarding rules, refer to
    * [Forwarding rule concepts](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts). Default value: "EXTERNAL" Possible values: ["EXTERNAL", "EXTERNAL_MANAGED", "INTERNAL_MANAGED", "INTERNAL_SELF_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#load_balancing_scheme GoogleComputeGlobalForwardingRule#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * Name of the resource; provided by the client when the resource is created.
    * The name must be 1-63 characters long, and comply with
    * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
    *
    * Specifically, the name must be 1-63 characters long and match the regular
    * expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first
    * character must be a lowercase letter, and all following characters must
    * be a dash, lowercase letter, or digit, except the last character, which
    * cannot be a dash.
    *
    * For Private Service Connect forwarding rules that forward traffic to Google
    * APIs, the forwarding rule name must be a 1-20 characters string with
    * lowercase letters and numbers and must start with a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#name GoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * This field is not used for external load balancing.
    *
    * For Internal TCP/UDP Load Balancing, this field identifies the network that
    * the load balanced IP should belong to for this Forwarding Rule.
    * If the subnetwork is specified, the network of the subnetwork will be used.
    * If neither subnetwork nor this field is specified, the default network will
    * be used.
    *
    * For Private Service Connect forwarding rules that forward traffic to Google
    * APIs, a network must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#network GoogleComputeGlobalForwardingRule#network}
    */
    readonly network?: string;
    /**
    * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#no_automate_dns_zone GoogleComputeGlobalForwardingRule#no_automate_dns_zone}
    */
    readonly noAutomateDnsZone?: boolean | cdktf.IResolvable;
    /**
    * The 'portRange' field has the following limitations:
    * * It requires that the forwarding rule 'IPProtocol' be TCP, UDP, or SCTP,
    * and
    * * It's applicable only to the following products: external passthrough
    * Network Load Balancers, internal and external proxy Network Load
    * Balancers, internal and external Application Load Balancers, external
    * protocol forwarding, and Classic VPN.
    * * Some products have restrictions on what ports can be used. See
    * [port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)
    * for details.
    *
    * For external forwarding rules, two or more forwarding rules cannot use the
    * same '[IPAddress, IPProtocol]' pair, and cannot have overlapping
    * 'portRange's.
    *
    * For internal forwarding rules within the same VPC network, two or more
    * forwarding rules cannot use the same '[IPAddress, IPProtocol]' pair, and
    * cannot have overlapping 'portRange's.
    *
    * @pattern: \d+(?:-\d+)?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#port_range GoogleComputeGlobalForwardingRule#port_range}
    */
    readonly portRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#project GoogleComputeGlobalForwardingRule#project}
    */
    readonly project?: string;
    /**
    * If not empty, this Forwarding Rule will only forward the traffic when the source IP address matches one of the IP addresses or CIDR ranges set here. Note that a Forwarding Rule can only have up to 64 source IP ranges, and this field can only be used with a regional Forwarding Rule whose scheme is EXTERNAL. Each sourceIpRange entry should be either an IP address (for example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#source_ip_ranges GoogleComputeGlobalForwardingRule#source_ip_ranges}
    */
    readonly sourceIpRanges?: string[];
    /**
    * This field identifies the subnetwork that the load balanced IP should
    * belong to for this Forwarding Rule, used in internal load balancing and
    * network load balancing with IPv6.
    *
    * If the network specified is in auto subnet mode, this field is optional.
    * However, a subnetwork must be specified if the network is in custom subnet
    * mode or when creating external forwarding rule with IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#subnetwork GoogleComputeGlobalForwardingRule#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The URL of the target resource to receive the matched traffic.  For
    * regional forwarding rules, this target must be in the same region as the
    * forwarding rule. For global forwarding rules, this target must be a global
    * load balancing resource.
    *
    * The forwarded traffic must be of a type appropriate to the target object.
    * *  For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    * *  For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle:
    *   *  'vpc-sc' - [ APIs that support VPC Service Controls](https://cloud.google.com/vpc-service-controls/docs/supported-products).
    *   *  'all-apis' - [All supported Google APIs](https://cloud.google.com/vpc/docs/private-service-connect#supported-apis).
    *
    *
    * For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#target GoogleComputeGlobalForwardingRule#target}
    */
    readonly target: string;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#metadata_filters GoogleComputeGlobalForwardingRule#metadata_filters}
    */
    readonly metadataFilters?: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable;
    /**
    * service_directory_registrations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#service_directory_registrations GoogleComputeGlobalForwardingRule#service_directory_registrations}
    */
    readonly serviceDirectoryRegistrations?: GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#timeouts GoogleComputeGlobalForwardingRule#timeouts}
    */
    readonly timeouts?: GoogleComputeGlobalForwardingRuleTimeouts;
}
export interface GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels {
    /**
    * Name of the metadata label. The length must be between
    * 1 and 1024 characters, inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#name GoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * The value that the label must match. The value has a maximum
    * length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#value GoogleComputeGlobalForwardingRule#value}
    */
    readonly value: string;
}
export declare function googleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsToTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare function googleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsToHclTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference;
}
export interface GoogleComputeGlobalForwardingRuleMetadataFilters {
    /**
    * Specifies how individual filterLabel matches within the list of
    * filterLabels contribute towards the overall metadataFilter match.
    *
    * MATCH_ANY - At least one of the filterLabels must have a matching
    * label in the provided metadata.
    * MATCH_ALL - All filterLabels must have matching labels in the
    * provided metadata. Possible values: ["MATCH_ANY", "MATCH_ALL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#filter_match_criteria GoogleComputeGlobalForwardingRule#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#filter_labels GoogleComputeGlobalForwardingRule#filter_labels}
    */
    readonly filterLabels: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function googleComputeGlobalForwardingRuleMetadataFiltersToTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable): any;
export declare function googleComputeGlobalForwardingRuleMetadataFiltersToHclTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList;
    putFilterLabels(value: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | undefined;
}
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference;
}
export interface GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations {
    /**
    * Service Directory namespace to register the forwarding rule under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#namespace GoogleComputeGlobalForwardingRule#namespace}
    */
    readonly namespace?: string;
    /**
    * [Optional] Service Directory region to register this global forwarding rule under.
    * Default to "us-central1". Only used for PSC for Google APIs. All PSC for
    * Google APIs Forwarding Rules on the same network should use the same Service
    * Directory region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#service_directory_region GoogleComputeGlobalForwardingRule#service_directory_region}
    */
    readonly serviceDirectoryRegion?: string;
}
export declare function googleComputeGlobalForwardingRuleServiceDirectoryRegistrationsToTerraform(struct?: GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrationsOutputReference | GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations): any;
export declare function googleComputeGlobalForwardingRuleServiceDirectoryRegistrationsToHclTerraform(struct?: GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrationsOutputReference | GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations): any;
export declare class GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _serviceDirectoryRegion?;
    get serviceDirectoryRegion(): string;
    set serviceDirectoryRegion(value: string);
    resetServiceDirectoryRegion(): void;
    get serviceDirectoryRegionInput(): string | undefined;
}
export interface GoogleComputeGlobalForwardingRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#create GoogleComputeGlobalForwardingRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#delete GoogleComputeGlobalForwardingRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#update GoogleComputeGlobalForwardingRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeGlobalForwardingRuleTimeoutsToTerraform(struct?: GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare function googleComputeGlobalForwardingRuleTimeoutsToHclTerraform(struct?: GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule google_compute_global_forwarding_rule}
*/
export declare class GoogleComputeGlobalForwardingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_global_forwarding_rule";
    /**
    * Generates CDKTF code for importing a GoogleComputeGlobalForwardingRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeGlobalForwardingRule to import
    * @param importFromId The id of the existing GoogleComputeGlobalForwardingRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeGlobalForwardingRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_forwarding_rule google_compute_global_forwarding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeGlobalForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeGlobalForwardingRuleConfig);
    private _allowPscGlobalAccess?;
    get allowPscGlobalAccess(): boolean | cdktf.IResolvable;
    set allowPscGlobalAccess(value: boolean | cdktf.IResolvable);
    resetAllowPscGlobalAccess(): void;
    get allowPscGlobalAccessInput(): boolean | cdktf.IResolvable | undefined;
    get baseForwardingRule(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _ipVersion?;
    get ipVersion(): string;
    set ipVersion(value: string);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _noAutomateDnsZone?;
    get noAutomateDnsZone(): boolean | cdktf.IResolvable;
    set noAutomateDnsZone(value: boolean | cdktf.IResolvable);
    resetNoAutomateDnsZone(): void;
    get noAutomateDnsZoneInput(): boolean | cdktf.IResolvable | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscConnectionId(): string;
    get pscConnectionStatus(): string;
    get selfLink(): string;
    private _sourceIpRanges?;
    get sourceIpRanges(): string[];
    set sourceIpRanges(value: string[]);
    resetSourceIpRanges(): void;
    get sourceIpRangesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _metadataFilters;
    get metadataFilters(): GoogleComputeGlobalForwardingRuleMetadataFiltersList;
    putMetadataFilters(value: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleMetadataFilters[] | undefined;
    private _serviceDirectoryRegistrations;
    get serviceDirectoryRegistrations(): GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrationsOutputReference;
    putServiceDirectoryRegistrations(value: GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations): void;
    resetServiceDirectoryRegistrations(): void;
    get serviceDirectoryRegistrationsInput(): GoogleComputeGlobalForwardingRuleServiceDirectoryRegistrations | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeGlobalForwardingRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeGlobalForwardingRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
