/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeGlobalNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The default port used if the port number is not specified in the
    * network endpoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#default_port GoogleComputeGlobalNetworkEndpointGroup#default_port}
    */
    readonly defaultPort?: number;
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#description GoogleComputeGlobalNetworkEndpointGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#id GoogleComputeGlobalNetworkEndpointGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource; provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#name GoogleComputeGlobalNetworkEndpointGroup#name}
    */
    readonly name: string;
    /**
    * Type of network endpoints in this network endpoint group. Possible values: ["INTERNET_IP_PORT", "INTERNET_FQDN_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#network_endpoint_type GoogleComputeGlobalNetworkEndpointGroup#network_endpoint_type}
    */
    readonly networkEndpointType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#project GoogleComputeGlobalNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#timeouts GoogleComputeGlobalNetworkEndpointGroup#timeouts}
    */
    readonly timeouts?: GoogleComputeGlobalNetworkEndpointGroupTimeouts;
}
export interface GoogleComputeGlobalNetworkEndpointGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#create GoogleComputeGlobalNetworkEndpointGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#delete GoogleComputeGlobalNetworkEndpointGroup#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeGlobalNetworkEndpointGroupTimeoutsToTerraform(struct?: GoogleComputeGlobalNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare function googleComputeGlobalNetworkEndpointGroupTimeoutsToHclTerraform(struct?: GoogleComputeGlobalNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeGlobalNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group google_compute_global_network_endpoint_group}
*/
export declare class GoogleComputeGlobalNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_global_network_endpoint_group";
    /**
    * Generates CDKTF code for importing a GoogleComputeGlobalNetworkEndpointGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeGlobalNetworkEndpointGroup to import
    * @param importFromId The id of the existing GoogleComputeGlobalNetworkEndpointGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeGlobalNetworkEndpointGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_global_network_endpoint_group google_compute_global_network_endpoint_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeGlobalNetworkEndpointGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeGlobalNetworkEndpointGroupConfig);
    private _defaultPort?;
    get defaultPort(): number;
    set defaultPort(value: number);
    resetDefaultPort(): void;
    get defaultPortInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string;
    set networkEndpointType(value: string);
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleComputeGlobalNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeGlobalNetworkEndpointGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeGlobalNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
