/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceFromMachineImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires stopping the instance without setting this field, the update will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#allow_stopping_for_update GoogleComputeInstanceFromMachineImage#allow_stopping_for_update}
    */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
    * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#can_ip_forward GoogleComputeInstanceFromMachineImage#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Whether deletion protection is enabled on this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#deletion_protection GoogleComputeInstanceFromMachineImage#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * A brief description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#description GoogleComputeInstanceFromMachineImage#description}
    */
    readonly description?: string;
    /**
    * Desired status of the instance. Either "RUNNING" or "TERMINATED".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#desired_status GoogleComputeInstanceFromMachineImage#desired_status}
    */
    readonly desiredStatus?: string;
    /**
    * Whether the instance has virtual displays enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_display GoogleComputeInstanceFromMachineImage#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#guest_accelerator GoogleComputeInstanceFromMachineImage#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleComputeInstanceFromMachineImageGuestAccelerator[] | cdktf.IResolvable;
    /**
    * A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#hostname GoogleComputeInstanceFromMachineImage#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#id GoogleComputeInstanceFromMachineImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs assigned to the instance.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#labels GoogleComputeInstanceFromMachineImage#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#machine_type GoogleComputeInstanceFromMachineImage#machine_type}
    */
    readonly machineType?: string;
    /**
    * Metadata key/value pairs made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#metadata GoogleComputeInstanceFromMachineImage#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Metadata startup scripts made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#metadata_startup_script GoogleComputeInstanceFromMachineImage#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * The minimum CPU platform specified for the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#min_cpu_platform GoogleComputeInstanceFromMachineImage#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#name GoogleComputeInstanceFromMachineImage#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#project GoogleComputeInstanceFromMachineImage#project}
    */
    readonly project?: string;
    /**
    * A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#resource_policies GoogleComputeInstanceFromMachineImage#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The service account to attach to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#service_account GoogleComputeInstanceFromMachineImage#service_account}
    */
    readonly serviceAccount?: GoogleComputeInstanceFromMachineImageServiceAccount[] | cdktf.IResolvable;
    /**
    * Name or self link of a machine image to create the instance from on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#source_machine_image GoogleComputeInstanceFromMachineImage#source_machine_image}
    */
    readonly sourceMachineImage: string;
    /**
    * The list of tags attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#tags GoogleComputeInstanceFromMachineImage#tags}
    */
    readonly tags?: string[];
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#zone GoogleComputeInstanceFromMachineImage#zone}
    */
    readonly zone?: string;
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#advanced_machine_features GoogleComputeInstanceFromMachineImage#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#confidential_instance_config GoogleComputeInstanceFromMachineImage#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_interface GoogleComputeInstanceFromMachineImage#network_interface}
    */
    readonly networkInterface?: GoogleComputeInstanceFromMachineImageNetworkInterface[] | cdktf.IResolvable;
    /**
    * network_performance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_performance_config GoogleComputeInstanceFromMachineImage#network_performance_config}
    */
    readonly networkPerformanceConfig?: GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig;
    /**
    * params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#params GoogleComputeInstanceFromMachineImage#params}
    */
    readonly params?: GoogleComputeInstanceFromMachineImageParams;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#reservation_affinity GoogleComputeInstanceFromMachineImage#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleComputeInstanceFromMachineImageReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#scheduling GoogleComputeInstanceFromMachineImage#scheduling}
    */
    readonly scheduling?: GoogleComputeInstanceFromMachineImageScheduling;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#shielded_instance_config GoogleComputeInstanceFromMachineImage#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleComputeInstanceFromMachineImageShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#timeouts GoogleComputeInstanceFromMachineImage#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceFromMachineImageTimeouts;
}
export interface GoogleComputeInstanceFromMachineImageAttachedDisk {
}
export declare function googleComputeInstanceFromMachineImageAttachedDiskToTerraform(struct?: GoogleComputeInstanceFromMachineImageAttachedDisk): any;
export declare function googleComputeInstanceFromMachineImageAttachedDiskToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageAttachedDisk): any;
export declare class GoogleComputeInstanceFromMachineImageAttachedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageAttachedDisk | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageAttachedDisk | undefined);
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class GoogleComputeInstanceFromMachineImageAttachedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageAttachedDiskOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageBootDiskInitializeParams {
}
export declare function googleComputeInstanceFromMachineImageBootDiskInitializeParamsToTerraform(struct?: GoogleComputeInstanceFromMachineImageBootDiskInitializeParams): any;
export declare function googleComputeInstanceFromMachineImageBootDiskInitializeParamsToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageBootDiskInitializeParams): any;
export declare class GoogleComputeInstanceFromMachineImageBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageBootDiskInitializeParams | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageBootDiskInitializeParams | undefined);
    get enableConfidentialCompute(): cdktf.IResolvable;
    get image(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get provisionedIops(): number;
    get provisionedThroughput(): number;
    private _resourceManagerTags;
    get resourceManagerTags(): cdktf.StringMap;
    get size(): number;
    get type(): string;
}
export declare class GoogleComputeInstanceFromMachineImageBootDiskInitializeParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageBootDiskInitializeParamsOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageBootDisk {
}
export declare function googleComputeInstanceFromMachineImageBootDiskToTerraform(struct?: GoogleComputeInstanceFromMachineImageBootDisk): any;
export declare function googleComputeInstanceFromMachineImageBootDiskToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageBootDisk): any;
export declare class GoogleComputeInstanceFromMachineImageBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageBootDisk | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageBootDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    private _initializeParams;
    get initializeParams(): GoogleComputeInstanceFromMachineImageBootDiskInitializeParamsList;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class GoogleComputeInstanceFromMachineImageBootDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageBootDiskOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#count GoogleComputeInstanceFromMachineImage#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#type GoogleComputeInstanceFromMachineImage#type}
    */
    readonly type?: string;
}
export declare function googleComputeInstanceFromMachineImageGuestAcceleratorToTerraform(struct?: GoogleComputeInstanceFromMachineImageGuestAccelerator | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageGuestAcceleratorToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageGuestAcceleratorOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageScratchDisk {
}
export declare function googleComputeInstanceFromMachineImageScratchDiskToTerraform(struct?: GoogleComputeInstanceFromMachineImageScratchDisk): any;
export declare function googleComputeInstanceFromMachineImageScratchDiskToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageScratchDisk): any;
export declare class GoogleComputeInstanceFromMachineImageScratchDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageScratchDisk | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageScratchDisk | undefined);
    get deviceName(): string;
    get interface(): string;
    get size(): number;
}
export declare class GoogleComputeInstanceFromMachineImageScratchDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageScratchDiskOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageServiceAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#email GoogleComputeInstanceFromMachineImage#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#scopes GoogleComputeInstanceFromMachineImage#scopes}
    */
    readonly scopes?: string[];
}
export declare function googleComputeInstanceFromMachineImageServiceAccountToTerraform(struct?: GoogleComputeInstanceFromMachineImageServiceAccount | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageServiceAccountToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageServiceAccount | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageServiceAccount | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageServiceAccount | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageServiceAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageServiceAccountOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_nested_virtualization GoogleComputeInstanceFromMachineImage#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#threads_per_core GoogleComputeInstanceFromMachineImage#threads_per_core}
    */
    readonly threadsPerCore?: number;
    /**
    * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance\'s nominal CPU count and the underlying platform\'s SMT width.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#visible_core_count GoogleComputeInstanceFromMachineImage#visible_core_count}
    */
    readonly visibleCoreCount?: number;
}
export declare function googleComputeInstanceFromMachineImageAdvancedMachineFeaturesToTerraform(struct?: GoogleComputeInstanceFromMachineImageAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures): any;
export declare function googleComputeInstanceFromMachineImageAdvancedMachineFeaturesToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures): any;
export declare class GoogleComputeInstanceFromMachineImageAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
    private _visibleCoreCount?;
    get visibleCoreCount(): number;
    set visibleCoreCount(value: number);
    resetVisibleCoreCount(): void;
    get visibleCoreCountInput(): number | undefined;
}
export interface GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig {
    /**
    *
    * 								Specifies which confidential computing technology to use.
    * 								This could be one of the following values: SEV, SEV_SNP.
    * 								If SEV_SNP, min_cpu_platform = "AMD Milan" is currently required.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#confidential_instance_type GoogleComputeInstanceFromMachineImage#confidential_instance_type}
    */
    readonly confidentialInstanceType?: string;
    /**
    * Defines whether the instance should have confidential compute enabled. Field will be deprecated in a future release
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_confidential_compute GoogleComputeInstanceFromMachineImage#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromMachineImageConfidentialInstanceConfigToTerraform(struct?: GoogleComputeInstanceFromMachineImageConfidentialInstanceConfigOutputReference | GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig): any;
export declare function googleComputeInstanceFromMachineImageConfidentialInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageConfidentialInstanceConfigOutputReference | GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig): any;
export declare class GoogleComputeInstanceFromMachineImageConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig | undefined);
    private _confidentialInstanceType?;
    get confidentialInstanceType(): string;
    set confidentialInstanceType(value: string);
    resetConfidentialInstanceType(): void;
    get confidentialInstanceTypeInput(): string | undefined;
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#nat_ip GoogleComputeInstanceFromMachineImage#nat_ip}
    */
    readonly natIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_tier GoogleComputeInstanceFromMachineImage#network_tier}
    */
    readonly networkTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#public_ptr_domain_name GoogleComputeInstanceFromMachineImage#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#security_policy GoogleComputeInstanceFromMachineImage#security_policy}
    */
    readonly securityPolicy?: string;
}
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigToTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#ip_cidr_range GoogleComputeInstanceFromMachineImage#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#subnetwork_range_name GoogleComputeInstanceFromMachineImage#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeToTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig {
    /**
    * The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#external_ipv6 GoogleComputeInstanceFromMachineImage#external_ipv6}
    */
    readonly externalIpv6?: string;
    /**
    * The prefix length of the external IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#external_ipv6_prefix_length GoogleComputeInstanceFromMachineImage#external_ipv6_prefix_length}
    */
    readonly externalIpv6PrefixLength?: string;
    /**
    * The name of this access configuration. In ipv6AccessConfigs, the recommended name is External IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#name GoogleComputeInstanceFromMachineImage#name}
    */
    readonly name?: string;
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_tier GoogleComputeInstanceFromMachineImage#network_tier}
    */
    readonly networkTier: string;
    /**
    * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#public_ptr_domain_name GoogleComputeInstanceFromMachineImage#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigToTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    private _externalIpv6?;
    get externalIpv6(): string;
    set externalIpv6(value: string);
    resetExternalIpv6(): void;
    get externalIpv6Input(): string | undefined;
    private _externalIpv6PrefixLength?;
    get externalIpv6PrefixLength(): string;
    set externalIpv6PrefixLength(value: string);
    resetExternalIpv6PrefixLength(): void;
    get externalIpv6PrefixLengthInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    get securityPolicy(): string;
}
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageNetworkInterface {
    /**
    * Access configurations, i.e. IPs via which this instance can be accessed via the Internet.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#access_config GoogleComputeInstanceFromMachineImage#access_config}
    */
    readonly accessConfig?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * An array of alias IP ranges for this network interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#alias_ip_range GoogleComputeInstanceFromMachineImage#alias_ip_range}
    */
    readonly aliasIpRange?: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * The prefix length of the primary internal IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#internal_ipv6_prefix_length GoogleComputeInstanceFromMachineImage#internal_ipv6_prefix_length}
    */
    readonly internalIpv6PrefixLength?: number;
    /**
    * An IPv6 internal network address for this network interface. If not specified, Google Cloud will automatically assign an internal IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#ipv6_address GoogleComputeInstanceFromMachineImage#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The name or self_link of the network attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network GoogleComputeInstanceFromMachineImage#network}
    */
    readonly network?: string;
    /**
    * The URL of the network attachment that this interface should connect to in the following format: projects/{projectNumber}/regions/{region_name}/networkAttachments/{network_attachment_name}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_attachment GoogleComputeInstanceFromMachineImage#network_attachment}
    */
    readonly networkAttachment?: string;
    /**
    * The private IP address assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#network_ip GoogleComputeInstanceFromMachineImage#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#nic_type GoogleComputeInstanceFromMachineImage#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#queue_count GoogleComputeInstanceFromMachineImage#queue_count}
    */
    readonly queueCount?: number;
    /**
    * A full or partial URL to a security policy to add to this instance. If this field is set to an empty string it will remove the associated security policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#security_policy GoogleComputeInstanceFromMachineImage#security_policy}
    */
    readonly securityPolicy?: string;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#stack_type GoogleComputeInstanceFromMachineImage#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name or self_link of the subnetwork attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#subnetwork GoogleComputeInstanceFromMachineImage#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The project in which the subnetwork belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#subnetwork_project GoogleComputeInstanceFromMachineImage#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#ipv6_access_config GoogleComputeInstanceFromMachineImage#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceToTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterface | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageNetworkInterfaceToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkInterface | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageNetworkInterface | cdktf.IResolvable | undefined);
    private _accessConfig;
    get accessConfig(): GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfigList;
    putAccessConfig(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageNetworkInterfaceAliasIpRange[] | undefined;
    private _internalIpv6PrefixLength?;
    get internalIpv6PrefixLength(): number;
    set internalIpv6PrefixLength(value: number);
    resetInternalIpv6PrefixLength(): void;
    get internalIpv6PrefixLengthInput(): number | undefined;
    get ipv6AccessType(): string;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkAttachment?;
    get networkAttachment(): string;
    set networkAttachment(value: string);
    resetNetworkAttachment(): void;
    get networkAttachmentInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageNetworkInterfaceOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig {
    /**
    * The egress bandwidth tier to enable. Possible values:TIER_1, DEFAULT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#total_egress_bandwidth_tier GoogleComputeInstanceFromMachineImage#total_egress_bandwidth_tier}
    */
    readonly totalEgressBandwidthTier: string;
}
export declare function googleComputeInstanceFromMachineImageNetworkPerformanceConfigToTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkPerformanceConfigOutputReference | GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig): any;
export declare function googleComputeInstanceFromMachineImageNetworkPerformanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageNetworkPerformanceConfigOutputReference | GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig): any;
export declare class GoogleComputeInstanceFromMachineImageNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig | undefined);
    private _totalEgressBandwidthTier?;
    get totalEgressBandwidthTier(): string;
    set totalEgressBandwidthTier(value: string);
    get totalEgressBandwidthTierInput(): string | undefined;
}
export interface GoogleComputeInstanceFromMachineImageParams {
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#resource_manager_tags GoogleComputeInstanceFromMachineImage#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
}
export declare function googleComputeInstanceFromMachineImageParamsToTerraform(struct?: GoogleComputeInstanceFromMachineImageParamsOutputReference | GoogleComputeInstanceFromMachineImageParams): any;
export declare function googleComputeInstanceFromMachineImageParamsToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageParamsOutputReference | GoogleComputeInstanceFromMachineImageParams): any;
export declare class GoogleComputeInstanceFromMachineImageParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageParams | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageParams | undefined);
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#key GoogleComputeInstanceFromMachineImage#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#values GoogleComputeInstanceFromMachineImage#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceFromMachineImageReservationAffinitySpecificReservationToTerraform(struct?: GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation): any;
export declare function googleComputeInstanceFromMachineImageReservationAffinitySpecificReservationToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation): any;
export declare class GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleComputeInstanceFromMachineImageReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#type GoogleComputeInstanceFromMachineImage#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#specific_reservation GoogleComputeInstanceFromMachineImage#specific_reservation}
    */
    readonly specificReservation?: GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation;
}
export declare function googleComputeInstanceFromMachineImageReservationAffinityToTerraform(struct?: GoogleComputeInstanceFromMachineImageReservationAffinityOutputReference | GoogleComputeInstanceFromMachineImageReservationAffinity): any;
export declare function googleComputeInstanceFromMachineImageReservationAffinityToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageReservationAffinityOutputReference | GoogleComputeInstanceFromMachineImageReservationAffinity): any;
export declare class GoogleComputeInstanceFromMachineImageReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageReservationAffinity | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): GoogleComputeInstanceFromMachineImageReservationAffinitySpecificReservation | undefined;
}
export interface GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#nanos GoogleComputeInstanceFromMachineImage#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#seconds GoogleComputeInstanceFromMachineImage#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout): any;
export declare function googleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout): any;
export declare class GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#nanos GoogleComputeInstanceFromMachineImage#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#seconds GoogleComputeInstanceFromMachineImage#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceFromMachineImageSchedulingMaxRunDurationToTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration): any;
export declare function googleComputeInstanceFromMachineImageSchedulingMaxRunDurationToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration): any;
export declare class GoogleComputeInstanceFromMachineImageSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#key GoogleComputeInstanceFromMachineImage#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#operator GoogleComputeInstanceFromMachineImage#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#values GoogleComputeInstanceFromMachineImage#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceFromMachineImageSchedulingNodeAffinitiesToTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageSchedulingNodeAffinitiesToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleComputeInstanceFromMachineImageSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromMachineImageSchedulingNodeAffinitiesOutputReference;
}
export interface GoogleComputeInstanceFromMachineImageScheduling {
    /**
    * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#automatic_restart GoogleComputeInstanceFromMachineImage#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#instance_termination_action GoogleComputeInstanceFromMachineImage#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Specifies the frequency of planned maintenance events. The accepted values are: PERIODIC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#maintenance_interval GoogleComputeInstanceFromMachineImage#maintenance_interval}
    */
    readonly maintenanceInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#min_node_cpus GoogleComputeInstanceFromMachineImage#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#on_host_maintenance GoogleComputeInstanceFromMachineImage#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Whether the instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#preemptible GoogleComputeInstanceFromMachineImage#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#provisioning_model GoogleComputeInstanceFromMachineImage#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * local_ssd_recovery_timeout block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#local_ssd_recovery_timeout GoogleComputeInstanceFromMachineImage#local_ssd_recovery_timeout}
    */
    readonly localSsdRecoveryTimeout?: GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout;
    /**
    * max_run_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#max_run_duration GoogleComputeInstanceFromMachineImage#max_run_duration}
    */
    readonly maxRunDuration?: GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#node_affinities GoogleComputeInstanceFromMachineImage#node_affinities}
    */
    readonly nodeAffinities?: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromMachineImageSchedulingToTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingOutputReference | GoogleComputeInstanceFromMachineImageScheduling): any;
export declare function googleComputeInstanceFromMachineImageSchedulingToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageSchedulingOutputReference | GoogleComputeInstanceFromMachineImageScheduling): any;
export declare class GoogleComputeInstanceFromMachineImageSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageScheduling | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    resetMaintenanceInterval(): void;
    get maintenanceIntervalInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeoutOutputReference;
    putLocalSsdRecoveryTimeout(value: GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout): void;
    resetLocalSsdRecoveryTimeout(): void;
    get localSsdRecoveryTimeoutInput(): GoogleComputeInstanceFromMachineImageSchedulingLocalSsdRecoveryTimeout | undefined;
    private _maxRunDuration;
    get maxRunDuration(): GoogleComputeInstanceFromMachineImageSchedulingMaxRunDurationOutputReference;
    putMaxRunDuration(value: GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration): void;
    resetMaxRunDuration(): void;
    get maxRunDurationInput(): GoogleComputeInstanceFromMachineImageSchedulingMaxRunDuration | undefined;
    private _nodeAffinities;
    get nodeAffinities(): GoogleComputeInstanceFromMachineImageSchedulingNodeAffinitiesList;
    putNodeAffinities(value: GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageSchedulingNodeAffinities[] | undefined;
}
export interface GoogleComputeInstanceFromMachineImageShieldedInstanceConfig {
    /**
    * Whether integrity monitoring is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_integrity_monitoring GoogleComputeInstanceFromMachineImage#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether secure boot is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_secure_boot GoogleComputeInstanceFromMachineImage#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance uses vTPM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#enable_vtpm GoogleComputeInstanceFromMachineImage#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromMachineImageShieldedInstanceConfigToTerraform(struct?: GoogleComputeInstanceFromMachineImageShieldedInstanceConfigOutputReference | GoogleComputeInstanceFromMachineImageShieldedInstanceConfig): any;
export declare function googleComputeInstanceFromMachineImageShieldedInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageShieldedInstanceConfigOutputReference | GoogleComputeInstanceFromMachineImageShieldedInstanceConfig): any;
export declare class GoogleComputeInstanceFromMachineImageShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceFromMachineImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#create GoogleComputeInstanceFromMachineImage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#delete GoogleComputeInstanceFromMachineImage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#update GoogleComputeInstanceFromMachineImage#update}
    */
    readonly update?: string;
}
export declare function googleComputeInstanceFromMachineImageTimeoutsToTerraform(struct?: GoogleComputeInstanceFromMachineImageTimeouts | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromMachineImageTimeoutsToHclTerraform(struct?: GoogleComputeInstanceFromMachineImageTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromMachineImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromMachineImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromMachineImageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image google_compute_instance_from_machine_image}
*/
export declare class GoogleComputeInstanceFromMachineImage extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_from_machine_image";
    /**
    * Generates CDKTF code for importing a GoogleComputeInstanceFromMachineImage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeInstanceFromMachineImage to import
    * @param importFromId The id of the existing GoogleComputeInstanceFromMachineImage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeInstanceFromMachineImage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_machine_image google_compute_instance_from_machine_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceFromMachineImageConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceFromMachineImageConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _attachedDisk;
    get attachedDisk(): GoogleComputeInstanceFromMachineImageAttachedDiskList;
    private _bootDisk;
    get bootDisk(): GoogleComputeInstanceFromMachineImageBootDiskList;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string;
    set desiredStatus(value: string);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleComputeInstanceFromMachineImageGuestAcceleratorList;
    putGuestAccelerator(value: GoogleComputeInstanceFromMachineImageGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _scratchDisk;
    get scratchDisk(): GoogleComputeInstanceFromMachineImageScratchDiskList;
    get selfLink(): string;
    private _serviceAccount;
    get serviceAccount(): GoogleComputeInstanceFromMachineImageServiceAccountList;
    putServiceAccount(value: GoogleComputeInstanceFromMachineImageServiceAccount[] | cdktf.IResolvable): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageServiceAccount[] | undefined;
    private _sourceMachineImage?;
    get sourceMachineImage(): string;
    set sourceMachineImage(value: string);
    get sourceMachineImageInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleComputeInstanceFromMachineImageAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleComputeInstanceFromMachineImageAdvancedMachineFeatures | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleComputeInstanceFromMachineImageConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleComputeInstanceFromMachineImageConfidentialInstanceConfig | undefined;
    private _networkInterface;
    get networkInterface(): GoogleComputeInstanceFromMachineImageNetworkInterfaceList;
    putNetworkInterface(value: GoogleComputeInstanceFromMachineImageNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageNetworkInterface[] | undefined;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): GoogleComputeInstanceFromMachineImageNetworkPerformanceConfigOutputReference;
    putNetworkPerformanceConfig(value: GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig): void;
    resetNetworkPerformanceConfig(): void;
    get networkPerformanceConfigInput(): GoogleComputeInstanceFromMachineImageNetworkPerformanceConfig | undefined;
    private _params;
    get params(): GoogleComputeInstanceFromMachineImageParamsOutputReference;
    putParams(value: GoogleComputeInstanceFromMachineImageParams): void;
    resetParams(): void;
    get paramsInput(): GoogleComputeInstanceFromMachineImageParams | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleComputeInstanceFromMachineImageReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleComputeInstanceFromMachineImageReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleComputeInstanceFromMachineImageReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): GoogleComputeInstanceFromMachineImageSchedulingOutputReference;
    putScheduling(value: GoogleComputeInstanceFromMachineImageScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleComputeInstanceFromMachineImageScheduling | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleComputeInstanceFromMachineImageShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleComputeInstanceFromMachineImageShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleComputeInstanceFromMachineImageShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceFromMachineImageTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceFromMachineImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceFromMachineImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
