/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceFromTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires stopping the instance without setting this field, the update will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#allow_stopping_for_update GoogleComputeInstanceFromTemplate#allow_stopping_for_update}
    */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
    * List of disks attached to the instance
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#attached_disk GoogleComputeInstanceFromTemplate#attached_disk}
    */
    readonly attachedDisk?: GoogleComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable;
    /**
    * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#can_ip_forward GoogleComputeInstanceFromTemplate#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Whether deletion protection is enabled on this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#deletion_protection GoogleComputeInstanceFromTemplate#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * A brief description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#description GoogleComputeInstanceFromTemplate#description}
    */
    readonly description?: string;
    /**
    * Desired status of the instance. Either "RUNNING" or "TERMINATED".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#desired_status GoogleComputeInstanceFromTemplate#desired_status}
    */
    readonly desiredStatus?: string;
    /**
    * Whether the instance has virtual displays enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_display GoogleComputeInstanceFromTemplate#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#guest_accelerator GoogleComputeInstanceFromTemplate#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#hostname GoogleComputeInstanceFromTemplate#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#id GoogleComputeInstanceFromTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs assigned to the instance.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#labels GoogleComputeInstanceFromTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#machine_type GoogleComputeInstanceFromTemplate#machine_type}
    */
    readonly machineType?: string;
    /**
    * Metadata key/value pairs made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#metadata GoogleComputeInstanceFromTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Metadata startup scripts made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#metadata_startup_script GoogleComputeInstanceFromTemplate#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * The minimum CPU platform specified for the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#min_cpu_platform GoogleComputeInstanceFromTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#name GoogleComputeInstanceFromTemplate#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#project GoogleComputeInstanceFromTemplate#project}
    */
    readonly project?: string;
    /**
    * A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#resource_policies GoogleComputeInstanceFromTemplate#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The scratch disks attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#scratch_disk GoogleComputeInstanceFromTemplate#scratch_disk}
    */
    readonly scratchDisk?: GoogleComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable;
    /**
    * The service account to attach to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#service_account GoogleComputeInstanceFromTemplate#service_account}
    */
    readonly serviceAccount?: GoogleComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable;
    /**
    * Name or self link of an instance template to create the instance based on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#source_instance_template GoogleComputeInstanceFromTemplate#source_instance_template}
    */
    readonly sourceInstanceTemplate: string;
    /**
    * The list of tags attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#tags GoogleComputeInstanceFromTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#zone GoogleComputeInstanceFromTemplate#zone}
    */
    readonly zone?: string;
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#advanced_machine_features GoogleComputeInstanceFromTemplate#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleComputeInstanceFromTemplateAdvancedMachineFeatures;
    /**
    * boot_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#boot_disk GoogleComputeInstanceFromTemplate#boot_disk}
    */
    readonly bootDisk?: GoogleComputeInstanceFromTemplateBootDisk;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#confidential_instance_config GoogleComputeInstanceFromTemplate#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleComputeInstanceFromTemplateConfidentialInstanceConfig;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_interface GoogleComputeInstanceFromTemplate#network_interface}
    */
    readonly networkInterface?: GoogleComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * network_performance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_performance_config GoogleComputeInstanceFromTemplate#network_performance_config}
    */
    readonly networkPerformanceConfig?: GoogleComputeInstanceFromTemplateNetworkPerformanceConfig;
    /**
    * params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#params GoogleComputeInstanceFromTemplate#params}
    */
    readonly params?: GoogleComputeInstanceFromTemplateParams;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#reservation_affinity GoogleComputeInstanceFromTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleComputeInstanceFromTemplateReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#scheduling GoogleComputeInstanceFromTemplate#scheduling}
    */
    readonly scheduling?: GoogleComputeInstanceFromTemplateScheduling;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#shielded_instance_config GoogleComputeInstanceFromTemplate#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleComputeInstanceFromTemplateShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#timeouts GoogleComputeInstanceFromTemplate#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceFromTemplateTimeouts;
}
export interface GoogleComputeInstanceFromTemplateAttachedDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#device_name GoogleComputeInstanceFromTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#disk_encryption_key_raw GoogleComputeInstanceFromTemplate#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#disk_encryption_key_sha256 GoogleComputeInstanceFromTemplate#disk_encryption_key_sha256}
    */
    readonly diskEncryptionKeySha256?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#kms_key_self_link GoogleComputeInstanceFromTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#mode GoogleComputeInstanceFromTemplate#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#source GoogleComputeInstanceFromTemplate#source}
    */
    readonly source?: string;
}
export declare function googleComputeInstanceFromTemplateAttachedDiskToTerraform(struct?: GoogleComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateAttachedDiskToHclTerraform(struct?: GoogleComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateAttachedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateAttachedDisk | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    private _diskEncryptionKeySha256?;
    get diskEncryptionKeySha256(): string;
    set diskEncryptionKeySha256(value: string);
    resetDiskEncryptionKeySha256(): void;
    get diskEncryptionKeySha256Input(): string | undefined;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromTemplateAttachedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateAttachedDiskOutputReference;
}
export interface GoogleComputeInstanceFromTemplateGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#count GoogleComputeInstanceFromTemplate#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#type GoogleComputeInstanceFromTemplate#type}
    */
    readonly type?: string;
}
export declare function googleComputeInstanceFromTemplateGuestAcceleratorToTerraform(struct?: GoogleComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateGuestAcceleratorToHclTerraform(struct?: GoogleComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateGuestAcceleratorOutputReference;
}
export interface GoogleComputeInstanceFromTemplateScratchDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#device_name GoogleComputeInstanceFromTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#interface GoogleComputeInstanceFromTemplate#interface}
    */
    readonly interface?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#size GoogleComputeInstanceFromTemplate#size}
    */
    readonly size?: number;
}
export declare function googleComputeInstanceFromTemplateScratchDiskToTerraform(struct?: GoogleComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateScratchDiskToHclTerraform(struct?: GoogleComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateScratchDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateScratchDisk | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
}
export declare class GoogleComputeInstanceFromTemplateScratchDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateScratchDiskOutputReference;
}
export interface GoogleComputeInstanceFromTemplateServiceAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#email GoogleComputeInstanceFromTemplate#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#scopes GoogleComputeInstanceFromTemplate#scopes}
    */
    readonly scopes?: string[];
}
export declare function googleComputeInstanceFromTemplateServiceAccountToTerraform(struct?: GoogleComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateServiceAccountToHclTerraform(struct?: GoogleComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateServiceAccount | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
}
export declare class GoogleComputeInstanceFromTemplateServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateServiceAccountOutputReference;
}
export interface GoogleComputeInstanceFromTemplateAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_nested_virtualization GoogleComputeInstanceFromTemplate#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#threads_per_core GoogleComputeInstanceFromTemplate#threads_per_core}
    */
    readonly threadsPerCore?: number;
    /**
    * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance\'s nominal CPU count and the underlying platform\'s SMT width.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#visible_core_count GoogleComputeInstanceFromTemplate#visible_core_count}
    */
    readonly visibleCoreCount?: number;
}
export declare function googleComputeInstanceFromTemplateAdvancedMachineFeaturesToTerraform(struct?: GoogleComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceFromTemplateAdvancedMachineFeatures): any;
export declare function googleComputeInstanceFromTemplateAdvancedMachineFeaturesToHclTerraform(struct?: GoogleComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceFromTemplateAdvancedMachineFeatures): any;
export declare class GoogleComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
    private _visibleCoreCount?;
    get visibleCoreCount(): number;
    set visibleCoreCount(value: number);
    resetVisibleCoreCount(): void;
    get visibleCoreCountInput(): number | undefined;
}
export interface GoogleComputeInstanceFromTemplateBootDiskInitializeParams {
    /**
    * A flag to enable confidential compute mode on boot disk
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_confidential_compute GoogleComputeInstanceFromTemplate#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
    /**
    * The image from which this disk was initialised.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#image GoogleComputeInstanceFromTemplate#image}
    */
    readonly image?: string;
    /**
    * A set of key/value label pairs assigned to the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#labels GoogleComputeInstanceFromTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#provisioned_iops GoogleComputeInstanceFromTemplate#provisioned_iops}
    */
    readonly provisionedIops?: number;
    /**
    * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#provisioned_throughput GoogleComputeInstanceFromTemplate#provisioned_throughput}
    */
    readonly provisionedThroughput?: number;
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#resource_manager_tags GoogleComputeInstanceFromTemplate#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * The size of the image in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#size GoogleComputeInstanceFromTemplate#size}
    */
    readonly size?: number;
    /**
    * The Google Compute Engine disk type. Such as pd-standard, pd-ssd or pd-balanced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#type GoogleComputeInstanceFromTemplate#type}
    */
    readonly type?: string;
}
export declare function googleComputeInstanceFromTemplateBootDiskInitializeParamsToTerraform(struct?: GoogleComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference | GoogleComputeInstanceFromTemplateBootDiskInitializeParams): any;
export declare function googleComputeInstanceFromTemplateBootDiskInitializeParamsToHclTerraform(struct?: GoogleComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference | GoogleComputeInstanceFromTemplateBootDiskInitializeParams): any;
export declare class GoogleComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateBootDiskInitializeParams | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _provisionedIops?;
    get provisionedIops(): number;
    set provisionedIops(value: number);
    resetProvisionedIops(): void;
    get provisionedIopsInput(): number | undefined;
    private _provisionedThroughput?;
    get provisionedThroughput(): number;
    set provisionedThroughput(value: number);
    resetProvisionedThroughput(): void;
    get provisionedThroughputInput(): number | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleComputeInstanceFromTemplateBootDisk {
    /**
    * Whether the disk will be auto-deleted when the instance is deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#auto_delete GoogleComputeInstanceFromTemplate#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Name with which attached disk will be accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#device_name GoogleComputeInstanceFromTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#disk_encryption_key_raw GoogleComputeInstanceFromTemplate#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#kms_key_self_link GoogleComputeInstanceFromTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#mode GoogleComputeInstanceFromTemplate#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#source GoogleComputeInstanceFromTemplate#source}
    */
    readonly source?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#initialize_params GoogleComputeInstanceFromTemplate#initialize_params}
    */
    readonly initializeParams?: GoogleComputeInstanceFromTemplateBootDiskInitializeParams;
}
export declare function googleComputeInstanceFromTemplateBootDiskToTerraform(struct?: GoogleComputeInstanceFromTemplateBootDiskOutputReference | GoogleComputeInstanceFromTemplateBootDisk): any;
export declare function googleComputeInstanceFromTemplateBootDiskToHclTerraform(struct?: GoogleComputeInstanceFromTemplateBootDiskOutputReference | GoogleComputeInstanceFromTemplateBootDisk): any;
export declare class GoogleComputeInstanceFromTemplateBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateBootDisk | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateBootDisk | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    get diskEncryptionKeySha256(): string;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): GoogleComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: GoogleComputeInstanceFromTemplateBootDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): GoogleComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
}
export interface GoogleComputeInstanceFromTemplateConfidentialInstanceConfig {
    /**
    *
    * 								Specifies which confidential computing technology to use.
    * 								This could be one of the following values: SEV, SEV_SNP.
    * 								If SEV_SNP, min_cpu_platform = "AMD Milan" is currently required.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#confidential_instance_type GoogleComputeInstanceFromTemplate#confidential_instance_type}
    */
    readonly confidentialInstanceType?: string;
    /**
    * Defines whether the instance should have confidential compute enabled. Field will be deprecated in a future release
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_confidential_compute GoogleComputeInstanceFromTemplate#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromTemplateConfidentialInstanceConfigToTerraform(struct?: GoogleComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference | GoogleComputeInstanceFromTemplateConfidentialInstanceConfig): any;
export declare function googleComputeInstanceFromTemplateConfidentialInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference | GoogleComputeInstanceFromTemplateConfidentialInstanceConfig): any;
export declare class GoogleComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateConfidentialInstanceConfig | undefined);
    private _confidentialInstanceType?;
    get confidentialInstanceType(): string;
    set confidentialInstanceType(value: string);
    resetConfidentialInstanceType(): void;
    get confidentialInstanceTypeInput(): string | undefined;
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#nat_ip GoogleComputeInstanceFromTemplate#nat_ip}
    */
    readonly natIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_tier GoogleComputeInstanceFromTemplate#network_tier}
    */
    readonly networkTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#public_ptr_domain_name GoogleComputeInstanceFromTemplate#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#security_policy GoogleComputeInstanceFromTemplate#security_policy}
    */
    readonly securityPolicy?: string;
}
export declare function googleComputeInstanceFromTemplateNetworkInterfaceAccessConfigToTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateNetworkInterfaceAccessConfigToHclTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#ip_cidr_range GoogleComputeInstanceFromTemplate#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#subnetwork_range_name GoogleComputeInstanceFromTemplate#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function googleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeToHclTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig {
    /**
    * The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#external_ipv6 GoogleComputeInstanceFromTemplate#external_ipv6}
    */
    readonly externalIpv6?: string;
    /**
    * The prefix length of the external IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#external_ipv6_prefix_length GoogleComputeInstanceFromTemplate#external_ipv6_prefix_length}
    */
    readonly externalIpv6PrefixLength?: string;
    /**
    * The name of this access configuration. In ipv6AccessConfigs, the recommended name is External IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#name GoogleComputeInstanceFromTemplate#name}
    */
    readonly name?: string;
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_tier GoogleComputeInstanceFromTemplate#network_tier}
    */
    readonly networkTier: string;
    /**
    * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#public_ptr_domain_name GoogleComputeInstanceFromTemplate#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function googleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    private _externalIpv6?;
    get externalIpv6(): string;
    set externalIpv6(value: string);
    resetExternalIpv6(): void;
    get externalIpv6Input(): string | undefined;
    private _externalIpv6PrefixLength?;
    get externalIpv6PrefixLength(): string;
    set externalIpv6PrefixLength(value: string);
    resetExternalIpv6PrefixLength(): void;
    get externalIpv6PrefixLengthInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    get securityPolicy(): string;
}
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface GoogleComputeInstanceFromTemplateNetworkInterface {
    /**
    * Access configurations, i.e. IPs via which this instance can be accessed via the Internet.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#access_config GoogleComputeInstanceFromTemplate#access_config}
    */
    readonly accessConfig?: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * An array of alias IP ranges for this network interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#alias_ip_range GoogleComputeInstanceFromTemplate#alias_ip_range}
    */
    readonly aliasIpRange?: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * The prefix length of the primary internal IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#internal_ipv6_prefix_length GoogleComputeInstanceFromTemplate#internal_ipv6_prefix_length}
    */
    readonly internalIpv6PrefixLength?: number;
    /**
    * An IPv6 internal network address for this network interface. If not specified, Google Cloud will automatically assign an internal IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#ipv6_address GoogleComputeInstanceFromTemplate#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The name or self_link of the network attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network GoogleComputeInstanceFromTemplate#network}
    */
    readonly network?: string;
    /**
    * The URL of the network attachment that this interface should connect to in the following format: projects/{projectNumber}/regions/{region_name}/networkAttachments/{network_attachment_name}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_attachment GoogleComputeInstanceFromTemplate#network_attachment}
    */
    readonly networkAttachment?: string;
    /**
    * The private IP address assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#network_ip GoogleComputeInstanceFromTemplate#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#nic_type GoogleComputeInstanceFromTemplate#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#queue_count GoogleComputeInstanceFromTemplate#queue_count}
    */
    readonly queueCount?: number;
    /**
    * A full or partial URL to a security policy to add to this instance. If this field is set to an empty string it will remove the associated security policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#security_policy GoogleComputeInstanceFromTemplate#security_policy}
    */
    readonly securityPolicy?: string;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#stack_type GoogleComputeInstanceFromTemplate#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name or self_link of the subnetwork attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#subnetwork GoogleComputeInstanceFromTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The project in which the subnetwork belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#subnetwork_project GoogleComputeInstanceFromTemplate#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#ipv6_access_config GoogleComputeInstanceFromTemplate#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromTemplateNetworkInterfaceToTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateNetworkInterfaceToHclTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateNetworkInterface | cdktf.IResolvable | undefined);
    private _accessConfig;
    get accessConfig(): GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfigList;
    putAccessConfig(value: GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[] | undefined;
    private _internalIpv6PrefixLength?;
    get internalIpv6PrefixLength(): number;
    set internalIpv6PrefixLength(value: number);
    resetInternalIpv6PrefixLength(): void;
    get internalIpv6PrefixLengthInput(): number | undefined;
    get ipv6AccessType(): string;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkAttachment?;
    get networkAttachment(): string;
    set networkAttachment(value: string);
    resetNetworkAttachment(): void;
    get networkAttachmentInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class GoogleComputeInstanceFromTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateNetworkInterfaceOutputReference;
}
export interface GoogleComputeInstanceFromTemplateNetworkPerformanceConfig {
    /**
    * The egress bandwidth tier to enable. Possible values:TIER_1, DEFAULT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#total_egress_bandwidth_tier GoogleComputeInstanceFromTemplate#total_egress_bandwidth_tier}
    */
    readonly totalEgressBandwidthTier: string;
}
export declare function googleComputeInstanceFromTemplateNetworkPerformanceConfigToTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkPerformanceConfigOutputReference | GoogleComputeInstanceFromTemplateNetworkPerformanceConfig): any;
export declare function googleComputeInstanceFromTemplateNetworkPerformanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromTemplateNetworkPerformanceConfigOutputReference | GoogleComputeInstanceFromTemplateNetworkPerformanceConfig): any;
export declare class GoogleComputeInstanceFromTemplateNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateNetworkPerformanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateNetworkPerformanceConfig | undefined);
    private _totalEgressBandwidthTier?;
    get totalEgressBandwidthTier(): string;
    set totalEgressBandwidthTier(value: string);
    get totalEgressBandwidthTierInput(): string | undefined;
}
export interface GoogleComputeInstanceFromTemplateParams {
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#resource_manager_tags GoogleComputeInstanceFromTemplate#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
}
export declare function googleComputeInstanceFromTemplateParamsToTerraform(struct?: GoogleComputeInstanceFromTemplateParamsOutputReference | GoogleComputeInstanceFromTemplateParams): any;
export declare function googleComputeInstanceFromTemplateParamsToHclTerraform(struct?: GoogleComputeInstanceFromTemplateParamsOutputReference | GoogleComputeInstanceFromTemplateParams): any;
export declare class GoogleComputeInstanceFromTemplateParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateParams | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateParams | undefined);
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#key GoogleComputeInstanceFromTemplate#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#values GoogleComputeInstanceFromTemplate#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceFromTemplateReservationAffinitySpecificReservationToTerraform(struct?: GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation): any;
export declare function googleComputeInstanceFromTemplateReservationAffinitySpecificReservationToHclTerraform(struct?: GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation): any;
export declare class GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleComputeInstanceFromTemplateReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#type GoogleComputeInstanceFromTemplate#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#specific_reservation GoogleComputeInstanceFromTemplate#specific_reservation}
    */
    readonly specificReservation?: GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation;
}
export declare function googleComputeInstanceFromTemplateReservationAffinityToTerraform(struct?: GoogleComputeInstanceFromTemplateReservationAffinityOutputReference | GoogleComputeInstanceFromTemplateReservationAffinity): any;
export declare function googleComputeInstanceFromTemplateReservationAffinityToHclTerraform(struct?: GoogleComputeInstanceFromTemplateReservationAffinityOutputReference | GoogleComputeInstanceFromTemplateReservationAffinity): any;
export declare class GoogleComputeInstanceFromTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateReservationAffinity | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): GoogleComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
}
export interface GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#nanos GoogleComputeInstanceFromTemplate#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#seconds GoogleComputeInstanceFromTemplate#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare function googleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare class GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#nanos GoogleComputeInstanceFromTemplate#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#seconds GoogleComputeInstanceFromTemplate#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceFromTemplateSchedulingMaxRunDurationToTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration): any;
export declare function googleComputeInstanceFromTemplateSchedulingMaxRunDurationToHclTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration): any;
export declare class GoogleComputeInstanceFromTemplateSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceFromTemplateSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#key GoogleComputeInstanceFromTemplate#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#operator GoogleComputeInstanceFromTemplate#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#values GoogleComputeInstanceFromTemplate#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceFromTemplateSchedulingNodeAffinitiesToTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateSchedulingNodeAffinitiesToHclTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleComputeInstanceFromTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceFromTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface GoogleComputeInstanceFromTemplateScheduling {
    /**
    * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#automatic_restart GoogleComputeInstanceFromTemplate#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#instance_termination_action GoogleComputeInstanceFromTemplate#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Specifies the frequency of planned maintenance events. The accepted values are: PERIODIC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#maintenance_interval GoogleComputeInstanceFromTemplate#maintenance_interval}
    */
    readonly maintenanceInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#min_node_cpus GoogleComputeInstanceFromTemplate#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#on_host_maintenance GoogleComputeInstanceFromTemplate#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Whether the instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#preemptible GoogleComputeInstanceFromTemplate#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#provisioning_model GoogleComputeInstanceFromTemplate#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * local_ssd_recovery_timeout block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#local_ssd_recovery_timeout GoogleComputeInstanceFromTemplate#local_ssd_recovery_timeout}
    */
    readonly localSsdRecoveryTimeout?: GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout;
    /**
    * max_run_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#max_run_duration GoogleComputeInstanceFromTemplate#max_run_duration}
    */
    readonly maxRunDuration?: GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#node_affinities GoogleComputeInstanceFromTemplate#node_affinities}
    */
    readonly nodeAffinities?: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromTemplateSchedulingToTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingOutputReference | GoogleComputeInstanceFromTemplateScheduling): any;
export declare function googleComputeInstanceFromTemplateSchedulingToHclTerraform(struct?: GoogleComputeInstanceFromTemplateSchedulingOutputReference | GoogleComputeInstanceFromTemplateScheduling): any;
export declare class GoogleComputeInstanceFromTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateScheduling | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    resetMaintenanceInterval(): void;
    get maintenanceIntervalInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference;
    putLocalSsdRecoveryTimeout(value: GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout): void;
    resetLocalSsdRecoveryTimeout(): void;
    get localSsdRecoveryTimeoutInput(): GoogleComputeInstanceFromTemplateSchedulingLocalSsdRecoveryTimeout | undefined;
    private _maxRunDuration;
    get maxRunDuration(): GoogleComputeInstanceFromTemplateSchedulingMaxRunDurationOutputReference;
    putMaxRunDuration(value: GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration): void;
    resetMaxRunDuration(): void;
    get maxRunDurationInput(): GoogleComputeInstanceFromTemplateSchedulingMaxRunDuration | undefined;
    private _nodeAffinities;
    get nodeAffinities(): GoogleComputeInstanceFromTemplateSchedulingNodeAffinitiesList;
    putNodeAffinities(value: GoogleComputeInstanceFromTemplateSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined;
}
export interface GoogleComputeInstanceFromTemplateShieldedInstanceConfig {
    /**
    * Whether integrity monitoring is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_integrity_monitoring GoogleComputeInstanceFromTemplate#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether secure boot is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_secure_boot GoogleComputeInstanceFromTemplate#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance uses vTPM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#enable_vtpm GoogleComputeInstanceFromTemplate#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceFromTemplateShieldedInstanceConfigToTerraform(struct?: GoogleComputeInstanceFromTemplateShieldedInstanceConfigOutputReference | GoogleComputeInstanceFromTemplateShieldedInstanceConfig): any;
export declare function googleComputeInstanceFromTemplateShieldedInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceFromTemplateShieldedInstanceConfigOutputReference | GoogleComputeInstanceFromTemplateShieldedInstanceConfig): any;
export declare class GoogleComputeInstanceFromTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceFromTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#create GoogleComputeInstanceFromTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#delete GoogleComputeInstanceFromTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#update GoogleComputeInstanceFromTemplate#update}
    */
    readonly update?: string;
}
export declare function googleComputeInstanceFromTemplateTimeoutsToTerraform(struct?: GoogleComputeInstanceFromTemplateTimeouts | cdktf.IResolvable): any;
export declare function googleComputeInstanceFromTemplateTimeoutsToHclTerraform(struct?: GoogleComputeInstanceFromTemplateTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceFromTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceFromTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceFromTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template google_compute_instance_from_template}
*/
export declare class GoogleComputeInstanceFromTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_from_template";
    /**
    * Generates CDKTF code for importing a GoogleComputeInstanceFromTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeInstanceFromTemplate to import
    * @param importFromId The id of the existing GoogleComputeInstanceFromTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeInstanceFromTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_from_template google_compute_instance_from_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceFromTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceFromTemplateConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _attachedDisk;
    get attachedDisk(): GoogleComputeInstanceFromTemplateAttachedDiskList;
    putAttachedDisk(value: GoogleComputeInstanceFromTemplateAttachedDisk[] | cdktf.IResolvable): void;
    resetAttachedDisk(): void;
    get attachedDiskInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateAttachedDisk[] | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string;
    set desiredStatus(value: string);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleComputeInstanceFromTemplateGuestAcceleratorList;
    putGuestAccelerator(value: GoogleComputeInstanceFromTemplateGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _scratchDisk;
    get scratchDisk(): GoogleComputeInstanceFromTemplateScratchDiskList;
    putScratchDisk(value: GoogleComputeInstanceFromTemplateScratchDisk[] | cdktf.IResolvable): void;
    resetScratchDisk(): void;
    get scratchDiskInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateScratchDisk[] | undefined;
    get selfLink(): string;
    private _serviceAccount;
    get serviceAccount(): GoogleComputeInstanceFromTemplateServiceAccountList;
    putServiceAccount(value: GoogleComputeInstanceFromTemplateServiceAccount[] | cdktf.IResolvable): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateServiceAccount[] | undefined;
    private _sourceInstanceTemplate?;
    get sourceInstanceTemplate(): string;
    set sourceInstanceTemplate(value: string);
    get sourceInstanceTemplateInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleComputeInstanceFromTemplateAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    private _bootDisk;
    get bootDisk(): GoogleComputeInstanceFromTemplateBootDiskOutputReference;
    putBootDisk(value: GoogleComputeInstanceFromTemplateBootDisk): void;
    resetBootDisk(): void;
    get bootDiskInput(): GoogleComputeInstanceFromTemplateBootDisk | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleComputeInstanceFromTemplateConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    private _networkInterface;
    get networkInterface(): GoogleComputeInstanceFromTemplateNetworkInterfaceList;
    putNetworkInterface(value: GoogleComputeInstanceFromTemplateNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateNetworkInterface[] | undefined;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): GoogleComputeInstanceFromTemplateNetworkPerformanceConfigOutputReference;
    putNetworkPerformanceConfig(value: GoogleComputeInstanceFromTemplateNetworkPerformanceConfig): void;
    resetNetworkPerformanceConfig(): void;
    get networkPerformanceConfigInput(): GoogleComputeInstanceFromTemplateNetworkPerformanceConfig | undefined;
    private _params;
    get params(): GoogleComputeInstanceFromTemplateParamsOutputReference;
    putParams(value: GoogleComputeInstanceFromTemplateParams): void;
    resetParams(): void;
    get paramsInput(): GoogleComputeInstanceFromTemplateParams | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleComputeInstanceFromTemplateReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleComputeInstanceFromTemplateReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleComputeInstanceFromTemplateReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): GoogleComputeInstanceFromTemplateSchedulingOutputReference;
    putScheduling(value: GoogleComputeInstanceFromTemplateScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleComputeInstanceFromTemplateScheduling | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleComputeInstanceFromTemplateShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleComputeInstanceFromTemplateShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceFromTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceFromTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceFromTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
