/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base instance name to use for instances in this group. The value must be a valid RFC1035 name. Supported characters are lowercase letters, numbers, and hyphens (-). Instances are named by appending a hyphen and a random four-character string to the base instance name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#base_instance_name GoogleComputeInstanceGroupManager#base_instance_name}
    */
    readonly baseInstanceName: string;
    /**
    * An optional textual description of the instance group manager.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#description GoogleComputeInstanceGroupManager#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#id GoogleComputeInstanceGroupManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Pagination behavior of the listManagedInstances API method for this managed instance group. Valid values are: "PAGELESS", "PAGINATED". If PAGELESS (default), Pagination is disabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are ignored and all instances are returned in a single response. If PAGINATED, pagination is enabled, maxResults and pageToken query parameters are respected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#list_managed_instances_results GoogleComputeInstanceGroupManager#list_managed_instances_results}
    */
    readonly listManagedInstancesResults?: string;
    /**
    * The name of the instance group manager. Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#name GoogleComputeInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#project GoogleComputeInstanceGroupManager#project}
    */
    readonly project?: string;
    /**
    * The full URL of all target pools to which new instances in the group are added. Updating the target pools attribute does not affect existing instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#target_pools GoogleComputeInstanceGroupManager#target_pools}
    */
    readonly targetPools?: string[];
    /**
    * The target number of running instances for this managed instance group. This value should always be explicitly set unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#target_size GoogleComputeInstanceGroupManager#target_size}
    */
    readonly targetSize?: number;
    /**
    * Whether to wait for all instances to be created/updated before returning. Note that if this is set to true and the operation does not succeed, Terraform will continue trying until it times out.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#wait_for_instances GoogleComputeInstanceGroupManager#wait_for_instances}
    */
    readonly waitForInstances?: boolean | cdktf.IResolvable;
    /**
    * When used with wait_for_instances specifies the status to wait for. When STABLE is specified this resource will wait until the instances are stable before returning. When UPDATED is set, it will wait for the version target to be reached and any per instance configs to be effective and all instances configs to be effective as well as all instances to be stable before returning.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#wait_for_instances_status GoogleComputeInstanceGroupManager#wait_for_instances_status}
    */
    readonly waitForInstancesStatus?: string;
    /**
    * The zone that instances in this group should be created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#zone GoogleComputeInstanceGroupManager#zone}
    */
    readonly zone?: string;
    /**
    * all_instances_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#all_instances_config GoogleComputeInstanceGroupManager#all_instances_config}
    */
    readonly allInstancesConfig?: GoogleComputeInstanceGroupManagerAllInstancesConfig;
    /**
    * auto_healing_policies block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#auto_healing_policies GoogleComputeInstanceGroupManager#auto_healing_policies}
    */
    readonly autoHealingPolicies?: GoogleComputeInstanceGroupManagerAutoHealingPolicies;
    /**
    * instance_lifecycle_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#instance_lifecycle_policy GoogleComputeInstanceGroupManager#instance_lifecycle_policy}
    */
    readonly instanceLifecyclePolicy?: GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy;
    /**
    * named_port block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#named_port GoogleComputeInstanceGroupManager#named_port}
    */
    readonly namedPort?: GoogleComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    /**
    * stateful_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#stateful_disk GoogleComputeInstanceGroupManager#stateful_disk}
    */
    readonly statefulDisk?: GoogleComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    /**
    * stateful_external_ip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#stateful_external_ip GoogleComputeInstanceGroupManager#stateful_external_ip}
    */
    readonly statefulExternalIp?: GoogleComputeInstanceGroupManagerStatefulExternalIp[] | cdktf.IResolvable;
    /**
    * stateful_internal_ip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#stateful_internal_ip GoogleComputeInstanceGroupManager#stateful_internal_ip}
    */
    readonly statefulInternalIp?: GoogleComputeInstanceGroupManagerStatefulInternalIp[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#timeouts GoogleComputeInstanceGroupManager#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceGroupManagerTimeouts;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#update_policy GoogleComputeInstanceGroupManager#update_policy}
    */
    readonly updatePolicy?: GoogleComputeInstanceGroupManagerUpdatePolicy;
    /**
    * version block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#version GoogleComputeInstanceGroupManager#version}
    */
    readonly version: GoogleComputeInstanceGroupManagerVersion[] | cdktf.IResolvable;
}
export interface GoogleComputeInstanceGroupManagerStatusAllInstancesConfig {
}
export declare function googleComputeInstanceGroupManagerStatusAllInstancesConfigToTerraform(struct?: GoogleComputeInstanceGroupManagerStatusAllInstancesConfig): any;
export declare function googleComputeInstanceGroupManagerStatusAllInstancesConfigToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatusAllInstancesConfig): any;
export declare class GoogleComputeInstanceGroupManagerStatusAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatusAllInstancesConfig | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatusAllInstancesConfig | undefined);
    get effective(): cdktf.IResolvable;
}
export declare class GoogleComputeInstanceGroupManagerStatusAllInstancesConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatusAllInstancesConfigOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs {
}
export declare function googleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsToTerraform(struct?: GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare function googleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare class GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined);
    get allEffective(): cdktf.IResolvable;
}
export declare class GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatusStateful {
}
export declare function googleComputeInstanceGroupManagerStatusStatefulToTerraform(struct?: GoogleComputeInstanceGroupManagerStatusStateful): any;
export declare function googleComputeInstanceGroupManagerStatusStatefulToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatusStateful): any;
export declare class GoogleComputeInstanceGroupManagerStatusStatefulOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatusStateful | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatusStateful | undefined);
    get hasStatefulConfig(): cdktf.IResolvable;
    private _perInstanceConfigs;
    get perInstanceConfigs(): GoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList;
}
export declare class GoogleComputeInstanceGroupManagerStatusStatefulList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatusStatefulOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatusVersionTarget {
}
export declare function googleComputeInstanceGroupManagerStatusVersionTargetToTerraform(struct?: GoogleComputeInstanceGroupManagerStatusVersionTarget): any;
export declare function googleComputeInstanceGroupManagerStatusVersionTargetToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatusVersionTarget): any;
export declare class GoogleComputeInstanceGroupManagerStatusVersionTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatusVersionTarget | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatusVersionTarget | undefined);
    get isReached(): cdktf.IResolvable;
}
export declare class GoogleComputeInstanceGroupManagerStatusVersionTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatusVersionTargetOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatus {
}
export declare function googleComputeInstanceGroupManagerStatusToTerraform(struct?: GoogleComputeInstanceGroupManagerStatus): any;
export declare function googleComputeInstanceGroupManagerStatusToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatus): any;
export declare class GoogleComputeInstanceGroupManagerStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatus | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatus | undefined);
    private _allInstancesConfig;
    get allInstancesConfig(): GoogleComputeInstanceGroupManagerStatusAllInstancesConfigList;
    get isStable(): cdktf.IResolvable;
    private _stateful;
    get stateful(): GoogleComputeInstanceGroupManagerStatusStatefulList;
    private _versionTarget;
    get versionTarget(): GoogleComputeInstanceGroupManagerStatusVersionTargetList;
}
export declare class GoogleComputeInstanceGroupManagerStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatusOutputReference;
}
export interface GoogleComputeInstanceGroupManagerAllInstancesConfig {
    /**
    * The label key-value pairs that you want to patch onto the instance,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#labels GoogleComputeInstanceGroupManager#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The metadata key-value pairs that you want to patch onto the instance. For more information, see Project and instance metadata,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#metadata GoogleComputeInstanceGroupManager#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
}
export declare function googleComputeInstanceGroupManagerAllInstancesConfigToTerraform(struct?: GoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference | GoogleComputeInstanceGroupManagerAllInstancesConfig): any;
export declare function googleComputeInstanceGroupManagerAllInstancesConfigToHclTerraform(struct?: GoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference | GoogleComputeInstanceGroupManagerAllInstancesConfig): any;
export declare class GoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerAllInstancesConfig | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerAllInstancesConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeInstanceGroupManagerAutoHealingPolicies {
    /**
    * The health check resource that signals autohealing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#health_check GoogleComputeInstanceGroupManager#health_check}
    */
    readonly healthCheck: string;
    /**
    * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. Between 0 and 3600.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#initial_delay_sec GoogleComputeInstanceGroupManager#initial_delay_sec}
    */
    readonly initialDelaySec: number;
}
export declare function googleComputeInstanceGroupManagerAutoHealingPoliciesToTerraform(struct?: GoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference | GoogleComputeInstanceGroupManagerAutoHealingPolicies): any;
export declare function googleComputeInstanceGroupManagerAutoHealingPoliciesToHclTerraform(struct?: GoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference | GoogleComputeInstanceGroupManagerAutoHealingPolicies): any;
export declare class GoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerAutoHealingPolicies | undefined);
    private _healthCheck?;
    get healthCheck(): string;
    set healthCheck(value: string);
    get healthCheckInput(): string | undefined;
    private _initialDelaySec?;
    get initialDelaySec(): number;
    set initialDelaySec(value: number);
    get initialDelaySecInput(): number | undefined;
}
export interface GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy {
    /**
    * Default behavior for all instance or health check failures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#default_action_on_failure GoogleComputeInstanceGroupManager#default_action_on_failure}
    */
    readonly defaultActionOnFailure?: string;
    /**
    * Specifies whether to apply the group's latest configuration when repairing a VM. Valid options are: YES, NO. If YES and you updated the group's instance template or per-instance configurations after the VM was created, then these changes are applied when VM is repaired. If NO (default), then updates are applied in accordance with the group's update policy type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#force_update_on_repair GoogleComputeInstanceGroupManager#force_update_on_repair}
    */
    readonly forceUpdateOnRepair?: string;
}
export declare function googleComputeInstanceGroupManagerInstanceLifecyclePolicyToTerraform(struct?: GoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference | GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy): any;
export declare function googleComputeInstanceGroupManagerInstanceLifecyclePolicyToHclTerraform(struct?: GoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference | GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy): any;
export declare class GoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy | undefined);
    private _defaultActionOnFailure?;
    get defaultActionOnFailure(): string;
    set defaultActionOnFailure(value: string);
    resetDefaultActionOnFailure(): void;
    get defaultActionOnFailureInput(): string | undefined;
    private _forceUpdateOnRepair?;
    get forceUpdateOnRepair(): string;
    set forceUpdateOnRepair(value: string);
    resetForceUpdateOnRepair(): void;
    get forceUpdateOnRepairInput(): string | undefined;
}
export interface GoogleComputeInstanceGroupManagerNamedPort {
    /**
    * The name of the port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#name GoogleComputeInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The port number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#port GoogleComputeInstanceGroupManager#port}
    */
    readonly port: number;
}
export declare function googleComputeInstanceGroupManagerNamedPortToTerraform(struct?: GoogleComputeInstanceGroupManagerNamedPort | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerNamedPortToHclTerraform(struct?: GoogleComputeInstanceGroupManagerNamedPort | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerNamedPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerNamedPort | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerNamedPort | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export declare class GoogleComputeInstanceGroupManagerNamedPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerNamedPortOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatefulDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted. The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the disk when the VM is deleted, but do not delete the disk. ON_PERMANENT_INSTANCE_DELETION will delete the stateful disk when the VM is permanently deleted from the instance group. The default is NEVER.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#delete_rule GoogleComputeInstanceGroupManager#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * The device name of the disk to be attached.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#device_name GoogleComputeInstanceGroupManager#device_name}
    */
    readonly deviceName: string;
}
export declare function googleComputeInstanceGroupManagerStatefulDiskToTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulDisk | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerStatefulDiskToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulDisk | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerStatefulDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatefulDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatefulDisk | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceGroupManagerStatefulDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatefulDiskOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatefulExternalIp {
    /**
    * A value that prescribes what should happen to an associated static Address resource when a VM instance is permanently deleted. The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the IP when the VM is deleted, but do not delete the address resource. ON_PERMANENT_INSTANCE_DELETION will delete the stateful address when the VM is permanently deleted from the instance group. The default is NEVER.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#delete_rule GoogleComputeInstanceGroupManager#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * The network interface name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#interface_name GoogleComputeInstanceGroupManager#interface_name}
    */
    readonly interfaceName?: string;
}
export declare function googleComputeInstanceGroupManagerStatefulExternalIpToTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulExternalIp | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerStatefulExternalIpToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulExternalIp | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerStatefulExternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatefulExternalIp | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatefulExternalIp | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _interfaceName?;
    get interfaceName(): string;
    set interfaceName(value: string);
    resetInterfaceName(): void;
    get interfaceNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceGroupManagerStatefulExternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGroupManagerStatefulExternalIp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatefulExternalIpOutputReference;
}
export interface GoogleComputeInstanceGroupManagerStatefulInternalIp {
    /**
    * A value that prescribes what should happen to an associated static Address resource when a VM instance is permanently deleted. The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the IP when the VM is deleted, but do not delete the address resource. ON_PERMANENT_INSTANCE_DELETION will delete the stateful address when the VM is permanently deleted from the instance group. The default is NEVER.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#delete_rule GoogleComputeInstanceGroupManager#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * The network interface name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#interface_name GoogleComputeInstanceGroupManager#interface_name}
    */
    readonly interfaceName?: string;
}
export declare function googleComputeInstanceGroupManagerStatefulInternalIpToTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulInternalIp | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerStatefulInternalIpToHclTerraform(struct?: GoogleComputeInstanceGroupManagerStatefulInternalIp | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerStatefulInternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerStatefulInternalIp | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerStatefulInternalIp | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _interfaceName?;
    get interfaceName(): string;
    set interfaceName(value: string);
    resetInterfaceName(): void;
    get interfaceNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceGroupManagerStatefulInternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGroupManagerStatefulInternalIp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerStatefulInternalIpOutputReference;
}
export interface GoogleComputeInstanceGroupManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#create GoogleComputeInstanceGroupManager#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#delete GoogleComputeInstanceGroupManager#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#update GoogleComputeInstanceGroupManager#update}
    */
    readonly update?: string;
}
export declare function googleComputeInstanceGroupManagerTimeoutsToTerraform(struct?: GoogleComputeInstanceGroupManagerTimeouts | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerTimeoutsToHclTerraform(struct?: GoogleComputeInstanceGroupManagerTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleComputeInstanceGroupManagerUpdatePolicy {
    /**
    * The maximum number of instances that can be created above the specified targetSize during the update process. Conflicts with max_surge_percent. If neither is set, defaults to 1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#max_surge_fixed GoogleComputeInstanceGroupManager#max_surge_fixed}
    */
    readonly maxSurgeFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process. Conflicts with max_surge_fixed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#max_surge_percent GoogleComputeInstanceGroupManager#max_surge_percent}
    */
    readonly maxSurgePercent?: number;
    /**
    * The maximum number of instances that can be unavailable during the update process. Conflicts with max_unavailable_percent. If neither is set, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#max_unavailable_fixed GoogleComputeInstanceGroupManager#max_unavailable_fixed}
    */
    readonly maxUnavailableFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be unavailable during the update process. Conflicts with max_unavailable_fixed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#max_unavailable_percent GoogleComputeInstanceGroupManager#max_unavailable_percent}
    */
    readonly maxUnavailablePercent?: number;
    /**
    * Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#min_ready_sec GoogleComputeInstanceGroupManager#min_ready_sec}
    */
    readonly minReadySec?: number;
    /**
    * Minimal action to be taken on an instance. You can specify either REFRESH to update without stopping instances, RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a REFRESH, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#minimal_action GoogleComputeInstanceGroupManager#minimal_action}
    */
    readonly minimalAction: string;
    /**
    * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#most_disruptive_allowed_action GoogleComputeInstanceGroupManager#most_disruptive_allowed_action}
    */
    readonly mostDisruptiveAllowedAction?: string;
    /**
    * The instance replacement method for managed instance groups. Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#replacement_method GoogleComputeInstanceGroupManager#replacement_method}
    */
    readonly replacementMethod?: string;
    /**
    * The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#type GoogleComputeInstanceGroupManager#type}
    */
    readonly type: string;
}
export declare function googleComputeInstanceGroupManagerUpdatePolicyToTerraform(struct?: GoogleComputeInstanceGroupManagerUpdatePolicyOutputReference | GoogleComputeInstanceGroupManagerUpdatePolicy): any;
export declare function googleComputeInstanceGroupManagerUpdatePolicyToHclTerraform(struct?: GoogleComputeInstanceGroupManagerUpdatePolicyOutputReference | GoogleComputeInstanceGroupManagerUpdatePolicy): any;
export declare class GoogleComputeInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerUpdatePolicy | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerUpdatePolicy | undefined);
    private _maxSurgeFixed?;
    get maxSurgeFixed(): number;
    set maxSurgeFixed(value: number);
    resetMaxSurgeFixed(): void;
    get maxSurgeFixedInput(): number | undefined;
    private _maxSurgePercent?;
    get maxSurgePercent(): number;
    set maxSurgePercent(value: number);
    resetMaxSurgePercent(): void;
    get maxSurgePercentInput(): number | undefined;
    private _maxUnavailableFixed?;
    get maxUnavailableFixed(): number;
    set maxUnavailableFixed(value: number);
    resetMaxUnavailableFixed(): void;
    get maxUnavailableFixedInput(): number | undefined;
    private _maxUnavailablePercent?;
    get maxUnavailablePercent(): number;
    set maxUnavailablePercent(value: number);
    resetMaxUnavailablePercent(): void;
    get maxUnavailablePercentInput(): number | undefined;
    private _minReadySec?;
    get minReadySec(): number;
    set minReadySec(value: number);
    resetMinReadySec(): void;
    get minReadySecInput(): number | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string;
    set mostDisruptiveAllowedAction(value: string);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _replacementMethod?;
    get replacementMethod(): string;
    set replacementMethod(value: string);
    resetReplacementMethod(): void;
    get replacementMethodInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeInstanceGroupManagerVersionTargetSize {
    /**
    * The number of instances which are managed for this version. Conflicts with percent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#fixed GoogleComputeInstanceGroupManager#fixed}
    */
    readonly fixed?: number;
    /**
    * The number of instances (calculated as percentage) which are managed for this version. Conflicts with fixed. Note that when using percent, rounding will be in favor of explicitly set target_size values; a managed instance group with 2 instances and 2 versions, one of which has a target_size.percent of 60 will create 2 instances of that version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#percent GoogleComputeInstanceGroupManager#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeInstanceGroupManagerVersionTargetSizeToTerraform(struct?: GoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference | GoogleComputeInstanceGroupManagerVersionTargetSize): any;
export declare function googleComputeInstanceGroupManagerVersionTargetSizeToHclTerraform(struct?: GoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference | GoogleComputeInstanceGroupManagerVersionTargetSize): any;
export declare class GoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupManagerVersionTargetSize | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerVersionTargetSize | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeInstanceGroupManagerVersion {
    /**
    * The full URL to an instance template from which all new instances of this version will be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#instance_template GoogleComputeInstanceGroupManager#instance_template}
    */
    readonly instanceTemplate: string;
    /**
    * Version name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#name GoogleComputeInstanceGroupManager#name}
    */
    readonly name?: string;
    /**
    * target_size block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#target_size GoogleComputeInstanceGroupManager#target_size}
    */
    readonly targetSize?: GoogleComputeInstanceGroupManagerVersionTargetSize;
}
export declare function googleComputeInstanceGroupManagerVersionToTerraform(struct?: GoogleComputeInstanceGroupManagerVersion | cdktf.IResolvable): any;
export declare function googleComputeInstanceGroupManagerVersionToHclTerraform(struct?: GoogleComputeInstanceGroupManagerVersion | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupManagerVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGroupManagerVersion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupManagerVersion | cdktf.IResolvable | undefined);
    private _instanceTemplate?;
    get instanceTemplate(): string;
    set instanceTemplate(value: string);
    get instanceTemplateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _targetSize;
    get targetSize(): GoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference;
    putTargetSize(value: GoogleComputeInstanceGroupManagerVersionTargetSize): void;
    resetTargetSize(): void;
    get targetSizeInput(): GoogleComputeInstanceGroupManagerVersionTargetSize | undefined;
}
export declare class GoogleComputeInstanceGroupManagerVersionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGroupManagerVersion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGroupManagerVersionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager google_compute_instance_group_manager}
*/
export declare class GoogleComputeInstanceGroupManager extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_group_manager";
    /**
    * Generates CDKTF code for importing a GoogleComputeInstanceGroupManager resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeInstanceGroupManager to import
    * @param importFromId The id of the existing GoogleComputeInstanceGroupManager that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeInstanceGroupManager to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_group_manager google_compute_instance_group_manager} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceGroupManagerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceGroupManagerConfig);
    private _baseInstanceName?;
    get baseInstanceName(): string;
    set baseInstanceName(value: string);
    get baseInstanceNameInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceGroup(): string;
    private _listManagedInstancesResults?;
    get listManagedInstancesResults(): string;
    set listManagedInstancesResults(value: string);
    resetListManagedInstancesResults(): void;
    get listManagedInstancesResultsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get operation(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _status;
    get status(): GoogleComputeInstanceGroupManagerStatusList;
    private _targetPools?;
    get targetPools(): string[];
    set targetPools(value: string[]);
    resetTargetPools(): void;
    get targetPoolsInput(): string[] | undefined;
    private _targetSize?;
    get targetSize(): number;
    set targetSize(value: number);
    resetTargetSize(): void;
    get targetSizeInput(): number | undefined;
    private _waitForInstances?;
    get waitForInstances(): boolean | cdktf.IResolvable;
    set waitForInstances(value: boolean | cdktf.IResolvable);
    resetWaitForInstances(): void;
    get waitForInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForInstancesStatus?;
    get waitForInstancesStatus(): string;
    set waitForInstancesStatus(value: string);
    resetWaitForInstancesStatus(): void;
    get waitForInstancesStatusInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _allInstancesConfig;
    get allInstancesConfig(): GoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference;
    putAllInstancesConfig(value: GoogleComputeInstanceGroupManagerAllInstancesConfig): void;
    resetAllInstancesConfig(): void;
    get allInstancesConfigInput(): GoogleComputeInstanceGroupManagerAllInstancesConfig | undefined;
    private _autoHealingPolicies;
    get autoHealingPolicies(): GoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference;
    putAutoHealingPolicies(value: GoogleComputeInstanceGroupManagerAutoHealingPolicies): void;
    resetAutoHealingPolicies(): void;
    get autoHealingPoliciesInput(): GoogleComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    private _instanceLifecyclePolicy;
    get instanceLifecyclePolicy(): GoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference;
    putInstanceLifecyclePolicy(value: GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy): void;
    resetInstanceLifecyclePolicy(): void;
    get instanceLifecyclePolicyInput(): GoogleComputeInstanceGroupManagerInstanceLifecyclePolicy | undefined;
    private _namedPort;
    get namedPort(): GoogleComputeInstanceGroupManagerNamedPortList;
    putNamedPort(value: GoogleComputeInstanceGroupManagerNamedPort[] | cdktf.IResolvable): void;
    resetNamedPort(): void;
    get namedPortInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerNamedPort[] | undefined;
    private _statefulDisk;
    get statefulDisk(): GoogleComputeInstanceGroupManagerStatefulDiskList;
    putStatefulDisk(value: GoogleComputeInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable): void;
    resetStatefulDisk(): void;
    get statefulDiskInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerStatefulDisk[] | undefined;
    private _statefulExternalIp;
    get statefulExternalIp(): GoogleComputeInstanceGroupManagerStatefulExternalIpList;
    putStatefulExternalIp(value: GoogleComputeInstanceGroupManagerStatefulExternalIp[] | cdktf.IResolvable): void;
    resetStatefulExternalIp(): void;
    get statefulExternalIpInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerStatefulExternalIp[] | undefined;
    private _statefulInternalIp;
    get statefulInternalIp(): GoogleComputeInstanceGroupManagerStatefulInternalIpList;
    putStatefulInternalIp(value: GoogleComputeInstanceGroupManagerStatefulInternalIp[] | cdktf.IResolvable): void;
    resetStatefulInternalIp(): void;
    get statefulInternalIpInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerStatefulInternalIp[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceGroupManagerTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceGroupManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerTimeouts | undefined;
    private _updatePolicy;
    get updatePolicy(): GoogleComputeInstanceGroupManagerUpdatePolicyOutputReference;
    putUpdatePolicy(value: GoogleComputeInstanceGroupManagerUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): GoogleComputeInstanceGroupManagerUpdatePolicy | undefined;
    private _version;
    get version(): GoogleComputeInstanceGroupManagerVersionList;
    putVersion(value: GoogleComputeInstanceGroupManagerVersion[] | cdktf.IResolvable): void;
    get versionInput(): cdktf.IResolvable | GoogleComputeInstanceGroupManagerVersion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
