/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#id GoogleComputeInstanceSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#project GoogleComputeInstanceSettings#project}
    */
    readonly project?: string;
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#zone GoogleComputeInstanceSettings#zone}
    */
    readonly zone: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#metadata GoogleComputeInstanceSettings#metadata}
    */
    readonly metadata?: GoogleComputeInstanceSettingsMetadata;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#timeouts GoogleComputeInstanceSettings#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceSettingsTimeouts;
}
export interface GoogleComputeInstanceSettingsMetadata {
    /**
    * A metadata key/value items map. The total size of all keys and values must be less than 512KB
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#items GoogleComputeInstanceSettings#items}
    */
    readonly items?: {
        [key: string]: string;
    };
}
export declare function googleComputeInstanceSettingsMetadataToTerraform(struct?: GoogleComputeInstanceSettingsMetadataOutputReference | GoogleComputeInstanceSettingsMetadata): any;
export declare function googleComputeInstanceSettingsMetadataToHclTerraform(struct?: GoogleComputeInstanceSettingsMetadataOutputReference | GoogleComputeInstanceSettingsMetadata): any;
export declare class GoogleComputeInstanceSettingsMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceSettingsMetadata | undefined;
    set internalValue(value: GoogleComputeInstanceSettingsMetadata | undefined);
    private _items?;
    get items(): {
        [key: string]: string;
    };
    set items(value: {
        [key: string]: string;
    });
    resetItems(): void;
    get itemsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeInstanceSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#create GoogleComputeInstanceSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#delete GoogleComputeInstanceSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#update GoogleComputeInstanceSettings#update}
    */
    readonly update?: string;
}
export declare function googleComputeInstanceSettingsTimeoutsToTerraform(struct?: GoogleComputeInstanceSettingsTimeouts | cdktf.IResolvable): any;
export declare function googleComputeInstanceSettingsTimeoutsToHclTerraform(struct?: GoogleComputeInstanceSettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings google_compute_instance_settings}
*/
export declare class GoogleComputeInstanceSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_settings";
    /**
    * Generates CDKTF code for importing a GoogleComputeInstanceSettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeInstanceSettings to import
    * @param importFromId The id of the existing GoogleComputeInstanceSettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeInstanceSettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance_settings google_compute_instance_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceSettingsConfig);
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _metadata;
    get metadata(): GoogleComputeInstanceSettingsMetadataOutputReference;
    putMetadata(value: GoogleComputeInstanceSettingsMetadata): void;
    resetMetadata(): void;
    get metadataInput(): GoogleComputeInstanceSettingsMetadata | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceSettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
