/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires stopping the instance without setting this field, the update will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#allow_stopping_for_update GoogleComputeInstance#allow_stopping_for_update}
    */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
    * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#can_ip_forward GoogleComputeInstance#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * Whether deletion protection is enabled on this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#deletion_protection GoogleComputeInstance#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * A brief description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#description GoogleComputeInstance#description}
    */
    readonly description?: string;
    /**
    * Desired status of the instance. Either "RUNNING" or "TERMINATED".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#desired_status GoogleComputeInstance#desired_status}
    */
    readonly desiredStatus?: string;
    /**
    * Whether the instance has virtual displays enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_display GoogleComputeInstance#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#guest_accelerator GoogleComputeInstance#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleComputeInstanceGuestAccelerator[] | cdktf.IResolvable;
    /**
    * A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#hostname GoogleComputeInstance#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#id GoogleComputeInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs assigned to the instance.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#labels GoogleComputeInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#machine_type GoogleComputeInstance#machine_type}
    */
    readonly machineType: string;
    /**
    * Metadata key/value pairs made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#metadata GoogleComputeInstance#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Metadata startup scripts made available within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#metadata_startup_script GoogleComputeInstance#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * The minimum CPU platform specified for the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#min_cpu_platform GoogleComputeInstance#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#name GoogleComputeInstance#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#project GoogleComputeInstance#project}
    */
    readonly project?: string;
    /**
    * A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#resource_policies GoogleComputeInstance#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The list of tags attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#tags GoogleComputeInstance#tags}
    */
    readonly tags?: string[];
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#zone GoogleComputeInstance#zone}
    */
    readonly zone?: string;
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#advanced_machine_features GoogleComputeInstance#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleComputeInstanceAdvancedMachineFeatures;
    /**
    * attached_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#attached_disk GoogleComputeInstance#attached_disk}
    */
    readonly attachedDisk?: GoogleComputeInstanceAttachedDisk[] | cdktf.IResolvable;
    /**
    * boot_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#boot_disk GoogleComputeInstance#boot_disk}
    */
    readonly bootDisk: GoogleComputeInstanceBootDisk;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#confidential_instance_config GoogleComputeInstance#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleComputeInstanceConfidentialInstanceConfig;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_interface GoogleComputeInstance#network_interface}
    */
    readonly networkInterface: GoogleComputeInstanceNetworkInterface[] | cdktf.IResolvable;
    /**
    * network_performance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_performance_config GoogleComputeInstance#network_performance_config}
    */
    readonly networkPerformanceConfig?: GoogleComputeInstanceNetworkPerformanceConfig;
    /**
    * params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#params GoogleComputeInstance#params}
    */
    readonly params?: GoogleComputeInstanceParams;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#reservation_affinity GoogleComputeInstance#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleComputeInstanceReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#scheduling GoogleComputeInstance#scheduling}
    */
    readonly scheduling?: GoogleComputeInstanceScheduling;
    /**
    * scratch_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#scratch_disk GoogleComputeInstance#scratch_disk}
    */
    readonly scratchDisk?: GoogleComputeInstanceScratchDisk[] | cdktf.IResolvable;
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#service_account GoogleComputeInstance#service_account}
    */
    readonly serviceAccount?: GoogleComputeInstanceServiceAccount;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#shielded_instance_config GoogleComputeInstance#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleComputeInstanceShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#timeouts GoogleComputeInstance#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceTimeouts;
}
export interface GoogleComputeInstanceGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#count GoogleComputeInstance#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#type GoogleComputeInstance#type}
    */
    readonly type?: string;
}
export declare function googleComputeInstanceGuestAcceleratorToTerraform(struct?: GoogleComputeInstanceGuestAccelerator | cdktf.IResolvable): any;
export declare function googleComputeInstanceGuestAcceleratorToHclTerraform(struct?: GoogleComputeInstanceGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeInstanceGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceGuestAcceleratorOutputReference;
}
export interface GoogleComputeInstanceAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_nested_virtualization GoogleComputeInstance#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#threads_per_core GoogleComputeInstance#threads_per_core}
    */
    readonly threadsPerCore?: number;
    /**
    * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance\'s nominal CPU count and the underlying platform\'s SMT width.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#visible_core_count GoogleComputeInstance#visible_core_count}
    */
    readonly visibleCoreCount?: number;
}
export declare function googleComputeInstanceAdvancedMachineFeaturesToTerraform(struct?: GoogleComputeInstanceAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceAdvancedMachineFeatures): any;
export declare function googleComputeInstanceAdvancedMachineFeaturesToHclTerraform(struct?: GoogleComputeInstanceAdvancedMachineFeaturesOutputReference | GoogleComputeInstanceAdvancedMachineFeatures): any;
export declare class GoogleComputeInstanceAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleComputeInstanceAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
    private _visibleCoreCount?;
    get visibleCoreCount(): number;
    set visibleCoreCount(value: number);
    resetVisibleCoreCount(): void;
    get visibleCoreCountInput(): number | undefined;
}
export interface GoogleComputeInstanceAttachedDisk {
    /**
    * Name with which the attached disk is accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#device_name GoogleComputeInstance#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#disk_encryption_key_raw GoogleComputeInstance#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#kms_key_self_link GoogleComputeInstance#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#mode GoogleComputeInstance#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#source GoogleComputeInstance#source}
    */
    readonly source: string;
}
export declare function googleComputeInstanceAttachedDiskToTerraform(struct?: GoogleComputeInstanceAttachedDisk | cdktf.IResolvable): any;
export declare function googleComputeInstanceAttachedDiskToHclTerraform(struct?: GoogleComputeInstanceAttachedDisk | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceAttachedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceAttachedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceAttachedDisk | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    get diskEncryptionKeySha256(): string;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export declare class GoogleComputeInstanceAttachedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceAttachedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceAttachedDiskOutputReference;
}
export interface GoogleComputeInstanceBootDiskInitializeParams {
    /**
    * A flag to enable confidential compute mode on boot disk
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_confidential_compute GoogleComputeInstance#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
    /**
    * The image from which this disk was initialised.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#image GoogleComputeInstance#image}
    */
    readonly image?: string;
    /**
    * A set of key/value label pairs assigned to the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#labels GoogleComputeInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#provisioned_iops GoogleComputeInstance#provisioned_iops}
    */
    readonly provisionedIops?: number;
    /**
    * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#provisioned_throughput GoogleComputeInstance#provisioned_throughput}
    */
    readonly provisionedThroughput?: number;
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#resource_manager_tags GoogleComputeInstance#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * The size of the image in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#size GoogleComputeInstance#size}
    */
    readonly size?: number;
    /**
    * The Google Compute Engine disk type. Such as pd-standard, pd-ssd or pd-balanced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#type GoogleComputeInstance#type}
    */
    readonly type?: string;
}
export declare function googleComputeInstanceBootDiskInitializeParamsToTerraform(struct?: GoogleComputeInstanceBootDiskInitializeParamsOutputReference | GoogleComputeInstanceBootDiskInitializeParams): any;
export declare function googleComputeInstanceBootDiskInitializeParamsToHclTerraform(struct?: GoogleComputeInstanceBootDiskInitializeParamsOutputReference | GoogleComputeInstanceBootDiskInitializeParams): any;
export declare class GoogleComputeInstanceBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceBootDiskInitializeParams | undefined;
    set internalValue(value: GoogleComputeInstanceBootDiskInitializeParams | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _provisionedIops?;
    get provisionedIops(): number;
    set provisionedIops(value: number);
    resetProvisionedIops(): void;
    get provisionedIopsInput(): number | undefined;
    private _provisionedThroughput?;
    get provisionedThroughput(): number;
    set provisionedThroughput(value: number);
    resetProvisionedThroughput(): void;
    get provisionedThroughputInput(): number | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleComputeInstanceBootDisk {
    /**
    * Whether the disk will be auto-deleted when the instance is deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#auto_delete GoogleComputeInstance#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Name with which attached disk will be accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#device_name GoogleComputeInstance#device_name}
    */
    readonly deviceName?: string;
    /**
    * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#disk_encryption_key_raw GoogleComputeInstance#disk_encryption_key_raw}
    */
    readonly diskEncryptionKeyRaw?: string;
    /**
    * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk. Only one of kms_key_self_link and disk_encryption_key_raw may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#kms_key_self_link GoogleComputeInstance#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#mode GoogleComputeInstance#mode}
    */
    readonly mode?: string;
    /**
    * The name or self_link of the disk attached to this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#source GoogleComputeInstance#source}
    */
    readonly source?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#initialize_params GoogleComputeInstance#initialize_params}
    */
    readonly initializeParams?: GoogleComputeInstanceBootDiskInitializeParams;
}
export declare function googleComputeInstanceBootDiskToTerraform(struct?: GoogleComputeInstanceBootDiskOutputReference | GoogleComputeInstanceBootDisk): any;
export declare function googleComputeInstanceBootDiskToHclTerraform(struct?: GoogleComputeInstanceBootDiskOutputReference | GoogleComputeInstanceBootDisk): any;
export declare class GoogleComputeInstanceBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceBootDisk | undefined;
    set internalValue(value: GoogleComputeInstanceBootDisk | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string;
    set diskEncryptionKeyRaw(value: string);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    get diskEncryptionKeySha256(): string;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): GoogleComputeInstanceBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: GoogleComputeInstanceBootDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): GoogleComputeInstanceBootDiskInitializeParams | undefined;
}
export interface GoogleComputeInstanceConfidentialInstanceConfig {
    /**
    *
    * 								Specifies which confidential computing technology to use.
    * 								This could be one of the following values: SEV, SEV_SNP.
    * 								If SEV_SNP, min_cpu_platform = "AMD Milan" is currently required.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#confidential_instance_type GoogleComputeInstance#confidential_instance_type}
    */
    readonly confidentialInstanceType?: string;
    /**
    * Defines whether the instance should have confidential compute enabled. Field will be deprecated in a future release
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_confidential_compute GoogleComputeInstance#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceConfidentialInstanceConfigToTerraform(struct?: GoogleComputeInstanceConfidentialInstanceConfigOutputReference | GoogleComputeInstanceConfidentialInstanceConfig): any;
export declare function googleComputeInstanceConfidentialInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceConfidentialInstanceConfigOutputReference | GoogleComputeInstanceConfidentialInstanceConfig): any;
export declare class GoogleComputeInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceConfidentialInstanceConfig | undefined);
    private _confidentialInstanceType?;
    get confidentialInstanceType(): string;
    set confidentialInstanceType(value: string);
    resetConfidentialInstanceType(): void;
    get confidentialInstanceTypeInput(): string | undefined;
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceNetworkInterfaceAccessConfig {
    /**
    * The IP address that is be 1:1 mapped to the instance's network ip.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#nat_ip GoogleComputeInstance#nat_ip}
    */
    readonly natIp?: string;
    /**
    * The networking tier used for configuring this instance. One of PREMIUM or STANDARD.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_tier GoogleComputeInstance#network_tier}
    */
    readonly networkTier?: string;
    /**
    * The DNS domain name for the public PTR record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#public_ptr_domain_name GoogleComputeInstance#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function googleComputeInstanceNetworkInterfaceAccessConfigToTerraform(struct?: GoogleComputeInstanceNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceNetworkInterfaceAccessConfigToHclTerraform(struct?: GoogleComputeInstanceNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    get securityPolicy(): string;
}
export declare class GoogleComputeInstanceNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceNetworkInterfaceAccessConfigOutputReference;
}
export interface GoogleComputeInstanceNetworkInterfaceAliasIpRange {
    /**
    * The IP CIDR range represented by this alias IP range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#ip_cidr_range GoogleComputeInstance#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#subnetwork_range_name GoogleComputeInstance#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function googleComputeInstanceNetworkInterfaceAliasIpRangeToTerraform(struct?: GoogleComputeInstanceNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare function googleComputeInstanceNetworkInterfaceAliasIpRangeToHclTerraform(struct?: GoogleComputeInstanceNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class GoogleComputeInstanceNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceNetworkInterfaceAliasIpRangeOutputReference;
}
export interface GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig {
    /**
    * The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#external_ipv6 GoogleComputeInstance#external_ipv6}
    */
    readonly externalIpv6?: string;
    /**
    * The prefix length of the external IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#external_ipv6_prefix_length GoogleComputeInstance#external_ipv6_prefix_length}
    */
    readonly externalIpv6PrefixLength?: string;
    /**
    * The name of this access configuration. In ipv6AccessConfigs, the recommended name is External IPv6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#name GoogleComputeInstance#name}
    */
    readonly name?: string;
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_tier GoogleComputeInstance#network_tier}
    */
    readonly networkTier: string;
    /**
    * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#public_ptr_domain_name GoogleComputeInstance#public_ptr_domain_name}
    */
    readonly publicPtrDomainName?: string;
}
export declare function googleComputeInstanceNetworkInterfaceIpv6AccessConfigToTerraform(struct?: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare function googleComputeInstanceNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    private _externalIpv6?;
    get externalIpv6(): string;
    set externalIpv6(value: string);
    resetExternalIpv6(): void;
    get externalIpv6Input(): string | undefined;
    private _externalIpv6PrefixLength?;
    get externalIpv6PrefixLength(): string;
    set externalIpv6PrefixLength(value: string);
    resetExternalIpv6PrefixLength(): void;
    get externalIpv6PrefixLengthInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _publicPtrDomainName?;
    get publicPtrDomainName(): string;
    set publicPtrDomainName(value: string);
    resetPublicPtrDomainName(): void;
    get publicPtrDomainNameInput(): string | undefined;
    get securityPolicy(): string;
}
export declare class GoogleComputeInstanceNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface GoogleComputeInstanceNetworkInterface {
    /**
    * The prefix length of the primary internal IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#internal_ipv6_prefix_length GoogleComputeInstance#internal_ipv6_prefix_length}
    */
    readonly internalIpv6PrefixLength?: number;
    /**
    * An IPv6 internal network address for this network interface. If not specified, Google Cloud will automatically assign an internal IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#ipv6_address GoogleComputeInstance#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The name or self_link of the network attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network GoogleComputeInstance#network}
    */
    readonly network?: string;
    /**
    * The URL of the network attachment that this interface should connect to in the following format: projects/{projectNumber}/regions/{region_name}/networkAttachments/{network_attachment_name}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_attachment GoogleComputeInstance#network_attachment}
    */
    readonly networkAttachment?: string;
    /**
    * The private IP address assigned to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#network_ip GoogleComputeInstance#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#nic_type GoogleComputeInstance#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#queue_count GoogleComputeInstance#queue_count}
    */
    readonly queueCount?: number;
    /**
    * A full or partial URL to a security policy to add to this instance. If this field is set to an empty string it will remove the associated security policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#security_policy GoogleComputeInstance#security_policy}
    */
    readonly securityPolicy?: string;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#stack_type GoogleComputeInstance#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name or self_link of the subnetwork attached to this interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#subnetwork GoogleComputeInstance#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The project in which the subnetwork belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#subnetwork_project GoogleComputeInstance#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#access_config GoogleComputeInstance#access_config}
    */
    readonly accessConfig?: GoogleComputeInstanceNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * alias_ip_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#alias_ip_range GoogleComputeInstance#alias_ip_range}
    */
    readonly aliasIpRange?: GoogleComputeInstanceNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#ipv6_access_config GoogleComputeInstance#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceNetworkInterfaceToTerraform(struct?: GoogleComputeInstanceNetworkInterface | cdktf.IResolvable): any;
export declare function googleComputeInstanceNetworkInterfaceToHclTerraform(struct?: GoogleComputeInstanceNetworkInterface | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceNetworkInterface | cdktf.IResolvable | undefined);
    private _internalIpv6PrefixLength?;
    get internalIpv6PrefixLength(): number;
    set internalIpv6PrefixLength(value: number);
    resetInternalIpv6PrefixLength(): void;
    get internalIpv6PrefixLengthInput(): number | undefined;
    get ipv6AccessType(): string;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkAttachment?;
    get networkAttachment(): string;
    set networkAttachment(value: string);
    resetNetworkAttachment(): void;
    get networkAttachmentInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    resetSecurityPolicy(): void;
    get securityPolicyInput(): string | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _accessConfig;
    get accessConfig(): GoogleComputeInstanceNetworkInterfaceAccessConfigList;
    putAccessConfig(value: GoogleComputeInstanceNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): GoogleComputeInstanceNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: GoogleComputeInstanceNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | GoogleComputeInstanceNetworkInterfaceAliasIpRange[] | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): GoogleComputeInstanceNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | GoogleComputeInstanceNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class GoogleComputeInstanceNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceNetworkInterfaceOutputReference;
}
export interface GoogleComputeInstanceNetworkPerformanceConfig {
    /**
    * The egress bandwidth tier to enable. Possible values:TIER_1, DEFAULT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#total_egress_bandwidth_tier GoogleComputeInstance#total_egress_bandwidth_tier}
    */
    readonly totalEgressBandwidthTier: string;
}
export declare function googleComputeInstanceNetworkPerformanceConfigToTerraform(struct?: GoogleComputeInstanceNetworkPerformanceConfigOutputReference | GoogleComputeInstanceNetworkPerformanceConfig): any;
export declare function googleComputeInstanceNetworkPerformanceConfigToHclTerraform(struct?: GoogleComputeInstanceNetworkPerformanceConfigOutputReference | GoogleComputeInstanceNetworkPerformanceConfig): any;
export declare class GoogleComputeInstanceNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceNetworkPerformanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceNetworkPerformanceConfig | undefined);
    private _totalEgressBandwidthTier?;
    get totalEgressBandwidthTier(): string;
    set totalEgressBandwidthTier(value: string);
    get totalEgressBandwidthTierInput(): string | undefined;
}
export interface GoogleComputeInstanceParams {
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#resource_manager_tags GoogleComputeInstance#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
}
export declare function googleComputeInstanceParamsToTerraform(struct?: GoogleComputeInstanceParamsOutputReference | GoogleComputeInstanceParams): any;
export declare function googleComputeInstanceParamsToHclTerraform(struct?: GoogleComputeInstanceParamsOutputReference | GoogleComputeInstanceParams): any;
export declare class GoogleComputeInstanceParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceParams | undefined;
    set internalValue(value: GoogleComputeInstanceParams | undefined);
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeInstanceReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#key GoogleComputeInstance#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#values GoogleComputeInstance#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceReservationAffinitySpecificReservationToTerraform(struct?: GoogleComputeInstanceReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceReservationAffinitySpecificReservation): any;
export declare function googleComputeInstanceReservationAffinitySpecificReservationToHclTerraform(struct?: GoogleComputeInstanceReservationAffinitySpecificReservationOutputReference | GoogleComputeInstanceReservationAffinitySpecificReservation): any;
export declare class GoogleComputeInstanceReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceReservationAffinitySpecificReservation | undefined;
    set internalValue(value: GoogleComputeInstanceReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleComputeInstanceReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#type GoogleComputeInstance#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#specific_reservation GoogleComputeInstance#specific_reservation}
    */
    readonly specificReservation?: GoogleComputeInstanceReservationAffinitySpecificReservation;
}
export declare function googleComputeInstanceReservationAffinityToTerraform(struct?: GoogleComputeInstanceReservationAffinityOutputReference | GoogleComputeInstanceReservationAffinity): any;
export declare function googleComputeInstanceReservationAffinityToHclTerraform(struct?: GoogleComputeInstanceReservationAffinityOutputReference | GoogleComputeInstanceReservationAffinity): any;
export declare class GoogleComputeInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceReservationAffinity | undefined;
    set internalValue(value: GoogleComputeInstanceReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): GoogleComputeInstanceReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: GoogleComputeInstanceReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): GoogleComputeInstanceReservationAffinitySpecificReservation | undefined;
}
export interface GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#nanos GoogleComputeInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#seconds GoogleComputeInstance#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout): any;
export declare function googleComputeInstanceSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeoutOutputReference | GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout): any;
export declare class GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout | undefined;
    set internalValue(value: GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceSchedulingMaxRunDuration {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#nanos GoogleComputeInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#seconds GoogleComputeInstance#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeInstanceSchedulingMaxRunDurationToTerraform(struct?: GoogleComputeInstanceSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceSchedulingMaxRunDuration): any;
export declare function googleComputeInstanceSchedulingMaxRunDurationToHclTerraform(struct?: GoogleComputeInstanceSchedulingMaxRunDurationOutputReference | GoogleComputeInstanceSchedulingMaxRunDuration): any;
export declare class GoogleComputeInstanceSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceSchedulingMaxRunDuration | undefined;
    set internalValue(value: GoogleComputeInstanceSchedulingMaxRunDuration | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeInstanceSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#key GoogleComputeInstance#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#operator GoogleComputeInstance#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#values GoogleComputeInstance#values}
    */
    readonly values: string[];
}
export declare function googleComputeInstanceSchedulingNodeAffinitiesToTerraform(struct?: GoogleComputeInstanceSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare function googleComputeInstanceSchedulingNodeAffinitiesToHclTerraform(struct?: GoogleComputeInstanceSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleComputeInstanceSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceSchedulingNodeAffinitiesOutputReference;
}
export interface GoogleComputeInstanceScheduling {
    /**
    * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#automatic_restart GoogleComputeInstance#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#instance_termination_action GoogleComputeInstance#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Specifies the frequency of planned maintenance events. The accepted values are: PERIODIC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#maintenance_interval GoogleComputeInstance#maintenance_interval}
    */
    readonly maintenanceInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#min_node_cpus GoogleComputeInstance#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#on_host_maintenance GoogleComputeInstance#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Whether the instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#preemptible GoogleComputeInstance#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#provisioning_model GoogleComputeInstance#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * local_ssd_recovery_timeout block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#local_ssd_recovery_timeout GoogleComputeInstance#local_ssd_recovery_timeout}
    */
    readonly localSsdRecoveryTimeout?: GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout;
    /**
    * max_run_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#max_run_duration GoogleComputeInstance#max_run_duration}
    */
    readonly maxRunDuration?: GoogleComputeInstanceSchedulingMaxRunDuration;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#node_affinities GoogleComputeInstance#node_affinities}
    */
    readonly nodeAffinities?: GoogleComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function googleComputeInstanceSchedulingToTerraform(struct?: GoogleComputeInstanceSchedulingOutputReference | GoogleComputeInstanceScheduling): any;
export declare function googleComputeInstanceSchedulingToHclTerraform(struct?: GoogleComputeInstanceSchedulingOutputReference | GoogleComputeInstanceScheduling): any;
export declare class GoogleComputeInstanceSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceScheduling | undefined;
    set internalValue(value: GoogleComputeInstanceScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    resetMaintenanceInterval(): void;
    get maintenanceIntervalInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeoutOutputReference;
    putLocalSsdRecoveryTimeout(value: GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout): void;
    resetLocalSsdRecoveryTimeout(): void;
    get localSsdRecoveryTimeoutInput(): GoogleComputeInstanceSchedulingLocalSsdRecoveryTimeout | undefined;
    private _maxRunDuration;
    get maxRunDuration(): GoogleComputeInstanceSchedulingMaxRunDurationOutputReference;
    putMaxRunDuration(value: GoogleComputeInstanceSchedulingMaxRunDuration): void;
    resetMaxRunDuration(): void;
    get maxRunDurationInput(): GoogleComputeInstanceSchedulingMaxRunDuration | undefined;
    private _nodeAffinities;
    get nodeAffinities(): GoogleComputeInstanceSchedulingNodeAffinitiesList;
    putNodeAffinities(value: GoogleComputeInstanceSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | GoogleComputeInstanceSchedulingNodeAffinities[] | undefined;
}
export interface GoogleComputeInstanceScratchDisk {
    /**
    * Name with which the attached disk is accessible under /dev/disk/by-id/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#device_name GoogleComputeInstance#device_name}
    */
    readonly deviceName?: string;
    /**
    * The disk interface used for attaching this disk. One of SCSI or NVME.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#interface GoogleComputeInstance#interface}
    */
    readonly interface: string;
    /**
    * The size of the disk in gigabytes. One of 375 or 3000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#size GoogleComputeInstance#size}
    */
    readonly size?: number;
}
export declare function googleComputeInstanceScratchDiskToTerraform(struct?: GoogleComputeInstanceScratchDisk | cdktf.IResolvable): any;
export declare function googleComputeInstanceScratchDiskToHclTerraform(struct?: GoogleComputeInstanceScratchDisk | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceScratchDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInstanceScratchDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceScratchDisk | cdktf.IResolvable | undefined);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    get interfaceInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
}
export declare class GoogleComputeInstanceScratchDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeInstanceScratchDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInstanceScratchDiskOutputReference;
}
export interface GoogleComputeInstanceServiceAccount {
    /**
    * The service account e-mail address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#email GoogleComputeInstance#email}
    */
    readonly email?: string;
    /**
    * A list of service scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#scopes GoogleComputeInstance#scopes}
    */
    readonly scopes: string[];
}
export declare function googleComputeInstanceServiceAccountToTerraform(struct?: GoogleComputeInstanceServiceAccountOutputReference | GoogleComputeInstanceServiceAccount): any;
export declare function googleComputeInstanceServiceAccountToHclTerraform(struct?: GoogleComputeInstanceServiceAccountOutputReference | GoogleComputeInstanceServiceAccount): any;
export declare class GoogleComputeInstanceServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceServiceAccount | undefined;
    set internalValue(value: GoogleComputeInstanceServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
}
export interface GoogleComputeInstanceShieldedInstanceConfig {
    /**
    * Whether integrity monitoring is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_integrity_monitoring GoogleComputeInstance#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether secure boot is enabled for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_secure_boot GoogleComputeInstance#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance uses vTPM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#enable_vtpm GoogleComputeInstance#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleComputeInstanceShieldedInstanceConfigToTerraform(struct?: GoogleComputeInstanceShieldedInstanceConfigOutputReference | GoogleComputeInstanceShieldedInstanceConfig): any;
export declare function googleComputeInstanceShieldedInstanceConfigToHclTerraform(struct?: GoogleComputeInstanceShieldedInstanceConfigOutputReference | GoogleComputeInstanceShieldedInstanceConfig): any;
export declare class GoogleComputeInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleComputeInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#create GoogleComputeInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#delete GoogleComputeInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#update GoogleComputeInstance#update}
    */
    readonly update?: string;
}
export declare function googleComputeInstanceTimeoutsToTerraform(struct?: GoogleComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleComputeInstanceTimeoutsToHclTerraform(struct?: GoogleComputeInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance google_compute_instance}
*/
export declare class GoogleComputeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance";
    /**
    * Generates CDKTF code for importing a GoogleComputeInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeInstance to import
    * @param importFromId The id of the existing GoogleComputeInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_instance google_compute_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string;
    set desiredStatus(value: string);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleComputeInstanceGuestAcceleratorList;
    putGuestAccelerator(value: GoogleComputeInstanceGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleComputeInstanceGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleComputeInstanceAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleComputeInstanceAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleComputeInstanceAdvancedMachineFeatures | undefined;
    private _attachedDisk;
    get attachedDisk(): GoogleComputeInstanceAttachedDiskList;
    putAttachedDisk(value: GoogleComputeInstanceAttachedDisk[] | cdktf.IResolvable): void;
    resetAttachedDisk(): void;
    get attachedDiskInput(): cdktf.IResolvable | GoogleComputeInstanceAttachedDisk[] | undefined;
    private _bootDisk;
    get bootDisk(): GoogleComputeInstanceBootDiskOutputReference;
    putBootDisk(value: GoogleComputeInstanceBootDisk): void;
    get bootDiskInput(): GoogleComputeInstanceBootDisk | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleComputeInstanceConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleComputeInstanceConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleComputeInstanceConfidentialInstanceConfig | undefined;
    private _networkInterface;
    get networkInterface(): GoogleComputeInstanceNetworkInterfaceList;
    putNetworkInterface(value: GoogleComputeInstanceNetworkInterface[] | cdktf.IResolvable): void;
    get networkInterfaceInput(): cdktf.IResolvable | GoogleComputeInstanceNetworkInterface[] | undefined;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): GoogleComputeInstanceNetworkPerformanceConfigOutputReference;
    putNetworkPerformanceConfig(value: GoogleComputeInstanceNetworkPerformanceConfig): void;
    resetNetworkPerformanceConfig(): void;
    get networkPerformanceConfigInput(): GoogleComputeInstanceNetworkPerformanceConfig | undefined;
    private _params;
    get params(): GoogleComputeInstanceParamsOutputReference;
    putParams(value: GoogleComputeInstanceParams): void;
    resetParams(): void;
    get paramsInput(): GoogleComputeInstanceParams | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleComputeInstanceReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleComputeInstanceReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleComputeInstanceReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): GoogleComputeInstanceSchedulingOutputReference;
    putScheduling(value: GoogleComputeInstanceScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleComputeInstanceScheduling | undefined;
    private _scratchDisk;
    get scratchDisk(): GoogleComputeInstanceScratchDiskList;
    putScratchDisk(value: GoogleComputeInstanceScratchDisk[] | cdktf.IResolvable): void;
    resetScratchDisk(): void;
    get scratchDiskInput(): cdktf.IResolvable | GoogleComputeInstanceScratchDisk[] | undefined;
    private _serviceAccount;
    get serviceAccount(): GoogleComputeInstanceServiceAccountOutputReference;
    putServiceAccount(value: GoogleComputeInstanceServiceAccount): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): GoogleComputeInstanceServiceAccount | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleComputeInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleComputeInstanceShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleComputeInstanceShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
