/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeMachineImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * A text description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#description GoogleComputeMachineImage#description}
    */
    readonly description?: string;
    /**
    * Specify this to create an application consistent machine image by informing the OS to prepare for the snapshot process.
    * Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#guest_flush GoogleComputeMachineImage#guest_flush}
    */
    readonly guestFlush?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#id GoogleComputeMachineImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#name GoogleComputeMachineImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#project GoogleComputeMachineImage#project}
    */
    readonly project?: string;
    /**
    * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#source_instance GoogleComputeMachineImage#source_instance}
    */
    readonly sourceInstance: string;
    /**
    * machine_image_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#machine_image_encryption_key GoogleComputeMachineImage#machine_image_encryption_key}
    */
    readonly machineImageEncryptionKey?: GoogleComputeMachineImageMachineImageEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#timeouts GoogleComputeMachineImage#timeouts}
    */
    readonly timeouts?: GoogleComputeMachineImageTimeouts;
}
export interface GoogleComputeMachineImageMachineImageEncryptionKey {
    /**
    * The name of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#kms_key_name GoogleComputeMachineImage#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
    * If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#kms_key_service_account GoogleComputeMachineImage#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#raw_key GoogleComputeMachineImage#raw_key}
    */
    readonly rawKey?: string;
}
export declare function googleComputeMachineImageMachineImageEncryptionKeyToTerraform(struct?: GoogleComputeMachineImageMachineImageEncryptionKeyOutputReference | GoogleComputeMachineImageMachineImageEncryptionKey): any;
export declare function googleComputeMachineImageMachineImageEncryptionKeyToHclTerraform(struct?: GoogleComputeMachineImageMachineImageEncryptionKeyOutputReference | GoogleComputeMachineImageMachineImageEncryptionKey): any;
export declare class GoogleComputeMachineImageMachineImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeMachineImageMachineImageEncryptionKey | undefined;
    set internalValue(value: GoogleComputeMachineImageMachineImageEncryptionKey | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeMachineImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#create GoogleComputeMachineImage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#delete GoogleComputeMachineImage#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeMachineImageTimeoutsToTerraform(struct?: GoogleComputeMachineImageTimeouts | cdktf.IResolvable): any;
export declare function googleComputeMachineImageTimeoutsToHclTerraform(struct?: GoogleComputeMachineImageTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeMachineImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeMachineImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeMachineImageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image google_compute_machine_image}
*/
export declare class GoogleComputeMachineImage extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_machine_image";
    /**
    * Generates CDKTF code for importing a GoogleComputeMachineImage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeMachineImage to import
    * @param importFromId The id of the existing GoogleComputeMachineImage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeMachineImage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_machine_image google_compute_machine_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeMachineImageConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeMachineImageConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _guestFlush?;
    get guestFlush(): boolean | cdktf.IResolvable;
    set guestFlush(value: boolean | cdktf.IResolvable);
    resetGuestFlush(): void;
    get guestFlushInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sourceInstance?;
    get sourceInstance(): string;
    set sourceInstance(value: string);
    get sourceInstanceInput(): string | undefined;
    get storageLocations(): string[];
    private _machineImageEncryptionKey;
    get machineImageEncryptionKey(): GoogleComputeMachineImageMachineImageEncryptionKeyOutputReference;
    putMachineImageEncryptionKey(value: GoogleComputeMachineImageMachineImageEncryptionKey): void;
    resetMachineImageEncryptionKey(): void;
    get machineImageEncryptionKeyInput(): GoogleComputeMachineImageMachineImageEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeMachineImageTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeMachineImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeMachineImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
