/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNetworkAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules. Possible values: ["ACCEPT_AUTOMATIC", "ACCEPT_MANUAL", "INVALID"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#connection_preference GoogleComputeNetworkAttachment#connection_preference}
    */
    readonly connectionPreference: string;
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#description GoogleComputeNetworkAttachment#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#name GoogleComputeNetworkAttachment#name}
    */
    readonly name: string;
    /**
    * Projects that are allowed to connect to this network attachment. The project can be specified using its id or number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#producer_accept_lists GoogleComputeNetworkAttachment#producer_accept_lists}
    */
    readonly producerAcceptLists?: string[];
    /**
    * Projects that are not allowed to connect to this network attachment. The project can be specified using its id or number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#producer_reject_lists GoogleComputeNetworkAttachment#producer_reject_lists}
    */
    readonly producerRejectLists?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#project GoogleComputeNetworkAttachment#project}
    */
    readonly project?: string;
    /**
    * URL of the region where the network attachment resides. This field applies only to the region resource. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#region GoogleComputeNetworkAttachment#region}
    */
    readonly region?: string;
    /**
    * An array of URLs where each entry is the URL of a subnet provided by the service consumer to use for endpoints in the producers that connect to this network attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#subnetworks GoogleComputeNetworkAttachment#subnetworks}
    */
    readonly subnetworks: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#timeouts GoogleComputeNetworkAttachment#timeouts}
    */
    readonly timeouts?: GoogleComputeNetworkAttachmentTimeouts;
}
export interface GoogleComputeNetworkAttachmentConnectionEndpoints {
}
export declare function googleComputeNetworkAttachmentConnectionEndpointsToTerraform(struct?: GoogleComputeNetworkAttachmentConnectionEndpoints): any;
export declare function googleComputeNetworkAttachmentConnectionEndpointsToHclTerraform(struct?: GoogleComputeNetworkAttachmentConnectionEndpoints): any;
export declare class GoogleComputeNetworkAttachmentConnectionEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeNetworkAttachmentConnectionEndpoints | undefined;
    set internalValue(value: GoogleComputeNetworkAttachmentConnectionEndpoints | undefined);
    get ipAddress(): string;
    get projectIdOrNum(): string;
    get secondaryIpCidrRanges(): string;
    get status(): string;
    get subnetwork(): string;
}
export declare class GoogleComputeNetworkAttachmentConnectionEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeNetworkAttachmentConnectionEndpointsOutputReference;
}
export interface GoogleComputeNetworkAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#create GoogleComputeNetworkAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#delete GoogleComputeNetworkAttachment#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeNetworkAttachmentTimeoutsToTerraform(struct?: GoogleComputeNetworkAttachmentTimeouts | cdktf.IResolvable): any;
export declare function googleComputeNetworkAttachmentTimeoutsToHclTerraform(struct?: GoogleComputeNetworkAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNetworkAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNetworkAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNetworkAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment google_compute_network_attachment}
*/
export declare class GoogleComputeNetworkAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_attachment";
    /**
    * Generates CDKTF code for importing a GoogleComputeNetworkAttachment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeNetworkAttachment to import
    * @param importFromId The id of the existing GoogleComputeNetworkAttachment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeNetworkAttachment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_attachment google_compute_network_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNetworkAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeNetworkAttachmentConfig);
    private _connectionEndpoints;
    get connectionEndpoints(): GoogleComputeNetworkAttachmentConnectionEndpointsList;
    private _connectionPreference?;
    get connectionPreference(): string;
    set connectionPreference(value: string);
    get connectionPreferenceInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _producerAcceptLists?;
    get producerAcceptLists(): string[];
    set producerAcceptLists(value: string[]);
    resetProducerAcceptLists(): void;
    get producerAcceptListsInput(): string[] | undefined;
    private _producerRejectLists?;
    get producerRejectLists(): string[];
    set producerRejectLists(value: string[]);
    resetProducerRejectLists(): void;
    get producerRejectListsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get selfLinkWithId(): string;
    private _subnetworks?;
    get subnetworks(): string[];
    set subnetworks(value: string[]);
    get subnetworksInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeNetworkAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNetworkAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNetworkAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
