/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNetworkEndpointsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#id GoogleComputeNetworkEndpoints#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The network endpoint group these endpoints are part of.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#network_endpoint_group GoogleComputeNetworkEndpoints#network_endpoint_group}
    */
    readonly networkEndpointGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#project GoogleComputeNetworkEndpoints#project}
    */
    readonly project?: string;
    /**
    * Zone where the containing network endpoint group is located.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#zone GoogleComputeNetworkEndpoints#zone}
    */
    readonly zone?: string;
    /**
    * network_endpoints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#network_endpoints GoogleComputeNetworkEndpoints#network_endpoints}
    */
    readonly networkEndpoints?: GoogleComputeNetworkEndpointsNetworkEndpoints[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#timeouts GoogleComputeNetworkEndpoints#timeouts}
    */
    readonly timeouts?: GoogleComputeNetworkEndpointsTimeouts;
}
export interface GoogleComputeNetworkEndpointsNetworkEndpoints {
    /**
    * The name for a specific VM instance that the IP address belongs to.
    * This is required for network endpoints of type GCE_VM_IP_PORT.
    * The instance must be in the same zone as the network endpoint group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#instance GoogleComputeNetworkEndpoints#instance}
    */
    readonly instance?: string;
    /**
    * IPv4 address of network endpoint. The IP address must belong
    * to a VM in GCE (either the primary IP or as part of an aliased IP
    * range).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#ip_address GoogleComputeNetworkEndpoints#ip_address}
    */
    readonly ipAddress: string;
    /**
    * Port number of network endpoint.
    * **Note** 'port' is required unless the Network Endpoint Group is created
    * with the type of 'GCE_VM_IP'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#port GoogleComputeNetworkEndpoints#port}
    */
    readonly port?: number;
}
export declare function googleComputeNetworkEndpointsNetworkEndpointsToTerraform(struct?: GoogleComputeNetworkEndpointsNetworkEndpoints | cdktf.IResolvable): any;
export declare function googleComputeNetworkEndpointsNetworkEndpointsToHclTerraform(struct?: GoogleComputeNetworkEndpointsNetworkEndpoints | cdktf.IResolvable): any;
export declare class GoogleComputeNetworkEndpointsNetworkEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeNetworkEndpointsNetworkEndpoints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNetworkEndpointsNetworkEndpoints | cdktf.IResolvable | undefined);
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export declare class GoogleComputeNetworkEndpointsNetworkEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeNetworkEndpointsNetworkEndpoints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeNetworkEndpointsNetworkEndpointsOutputReference;
}
export interface GoogleComputeNetworkEndpointsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#create GoogleComputeNetworkEndpoints#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#delete GoogleComputeNetworkEndpoints#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#update GoogleComputeNetworkEndpoints#update}
    */
    readonly update?: string;
}
export declare function googleComputeNetworkEndpointsTimeoutsToTerraform(struct?: GoogleComputeNetworkEndpointsTimeouts | cdktf.IResolvable): any;
export declare function googleComputeNetworkEndpointsTimeoutsToHclTerraform(struct?: GoogleComputeNetworkEndpointsTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNetworkEndpointsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNetworkEndpointsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNetworkEndpointsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints google_compute_network_endpoints}
*/
export declare class GoogleComputeNetworkEndpoints extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_endpoints";
    /**
    * Generates CDKTF code for importing a GoogleComputeNetworkEndpoints resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeNetworkEndpoints to import
    * @param importFromId The id of the existing GoogleComputeNetworkEndpoints that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeNetworkEndpoints to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_network_endpoints google_compute_network_endpoints} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNetworkEndpointsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeNetworkEndpointsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkEndpointGroup?;
    get networkEndpointGroup(): string;
    set networkEndpointGroup(value: string);
    get networkEndpointGroupInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _networkEndpoints;
    get networkEndpoints(): GoogleComputeNetworkEndpointsNetworkEndpointsList;
    putNetworkEndpoints(value: GoogleComputeNetworkEndpointsNetworkEndpoints[] | cdktf.IResolvable): void;
    resetNetworkEndpoints(): void;
    get networkEndpointsInput(): cdktf.IResolvable | GoogleComputeNetworkEndpointsNetworkEndpoints[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeNetworkEndpointsTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNetworkEndpointsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNetworkEndpointsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
