/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputePublicDelegatedPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#description GoogleComputePublicDelegatedPrefix#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#id GoogleComputePublicDelegatedPrefix#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The IPv4 address range, in CIDR format, represented by this public advertised prefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#ip_cidr_range GoogleComputePublicDelegatedPrefix#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * If true, the prefix will be live migrated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#is_live_migration GoogleComputePublicDelegatedPrefix#is_live_migration}
    */
    readonly isLiveMigration?: boolean | cdktf.IResolvable;
    /**
    * Name of the resource. The name must be 1-63 characters long, and
    * comply with RFC1035. Specifically, the name must be 1-63 characters
    * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
    * which means the first character must be a lowercase letter, and all
    * following characters must be a dash, lowercase letter, or digit,
    * except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#name GoogleComputePublicDelegatedPrefix#name}
    */
    readonly name: string;
    /**
    * The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#parent_prefix GoogleComputePublicDelegatedPrefix#parent_prefix}
    */
    readonly parentPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#project GoogleComputePublicDelegatedPrefix#project}
    */
    readonly project?: string;
    /**
    * A region where the prefix will reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#region GoogleComputePublicDelegatedPrefix#region}
    */
    readonly region: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#timeouts GoogleComputePublicDelegatedPrefix#timeouts}
    */
    readonly timeouts?: GoogleComputePublicDelegatedPrefixTimeouts;
}
export interface GoogleComputePublicDelegatedPrefixTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#create GoogleComputePublicDelegatedPrefix#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#delete GoogleComputePublicDelegatedPrefix#delete}
    */
    readonly delete?: string;
}
export declare function googleComputePublicDelegatedPrefixTimeoutsToTerraform(struct?: GoogleComputePublicDelegatedPrefixTimeouts | cdktf.IResolvable): any;
export declare function googleComputePublicDelegatedPrefixTimeoutsToHclTerraform(struct?: GoogleComputePublicDelegatedPrefixTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputePublicDelegatedPrefixTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePublicDelegatedPrefixTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputePublicDelegatedPrefixTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix google_compute_public_delegated_prefix}
*/
export declare class GoogleComputePublicDelegatedPrefix extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_public_delegated_prefix";
    /**
    * Generates CDKTF code for importing a GoogleComputePublicDelegatedPrefix resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputePublicDelegatedPrefix to import
    * @param importFromId The id of the existing GoogleComputePublicDelegatedPrefix that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputePublicDelegatedPrefix to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_public_delegated_prefix google_compute_public_delegated_prefix} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputePublicDelegatedPrefixConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputePublicDelegatedPrefixConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _isLiveMigration?;
    get isLiveMigration(): boolean | cdktf.IResolvable;
    set isLiveMigration(value: boolean | cdktf.IResolvable);
    resetIsLiveMigration(): void;
    get isLiveMigrationInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentPrefix?;
    get parentPrefix(): string;
    set parentPrefix(value: string);
    get parentPrefixInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleComputePublicDelegatedPrefixTimeoutsOutputReference;
    putTimeouts(value: GoogleComputePublicDelegatedPrefixTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputePublicDelegatedPrefixTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
