/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionCommitmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to enable automatic renewal for the commitment.
    * The default value is false if not specified.
    * If the field is set to true, the commitment will be automatically renewed for either
    * one or three years according to the terms of the existing commitment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#auto_renew GoogleComputeRegionCommitment#auto_renew}
    */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
    * The category of the commitment. Category MACHINE specifies commitments composed of
    * machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE
    * specifies commitments composed of software licenses, listed in licenseResources.
    * Note that only MACHINE commitments should have a Type specified. Possible values: ["LICENSE", "MACHINE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#category GoogleComputeRegionCommitment#category}
    */
    readonly category?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#description GoogleComputeRegionCommitment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#id GoogleComputeRegionCommitment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#name GoogleComputeRegionCommitment#name}
    */
    readonly name: string;
    /**
    * The plan for this commitment, which determines duration and discount rate.
    * The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years). Possible values: ["TWELVE_MONTH", "THIRTY_SIX_MONTH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#plan GoogleComputeRegionCommitment#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#project GoogleComputeRegionCommitment#project}
    */
    readonly project?: string;
    /**
    * URL of the region where this commitment may be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#region GoogleComputeRegionCommitment#region}
    */
    readonly region?: string;
    /**
    * The type of commitment, which affects the discount rate and the eligible resources.
    * The type could be one of the following value: 'MEMORY_OPTIMIZED', 'ACCELERATOR_OPTIMIZED',
    * 'GENERAL_PURPOSE_N1', 'GENERAL_PURPOSE_N2', 'GENERAL_PURPOSE_N2D', 'GENERAL_PURPOSE_E2',
    * 'GENERAL_PURPOSE_T2D', 'GENERAL_PURPOSE_C3', 'COMPUTE_OPTIMIZED_C2', 'COMPUTE_OPTIMIZED_C2D' and
    * 'GRAPHICS_OPTIMIZED_G2'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#type GoogleComputeRegionCommitment#type}
    */
    readonly type?: string;
    /**
    * license_resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#license_resource GoogleComputeRegionCommitment#license_resource}
    */
    readonly licenseResource?: GoogleComputeRegionCommitmentLicenseResource;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#resources GoogleComputeRegionCommitment#resources}
    */
    readonly resources?: GoogleComputeRegionCommitmentResources[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#timeouts GoogleComputeRegionCommitment#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionCommitmentTimeouts;
}
export interface GoogleComputeRegionCommitmentLicenseResource {
    /**
    * The number of licenses purchased.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#amount GoogleComputeRegionCommitment#amount}
    */
    readonly amount?: string;
    /**
    * Specifies the core range of the instance for which this license applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#cores_per_license GoogleComputeRegionCommitment#cores_per_license}
    */
    readonly coresPerLicense?: string;
    /**
    * Any applicable license URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#license GoogleComputeRegionCommitment#license}
    */
    readonly license: string;
}
export declare function googleComputeRegionCommitmentLicenseResourceToTerraform(struct?: GoogleComputeRegionCommitmentLicenseResourceOutputReference | GoogleComputeRegionCommitmentLicenseResource): any;
export declare function googleComputeRegionCommitmentLicenseResourceToHclTerraform(struct?: GoogleComputeRegionCommitmentLicenseResourceOutputReference | GoogleComputeRegionCommitmentLicenseResource): any;
export declare class GoogleComputeRegionCommitmentLicenseResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionCommitmentLicenseResource | undefined;
    set internalValue(value: GoogleComputeRegionCommitmentLicenseResource | undefined);
    private _amount?;
    get amount(): string;
    set amount(value: string);
    resetAmount(): void;
    get amountInput(): string | undefined;
    private _coresPerLicense?;
    get coresPerLicense(): string;
    set coresPerLicense(value: string);
    resetCoresPerLicense(): void;
    get coresPerLicenseInput(): string | undefined;
    private _license?;
    get license(): string;
    set license(value: string);
    get licenseInput(): string | undefined;
}
export interface GoogleComputeRegionCommitmentResources {
    /**
    * Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#accelerator_type GoogleComputeRegionCommitment#accelerator_type}
    */
    readonly acceleratorType?: string;
    /**
    * The amount of the resource purchased (in a type-dependent unit,
    * such as bytes). For vCPUs, this can just be an integer. For memory,
    * this must be provided in MB. Memory must be a multiple of 256 MB,
    * with up to 6.5GB of memory per every vCPU.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#amount GoogleComputeRegionCommitment#amount}
    */
    readonly amount?: string;
    /**
    * Type of resource for which this commitment applies.
    * Possible values are VCPU, MEMORY, LOCAL_SSD, and ACCELERATOR.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#type GoogleComputeRegionCommitment#type}
    */
    readonly type?: string;
}
export declare function googleComputeRegionCommitmentResourcesToTerraform(struct?: GoogleComputeRegionCommitmentResources | cdktf.IResolvable): any;
export declare function googleComputeRegionCommitmentResourcesToHclTerraform(struct?: GoogleComputeRegionCommitmentResources | cdktf.IResolvable): any;
export declare class GoogleComputeRegionCommitmentResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionCommitmentResources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionCommitmentResources | cdktf.IResolvable | undefined);
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    resetAcceleratorType(): void;
    get acceleratorTypeInput(): string | undefined;
    private _amount?;
    get amount(): string;
    set amount(value: string);
    resetAmount(): void;
    get amountInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeRegionCommitmentResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionCommitmentResources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionCommitmentResourcesOutputReference;
}
export interface GoogleComputeRegionCommitmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#create GoogleComputeRegionCommitment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#delete GoogleComputeRegionCommitment#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeRegionCommitmentTimeoutsToTerraform(struct?: GoogleComputeRegionCommitmentTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionCommitmentTimeoutsToHclTerraform(struct?: GoogleComputeRegionCommitmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionCommitmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionCommitmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionCommitmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment google_compute_region_commitment}
*/
export declare class GoogleComputeRegionCommitment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_commitment";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionCommitment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionCommitment to import
    * @param importFromId The id of the existing GoogleComputeRegionCommitment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionCommitment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_commitment google_compute_region_commitment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionCommitmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionCommitmentConfig);
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    resetAutoRenew(): void;
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _category?;
    get category(): string;
    set category(value: string);
    resetCategory(): void;
    get categoryInput(): string | undefined;
    get commitmentId(): number;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endTimestamp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get startTimestamp(): string;
    get status(): string;
    get statusMessage(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _licenseResource;
    get licenseResource(): GoogleComputeRegionCommitmentLicenseResourceOutputReference;
    putLicenseResource(value: GoogleComputeRegionCommitmentLicenseResource): void;
    resetLicenseResource(): void;
    get licenseResourceInput(): GoogleComputeRegionCommitmentLicenseResource | undefined;
    private _resources;
    get resources(): GoogleComputeRegionCommitmentResourcesList;
    putResources(value: GoogleComputeRegionCommitmentResources[] | cdktf.IResolvable): void;
    resetResources(): void;
    get resourcesInput(): cdktf.IResolvable | GoogleComputeRegionCommitmentResources[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionCommitmentTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionCommitmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionCommitmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
