/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#description GoogleComputeRegionDisk#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#id GoogleComputeRegionDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#interface GoogleComputeRegionDisk#interface}
    */
    readonly interface?: string;
    /**
    * Labels to apply to this disk.  A list of key->value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#labels GoogleComputeRegionDisk#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Any applicable license URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#licenses GoogleComputeRegionDisk#licenses}
    */
    readonly licenses?: string[];
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#name GoogleComputeRegionDisk#name}
    */
    readonly name: string;
    /**
    * Physical block size of the persistent disk, in bytes. If not present
    * in a request, a default value is used. Currently supported sizes
    * are 4096 and 16384, other sizes may be added in the future.
    * If an unsupported value is requested, the error message will list
    * the supported values for the caller's project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#physical_block_size_bytes GoogleComputeRegionDisk#physical_block_size_bytes}
    */
    readonly physicalBlockSizeBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#project GoogleComputeRegionDisk#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#region GoogleComputeRegionDisk#region}
    */
    readonly region?: string;
    /**
    * URLs of the zones where the disk should be replicated to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#replica_zones GoogleComputeRegionDisk#replica_zones}
    */
    readonly replicaZones: string[];
    /**
    * Size of the persistent disk, specified in GB. You can specify this
    * field when creating a persistent disk using the sourceImage or
    * sourceSnapshot parameter, or specify it alone to create an empty
    * persistent disk.
    *
    * If you specify this field along with sourceImage or sourceSnapshot,
    * the value of sizeGb must not be less than the size of the sourceImage
    * or the size of the snapshot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#size GoogleComputeRegionDisk#size}
    */
    readonly size?: number;
    /**
    * The source snapshot used to create this disk. You can provide this as
    * a partial or full URL to the resource. For example, the following are
    * valid values:
    *
    * * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
    * * 'projects/project/global/snapshots/snapshot'
    * * 'global/snapshots/snapshot'
    * * 'snapshot'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#snapshot GoogleComputeRegionDisk#snapshot}
    */
    readonly snapshot?: string;
    /**
    * The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
    * For example, the following are valid values:
    *
    * * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
    * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
    * * projects/{project}/zones/{zone}/disks/{disk}
    * * projects/{project}/regions/{region}/disks/{disk}
    * * zones/{zone}/disks/{disk}
    * * regions/{region}/disks/{disk}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#source_disk GoogleComputeRegionDisk#source_disk}
    */
    readonly sourceDisk?: string;
    /**
    * URL of the disk type resource describing which disk type to use to
    * create the disk. Provide this when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#type GoogleComputeRegionDisk#type}
    */
    readonly type?: string;
    /**
    * async_primary_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#async_primary_disk GoogleComputeRegionDisk#async_primary_disk}
    */
    readonly asyncPrimaryDisk?: GoogleComputeRegionDiskAsyncPrimaryDisk;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#disk_encryption_key GoogleComputeRegionDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: GoogleComputeRegionDiskDiskEncryptionKey;
    /**
    * guest_os_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#guest_os_features GoogleComputeRegionDisk#guest_os_features}
    */
    readonly guestOsFeatures?: GoogleComputeRegionDiskGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * source_snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#source_snapshot_encryption_key GoogleComputeRegionDisk#source_snapshot_encryption_key}
    */
    readonly sourceSnapshotEncryptionKey?: GoogleComputeRegionDiskSourceSnapshotEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#timeouts GoogleComputeRegionDisk#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionDiskTimeouts;
}
export interface GoogleComputeRegionDiskAsyncPrimaryDisk {
    /**
    * Primary disk for asynchronous disk replication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#disk GoogleComputeRegionDisk#disk}
    */
    readonly disk: string;
}
export declare function googleComputeRegionDiskAsyncPrimaryDiskToTerraform(struct?: GoogleComputeRegionDiskAsyncPrimaryDiskOutputReference | GoogleComputeRegionDiskAsyncPrimaryDisk): any;
export declare function googleComputeRegionDiskAsyncPrimaryDiskToHclTerraform(struct?: GoogleComputeRegionDiskAsyncPrimaryDiskOutputReference | GoogleComputeRegionDiskAsyncPrimaryDisk): any;
export declare class GoogleComputeRegionDiskAsyncPrimaryDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionDiskAsyncPrimaryDisk | undefined;
    set internalValue(value: GoogleComputeRegionDiskAsyncPrimaryDisk | undefined);
    private _disk?;
    get disk(): string;
    set disk(value: string);
    get diskInput(): string | undefined;
}
export interface GoogleComputeRegionDiskDiskEncryptionKey {
    /**
    * The name of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#kms_key_name GoogleComputeRegionDisk#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#raw_key GoogleComputeRegionDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function googleComputeRegionDiskDiskEncryptionKeyToTerraform(struct?: GoogleComputeRegionDiskDiskEncryptionKeyOutputReference | GoogleComputeRegionDiskDiskEncryptionKey): any;
export declare function googleComputeRegionDiskDiskEncryptionKeyToHclTerraform(struct?: GoogleComputeRegionDiskDiskEncryptionKeyOutputReference | GoogleComputeRegionDiskDiskEncryptionKey): any;
export declare class GoogleComputeRegionDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionDiskDiskEncryptionKey | undefined;
    set internalValue(value: GoogleComputeRegionDiskDiskEncryptionKey | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeRegionDiskGuestOsFeatures {
    /**
    * The type of supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Possible values: ["MULTI_IP_SUBNET", "SECURE_BOOT", "SEV_CAPABLE", "UEFI_COMPATIBLE", "VIRTIO_SCSI_MULTIQUEUE", "WINDOWS", "GVNIC", "SEV_LIVE_MIGRATABLE", "SEV_SNP_CAPABLE", "SUSPEND_RESUME_COMPATIBLE", "TDX_CAPABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#type GoogleComputeRegionDisk#type}
    */
    readonly type: string;
}
export declare function googleComputeRegionDiskGuestOsFeaturesToTerraform(struct?: GoogleComputeRegionDiskGuestOsFeatures | cdktf.IResolvable): any;
export declare function googleComputeRegionDiskGuestOsFeaturesToHclTerraform(struct?: GoogleComputeRegionDiskGuestOsFeatures | cdktf.IResolvable): any;
export declare class GoogleComputeRegionDiskGuestOsFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionDiskGuestOsFeatures | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionDiskGuestOsFeatures | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleComputeRegionDiskGuestOsFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionDiskGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionDiskGuestOsFeaturesOutputReference;
}
export interface GoogleComputeRegionDiskSourceSnapshotEncryptionKey {
    /**
    * The name of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#kms_key_name GoogleComputeRegionDisk#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
    * RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#raw_key GoogleComputeRegionDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function googleComputeRegionDiskSourceSnapshotEncryptionKeyToTerraform(struct?: GoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeRegionDiskSourceSnapshotEncryptionKey): any;
export declare function googleComputeRegionDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: GoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeRegionDiskSourceSnapshotEncryptionKey): any;
export declare class GoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: GoogleComputeRegionDiskSourceSnapshotEncryptionKey | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface GoogleComputeRegionDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#create GoogleComputeRegionDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#delete GoogleComputeRegionDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#update GoogleComputeRegionDisk#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionDiskTimeoutsToTerraform(struct?: GoogleComputeRegionDiskTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionDiskTimeoutsToHclTerraform(struct?: GoogleComputeRegionDiskTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk google_compute_region_disk}
*/
export declare class GoogleComputeRegionDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_disk";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionDisk to import
    * @param importFromId The id of the existing GoogleComputeRegionDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_disk google_compute_region_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionDiskConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionDiskConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _licenses?;
    get licenses(): string[];
    set licenses(value: string[]);
    resetLicenses(): void;
    get licensesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    get physicalBlockSizeBytes(): number;
    set physicalBlockSizeBytes(value: number);
    resetPhysicalBlockSizeBytes(): void;
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaZones?;
    get replicaZones(): string[];
    set replicaZones(value: string[]);
    get replicaZonesInput(): string[] | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshot?;
    get snapshot(): string;
    set snapshot(value: string);
    resetSnapshot(): void;
    get snapshotInput(): string | undefined;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    resetSourceDisk(): void;
    get sourceDiskInput(): string | undefined;
    get sourceDiskId(): string;
    get sourceSnapshotId(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    private _asyncPrimaryDisk;
    get asyncPrimaryDisk(): GoogleComputeRegionDiskAsyncPrimaryDiskOutputReference;
    putAsyncPrimaryDisk(value: GoogleComputeRegionDiskAsyncPrimaryDisk): void;
    resetAsyncPrimaryDisk(): void;
    get asyncPrimaryDiskInput(): GoogleComputeRegionDiskAsyncPrimaryDisk | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): GoogleComputeRegionDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: GoogleComputeRegionDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): GoogleComputeRegionDiskDiskEncryptionKey | undefined;
    private _guestOsFeatures;
    get guestOsFeatures(): GoogleComputeRegionDiskGuestOsFeaturesList;
    putGuestOsFeatures(value: GoogleComputeRegionDiskGuestOsFeatures[] | cdktf.IResolvable): void;
    resetGuestOsFeatures(): void;
    get guestOsFeaturesInput(): cdktf.IResolvable | GoogleComputeRegionDiskGuestOsFeatures[] | undefined;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): GoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: GoogleComputeRegionDiskSourceSnapshotEncryptionKey): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): GoogleComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionDiskTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
