/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * How often (in seconds) to send a health check. The default value is 5
    * seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#check_interval_sec GoogleComputeRegionHealthCheck#check_interval_sec}
    */
    readonly checkIntervalSec?: number;
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#description GoogleComputeRegionHealthCheck#description}
    */
    readonly description?: string;
    /**
    * A so-far unhealthy instance will be marked healthy after this many
    * consecutive successes. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#healthy_threshold GoogleComputeRegionHealthCheck#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#id GoogleComputeRegionHealthCheck#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035.  Specifically, the name must be 1-63 characters long and
    * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
    * the first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the
    * last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#name GoogleComputeRegionHealthCheck#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#project GoogleComputeRegionHealthCheck#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created health check should reside.
    * If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#region GoogleComputeRegionHealthCheck#region}
    */
    readonly region?: string;
    /**
    * How long (in seconds) to wait before claiming failure.
    * The default value is 5 seconds.  It is invalid for timeoutSec to have
    * greater value than checkIntervalSec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#timeout_sec GoogleComputeRegionHealthCheck#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * A so-far healthy instance will be marked unhealthy after this many
    * consecutive failures. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#unhealthy_threshold GoogleComputeRegionHealthCheck#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
    /**
    * grpc_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#grpc_health_check GoogleComputeRegionHealthCheck#grpc_health_check}
    */
    readonly grpcHealthCheck?: GoogleComputeRegionHealthCheckGrpcHealthCheck;
    /**
    * http2_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#http2_health_check GoogleComputeRegionHealthCheck#http2_health_check}
    */
    readonly http2HealthCheck?: GoogleComputeRegionHealthCheckHttp2HealthCheck;
    /**
    * http_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#http_health_check GoogleComputeRegionHealthCheck#http_health_check}
    */
    readonly httpHealthCheck?: GoogleComputeRegionHealthCheckHttpHealthCheck;
    /**
    * https_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#https_health_check GoogleComputeRegionHealthCheck#https_health_check}
    */
    readonly httpsHealthCheck?: GoogleComputeRegionHealthCheckHttpsHealthCheck;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#log_config GoogleComputeRegionHealthCheck#log_config}
    */
    readonly logConfig?: GoogleComputeRegionHealthCheckLogConfig;
    /**
    * ssl_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#ssl_health_check GoogleComputeRegionHealthCheck#ssl_health_check}
    */
    readonly sslHealthCheck?: GoogleComputeRegionHealthCheckSslHealthCheck;
    /**
    * tcp_health_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#tcp_health_check GoogleComputeRegionHealthCheck#tcp_health_check}
    */
    readonly tcpHealthCheck?: GoogleComputeRegionHealthCheckTcpHealthCheck;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#timeouts GoogleComputeRegionHealthCheck#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionHealthCheckTimeouts;
}
export interface GoogleComputeRegionHealthCheckGrpcHealthCheck {
    /**
    * The gRPC service name for the health check.
    * The value of grpcServiceName has the following meanings by convention:
    *
    * * Empty serviceName means the overall status of all services at the backend.
    * * Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
    *
    * The grpcServiceName can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#grpc_service_name GoogleComputeRegionHealthCheck#grpc_service_name}
    */
    readonly grpcServiceName?: string;
    /**
    * The port number for the health check request.
    * Must be specified if portName and portSpecification are not set
    * or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, gRPC health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
}
export declare function googleComputeRegionHealthCheckGrpcHealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckGrpcHealthCheckOutputReference | GoogleComputeRegionHealthCheckGrpcHealthCheck): any;
export declare function googleComputeRegionHealthCheckGrpcHealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckGrpcHealthCheckOutputReference | GoogleComputeRegionHealthCheckGrpcHealthCheck): any;
export declare class GoogleComputeRegionHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckGrpcHealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckGrpcHealthCheck | undefined);
    private _grpcServiceName?;
    get grpcServiceName(): string;
    set grpcServiceName(value: string);
    resetGrpcServiceName(): void;
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckHttp2HealthCheck {
    /**
    * The value of the host header in the HTTP2 health check request.
    * If left empty (default value), the public IP on behalf of which this health
    * check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#host GoogleComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP2 health check request.
    * The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, HTTP2 health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
    * backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#proxy_header GoogleComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP2 health check request.
    * The default value is /.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#request_path GoogleComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
    * (the default value), any response will indicate health. The response data
    * can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#response GoogleComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeRegionHealthCheckHttp2HealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckHttp2HealthCheckOutputReference | GoogleComputeRegionHealthCheckHttp2HealthCheck): any;
export declare function googleComputeRegionHealthCheckHttp2HealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckHttp2HealthCheckOutputReference | GoogleComputeRegionHealthCheckHttp2HealthCheck): any;
export declare class GoogleComputeRegionHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckHttp2HealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckHttp2HealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckHttpHealthCheck {
    /**
    * The value of the host header in the HTTP health check request.
    * If left empty (default value), the public IP on behalf of which this health
    * check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#host GoogleComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP health check request.
    * The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, HTTP health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
    * backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#proxy_header GoogleComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP health check request.
    * The default value is /.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#request_path GoogleComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
    * (the default value), any response will indicate health. The response data
    * can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#response GoogleComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeRegionHealthCheckHttpHealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckHttpHealthCheckOutputReference | GoogleComputeRegionHealthCheckHttpHealthCheck): any;
export declare function googleComputeRegionHealthCheckHttpHealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckHttpHealthCheckOutputReference | GoogleComputeRegionHealthCheckHttpHealthCheck): any;
export declare class GoogleComputeRegionHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckHttpHealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckHttpHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckHttpsHealthCheck {
    /**
    * The value of the host header in the HTTPS health check request.
    * If left empty (default value), the public IP on behalf of which this health
    * check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#host GoogleComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTPS health check request.
    * The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, HTTPS health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
    * backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#proxy_header GoogleComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTPS health check request.
    * The default value is /.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#request_path GoogleComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
    * (the default value), any response will indicate health. The response data
    * can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#response GoogleComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeRegionHealthCheckHttpsHealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckHttpsHealthCheckOutputReference | GoogleComputeRegionHealthCheckHttpsHealthCheck): any;
export declare function googleComputeRegionHealthCheckHttpsHealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckHttpsHealthCheckOutputReference | GoogleComputeRegionHealthCheckHttpsHealthCheck): any;
export declare class GoogleComputeRegionHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckHttpsHealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckHttpsHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckLogConfig {
    /**
    * Indicates whether or not to export logs. This is false by default,
    * which means no health check logging will be done.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#enable GoogleComputeRegionHealthCheck#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionHealthCheckLogConfigToTerraform(struct?: GoogleComputeRegionHealthCheckLogConfigOutputReference | GoogleComputeRegionHealthCheckLogConfig): any;
export declare function googleComputeRegionHealthCheckLogConfigToHclTerraform(struct?: GoogleComputeRegionHealthCheckLogConfigOutputReference | GoogleComputeRegionHealthCheckLogConfig): any;
export declare class GoogleComputeRegionHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckLogConfig | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionHealthCheckSslHealthCheck {
    /**
    * The TCP port number for the SSL health check request.
    * The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, SSL health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
    * backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#proxy_header GoogleComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the SSL connection has been
    * established (default value is empty). If both request and response are
    * empty, the connection establishment alone will indicate health. The request
    * data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#request GoogleComputeRegionHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
    * (the default value), any response will indicate health. The response data
    * can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#response GoogleComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeRegionHealthCheckSslHealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckSslHealthCheckOutputReference | GoogleComputeRegionHealthCheckSslHealthCheck): any;
export declare function googleComputeRegionHealthCheckSslHealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckSslHealthCheckOutputReference | GoogleComputeRegionHealthCheckSslHealthCheck): any;
export declare class GoogleComputeRegionHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckSslHealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckSslHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckTcpHealthCheck {
    /**
    * The TCP port number for the TCP health check request.
    * The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port GoogleComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
    * port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_name GoogleComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
    * following values:
    *
    *   * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
    *
    *   * 'USE_NAMED_PORT': The 'portName' is used for health checking.
    *
    *   * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    *   network endpoint is used for health checking. For other backends, the
    *   port or named port specified in the Backend Service is used for health
    *   checking.
    *
    * If not specified, TCP health check follows behavior specified in 'port' and
    * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#port_specification GoogleComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
    * backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#proxy_header GoogleComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the TCP connection has been
    * established (default value is empty). If both request and response are
    * empty, the connection establishment alone will indicate health. The request
    * data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#request GoogleComputeRegionHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
    * (the default value), any response will indicate health. The response data
    * can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#response GoogleComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeRegionHealthCheckTcpHealthCheckToTerraform(struct?: GoogleComputeRegionHealthCheckTcpHealthCheckOutputReference | GoogleComputeRegionHealthCheckTcpHealthCheck): any;
export declare function googleComputeRegionHealthCheckTcpHealthCheckToHclTerraform(struct?: GoogleComputeRegionHealthCheckTcpHealthCheckOutputReference | GoogleComputeRegionHealthCheckTcpHealthCheck): any;
export declare class GoogleComputeRegionHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckTcpHealthCheck | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckTcpHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeRegionHealthCheckTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#create GoogleComputeRegionHealthCheck#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#delete GoogleComputeRegionHealthCheck#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#update GoogleComputeRegionHealthCheck#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionHealthCheckTimeoutsToTerraform(struct?: GoogleComputeRegionHealthCheckTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionHealthCheckTimeoutsToHclTerraform(struct?: GoogleComputeRegionHealthCheckTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionHealthCheckTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionHealthCheckTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check google_compute_region_health_check}
*/
export declare class GoogleComputeRegionHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_health_check";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionHealthCheck resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionHealthCheck to import
    * @param importFromId The id of the existing GoogleComputeRegionHealthCheck that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionHealthCheck to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_health_check google_compute_region_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number;
    set checkIntervalSec(value: number);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    get type(): string;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck;
    get grpcHealthCheck(): GoogleComputeRegionHealthCheckGrpcHealthCheckOutputReference;
    putGrpcHealthCheck(value: GoogleComputeRegionHealthCheckGrpcHealthCheck): void;
    resetGrpcHealthCheck(): void;
    get grpcHealthCheckInput(): GoogleComputeRegionHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck;
    get http2HealthCheck(): GoogleComputeRegionHealthCheckHttp2HealthCheckOutputReference;
    putHttp2HealthCheck(value: GoogleComputeRegionHealthCheckHttp2HealthCheck): void;
    resetHttp2HealthCheck(): void;
    get http2HealthCheckInput(): GoogleComputeRegionHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck;
    get httpHealthCheck(): GoogleComputeRegionHealthCheckHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: GoogleComputeRegionHealthCheckHttpHealthCheck): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): GoogleComputeRegionHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck;
    get httpsHealthCheck(): GoogleComputeRegionHealthCheckHttpsHealthCheckOutputReference;
    putHttpsHealthCheck(value: GoogleComputeRegionHealthCheckHttpsHealthCheck): void;
    resetHttpsHealthCheck(): void;
    get httpsHealthCheckInput(): GoogleComputeRegionHealthCheckHttpsHealthCheck | undefined;
    private _logConfig;
    get logConfig(): GoogleComputeRegionHealthCheckLogConfigOutputReference;
    putLogConfig(value: GoogleComputeRegionHealthCheckLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleComputeRegionHealthCheckLogConfig | undefined;
    private _sslHealthCheck;
    get sslHealthCheck(): GoogleComputeRegionHealthCheckSslHealthCheckOutputReference;
    putSslHealthCheck(value: GoogleComputeRegionHealthCheckSslHealthCheck): void;
    resetSslHealthCheck(): void;
    get sslHealthCheckInput(): GoogleComputeRegionHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck;
    get tcpHealthCheck(): GoogleComputeRegionHealthCheckTcpHealthCheckOutputReference;
    putTcpHealthCheck(value: GoogleComputeRegionHealthCheckTcpHealthCheck): void;
    resetTcpHealthCheck(): void;
    get tcpHealthCheckInput(): GoogleComputeRegionHealthCheckTcpHealthCheck | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionHealthCheckTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionHealthCheckTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
