/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to allow sending and receiving of packets with non-matching source or destination IPs. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#can_ip_forward GoogleComputeRegionInstanceTemplate#can_ip_forward}
    */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
    * A brief description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#description GoogleComputeRegionInstanceTemplate#description}
    */
    readonly description?: string;
    /**
    * Enable Virtual Displays on this instance. Note: allow_stopping_for_update must be set to true in order to update this field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_display GoogleComputeRegionInstanceTemplate#enable_display}
    */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#id GoogleComputeRegionInstanceTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A description of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#instance_description GoogleComputeRegionInstanceTemplate#instance_description}
    */
    readonly instanceDescription?: string;
    /**
    * A set of key/value label pairs to assign to instances created from this template,
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#labels GoogleComputeRegionInstanceTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to create. To create a machine with a custom type (such as extended memory), format the value like custom-VCPUS-MEM_IN_MB like custom-6-20480 for 6 vCPU and 20GB of RAM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#machine_type GoogleComputeRegionInstanceTemplate#machine_type}
    */
    readonly machineType: string;
    /**
    * Metadata key/value pairs to make available from within instances created from this template.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#metadata GoogleComputeRegionInstanceTemplate#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * An alternative to using the startup-script metadata key, mostly to match the compute_instance resource. This replaces the startup-script metadata key on the created instance and thus the two mechanisms are not allowed to be used simultaneously.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#metadata_startup_script GoogleComputeRegionInstanceTemplate#metadata_startup_script}
    */
    readonly metadataStartupScript?: string;
    /**
    * Specifies a minimum CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell or Intel Skylake.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#min_cpu_platform GoogleComputeRegionInstanceTemplate#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#name GoogleComputeRegionInstanceTemplate#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#name_prefix GoogleComputeRegionInstanceTemplate#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#project GoogleComputeRegionInstanceTemplate#project}
    */
    readonly project?: string;
    /**
    * The region in which the instance template is located. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#region GoogleComputeRegionInstanceTemplate#region}
    */
    readonly region?: string;
    /**
    * A map of resource manager tags.
    * 				Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#resource_manager_tags GoogleComputeRegionInstanceTemplate#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#resource_policies GoogleComputeRegionInstanceTemplate#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * Tags to attach to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#tags GoogleComputeRegionInstanceTemplate#tags}
    */
    readonly tags?: string[];
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#advanced_machine_features GoogleComputeRegionInstanceTemplate#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures;
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#confidential_instance_config GoogleComputeRegionInstanceTemplate#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#disk GoogleComputeRegionInstanceTemplate#disk}
    */
    readonly disk: GoogleComputeRegionInstanceTemplateDisk[] | cdktf.IResolvable;
    /**
    * guest_accelerator block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#guest_accelerator GoogleComputeRegionInstanceTemplate#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleComputeRegionInstanceTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network_interface GoogleComputeRegionInstanceTemplate#network_interface}
    */
    readonly networkInterface?: GoogleComputeRegionInstanceTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * network_performance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network_performance_config GoogleComputeRegionInstanceTemplate#network_performance_config}
    */
    readonly networkPerformanceConfig?: GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#reservation_affinity GoogleComputeRegionInstanceTemplate#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleComputeRegionInstanceTemplateReservationAffinity;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#scheduling GoogleComputeRegionInstanceTemplate#scheduling}
    */
    readonly scheduling?: GoogleComputeRegionInstanceTemplateScheduling;
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#service_account GoogleComputeRegionInstanceTemplate#service_account}
    */
    readonly serviceAccount?: GoogleComputeRegionInstanceTemplateServiceAccount;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#shielded_instance_config GoogleComputeRegionInstanceTemplate#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleComputeRegionInstanceTemplateShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#timeouts GoogleComputeRegionInstanceTemplate#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionInstanceTemplateTimeouts;
}
export interface GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures {
    /**
    * Whether to enable nested virtualization or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_nested_virtualization GoogleComputeRegionInstanceTemplate#enable_nested_virtualization}
    */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#threads_per_core GoogleComputeRegionInstanceTemplate#threads_per_core}
    */
    readonly threadsPerCore?: number;
    /**
    * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance\'s nominal CPU count and the underlying platform\'s SMT width.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#visible_core_count GoogleComputeRegionInstanceTemplate#visible_core_count}
    */
    readonly visibleCoreCount?: number;
}
export declare function googleComputeRegionInstanceTemplateAdvancedMachineFeaturesToTerraform(struct?: GoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference | GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures): any;
export declare function googleComputeRegionInstanceTemplateAdvancedMachineFeaturesToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference | GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures): any;
export declare class GoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures | undefined);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
    private _visibleCoreCount?;
    get visibleCoreCount(): number;
    set visibleCoreCount(value: number);
    resetVisibleCoreCount(): void;
    get visibleCoreCountInput(): number | undefined;
}
export interface GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig {
    /**
    *
    * 								Specifies which confidential computing technology to use.
    * 								This could be one of the following values: SEV, SEV_SNP.
    * 								If SEV_SNP, min_cpu_platform = "AMD Milan" is currently required.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#confidential_instance_type GoogleComputeRegionInstanceTemplate#confidential_instance_type}
    */
    readonly confidentialInstanceType?: string;
    /**
    * Defines whether the instance should have confidential compute enabled. Field will be deprecated in a future release.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_confidential_compute GoogleComputeRegionInstanceTemplate#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionInstanceTemplateConfidentialInstanceConfigToTerraform(struct?: GoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference | GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig): any;
export declare function googleComputeRegionInstanceTemplateConfidentialInstanceConfigToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference | GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig): any;
export declare class GoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig | undefined);
    private _confidentialInstanceType?;
    get confidentialInstanceType(): string;
    set confidentialInstanceType(value: string);
    resetConfidentialInstanceType(): void;
    get confidentialInstanceTypeInput(): string | undefined;
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey {
    /**
    * The self link of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#kms_key_self_link GoogleComputeRegionInstanceTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink: string;
}
export declare function googleComputeRegionInstanceTemplateDiskDiskEncryptionKeyToTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey): any;
export declare function googleComputeRegionInstanceTemplateDiskDiskEncryptionKeyToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey): any;
export declare class GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    get kmsKeySelfLinkInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey {
    /**
    * The self link of the encryption key that is stored in
    * Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#kms_key_self_link GoogleComputeRegionInstanceTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink: string;
    /**
    * The service account being used for the encryption
    * request for the given KMS key. If absent, the Compute
    * Engine default service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#kms_key_service_account GoogleComputeRegionInstanceTemplate#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
}
export declare function googleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyToTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare function googleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare class GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey {
    /**
    * The self link of the encryption key that is stored in
    * Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#kms_key_self_link GoogleComputeRegionInstanceTemplate#kms_key_self_link}
    */
    readonly kmsKeySelfLink: string;
    /**
    * The service account being used for the encryption
    * request for the given KMS key. If absent, the Compute
    * Engine default service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#kms_key_service_account GoogleComputeRegionInstanceTemplate#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
}
export declare function googleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyToTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare function googleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference | GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare class GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceTemplateDisk {
    /**
    * Whether or not the disk should be auto-deleted. This defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#auto_delete GoogleComputeRegionInstanceTemplate#auto_delete}
    */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
    * Indicates that this is a boot disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#boot GoogleComputeRegionInstanceTemplate#boot}
    */
    readonly boot?: boolean | cdktf.IResolvable;
    /**
    * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance. If not specified, the server chooses a default device name to apply to this disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#device_name GoogleComputeRegionInstanceTemplate#device_name}
    */
    readonly deviceName?: string;
    /**
    * Name of the disk. When not provided, this defaults to the name of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#disk_name GoogleComputeRegionInstanceTemplate#disk_name}
    */
    readonly diskName?: string;
    /**
    * The size of the image in gigabytes. If not specified, it will inherit the size of its base image. For SCRATCH disks, the size must be one of 375 or 3000 GB, with a default of 375 GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#disk_size_gb GoogleComputeRegionInstanceTemplate#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The Google Compute Engine disk type. Such as "pd-ssd", "local-ssd", "pd-balanced" or "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#disk_type GoogleComputeRegionInstanceTemplate#disk_type}
    */
    readonly diskType?: string;
    /**
    * Specifies the disk interface to use for attaching this disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#interface GoogleComputeRegionInstanceTemplate#interface}
    */
    readonly interface?: string;
    /**
    * A set of key/value label pairs to assign to disks,
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#labels GoogleComputeRegionInstanceTemplate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If you are attaching or creating a boot disk, this must read-write mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#mode GoogleComputeRegionInstanceTemplate#mode}
    */
    readonly mode?: string;
    /**
    * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the [Extreme persistent disk documentation](https://cloud.google.com/compute/docs/disks/extreme-persistent-disk).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#provisioned_iops GoogleComputeRegionInstanceTemplate#provisioned_iops}
    */
    readonly provisionedIops?: number;
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#resource_manager_tags GoogleComputeRegionInstanceTemplate#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * A list (short name or id) of resource policies to attach to this disk. Currently a max of 1 resource policy is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#resource_policies GoogleComputeRegionInstanceTemplate#resource_policies}
    */
    readonly resourcePolicies?: string[];
    /**
    * The name (not self_link) of the disk (such as those managed by google_compute_disk) to attach. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#source GoogleComputeRegionInstanceTemplate#source}
    */
    readonly source?: string;
    /**
    * The image from which to initialize this disk. This can be one of: the image's self_link, projects/{project}/global/images/{image}, projects/{project}/global/images/family/{family}, global/images/{image}, global/images/family/{family}, family/{family}, {project}/{family}, {project}/{image}, {family}, or {image}. ~> Note: Either source or source_image is required when creating a new instance except for when creating a local SSD.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#source_image GoogleComputeRegionInstanceTemplate#source_image}
    */
    readonly sourceImage?: string;
    /**
    * The source snapshot to create this disk. When creating
    * a new instance, one of initializeParams.sourceSnapshot,
    * initializeParams.sourceImage, or disks.source is
    * required except for local SSD.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#source_snapshot GoogleComputeRegionInstanceTemplate#source_snapshot}
    */
    readonly sourceSnapshot?: string;
    /**
    * The type of Google Compute Engine disk, can be either "SCRATCH" or "PERSISTENT".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#type GoogleComputeRegionInstanceTemplate#type}
    */
    readonly type?: string;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#disk_encryption_key GoogleComputeRegionInstanceTemplate#disk_encryption_key}
    */
    readonly diskEncryptionKey?: GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey;
    /**
    * source_image_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#source_image_encryption_key GoogleComputeRegionInstanceTemplate#source_image_encryption_key}
    */
    readonly sourceImageEncryptionKey?: GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey;
    /**
    * source_snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#source_snapshot_encryption_key GoogleComputeRegionInstanceTemplate#source_snapshot_encryption_key}
    */
    readonly sourceSnapshotEncryptionKey?: GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey;
}
export declare function googleComputeRegionInstanceTemplateDiskToTerraform(struct?: GoogleComputeRegionInstanceTemplateDisk | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateDiskToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateDisk | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateDisk | cdktf.IResolvable | undefined);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable;
    set autoDelete(value: boolean | cdktf.IResolvable);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _boot?;
    get boot(): boolean | cdktf.IResolvable;
    set boot(value: boolean | cdktf.IResolvable);
    resetBoot(): void;
    get bootInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    resetDiskName(): void;
    get diskNameInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _provisionedIops?;
    get provisionedIops(): number;
    set provisionedIops(value: number);
    resetProvisionedIops(): void;
    get provisionedIopsInput(): number | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _diskEncryptionKey;
    get diskEncryptionKey(): GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): GoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey | undefined;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference;
    putSourceImageEncryptionKey(value: GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey): void;
    resetSourceImageEncryptionKey(): void;
    get sourceImageEncryptionKeyInput(): GoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): GoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateDiskOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateGuestAccelerator {
    /**
    * The number of the guest accelerator cards exposed to this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#count GoogleComputeRegionInstanceTemplate#count}
    */
    readonly count: number;
    /**
    * The accelerator type resource to expose to this instance. E.g. nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#type GoogleComputeRegionInstanceTemplate#type}
    */
    readonly type: string;
}
export declare function googleComputeRegionInstanceTemplateGuestAcceleratorToTerraform(struct?: GoogleComputeRegionInstanceTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateGuestAcceleratorToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateGuestAcceleratorOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig {
    /**
    * The IP address that will be 1:1 mapped to the instance's network ip. If not given, one will be generated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#nat_ip GoogleComputeRegionInstanceTemplate#nat_ip}
    */
    readonly natIp?: string;
    /**
    * The networking tier used for configuring this instance template. This field can take the following values: PREMIUM, STANDARD, FIXED_STANDARD. If this field is not specified, it is assumed to be PREMIUM.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network_tier GoogleComputeRegionInstanceTemplate#network_tier}
    */
    readonly networkTier?: string;
}
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigToTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | cdktf.IResolvable | undefined);
    private _natIp?;
    get natIp(): string;
    set natIp(value: string);
    resetNatIp(): void;
    get natIpInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    get publicPtrDomainName(): string;
}
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange {
    /**
    * The IP CIDR range represented by this alias IP range. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. At the time of writing only a netmask (e.g. /24) may be supplied, with a CIDR format resulting in an API error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#ip_cidr_range GoogleComputeRegionInstanceTemplate#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range. If left unspecified, the primary range of the subnetwork will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#subnetwork_range_name GoogleComputeRegionInstanceTemplate#subnetwork_range_name}
    */
    readonly subnetworkRangeName?: string;
}
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _subnetworkRangeName?;
    get subnetworkRangeName(): string;
    set subnetworkRangeName(value: string);
    resetSubnetworkRangeName(): void;
    get subnetworkRangeNameInput(): string | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig {
    /**
    * The service-level to be provided for IPv6 traffic when the subnet has an external subnet. Only PREMIUM tier is valid for IPv6
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network_tier GoogleComputeRegionInstanceTemplate#network_tier}
    */
    readonly networkTier: string;
}
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | cdktf.IResolvable | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get name(): string;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    get publicPtrDomainName(): string;
}
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateNetworkInterface {
    /**
    * The prefix length of the primary internal IPv6 range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#internal_ipv6_prefix_length GoogleComputeRegionInstanceTemplate#internal_ipv6_prefix_length}
    */
    readonly internalIpv6PrefixLength?: number;
    /**
    * An IPv6 internal network address for this network interface. If not specified, Google Cloud will automatically assign an internal IPv6 address from the instance's subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#ipv6_address GoogleComputeRegionInstanceTemplate#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The name or self_link of the network to attach this interface to. Use network attribute for Legacy or Auto subnetted networks and subnetwork for custom subnetted networks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network GoogleComputeRegionInstanceTemplate#network}
    */
    readonly network?: string;
    /**
    * The private IP address to assign to the instance. If empty, the address will be automatically assigned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#network_ip GoogleComputeRegionInstanceTemplate#network_ip}
    */
    readonly networkIp?: string;
    /**
    * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#nic_type GoogleComputeRegionInstanceTemplate#nic_type}
    */
    readonly nicType?: string;
    /**
    * The networking queue count that's specified by users for the network interface. Both Rx and Tx queues will be set to this number. It will be empty if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#queue_count GoogleComputeRegionInstanceTemplate#queue_count}
    */
    readonly queueCount?: number;
    /**
    * The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#stack_type GoogleComputeRegionInstanceTemplate#stack_type}
    */
    readonly stackType?: string;
    /**
    * The name of the subnetwork to attach this interface to. The subnetwork must exist in the same region this instance will be created in. Either network or subnetwork must be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#subnetwork GoogleComputeRegionInstanceTemplate#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The ID of the project in which the subnetwork belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#subnetwork_project GoogleComputeRegionInstanceTemplate#subnetwork_project}
    */
    readonly subnetworkProject?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#access_config GoogleComputeRegionInstanceTemplate#access_config}
    */
    readonly accessConfig?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable;
    /**
    * alias_ip_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#alias_ip_range GoogleComputeRegionInstanceTemplate#alias_ip_range}
    */
    readonly aliasIpRange?: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable;
    /**
    * ipv6_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#ipv6_access_config GoogleComputeRegionInstanceTemplate#ipv6_access_config}
    */
    readonly ipv6AccessConfig?: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable;
}
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceToTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterface | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateNetworkInterfaceToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkInterface | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateNetworkInterface | cdktf.IResolvable | undefined);
    private _internalIpv6PrefixLength?;
    get internalIpv6PrefixLength(): number;
    set internalIpv6PrefixLength(value: number);
    resetInternalIpv6PrefixLength(): void;
    get internalIpv6PrefixLengthInput(): number | undefined;
    get ipv6AccessType(): string;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkIp?;
    get networkIp(): string;
    set networkIp(value: string);
    resetNetworkIp(): void;
    get networkIpInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _queueCount?;
    get queueCount(): number;
    set queueCount(value: number);
    resetQueueCount(): void;
    get queueCountInput(): number | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _subnetworkProject?;
    get subnetworkProject(): string;
    set subnetworkProject(value: string);
    resetSubnetworkProject(): void;
    get subnetworkProjectInput(): string | undefined;
    private _accessConfig;
    get accessConfig(): GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigList;
    putAccessConfig(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig[] | cdktf.IResolvable): void;
    resetAccessConfig(): void;
    get accessConfigInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig[] | undefined;
    private _aliasIpRange;
    get aliasIpRange(): GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeList;
    putAliasIpRange(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange[] | cdktf.IResolvable): void;
    resetAliasIpRange(): void;
    get aliasIpRangeInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange[] | undefined;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigList;
    putIpv6AccessConfig(value: GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | cdktf.IResolvable): void;
    resetIpv6AccessConfig(): void;
    get ipv6AccessConfigInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig[] | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateNetworkInterfaceOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig {
    /**
    * The egress bandwidth tier to enable. Possible values:TIER_1, DEFAULT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#total_egress_bandwidth_tier GoogleComputeRegionInstanceTemplate#total_egress_bandwidth_tier}
    */
    readonly totalEgressBandwidthTier: string;
}
export declare function googleComputeRegionInstanceTemplateNetworkPerformanceConfigToTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference | GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig): any;
export declare function googleComputeRegionInstanceTemplateNetworkPerformanceConfigToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference | GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig): any;
export declare class GoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig | undefined);
    private _totalEgressBandwidthTier?;
    get totalEgressBandwidthTier(): string;
    set totalEgressBandwidthTier(value: string);
    get totalEgressBandwidthTierInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation {
    /**
    * Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#key GoogleComputeRegionInstanceTemplate#key}
    */
    readonly key: string;
    /**
    * Corresponds to the label values of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#values GoogleComputeRegionInstanceTemplate#values}
    */
    readonly values: string[];
}
export declare function googleComputeRegionInstanceTemplateReservationAffinitySpecificReservationToTerraform(struct?: GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference | GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation): any;
export declare function googleComputeRegionInstanceTemplateReservationAffinitySpecificReservationToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference | GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation): any;
export declare class GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleComputeRegionInstanceTemplateReservationAffinity {
    /**
    * The type of reservation from which this instance can consume resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#type GoogleComputeRegionInstanceTemplate#type}
    */
    readonly type: string;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#specific_reservation GoogleComputeRegionInstanceTemplate#specific_reservation}
    */
    readonly specificReservation?: GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation;
}
export declare function googleComputeRegionInstanceTemplateReservationAffinityToTerraform(struct?: GoogleComputeRegionInstanceTemplateReservationAffinityOutputReference | GoogleComputeRegionInstanceTemplateReservationAffinity): any;
export declare function googleComputeRegionInstanceTemplateReservationAffinityToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateReservationAffinityOutputReference | GoogleComputeRegionInstanceTemplateReservationAffinity): any;
export declare class GoogleComputeRegionInstanceTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateReservationAffinity | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateReservationAffinity | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation;
    get specificReservation(): GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): GoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation | undefined;
}
export interface GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#nanos GoogleComputeRegionInstanceTemplate#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#seconds GoogleComputeRegionInstanceTemplate#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | cdktf.IResolvable | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration {
    /**
    * Span of time that's a fraction of a second at nanosecond
    * resolution. Durations less than one second are represented
    * with a 0 seconds field and a positive nanos field. Must
    * be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#nanos GoogleComputeRegionInstanceTemplate#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second.
    * Must be from 0 to 315,576,000,000 inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#seconds GoogleComputeRegionInstanceTemplate#seconds}
    */
    readonly seconds: number;
}
export declare function googleComputeRegionInstanceTemplateSchedulingMaxRunDurationToTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference | GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration): any;
export declare function googleComputeRegionInstanceTemplateSchedulingMaxRunDurationToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference | GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration): any;
export declare class GoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#key GoogleComputeRegionInstanceTemplate#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#operator GoogleComputeRegionInstanceTemplate#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#values GoogleComputeRegionInstanceTemplate#values}
    */
    readonly values: string[];
}
export declare function googleComputeRegionInstanceTemplateSchedulingNodeAffinitiesToTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateSchedulingNodeAffinitiesToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface GoogleComputeRegionInstanceTemplateScheduling {
    /**
    * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). This defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#automatic_restart GoogleComputeRegionInstanceTemplate#automatic_restart}
    */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
    * Specifies the action GCE should take when SPOT VM is preempted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#instance_termination_action GoogleComputeRegionInstanceTemplate#instance_termination_action}
    */
    readonly instanceTerminationAction?: string;
    /**
    * Specifies the frequency of planned maintenance events. The accepted values are: PERIODIC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#maintenance_interval GoogleComputeRegionInstanceTemplate#maintenance_interval}
    */
    readonly maintenanceInterval?: string;
    /**
    * Minimum number of cpus for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#min_node_cpus GoogleComputeRegionInstanceTemplate#min_node_cpus}
    */
    readonly minNodeCpus?: number;
    /**
    * Defines the maintenance behavior for this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#on_host_maintenance GoogleComputeRegionInstanceTemplate#on_host_maintenance}
    */
    readonly onHostMaintenance?: string;
    /**
    * Allows instance to be preempted. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#preemptible GoogleComputeRegionInstanceTemplate#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance is spot. If this is set as SPOT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#provisioning_model GoogleComputeRegionInstanceTemplate#provisioning_model}
    */
    readonly provisioningModel?: string;
    /**
    * local_ssd_recovery_timeout block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#local_ssd_recovery_timeout GoogleComputeRegionInstanceTemplate#local_ssd_recovery_timeout}
    */
    readonly localSsdRecoveryTimeout?: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout[] | cdktf.IResolvable;
    /**
    * max_run_duration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#max_run_duration GoogleComputeRegionInstanceTemplate#max_run_duration}
    */
    readonly maxRunDuration?: GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration;
    /**
    * node_affinities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#node_affinities GoogleComputeRegionInstanceTemplate#node_affinities}
    */
    readonly nodeAffinities?: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable;
}
export declare function googleComputeRegionInstanceTemplateSchedulingToTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingOutputReference | GoogleComputeRegionInstanceTemplateScheduling): any;
export declare function googleComputeRegionInstanceTemplateSchedulingToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateSchedulingOutputReference | GoogleComputeRegionInstanceTemplateScheduling): any;
export declare class GoogleComputeRegionInstanceTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateScheduling | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateScheduling | undefined);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable;
    set automaticRestart(value: boolean | cdktf.IResolvable);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceTerminationAction?;
    get instanceTerminationAction(): string;
    set instanceTerminationAction(value: string);
    resetInstanceTerminationAction(): void;
    get instanceTerminationActionInput(): string | undefined;
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    resetMaintenanceInterval(): void;
    get maintenanceIntervalInput(): string | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number;
    set minNodeCpus(value: number);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string;
    set onHostMaintenance(value: string);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningModel?;
    get provisioningModel(): string;
    set provisioningModel(value: string);
    resetProvisioningModel(): void;
    get provisioningModelInput(): string | undefined;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList;
    putLocalSsdRecoveryTimeout(value: GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout[] | cdktf.IResolvable): void;
    resetLocalSsdRecoveryTimeout(): void;
    get localSsdRecoveryTimeoutInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout[] | undefined;
    private _maxRunDuration;
    get maxRunDuration(): GoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference;
    putMaxRunDuration(value: GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration): void;
    resetMaxRunDuration(): void;
    get maxRunDurationInput(): GoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration | undefined;
    private _nodeAffinities;
    get nodeAffinities(): GoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesList;
    putNodeAffinities(value: GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities[] | cdktf.IResolvable): void;
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateSchedulingNodeAffinities[] | undefined;
}
export interface GoogleComputeRegionInstanceTemplateServiceAccount {
    /**
    * The service account e-mail address. If not given, the default Google Compute Engine service account is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#email GoogleComputeRegionInstanceTemplate#email}
    */
    readonly email?: string;
    /**
    * A list of service scopes. Both OAuth2 URLs and gcloud short names are supported. To allow full access to all Cloud APIs, use the cloud-platform scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#scopes GoogleComputeRegionInstanceTemplate#scopes}
    */
    readonly scopes: string[];
}
export declare function googleComputeRegionInstanceTemplateServiceAccountToTerraform(struct?: GoogleComputeRegionInstanceTemplateServiceAccountOutputReference | GoogleComputeRegionInstanceTemplateServiceAccount): any;
export declare function googleComputeRegionInstanceTemplateServiceAccountToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateServiceAccountOutputReference | GoogleComputeRegionInstanceTemplateServiceAccount): any;
export declare class GoogleComputeRegionInstanceTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateServiceAccount | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
}
export interface GoogleComputeRegionInstanceTemplateShieldedInstanceConfig {
    /**
    * Compare the most recent boot measurements to the integrity policy baseline and return a pair of pass/fail results depending on whether they match or not. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_integrity_monitoring GoogleComputeRegionInstanceTemplate#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Verify the digital signature of all boot components, and halt the boot process if signature verification fails. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_secure_boot GoogleComputeRegionInstanceTemplate#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Use a virtualized trusted platform module, which is a specialized computer chip you can use to encrypt objects like keys and certificates. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#enable_vtpm GoogleComputeRegionInstanceTemplate#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleComputeRegionInstanceTemplateShieldedInstanceConfigToTerraform(struct?: GoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference | GoogleComputeRegionInstanceTemplateShieldedInstanceConfig): any;
export declare function googleComputeRegionInstanceTemplateShieldedInstanceConfigToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference | GoogleComputeRegionInstanceTemplateShieldedInstanceConfig): any;
export declare class GoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeRegionInstanceTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#create GoogleComputeRegionInstanceTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#delete GoogleComputeRegionInstanceTemplate#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeRegionInstanceTemplateTimeoutsToTerraform(struct?: GoogleComputeRegionInstanceTemplateTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionInstanceTemplateTimeoutsToHclTerraform(struct?: GoogleComputeRegionInstanceTemplateTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template google_compute_region_instance_template}
*/
export declare class GoogleComputeRegionInstanceTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_instance_template";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionInstanceTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionInstanceTemplate to import
    * @param importFromId The id of the existing GoogleComputeRegionInstanceTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionInstanceTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_instance_template google_compute_region_instance_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionInstanceTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionInstanceTemplateConfig);
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable;
    set canIpForward(value: boolean | cdktf.IResolvable);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable;
    set enableDisplay(value: boolean | cdktf.IResolvable);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceDescription?;
    get instanceDescription(): string;
    set instanceDescription(value: string);
    resetInstanceDescription(): void;
    get instanceDescriptionInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string;
    set metadataStartupScript(value: string);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[];
    set resourcePolicies(value: string[]);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleComputeRegionInstanceTemplateAdvancedMachineFeatures | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleComputeRegionInstanceTemplateConfidentialInstanceConfig | undefined;
    private _disk;
    get disk(): GoogleComputeRegionInstanceTemplateDiskList;
    putDisk(value: GoogleComputeRegionInstanceTemplateDisk[] | cdktf.IResolvable): void;
    get diskInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateDisk[] | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleComputeRegionInstanceTemplateGuestAcceleratorList;
    putGuestAccelerator(value: GoogleComputeRegionInstanceTemplateGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateGuestAccelerator[] | undefined;
    private _networkInterface;
    get networkInterface(): GoogleComputeRegionInstanceTemplateNetworkInterfaceList;
    putNetworkInterface(value: GoogleComputeRegionInstanceTemplateNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateNetworkInterface[] | undefined;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): GoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference;
    putNetworkPerformanceConfig(value: GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig): void;
    resetNetworkPerformanceConfig(): void;
    get networkPerformanceConfigInput(): GoogleComputeRegionInstanceTemplateNetworkPerformanceConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleComputeRegionInstanceTemplateReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleComputeRegionInstanceTemplateReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleComputeRegionInstanceTemplateReservationAffinity | undefined;
    private _scheduling;
    get scheduling(): GoogleComputeRegionInstanceTemplateSchedulingOutputReference;
    putScheduling(value: GoogleComputeRegionInstanceTemplateScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleComputeRegionInstanceTemplateScheduling | undefined;
    private _serviceAccount;
    get serviceAccount(): GoogleComputeRegionInstanceTemplateServiceAccountOutputReference;
    putServiceAccount(value: GoogleComputeRegionInstanceTemplateServiceAccount): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): GoogleComputeRegionInstanceTemplateServiceAccount | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleComputeRegionInstanceTemplateShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleComputeRegionInstanceTemplateShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionInstanceTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionInstanceTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionInstanceTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
